/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobCompletionInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobLink;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class CloneT4JobCompletion
implements JobCompletionInterface {
    private String sourceT4Name;
    private String destinationT4Name;
    private T4Interface sourceT4;
    private T4Interface destinationT4;
    private int executeCount = 0;
    private int failedGetJobCount = 0;
    private boolean isDone = false;
    private ArrayList preReqs = new ArrayList();
    private ConfigContext myContext;

    public CloneT4JobCompletion(String sourceT4Name, String destinationT4Name) {
        this.sourceT4Name = sourceT4Name;
        this.destinationT4Name = destinationT4Name;
    }

    List getDestinationT4s(ConfigContext context) throws ConfigMgmtException {
        ArrayList<T4Interface> list = new ArrayList<T4Interface>();
        list.add(this.getDestinationT4(context));
        return list;
    }

    T4Interface getDestinationT4(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "getDestinationT4");
        if (null == this.destinationT4) {
            ManageT4sInterface manageT4sInterface = ManageT4sFactory.getManager();
            manageT4sInterface.init(context, new SearchFilter("Name", this.destinationT4Name));
            try {
                this.destinationT4 = (T4Interface)manageT4sInterface.getItemList().get(0);
            }
            catch (IndexOutOfBoundsException oob) {
                Trace.error((Object)this, "getDestinationT4", "Failed to find destination T4 with name: " + this.destinationT4Name);
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "Failed to find destination T4 for cloning with name: " + this.destinationT4Name);
            }
        } else {
            this.destinationT4.setConfigContext(context);
        }
        return this.destinationT4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobLink[] execute(ConfigContext cc) throws ConfigMgmtException {
        Trace.methodBegin(this, "execute");
        try {
            ++this.executeCount;
            this.myContext = cc;
            this.destinationT4 = null;
            T4Interface destT4 = this.getDestinationT4(cc);
            if (destT4.isFeatureSupported(3)) {
                Trace.verbose((Object)this, "execute", "setting array hot spare values");
                destT4.setAhsPoolSize(this.getSourceT4().getAhsPoolSize());
                destT4.save();
                destT4.reload();
            }
            Trace.verbose((Object)this, "execute", "calling cloneInitiatorsAndGroups");
            this.cloneInitiatorsAndGroups(this.myContext);
            this.cloneVolumeGroups(this.myContext);
            JobLink[] jobLinkArray = new JobLink[]{};
            return jobLinkArray;
        }
        finally {
            this.cleanup();
        }
    }

    public void cloneVolumeGroups(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "cloneVolumeGroups");
        ManageVolumeGroupsInterface manageVolumeGroups = ManageVolumeGroupsFactory.getManager();
        manageVolumeGroups.setScope(this.getSourceT4());
        manageVolumeGroups.init(context, null);
        Trace.verbose((Object)this, "cloneVolumeGroups", "getting volume groups list");
        ArrayList volumeGroupList = new ArrayList(manageVolumeGroups.getItemList());
        ManageStorageVolumesInterface manageStorageVolumes = ManageStorageVolumesFactory.getManager();
        manageStorageVolumes.setScope(this.getSourceT4());
        ManageInitiatorGroupsInterface manageInitiatorGroups = ManageInitiatorGroupsFactory.getManager();
        manageInitiatorGroups.setScope(this.getSourceT4());
        ManageBindingsInterface manageBindings = ManageBindingsFactory.getManager();
        Trace.verbose((Object)this, "cloneVolumeGroups", "iterating volume groups");
        Iterator volumeGroupIterator = volumeGroupList.iterator();
        while (volumeGroupIterator.hasNext()) {
            VolumeGroupInterface volumeGroup = (VolumeGroupInterface)volumeGroupIterator.next();
            this.cloneVolumeGroup(context, manageStorageVolumes, manageBindings, volumeGroup, manageVolumeGroups);
        }
    }

    public void cloneVolumeGroup(ConfigContext context, ManageStorageVolumesInterface manageStorageVolumes, ManageBindingsInterface manageBindings, VolumeGroupInterface volumeGroup, ManageVolumeGroupsInterface manageVolumeGroups) throws ConfigMgmtException {
        Trace.methodBegin(this, "cloneVolumeGroup");
        List volumes = volumeGroup.getVolumes();
        ArrayList destinationVolumes = this.copyVolumes(context, volumes);
        manageBindings.setScope(volumeGroup);
        manageBindings.init(context, null);
        ArrayList destinationInitiatorGroups = new ArrayList();
        ArrayList destinationAccessRights = new ArrayList();
        this.copyInitiatorGroupsAndAccessRights(manageBindings, destinationInitiatorGroups, destinationAccessRights);
        manageVolumeGroups.createVolumeGroup(volumeGroup.getName(), this.getDestinationT4(context), destinationVolumes, destinationInitiatorGroups, destinationAccessRights);
    }

    private ArrayList copyVolumes(ConfigContext context, List volumes) throws ConfigMgmtException {
        ArrayList<StorageVolumeInterface> destinationVolumes = new ArrayList<StorageVolumeInterface>();
        ManageStorageVolumesInterface destManageStorageVolumes = ManageStorageVolumesFactory.getManager();
        destManageStorageVolumes.setScope(this.getDestinationT4(context));
        Iterator volumeIterator = volumes.iterator();
        while (volumeIterator.hasNext()) {
            String volName = ((StorageVolumeInterface)volumeIterator.next()).getName();
            SearchFilter filter = new SearchFilter("OtherIdentifyingInfo", volName);
            destManageStorageVolumes.init(context, filter);
            try {
                StorageVolumeInterface destinationStorageVolume = (StorageVolumeInterface)destManageStorageVolumes.getItemList().get(0);
                destinationVolumes.add(destinationStorageVolume);
            }
            catch (IndexOutOfBoundsException oob) {
                Trace.error((Object)this, "copyVolumes", "Unable to find volume: " + volName);
            }
        }
        return destinationVolumes;
    }

    private void copyInitiatorGroupsAndAccessRights(ManageBindingsInterface manageBindings, List destinationInitiatorGroups, List destinationAccessRights) throws ConfigMgmtException {
        Trace.methodBegin(this, "copyInitiatorGroupsAndAccessRights");
        ManageInitiatorGroupsInterface destManageInitiatorGroups = ManageInitiatorGroupsFactory.getManager();
        destManageInitiatorGroups.setScope(this.getDestinationT4(this.myContext));
        Iterator bindingIterator = manageBindings.getItemList().iterator();
        while (bindingIterator.hasNext()) {
            BindingInterface srcBinding = (BindingInterface)bindingIterator.next();
            SearchFilter sf = new SearchFilter("ElementName", srcBinding.getInitiatorGroup().getName());
            destManageInitiatorGroups.init(this.myContext, sf);
            List destInitGroups = destManageInitiatorGroups.getItemList();
            if (destInitGroups.size() <= 0) continue;
            destinationInitiatorGroups.add((InitiatorGroupInterface)destInitGroups.get(0));
            destinationAccessRights.add(srcBinding.getAccess());
        }
    }

    public ConfigContext cloneInitiatorsAndGroups(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "cloneInitiatorsAndGroups");
        ManageInitiatorGroupsInterface manageInitiatorGroups = ManageInitiatorGroupsFactory.getManager();
        manageInitiatorGroups.setScope(this.getSourceT4());
        manageInitiatorGroups.init(context, null);
        List initiatorGroupsList = manageInitiatorGroups.getItemList();
        Trace.verbose((Object)this, "cloneInitiatorsAndGroups", "Clone all IGs and initiators that are in these groups");
        manageInitiatorGroups.importInitiatorGroups(this.getDestinationT4s(context), this.getSourceT4(), initiatorGroupsList);
        Trace.verbose((Object)this, "cloneInitiatorsAndGroups", "Copy initiators that do not belong to any group");
        ManageInitiatorsInterface manageInitiators = ManageInitiatorsFactory.getManager();
        manageInitiators.setScope(this.getSourceT4());
        manageInitiators.init(context, null);
        List initiatorList = manageInitiators.getItemList();
        List destT4s = this.getDestinationT4s(context);
        for (int i = 0; i < initiatorList.size(); ++i) {
            InitiatorInterface ii = (InitiatorInterface)initiatorList.get(i);
            List ig = ii.getInitiatorGroups();
            if (ig != null && ig.size() != 0) continue;
            Trace.verbose((Object)this, "cloneInitiatorsAndGroups", "Copy initiator:" + ii.getWWN());
            for (int j = 0; j < destT4s.size(); ++j) {
                T4Interface t4 = (T4Interface)destT4s.get(j);
                manageInitiators.setScope(t4);
                manageInitiators.init(context, null);
                Trace.verbose((Object)this, "cloneInitiatorsAndGroups", "Creating initiator on T4:" + t4.getName());
                manageInitiators.createInitiator(t4, ii.getWWN(), ii.getDescription(), null);
            }
        }
        return context;
    }

    public String getErrorKey() {
        return "ARRAY_DUPLICATE_FROM_SOURCE_ERROR";
    }

    public String[] getErrorSubstitutions() {
        String[] substitutions = new String[]{this.destinationT4Name, this.getSourceT4Name()};
        return substitutions;
    }

    public T4Interface getSourceT4() throws ConfigMgmtException {
        if (this.sourceT4 == null) {
            Trace.verbose((Object)this, "getSourceT4", "Must find the source array.");
            ManageT4sInterface t4Mgr = ManageT4sFactory.getManager();
            t4Mgr.init(this.myContext, new SearchFilter("Name", this.getSourceT4Name()));
            try {
                this.sourceT4 = (T4Interface)t4Mgr.getItemList().get(0);
            }
            catch (IndexOutOfBoundsException oob) {
                Trace.error((Object)this, "getSourceT4", "Failed to find source T4 with name: " + this.getSourceT4Name());
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "Failed to find source T4 during cloning with name: " + this.getSourceT4Name());
            }
        }
        return this.sourceT4;
    }

    public String getSourceT4Name() {
        return this.sourceT4Name;
    }

    public void cleanup() {
        Trace.methodBegin(this, "cleanup");
        this.isDone = true;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    public ArrayList getPrerequisiteTasks() {
        return this.preReqs;
    }

    public void addPrerequisiteTasks(Collection jobs) {
        this.preReqs.addAll(jobs);
    }

    public boolean isReadyToRun(ConfigContext cc) {
        Trace.methodBegin(this, "isReadyToRun");
        boolean isReady = false;
        ++this.failedGetJobCount;
        JobManager jobMgr = new JobManager();
        jobMgr.setShowAllJobs(false);
        try {
            String arrayIP = this.getDestinationT4(cc).getClusterName();
            SearchFilter sf = new SearchFilter("InstanceID", Pattern.compile("^" + arrayIP + ":"));
            jobMgr.init(cc, sf);
            List list = jobMgr.getItemList();
            this.failedGetJobCount = 0;
            if (list != null && list.size() > 0) {
                Trace.verbose((Object)this, "isReadyToRun", " have : " + list.size() + " active jobs.");
                isReady = false;
            } else {
                Trace.verbose((Object)this, "isReadyToRun", "no active jobs or null");
                isReady = true;
            }
        }
        catch (ConfigMgmtException e) {
            Trace.verbose((Object)this, "isReadyToRun", (Throwable)e);
            if (this.failedGetJobCount > 5) {
                Trace.verbose((Object)this, "isReadyToRun", "Failed too many times, returning true");
                isReady = true;
            }
            Trace.verbose((Object)this, "isReadyToRun", "failed: " + this.failedGetJobCount + " times, will try again.");
            isReady = false;
        }
        return isReady;
    }
}

