/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapArrayToSet;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapUint64ToBigInteger;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirrorComponentCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirroredVolumeCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationSetCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageArrayEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageDomain;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.StorageArray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageT4s;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageTrays;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class VDisk
implements VDiskEnt1Interface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private ArrayList fieldMap;
    private CIMInstance instance;
    private String systemCreationClassName;
    private String systemName;
    private String creationClassName;
    private String deviceID;
    private String elementName;
    private String otherIdentifyingInfo;
    private String dspArrayID;
    private StorageArrayEnt1Interface storArray;
    private BigInteger consumableBlocks;
    private BigInteger numberOfBlocks;
    private BigInteger blockSize;
    private int status;
    private Set operationalStatus;
    private String storageProfileName = null;
    private StorageProfile profile;
    private String storagePoolName = null;
    private StoragePool pool = null;
    private String storageDomainName = null;
    private StorageDomain domain;
    private int maxNumPartitions;
    private int numUsedPartitions;
    private String vendorName = null;
    private String modelName = null;
    private Collection keyProperties;
    private Boolean external;
    protected static final int VDISK_INITIALIZED = 2;
    protected static final int VDISK_UNINITIALIZED = 32768;
    protected static final int VDISK_OFFLINE = 3;
    protected static final int STORAGE_POOL_NAME = 0;
    protected static final int STORAGE_DOMAIN_NAME = 1;
    protected static final int STORAGE_PROFILE_NAME = 2;

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.verbose((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.instance.getObjectPath(), false, true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
        }
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        if (this.elementName == null) {
            return "";
        }
        return this.elementName;
    }

    public String getWWN() {
        Trace.methodBegin(this, "getWWN");
        if (this.otherIdentifyingInfo == null) {
            return "";
        }
        return this.otherIdentifyingInfo;
    }

    public String getTrayId() throws ConfigMgmtException {
        String METHOD = "getTrayId";
        Trace.methodBegin(this, "getTrayId");
        try {
            StorageVolumeInterface vol = this.getT4Volume();
            if (vol == null) {
                return "";
            }
            return vol.getTrayId();
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getTrayId", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getTrayId", "NullPointerException - Null returned when trying to obtain this VDisk's tray id: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting this VDisk's tray id.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getTrayId", "Exception - Exception thrown when trying to obtain this VDisk's tray id: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting this VDisk's tray id.", e);
        }
    }

    public boolean isInUse() {
        Trace.methodBegin(this, "isInUse");
        BigInteger zero = new BigInteger("0");
        Trace.verbose((Object)this, "isInUse", "Checking if VDisk is in use based on ConfiguredCapacity.");
        return !this.getConfiguredCapacity().equals(zero);
    }

    public boolean isExternal() throws ConfigMgmtException {
        String METHOD = new String("isExternal");
        Trace.methodBegin(this, METHOD);
        if (this.external != null) {
            Trace.methodEnd(this, METHOD);
            return this.external;
        }
        try {
            Trace.verbose((Object)this, METHOD, "Querying CIM for associated ExternalCollection Instances");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPExternalExtent", "SunStorEdge_DSPExternalCollection", "Member", "Collection", true, false, null);
            Trace.verbose((Object)this, METHOD, "Returned from querying CIM for ExternalCollection Instances");
            if (enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, METHOD, "Returning true - external.");
                this.external = Boolean.TRUE;
            } else {
                Trace.verbose((Object)this, METHOD, "Returning false - internal.");
                this.external = Boolean.FALSE;
            }
            Trace.methodEnd(this, METHOD);
            return this.external;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to find internal/external: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems finding internal/external.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain internal/external: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems finding internal/external.", e);
        }
    }

    public BigInteger getTotalCapacity() {
        Trace.methodBegin(this, "getTotalCapacity");
        return this.numberOfBlocks.multiply(this.blockSize);
    }

    public BigInteger getConfiguredCapacity() {
        Trace.methodBegin(this, "getConfiguredCapacity");
        return this.numberOfBlocks.multiply(this.blockSize).subtract(this.consumableBlocks.multiply(this.blockSize));
    }

    public BigInteger getAvailableCapacity() {
        Trace.methodBegin(this, "getAvailableCapacity");
        return this.consumableBlocks.multiply(this.blockSize);
    }

    public int getStatus() {
        Trace.methodBegin(this, "getStatus");
        return this.status;
    }

    public String getVendor() {
        String METHOD = new String("getVendor");
        Trace.methodBegin(this, METHOD);
        if (this.vendorName == null) {
            try {
                this.getMediaInfo();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, METHOD, "Errors obtaining vendor information.");
            }
        }
        return this.vendorName;
    }

    public String getModel() {
        String METHOD = new String("getModel");
        Trace.methodBegin(this, METHOD);
        if (this.modelName == null) {
            try {
                this.getMediaInfo();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, METHOD, "Errors obtaining model information.");
            }
        }
        return this.modelName;
    }

    public int getNumFreePartitions() {
        Trace.methodBegin(this, "getNumFreePartitions");
        return this.maxNumPartitions - this.numUsedPartitions;
    }

    public int getNumUsedPartitions() {
        Trace.methodBegin(this, "getNumUsedPartitions");
        return this.numUsedPartitions;
    }

    public int getMaxNumPartitions() {
        Trace.methodBegin(this, "getMaxNumPartitions");
        return this.maxNumPartitions;
    }

    public String getStorageProfileName() {
        Trace.methodBegin(this, "getStorageProfileName");
        if (this.storageProfileName == null) {
            try {
                this.getAssociatedNames(2);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStorageProfileName", "Error retrieving StorageProfile name.");
                this.storageProfileName = "";
            }
        }
        return this.storageProfileName;
    }

    public StorageProfileInterface getStorageProfile() {
        String METHOD = "getStorageProfile";
        Trace.methodBegin(this, "getStorageProfile");
        if (this.profile == null) {
            try {
                this.getAssociatedNames(2);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStorageProfile", "Error retrieving StorageProfile.");
            }
        }
        Trace.methodEnd(this, "getStorageProfile");
        return this.profile;
    }

    public String getStorageDomainName() {
        Trace.methodBegin(this, "getStorageDomainName");
        if (this.storageDomainName == null) {
            try {
                this.getAssociatedNames(1);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStorageDomainName", "Error retrieving StorageDomain name.");
                this.storageDomainName = "";
            }
        }
        return this.storageDomainName;
    }

    public StorageDomainInterface getStorageDomain() {
        String METHOD = "getStorageDomain";
        Trace.methodBegin(this, "getStorageDomain");
        if (this.domain == null) {
            try {
                this.getAssociatedNames(1);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStorageDomain", "Error retrieving StorageDomain.");
            }
        }
        Trace.methodEnd(this, "getStorageDomain");
        return this.domain;
    }

    public String getStoragePoolName() {
        Trace.methodBegin(this, "getStoragePoolName");
        if (this.storagePoolName == null) {
            try {
                this.getAssociatedNames(0);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStoragePoolName", "Error retrieving StoragePool name.");
                this.storagePoolName = "";
            }
        }
        return this.storagePoolName;
    }

    public StoragePoolInterface getStoragePool() {
        String METHOD = "getStoragePool";
        Trace.methodBegin(this, "getStoragePool");
        if (this.pool == null) {
            try {
                this.getAssociatedNames(0);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStoragePool", "Error retrieving StorageDomain.");
            }
        }
        Trace.methodEnd(this, "getStoragePool");
        return this.pool;
    }

    public ArrayList getAssociatedVolumes() throws ConfigMgmtException {
        return this.getAssociatedVolumes(2);
    }

    public ArrayList getAssociatedVolumes(int filter) throws ConfigMgmtException {
        String METHOD = "getAssociatedVolumes";
        Trace.methodBegin(this, "getAssociatedVolumes");
        HashMap volumes = new HashMap();
        HashMap<String, ReplicationSetCIM> repSets = new HashMap<String, ReplicationSetCIM>();
        if (this.getOperationalStatus().contains(new Integer(32768))) {
            Trace.verbose((Object)this, "getAssociatedVolumes", "This VDisk is Uninitialized, returning empty list.");
            return new ArrayList();
        }
        try {
            Trace.verbose((Object)this, "getAssociatedVolumes", "Querying the CIM for associated StorageVolumes");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPBasedOn", "SunStorEdge_DSPStorageVolume", "Antecedent", "Dependent", true, true, null);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getAssociatedVolumes", "StorageVolume instances found.");
                Object svi = null;
                ReplicationSetCIM repSet = null;
                String repSetName = null;
                Set usage = null;
                CIMInstance ci = null;
                CIMProperty cp = null;
                int type = -1;
                while (enumeration.hasMoreElements()) {
                    ci = (CIMInstance)enumeration.nextElement();
                    cp = ci.getProperty("ObjectType");
                    type = ((UnsignedInt16)cp.getValue().getValue()).intValue();
                    Trace.verbose((Object)this, "getAssociatedVolumes", "Volume type is: " + type);
                    if (filter == 3) {
                        if (type == 1 || type == 5) continue;
                        if (type == 4) {
                            this.getVolumeForRepSet(ci, volumes);
                            continue;
                        }
                    }
                    if (filter == 2) {
                        if (type == 4) {
                            this.getVolumeForRepSet(ci, volumes);
                            continue;
                        }
                        if (type == 1) continue;
                        if (type == 5) {
                            this.getVolumesAssociatedWithGALVolume(ci, volumes);
                            continue;
                        }
                    }
                    if (filter == 1) {
                        if (type == 5) {
                            this.getReplicationSetsAssociatedWithGALVolume(ci, repSets);
                            continue;
                        }
                        if (type != 4) {
                            this.getRepSetForVolume(ci, repSets);
                            continue;
                        }
                    }
                    if (type == 4) {
                        repSetName = (String)ci.getProperty("ElementName").getValue().getValue();
                        repSet = (ReplicationSetCIM)repSets.get(repSetName);
                        if (repSet == null) {
                            repSet = new ReplicationSetCIM(ci, this.context);
                            repSets.put(repSetName, repSet);
                        }
                        usage = repSet.getUsageByRepSet();
                        usage.add("usage.by.volume.replication.bitmap");
                        repSet.setUsageByRepSet(usage);
                        continue;
                    }
                    this.convertAndAddVolume(ci, type, volumes, false);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedVolumes", "Failed: " + cme);
            throw cme;
        }
        ArrayList result = new ArrayList();
        if (filter == 1) {
            result.addAll(repSets.values());
        } else if (filter == 2) {
            this.getAssociatedVolumesWithSnapshotReserves(volumes);
            result.addAll(volumes.values());
        } else {
            result.addAll(volumes.values());
        }
        return result;
    }

    private void getAssociatedVolumesWithSnapshotReserves(HashMap volumes) throws ConfigMgmtException {
        String METHOD_NAME = "getAssociatedVolumesWithSnapshotReserves";
        Trace.methodBegin(this, "getAssociatedVolumesWithSnapshotReserves");
        try {
            Trace.verbose((Object)this, "getAssociatedVolumesWithSnapshotReserves", "Walking MetaBasedOn associations.");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPMetaBasedOn", "SunStorEdge_DSPStorageVolume", "Antecedent", "Dependent", true, true, null);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getAssociatedVolumesWithSnapshotReserves", "Volumes with snapshot reserves found.");
                while (enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    CIMProperty cp = ci.getProperty("ObjectType");
                    UnsignedInt16 objectType = (UnsignedInt16)cp.getValue().getValue();
                    int type = objectType.intValue();
                    this.convertAndAddVolume(ci, type, volumes, true);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedVolumesWithSnapshotReserves", "Failed: " + cme);
            throw cme;
        }
    }

    private void getVolumesAssociatedWithGALVolume(CIMInstance galVolume, HashMap volumes) throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumesAssociatedWithGALVolume");
        HashMap repSets = new HashMap();
        this.getReplicationSetsAssociatedWithGALVolume(galVolume, repSets);
        Set repSetKeys = repSets.keySet();
        ReplicationSetCIM repSet = null;
        StorageVolume volume = null;
        String key = null;
        Set usage = null;
        Iterator iter = repSetKeys.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            repSet = (ReplicationSetCIM)repSets.get(key);
            volume = (StorageVolume)volumes.get(repSet.getLocalVolume().getWwn());
            if (volume == null) {
                volume = (StorageVolume)repSet.getLocalVolume();
                volumes.put(volume.getWwn(), volume);
            }
            usage = volume.getUsageByVolume();
            usage.add("usage.by.volume.replication.queue");
            volume.setUsageByVolume(usage);
        }
    }

    private void getReplicationSetsAssociatedWithGALVolume(CIMInstance galVolume, HashMap repSets) throws ConfigMgmtException {
        CIMInstance repGroup;
        CIMInstance repParameters;
        Trace.methodBegin(this, "getReplicationSetsAssociatedWithGALVolume");
        Enumeration enumeration = this.handle.associators(galVolume.getObjectPath(), "SunStorEdge_DSPReplicationQueue", "SunStorEdge_DSPReplicationParameters", "Dependent", "Antecedent", true, false, null);
        if (enumeration != null && enumeration.hasMoreElements() && (enumeration = this.handle.associators((repParameters = (CIMInstance)enumeration.nextElement()).getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPReplicationGroup", "SettingData", "ManagedElement", true, false, null)) != null && enumeration.hasMoreElements() && (enumeration = this.handle.associators((repGroup = (CIMInstance)enumeration.nextElement()).getObjectPath(), "SunStorEdge_DSPMemberOfCollection", "SunStorEdge_DSPReplicationSet", "Collection", "Member", true, false, null)) != null && enumeration.hasMoreElements()) {
            CIMInstance ci = null;
            ReplicationSetCIM repSet = null;
            String repSetName = null;
            Set usage = null;
            while (enumeration.hasMoreElements()) {
                ci = (CIMInstance)enumeration.nextElement();
                repSetName = (String)ci.getProperty("ElementName").getValue().getValue();
                repSet = (ReplicationSetCIM)repSets.get(repSetName);
                if (repSet == null) {
                    repSet = new ReplicationSetCIM(ci, this.context);
                    repSets.put(repSetName, repSet);
                }
                usage = repSet.getUsageByRepSet();
                usage.add("usage.by.volume.replication.queue");
                repSet.setUsageByRepSet(usage);
            }
        }
    }

    private void convertAndAddVolume(CIMInstance ci, int type, HashMap volumes, boolean setUsageToSnapReserve) throws ConfigMgmtException {
        String volumeWwn = (String)ci.getProperty("Name").getValue().getValue();
        StorageVolumeEnt1Interface volume = (StorageVolumeEnt1Interface)volumes.get(volumeWwn);
        if (volume == null) {
            if (type == 2) {
                MirroredVolumeCIM mv = new MirroredVolumeCIM();
                mv.setInstance(ci);
                mv.init(this.context);
                CIMObjectWrapper.populate(mv, mv.getFieldMap(), ci);
                mv.loadKeys();
                volume = mv;
            } else if (type == 3) {
                Vector info;
                this.getMirrorForMirrorComponent(ci, volumes, setUsageToSnapReserve);
                CIMValue cv = ci.getProperty("OtherIdentifyingInfo").getValue();
                String volType = new String();
                if (cv != null && (info = (Vector)cv.getValue()).size() != 0) {
                    volType = (String)info.get(0);
                }
                if (volType.equals("Split")) {
                    MirrorComponentCIM mc = new MirrorComponentCIM();
                    mc.setInstance(ci);
                    mc.init(this.context);
                    CIMObjectWrapper.populate(mc, mc.getFieldMap(), ci);
                    mc.loadKeys();
                    volume = mc;
                }
            } else {
                StorageVolume sv = new StorageVolume();
                sv.setInstance(ci);
                sv.init(this.context);
                CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                sv.loadKeys();
                volume = sv;
            }
            if (volume != null) {
                volumes.put(volume.getWwn(), volume);
            }
        }
        if (volume != null) {
            Set usage = volume.getUsageByVolume();
            if (setUsageToSnapReserve) {
                usage.add("usage.by.volume.snapshot.reserve");
            } else if (type == 2) {
                usage.add("usage.by.volume.mirror.logs");
            } else if (type == 3) {
                usage.add("usage.by.volume.mirror.component");
            } else {
                usage.add("usage.by.volume.volume.data");
            }
            volume.setUsageByVolume(usage);
        }
    }

    private void getMirrorForMirrorComponent(CIMInstance mirrorComponent, HashMap volumes, boolean setUsageToSnapReserve) throws ConfigMgmtException {
        Trace.methodBegin(this, "getMirrorForMirrorComponent");
        Enumeration mirrors = this.handle.associators(mirrorComponent.getObjectPath(), "SunStorEdge_DSPSynchronizedComponent", "SunStorEdge_DSPStorageVolume", "Antecedent", "Dependent", true, false, null);
        if (mirrors != null && mirrors.hasMoreElements()) {
            CIMInstance ci = (CIMInstance)mirrors.nextElement();
            String mirrorWwn = (String)ci.getProperty("Name").getValue().getValue();
            StorageVolumeEnt1Interface mirror = (StorageVolumeEnt1Interface)volumes.get(mirrorWwn);
            if (mirror == null) {
                MirroredVolumeCIM mv = new MirroredVolumeCIM();
                mv.setInstance(ci);
                mv.init(this.context);
                CIMObjectWrapper.populate(mv, mv.getFieldMap(), ci);
                mv.loadKeys();
                mirror = mv;
                volumes.put(mirrorWwn, mirror);
            }
            Set usage = mirror.getUsageByVolume();
            if (setUsageToSnapReserve) {
                usage.add("usage.by.volume.snapshot.reserve");
            } else {
                usage.add("usage.by.volume.mirror.component");
            }
            mirror.setUsageByVolume(usage);
        }
    }

    private void getVolumeForRepSet(CIMInstance repSet, HashMap volumes) throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumeForRepSet");
        Enumeration enumeration = this.handle.associators(repSet.getObjectPath(), "SunStorEdge_DSPRemoteStorageSynchronized", "SunStorEdge_DSPStorageVolume", "SyncedElement", "SystemElement", true, false, null);
        if (enumeration != null && enumeration.hasMoreElements()) {
            CIMInstance ci = (CIMInstance)enumeration.nextElement();
            String volumeWwn = (String)ci.getProperty("Name").getValue().getValue();
            StorageVolumeEnt1Interface volume = (StorageVolumeEnt1Interface)volumes.get(volumeWwn);
            if (volume == null) {
                StorageVolume sv = new StorageVolume();
                sv.setInstance(ci);
                sv.init(this.context);
                CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                sv.loadKeys();
                volume = sv;
                volumes.put(volumeWwn, volume);
            }
            Set usage = volume.getUsageByVolume();
            usage.add("usage.by.volume.replication.bitmap");
            volume.setUsageByVolume(usage);
        }
    }

    private void getRepSetForVolume(CIMInstance volume, HashMap repSets) throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumeForRepSet");
        Enumeration enumeration = this.handle.associators(volume.getObjectPath(), "SunStorEdge_DSPRemoteStorageSynchronized", "SunStorEdge_DSPStorageVolume", "SystemElement", "SyncedElement", true, false, null);
        if (enumeration != null && enumeration.hasMoreElements()) {
            CIMInstance ci = (CIMInstance)enumeration.nextElement();
            String repSetName = (String)ci.getProperty("ElementName").getValue().getValue();
            ReplicationSetCIM repSet = (ReplicationSetCIM)repSets.get(repSetName);
            if (repSet == null) {
                repSet = new ReplicationSetCIM(ci, this.context);
                repSets.put(repSetName, repSet);
            }
            Set usage = repSet.getUsageByRepSet();
            usage.add("usage.by.volume.local.volume");
            repSet.setUsageByRepSet(usage);
        }
    }

    public StorageVolumeInterface getAssociatedVLV() throws ConfigMgmtException {
        String METHOD = new String("getAssociatedVLV");
        StorageVolume vlv = null;
        try {
            ArrayList volumes = this.getAssociatedVolumes();
            for (int i = 0; i < volumes.size(); ++i) {
                StorageVolume vol = (StorageVolume)volumes.get(i);
                if (!vol.getType().equals("Legacy")) continue;
                vlv = vol;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain associated VLV: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting associated VLV.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain associated VLV: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting associated VLV.", e);
        }
        return vlv;
    }

    public ArrayList[] getAssociatedDisks() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssociatedDisks");
        ArrayList[] arr_disks = new ArrayList[]{new ArrayList(), new ArrayList()};
        try {
            ManageStorageVolumes msv = new ManageStorageVolumes();
            String pattern = "^\\d{" + ManageVDisks.IGNORE_DIGITS + "}" + this.getWWN() + "$";
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "getAssociatedDisks", "Attempting to retrieve 6020 Volume with wwn: " + this.getWWN());
            }
            SearchFilter sf = new SearchFilter("DeviceID", Pattern.compile(pattern));
            msv.init(this.context, sf);
            List items = msv.getItemList();
            StorageVolumeInterface vol = null;
            if (items != null && items.size() != 0) {
                vol = (StorageVolumeInterface)items.get(0);
                String raidGroupName = vol.getRaidGroupName();
                String t4Name = vol.getT4Name();
                String trayId = vol.getTrayId();
                ManageT4s mt4 = new ManageT4s();
                mt4.init(this.context, null);
                T4Interface t4 = mt4.getT4ByName(t4Name);
                ManageTrays mtray = new ManageTrays();
                mtray.setScope(t4);
                mtray.init(this.context, null);
                List trays = mtray.getItemList();
                boolean found = false;
                int size = trays.size();
                TrayInterface tray = null;
                for (int i = 0; i < size && !found; ++i) {
                    tray = (TrayInterface)trays.get(i);
                    if (!tray.getId().equals(trayId)) continue;
                    found = true;
                }
                if (found) {
                    int i;
                    ManageDisks mdisk = new ManageDisks();
                    mdisk.setScope(tray);
                    mdisk.init(this.context, null);
                    List disks = mdisk.getItemList();
                    ManageRaidGroups mrg = new ManageRaidGroups();
                    mrg.setScope(tray);
                    mrg.init(this.context, null);
                    List raidGroups = mrg.getItemList();
                    size = raidGroups.size();
                    found = false;
                    RaidGroupInterface rgrp = null;
                    for (i = 0; i < size && !found; ++i) {
                        rgrp = (RaidGroupInterface)raidGroups.get(i);
                        if (!rgrp.getName().equals(raidGroupName)) continue;
                        found = true;
                    }
                    if (found) {
                        size = disks.size();
                        for (i = 0; i < size; ++i) {
                            DiskInterface disk = (DiskInterface)disks.get(i);
                            if ((disk.getSlotNumber() < rgrp.getBeginDiskNumber() || disk.getSlotNumber() > rgrp.getEndDiskNumber()) && (disk.getSubstitutedBy() == null || !disk.getSubstitutedBy().equals(""))) continue;
                            arr_disks[0].add(disk);
                        }
                        arr_disks[1].add(t4Name);
                    }
                }
            } else if (items == null) {
                Trace.error((Object)this, "getAssociatedDisks", "Could not get Volume list. StorageVolume list is null: " + this.getWWN());
            } else {
                Trace.error((Object)this, "getAssociatedDisks", "Could not find Volume with specified wwn: " + this.getWWN());
            }
            return arr_disks;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedDisks", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssociatedDisks", "NullPointerException - Null returned when trying to obtain AssociatedDisks: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting this AssociatedDisks.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getTrayId", "Exception - Exception thrown when trying to obtain AssociatedDisks: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting AssociatedDisks.", e);
        }
    }

    public Map getKey() {
        Trace.methodBegin(this, "getKey");
        return null;
    }

    public String getSystemCreationClassName() {
        Trace.methodBegin(this, "getSystemCreationClassName");
        return this.systemCreationClassName;
    }

    public String getSystemName() {
        Trace.methodBegin(this, "getSystemName");
        return this.systemName;
    }

    public String getCreationClassName() {
        Trace.methodBegin(this, "getCreationClassName");
        return this.creationClassName;
    }

    public String getDeviceID() {
        Trace.methodBegin(this, "getDeviceID");
        return this.deviceID;
    }

    public String getOtherIdentifyingInfo() {
        Trace.methodBegin(this, "getOtherIdentifyingInfo");
        return this.otherIdentifyingInfo;
    }

    public Set getOperationalStatus() {
        Trace.methodBegin(this, "getOperationalStatus");
        return this.operationalStatus;
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.instance;
    }

    public StorageArrayEnt1Interface getArrayController() throws ConfigMgmtException {
        String METHOD = "getArrayController";
        Trace.methodBegin(this, "getArrayController");
        if (this.storArray == null) {
            String name = null;
            StorageVolumeInterface vol = null;
            String arrayCID = null;
            CIMInstance ci = null;
            try {
                Trace.verbose((Object)this, "getArrayController", "Querying CIM for associated ArrayControllerSettingData Instance");
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPExtentArraySettingData", "SunStorEdge_DSPArrayControllerSettingData", "ManagedElement", "SettingData", true, false, null);
                Trace.verbose((Object)this, "getArrayController", "Returned from querying CIM for associated ArrayControllerSettingData Instance");
                if (enumeration != null && enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getArrayController", "ArrayControllerSettingData Instance Found");
                    ci = (CIMInstance)enumeration.nextElement();
                    CIMValue c_arrayID = ci.getProperty("InstanceID").getValue();
                    arrayCID = (String)c_arrayID.getValue();
                    CIMValue c_name = ci.getProperty("ElementName").getValue();
                    if (c_name != null) {
                        name = (String)c_name.getValue();
                    }
                    if (arrayCID.equals(this.dspArrayID)) {
                        Trace.verbose((Object)this, "getArrayController", "Array ID found on both association and vdisk instance");
                    } else {
                        Trace.error((Object)this, "getArrayController", "Stale Array ID: " + this.dspArrayID);
                        Trace.warn((Object)this, "getArrayController", "Generating associations for Array ID");
                        int retVal = this.invokeCreateArrayIDName(this.dspArrayID, name);
                        CIMObjectPath objPath = new CIMObjectPath();
                        objPath.setObjectName("SunStorEdge_DSPArrayControllerSettingData");
                        objPath.addKey("InstanceID", new CIMValue((Object)this.dspArrayID));
                        ci = this.handle.getInstance(objPath, false, true, false, null);
                        if (ci != null) {
                            c_name = ci.getProperty("ElementName").getValue();
                            name = (String)c_name.getValue();
                        }
                    }
                } else {
                    Trace.verbose((Object)this, "getArrayController", "ArrayControllerSettingData NOT FOUND");
                    if (!this.isExternal()) {
                        vol = this.getT4Volume();
                        if (vol == null) {
                            Trace.error((Object)this, "getArrayController", "Vdisk neither external or external");
                        } else {
                            name = vol.getT4Name();
                        }
                    } else {
                        name = null;
                    }
                    int retVal = this.invokeCreateArrayIDName(this.dspArrayID, name);
                    Trace.verbose((Object)this, "getArrayController", "ret value after create arrayid name: " + retVal);
                    if (retVal == 0) {
                        CIMObjectPath objPath = new CIMObjectPath();
                        objPath.setObjectName("SunStorEdge_DSPArrayControllerSettingData");
                        objPath.addKey("InstanceID", new CIMValue((Object)this.dspArrayID));
                        ci = this.handle.getInstance(objPath, false, true, false, null);
                        if (ci != null) {
                            CIMValue c_name = ci.getProperty("ElementName").getValue();
                            name = (String)c_name.getValue();
                        } else {
                            Trace.error((Object)this, "getArrayController", "Error retreiving ArrayControllerSettingData instance with key/name: " + this.dspArrayID + "/" + name);
                            enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPArrayControllerSettingData where ElementName = '" + name + "'");
                            Trace.verbose((Object)this, "getArrayController", "after execQuery getting ArrayControllerSettingData by name: " + name);
                            if (enumeration != null && enumeration.hasMoreElements()) {
                                ci = (CIMInstance)enumeration.nextElement();
                                Trace.verbose((Object)this, "getArrayController", "ArrayControllerSettingData instance found from execQuery");
                            }
                        }
                    } else if (retVal == 6) {
                        Trace.error((Object)this, "getArrayController", "Error retreiving ArrayControllerSettingData (name duplicated) instance(key/name)" + this.dspArrayID + "/" + name);
                        enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPArrayControllerSettingData where ElementName = '" + name + "'");
                        Trace.verbose((Object)this, "getArrayController", "after execQuery getting ArrayControllerSettingData by name: " + name);
                        if (enumeration != null && enumeration.hasMoreElements()) {
                            ci = (CIMInstance)enumeration.nextElement();
                            Trace.verbose((Object)this, "getArrayController", "ArrayControllerSettingData instance found from execQuery");
                        }
                    } else {
                        Trace.error((Object)this, "getArrayController", "Error creating ArrayControllerSettingData name: " + name);
                    }
                }
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getArrayController", "Failed: " + cme);
                throw cme;
            }
            if (ci != null) {
                this.storArray = new StorageArray(this.context, ci, this, name);
            } else {
                Trace.error((Object)this, "getArrayController", "Not ArrayControllerSettingData found for key/name: " + this.dspArrayID + "/" + name);
            }
        }
        Trace.methodEnd(this, "getArrayController");
        return this.storArray;
    }

    public void setSystemCreationClassName(String systemCreationClassName) {
        Trace.methodBegin(this, "setSystemCreationClassName");
        this.systemCreationClassName = systemCreationClassName;
    }

    public void setSystemName(String systemName) {
        Trace.methodBegin(this, "setName");
        this.systemName = systemName;
    }

    public void setCreationClassName(String creationClassName) {
        Trace.methodBegin(this, "setCreationClassName");
        this.creationClassName = creationClassName;
    }

    public void setDeviceID(String deviceID) {
        Trace.methodBegin(this, "setInstanceID");
        this.deviceID = deviceID;
    }

    public void setElementName(String name) {
        Trace.methodBegin(this, "setElementName");
        this.elementName = name;
    }

    public void setOtherIdentifyingInfo(String otherIdentifyingInfo) {
        Trace.methodBegin(this, "setOtherIdentifyingInfo");
        this.otherIdentifyingInfo = otherIdentifyingInfo;
    }

    public void setConsumableBlocks(BigInteger consumableBlocks) {
        Trace.methodBegin(this, "setConsumableBlocks");
        this.consumableBlocks = consumableBlocks;
    }

    public void setNumberOfBlocks(BigInteger numberOfBlocks) {
        Trace.methodBegin(this, "setNumberOfBlocks");
        this.numberOfBlocks = numberOfBlocks;
    }

    public void setBlockSize(BigInteger blockSize) {
        Trace.methodBegin(this, "setBlockSize");
        this.blockSize = blockSize;
    }

    public void setNumUsedPartitions(int numUsedPartitions) {
        Trace.methodBegin(this, "setNumUsedPartitions");
        this.numUsedPartitions = numUsedPartitions;
    }

    public void setMaxNumPartitions(int maxNumPartitions) {
        Trace.methodBegin(this, "setMaxNumPartitions");
        this.maxNumPartitions = maxNumPartitions;
    }

    public void setOperationalStatus(Set operationalStatus) {
        Trace.methodBegin(this, "setOperationalStatus");
        this.operationalStatus = operationalStatus;
        Object[] objs = operationalStatus.toArray();
        if (objs != null && objs.length >= 1) {
            this.status = new Integer(objs[0].toString());
            return;
        }
        this.status = 0;
    }

    public String getDspArrayID() {
        String METHOD = "getDspArrayID";
        Trace.methodBegin(this, "getDspArrayID");
        Trace.methodEnd(this, "getDspArrayID");
        return this.dspArrayID;
    }

    public void setDspArrayID(String id) {
        String METHOD = "setDspArrayID";
        Trace.methodBegin(this, "setDspArrayID");
        this.dspArrayID = id;
        Trace.methodEnd(this, "setDspArrayID");
    }

    public void setInstance(CIMInstance instance) {
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
    }

    public void setKey(Collection props) {
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
    }

    private void getAssociatedNames(int name) throws ConfigMgmtException {
        String METHOD = "getAssociatedNames";
        Trace.methodBegin(this, "getAssociatedNames");
        if (this.pool == null && !this.getOperationalStatus().contains(new Integer(32768))) {
            Trace.verbose((Object)this, "getAssociatedNames", "Querying the CIM for associated StoragePool");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPConcreteComponent", "SunStorEdge_DSPStoragePool", "PartComponent", "GroupComponent", true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
            Trace.verbose((Object)this, "getAssociatedNames", "Returned from querying the CIM for associated StoragePool");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getAssociatedNames", "StoragePool Instance Found");
                CIMInstance c_pool = (CIMInstance)enumeration.nextElement();
                this.pool = new StoragePool();
                this.pool.setInstance(c_pool);
                this.pool.init(this.context);
                CIMObjectWrapper.populate(this.pool, this.pool.getFieldMap(), c_pool);
                this.pool.loadKeys();
            } else {
                Trace.verbose((Object)this, "getAssociatedNames", "Unable to retrieve StoragePool.");
            }
        }
        if (this.pool != null) {
            switch (name) {
                case 0: {
                    this.storagePoolName = this.pool.getName();
                    break;
                }
                case 1: {
                    this.domain = (StorageDomain)this.pool.getStorageDomain();
                    if (this.domain != null) {
                        this.storageDomainName = this.domain.getName();
                        break;
                    }
                    this.storageDomainName = "";
                    break;
                }
                case 2: {
                    this.profile = this.pool.getStorageProfile();
                    this.storageProfileName = this.profile != null ? this.profile.getName() : "";
                }
            }
        } else {
            Trace.verbose((Object)this, "getAssociatedNames", "The VDisk is unassigned and has no associations");
            this.storageProfileName = "";
            this.storagePoolName = "";
            this.storageDomainName = "";
        }
    }

    private void getMediaInfo() throws ConfigMgmtException {
        String METHOD = new String("getMediaInfo");
        Trace.methodBegin(this, METHOD);
        if (this.instance == null) {
            Trace.error((Object)this, METHOD, "Error: Could not find instance for this VDisk.");
            this.vendorName = "";
            this.modelName = "";
            return;
        }
        CIMValue venName = this.instance.getProperty("Manufacturer").getValue();
        if (venName != null) {
            this.vendorName = (String)venName.getValue();
        } else {
            Trace.error((Object)this, METHOD, "Errors getting vendor name from DiskMedia");
            this.vendorName = "";
        }
        CIMValue modName = this.instance.getProperty("Model").getValue();
        if (modName != null) {
            this.modelName = (String)modName.getValue();
        } else {
            Trace.error((Object)this, METHOD, "Errors getting model name from DiskMedia");
            this.modelName = "";
        }
        Trace.methodEnd(this, METHOD);
    }

    public Collection getFieldMap() throws ConfigMgmtException {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("systemCreationClassName", "SystemCreationClassName", true, false));
            this.fieldMap.add(new MapElement("systemName", "SystemName", true, false));
            this.fieldMap.add(new MapElement("creationClassName", "CreationClassName", true, false));
            this.fieldMap.add(new MapElement("deviceID", "DeviceID", true, false));
            this.fieldMap.add(new MapElement("elementName", "ElementName", true, false));
            this.fieldMap.add(new MapStringArrayToString("otherIdentifyingInfo", "OtherIdentifyingInfo", true, true, 0));
            this.fieldMap.add(new MapStringArrayToString("dspArrayID", "OtherIdentifyingInfo", true, true, 1));
            this.fieldMap.add(new MapArrayToSet("operationalStatus", "OperationalStatus", true, true));
            this.fieldMap.add(new MapUint64ToBigInteger("consumableBlocks", "ConsumableBlocks", true, false));
            this.fieldMap.add(new MapUint64ToBigInteger("numberOfBlocks", "NumberOfBlocks", true, false));
            this.fieldMap.add(new MapUint64ToBigInteger("blockSize", "BlockSize", true, false));
            this.fieldMap.add(new MapElement("numUsedPartitions", "CurNumPartitions", true, false));
            this.fieldMap.add(new MapElement("maxNumPartitions", "MaxNumPartitions", true, false));
        }
        return this.fieldMap;
    }

    public void loadKeys() {
        Trace.methodBegin(this, "loadKeys");
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("SystemCreationClassName", new CIMValue((Object)this.getSystemCreationClassName())));
        prop.add(new CIMProperty("SystemName", new CIMValue((Object)this.getSystemName())));
        prop.add(new CIMProperty("CreationClassName", new CIMValue((Object)this.getCreationClassName())));
        prop.add(new CIMProperty("DeviceID", new CIMValue((Object)this.getDeviceID())));
        this.setKey(prop);
    }

    public String toString() {
        if (Trace.isTraceEnabled(this)) {
            return "VDisk with:\n   CIMObjectPath: " + this.instance.getObjectPath() + "\n   key(s): " + this.systemCreationClassName + " , " + this.systemName + " , " + this.creationClassName + " , " + this.deviceID + "\n   name: " + this.getName() + "\n   profile name: " + this.getStorageProfileName() + "\n   domain name: " + this.getStorageDomainName() + "\n   pool name: " + this.getStoragePoolName() + "\n   wwn: " + this.getWWN() + "\n   total capacity: " + this.getTotalCapacity() + "\n   configured capacity: " + this.getConfiguredCapacity() + "\n   available capacity: " + this.getAvailableCapacity() + "\n   status: " + this.getStatus();
        }
        return "";
    }

    private StorageVolumeInterface getT4Volume() throws ConfigMgmtException {
        String METHOD = "getT4Volume";
        Trace.methodBegin(this, "getT4Volume");
        StorageVolumeInterface vol = null;
        ManageStorageVolumes msv = new ManageStorageVolumes();
        int numLeadingDigits = 8;
        String pattern = "^\\d{" + numLeadingDigits + "}" + this.getWWN() + "$";
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "getT4Volume", "Attempting to retrieve 6020 Volume with wwn: " + this.getWWN());
        }
        SearchFilter sf = new SearchFilter("DeviceID", Pattern.compile(pattern));
        msv.init(this.context, sf);
        List items = msv.getItemList();
        if (items.size() != 0) {
            vol = (StorageVolumeInterface)items.get(0);
        } else {
            Trace.error((Object)this, "getT4Volume", "Could not find Volume with specified wwn: " + this.getWWN());
        }
        Trace.methodEnd(this, "getT4Volume");
        return vol;
    }

    private int invokeCreateArrayIDName(String id, String name) throws ConfigMgmtException {
        String METHOD = "invokeCreateArrayIDName";
        Trace.methodBegin(this, "invokeCreateArrayIDName");
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, "DEFAULT", 0);
        Trace.verbose((Object)this, "invokeCreateArrayIDName", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "invokeCreateArrayIDName", "Calling CreateArrayIDName with name: " + name);
        CIMArgument[] inArgs = new CIMArgument[2];
        CIMArgument[] outArgs = new CIMArgument[1];
        inArgs[0] = new CIMArgument("ArrayID", new CIMValue((Object)id));
        inArgs[1] = new CIMArgument("ArrayName", new CIMValue((Object)name));
        outArgs[0] = new CIMArgument("ArrayName", new CIMValue(null));
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateArrayIDName", inArgs, outArgs);
        Trace.verbose((Object)this, "invokeCreateArrayIDName", "Returned from calling CreateArrayIDName");
        int retVal = (Integer)returnCodeValue.getValue();
        Trace.methodEnd(this, "invokeCreateArrayIDName");
        return retVal;
    }

    public String getState() {
        return null;
    }

    public int getRaidLevel() {
        return 0;
    }

    public List getVolumes() throws ConfigMgmtException {
        return null;
    }

    public void changeStatus(int status) throws ConfigMgmtException {
    }

    public MethodCallStatus initialize() throws ConfigMgmtException {
        return null;
    }

    public int getUseHotSpare() throws ConfigMgmtException {
        return 0;
    }

    public int getNumberOfVolumes() {
        return -1;
    }

    public int getNumberOfDisks() {
        return -1;
    }

    public String getKeyAsString() {
        return null;
    }

    public Collection getKeyAsCollection() {
        Trace.methodBegin(this, "getKeyAsCollection");
        return this.keyProperties;
    }

    public String getWwn() {
        return null;
    }

    public String getObjectItemType() {
        return null;
    }

    public boolean doesVDiskHaveVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "doesVDiskHaveVolumes");
        Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPBasedOn", "SunStorEdge_DSPStorageVolume", "Antecedent", "Dependent", true, true, null);
        if (enumeration != null && enumeration.hasMoreElements()) {
            return true;
        }
        enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPMetaBasedOn", "SunStorEdge_DSPStorageVolume", "Antecedent", "Dependent", true, true, null);
        return enumeration != null && enumeration.hasMoreElements();
    }

    public boolean doesVDiskHaveRepSets() throws ConfigMgmtException {
        Trace.methodBegin(this, "doesVDiskHaveRepSets");
        Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPBasedOn", "SunStorEdge_DSPStorageVolume", "Antecedent", "Dependent", true, true, null);
        if (enumeration != null) {
            CIMInstance ci = null;
            CIMProperty cp = null;
            int type = -1;
            while (enumeration.hasMoreElements()) {
                ci = (CIMInstance)enumeration.nextElement();
                cp = ci.getProperty("ObjectType");
                type = ((UnsignedInt16)cp.getValue().getValue()).intValue();
                if (type == 4 || type == 5) {
                    return true;
                }
                HashMap map = new HashMap();
                this.getRepSetForVolume(ci, map);
                if (map.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static interface VolumeFilter {
        public static final int FILTER_REP_SET = 1;
        public static final int FILTER_OUT_REP_SET = 2;
        public static final int FILTER_OUT_REP_SET_SNAP_GAL = 3;
    }
}

