/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1.Initiator;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1.ManageInitiators;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapArrayToSet;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirrorComponentCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.SnapShotVolumeCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.InitiatorVolumeMapping;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;

public class StorageVolume
implements StorageVolumeEnt1Interface {
    protected ConfigContext context;
    protected CIMOMHandleWrapper handle;
    private String name;
    private String description;
    private String poolName = null;
    private String profileName = null;
    private String storageDomainName;
    private BigInteger blockSize;
    private BigInteger consumableBlocks;
    private String volumeGroupName;
    private int state;
    private SortedSet conditionInfo;
    private Set popCondition;
    private String wwn;
    private String type;
    private Date creationDate = null;
    private int snapshotPoolSize = -1;
    private int snapshotPoolPercentFull = -1;
    private int snapshotCount = -1;
    private int writeActivity = -1;
    private int snapshotPolicy = -1;
    private int objectType;
    private int rollbackPercentage = -1;
    private int rollbackPriority = -1;
    private Collection keyProperties;
    private String systemCreationClassName;
    private String systemName;
    private String creationClassName;
    private String deviceID;
    private ArrayList fieldMap;
    protected CIMInstance instance;
    private CIMObjectPath poolPath;
    private Set usageByVolume = new HashSet();
    private static final int CIM_CONDITION_UNKNOWN = 0;
    private static final int CIM_CONDITION_OK = 2;
    private static final int CIM_CONDITION_DEGRADED = 3;
    private static final int CIM_CONDITION_ERROR = 6;
    private static final int CIM_CONDITION_NON_RECOVERABLE_ERROR = 7;
    private static final int CIM_CONDITION_IN_SERVICE = 11;
    private static final int CIM_CONDITION_NO_CONTACT = 12;
    private static final int CIM_CONDITION_LOST_COMMUNICATION = 13;
    private static final int CIM_CONDITION_SUP_ENTITY_IN_ERROR = 16;
    private static final int CIM_CONDITION_VLV = 32768;
    private static final int CIM_CONDITION_DONT_INSTANTIATE = 32769;
    private static final int CIM_CONDITION_ERR_DETECTED = 32770;
    private static final int CIM_CONDITION_PIT_ROLLBACK = 32771;
    private static final int CIM_CONDITION_PIT_ROLLBACK_CLEANUP = 32772;
    private static final int CIM_CONDITION_PIT_RESET = 32773;
    private static final int CIM_CONDITION_LM_RESILVER = 32774;
    private static final int CIM_CONDITION_LM_SPLIT_VOLUMES = 32775;
    private static final int CIM_CONDITION_LM_SPLIT = 32776;
    private static final int CIM_CONDITION_LM_REJOINING = 32777;
    private static final int CIM_CONDITION_GAL = 32778;
    private static final int CIM_CONDITION_LM_PRIMARY = 32779;
    private static final int CIM_CONDITION_PIT_TYPE_SYNC = 32780;
    private static final int CIM_CONDITION_PIT_TYPE_INLINE = 32781;
    private static final int CIM_CONDITION_MIRROR_LOGS_DEGRADED = 32782;
    private static final int CIM_CONDITION_LM_COMP_RESILVER = 32783;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$StorageVolume;

    public void init(ConfigContext context) throws ConfigMgmtException {
        String METHOD = "init";
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
        Trace.methodEnd(this, "init");
    }

    public void save() throws ConfigMgmtException {
        String METHOD = "save";
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
        }
        Trace.methodEnd(this, "save");
    }

    public void reload() throws ConfigMgmtException {
        String METHOD = "reload";
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.instance.getObjectPath(), false, true, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES);
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
        }
        this.snapshotPoolSize = -1;
        this.writeActivity = -1;
        this.snapshotCount = -1;
        this.snapshotPolicy = -1;
        Trace.methodEnd(this, "reload");
    }

    private ArrayList getMappingsHelper(String search) throws ConfigMgmtException {
        String METHOD = "getMappingsHelper";
        Trace.methodBegin(this, "getMappingsHelper");
        ArrayList<InitiatorVolumeMapping> mappings = new ArrayList<InitiatorVolumeMapping>();
        Trace.verbose((Object)this, "getMappingsHelper", "Querying CIM for associated SCSIProtocolController Instances");
        Enumeration enumSCSI = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPProtocolControllerForUnit", "SunStorEdge_DSPSCSIProtocolController", "Dependent", "Antecedent", true, false, null);
        Trace.verbose((Object)this, "getMappingsHelper", "Returned from querying CIM for associated SCSIProtocolController Instances");
        if (enumSCSI != null && enumSCSI.hasMoreElements()) {
            Trace.verbose((Object)this, "getMappingsHelper", "SCSIProtocolController Instance Found.");
            block0: while (enumSCSI.hasMoreElements()) {
                CIMInstance scsi = (CIMInstance)enumSCSI.nextElement();
                CIMProperty inUseLuns = scsi.getProperty("InUseLuns");
                if (inUseLuns == null) {
                    Trace.verbose((Object)this, "getMappingsHelper", "Mapped luns not found, returning.");
                    Trace.methodEnd(this, "getMappingsHelper");
                    return new ArrayList();
                }
                Vector luns = (Vector)inUseLuns.getValue().getValue();
                CIMProperty volumePermissions = scsi.getProperty("VolumePermissions");
                if (volumePermissions == null) {
                    Trace.verbose((Object)this, "getMappingsHelper", "Mapped permissions not found, returning.");
                    Trace.methodEnd(this, "getMappingsHelper");
                    return new ArrayList();
                }
                Vector permissions = (Vector)volumePermissions.getValue().getValue();
                CIMProperty mappedVolumes = scsi.getProperty("MappedVolumes");
                if (mappedVolumes == null) {
                    Trace.verbose((Object)this, "getMappingsHelper", "Mapped volumes not found, returning.");
                    Trace.methodEnd(this, "getMappingsHelper");
                    return new ArrayList();
                }
                Vector volumes = (Vector)mappedVolumes.getValue().getValue();
                CIMProperty cp_mapStates = scsi.getProperty("MapState");
                Vector v_mapStates = null;
                if (cp_mapStates != null && (v_mapStates = (Vector)cp_mapStates.getValue().getValue()).size() != luns.size()) {
                    v_mapStates = null;
                }
                CIMProperty assignedInitiator = scsi.getProperty("AssociatedInitiator");
                String curInitiatorWwn = new String();
                if (assignedInitiator == null) {
                    Trace.verbose((Object)this, "getMappingsHelper", "Assigned Initiator not found, returning.");
                    Trace.methodEnd(this, "getMappingsHelper");
                    return new ArrayList();
                }
                curInitiatorWwn = (String)assignedInitiator.getValue().getValue();
                Trace.verbose((Object)this, "getMappingsHelper", "Creating Initiator Java Object");
                ManageInitiators mi = new ManageInitiators();
                mi.init(this.context, null);
                Initiator mappedInitiator = (Initiator)mi.getItemByInstanceID(curInitiatorWwn);
                if (mappedInitiator == null) {
                    Trace.error((Object)this, "getMappingsHelper", "Error retrieving Initiator for WWN: " + curInitiatorWwn);
                    Trace.methodEnd(this, "getMappingsHelper");
                    return new ArrayList();
                }
                Trace.verbose((Object)this, "getMappingsHelper", "Locating correct StorageVolume.");
                int size = luns.size();
                for (int j = 0; j < size; ++j) {
                    if (!((String)volumes.get(j)).equals(this.deviceID)) continue;
                    Trace.verbose((Object)this, "getMappingsHelper", "Found correct StorageVolume");
                    HashSet<Integer> perms = new HashSet<Integer>();
                    if (((UnsignedInt16)permissions.get(j)).intValue() == 5) {
                        perms.add(new Integer("5"));
                    } else {
                        perms.add(new Integer("5"));
                        perms.add(new Integer("6"));
                    }
                    Trace.verbose((Object)this, "getMappingsHelper", "Creating InitiatorVolumeMapping object");
                    InitiatorVolumeMapping ivm = new InitiatorVolumeMapping(((UnsignedInt16)luns.get(j)).toString(), perms, mappedInitiator);
                    if (v_mapStates != null) {
                        String m_value = (String)v_mapStates.get(j);
                        ivm.setState(m_value);
                    }
                    mappings.add(ivm);
                    continue block0;
                }
            }
        }
        Trace.verbose((Object)this, "getMappingsHelper", "Searching for specific Initiator mapping");
        if (search != null) {
            InitiatorVolumeMappingInterface ivmi = new InitiatorVolumeMapping();
            InitiatorInterface inter = new Initiator();
            for (int i = 0; i < mappings.size(); ++i) {
                ivmi = (InitiatorVolumeMappingInterface)mappings.get(i);
                inter = (InitiatorInterface)ivmi.getObject();
                if (!inter.getName().equals(search)) continue;
                Trace.verbose((Object)this, "getMappingsHelper", "Specific Initiator mapping found.");
                ArrayList searchResult = new ArrayList();
                searchResult.add(mappings.get(i));
                Trace.methodEnd(this, "getMappingsHelper");
                return searchResult;
            }
            Trace.verbose((Object)this, "getMappingsHelper", "Specific Initiator mapping no found");
            Trace.methodEnd(this, "getMappingsHelper");
            return new ArrayList();
        }
        Trace.methodEnd(this, "getMappingsHelper");
        return mappings;
    }

    public String getName() {
        String METHOD = "getName";
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            Trace.methodEnd(this, "getName");
            return "";
        }
        Trace.methodEnd(this, "getName");
        return this.name;
    }

    public String getDescription() {
        String METHOD = "getDescription";
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            Trace.methodEnd(this, "getDescription");
            return "";
        }
        Trace.methodEnd(this, "getDescription");
        return this.description;
    }

    public String getStoragePoolName() {
        String METHOD = "getStoragePoolName";
        Trace.methodBegin(this, "getStoragePoolName");
        if (this.poolName == null) {
            try {
                this.getAssociatedNames();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStoragePoolName", "Errors retrieving StoragePool Name.");
                this.poolName = "";
            }
        }
        Trace.methodEnd(this, "getStoragePoolName");
        return this.poolName;
    }

    public String getProfileName() {
        String METHOD = "getProfileName";
        Trace.methodBegin(this, "getProfileName");
        if (this.profileName == null) {
            try {
                this.getAssociatedNames();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getProfileName", "Errors retrieving StorageProfile Name.");
                this.profileName = "";
            }
        }
        Trace.methodEnd(this, "getProfileName");
        return this.profileName;
    }

    public String getStorageDomainName() {
        String METHOD = "getStorageDomainName";
        Trace.methodBegin(this, "getStorageDomainName");
        if (this.storageDomainName == null) {
            try {
                this.getAssociatedNames();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStorageDomainName", "Errors retrieving StorageDomain Name.");
                this.storageDomainName = "";
            }
        }
        if (this.storageDomainName == null) {
            Trace.methodEnd(this, "getStorageDomainName");
            return "";
        }
        Trace.methodEnd(this, "getStorageDomainName");
        return this.storageDomainName;
    }

    public BigInteger getSize() {
        String METHOD = "getSize";
        Trace.methodBegin(this, "getSize");
        BigInteger size = this.consumableBlocks.multiply(this.blockSize);
        Trace.verbose((Object)this, "getSize", "Calculated size in bytes is: " + size);
        return size;
    }

    public BigInteger getCapacity() {
        String METHOD = "getCapacity";
        Trace.methodBegin(this, "getCapacity");
        Trace.methodEnd(this, "getCapacity");
        return this.consumableBlocks.multiply(this.blockSize);
    }

    public String getVolumeGroupName() {
        String METHOD = "getVolumeGroupName";
        Trace.methodBegin(this, "getVolumeGroupName");
        if (this.volumeGroupName == null) {
            Trace.methodEnd(this, "getVolumeGroupName");
            return "";
        }
        Trace.methodEnd(this, "getVolumeGroupName");
        return this.volumeGroupName;
    }

    public int getState() {
        String METHOD = "getState";
        Trace.methodBegin(this, "getState");
        Trace.methodEnd(this, "getState");
        return this.state;
    }

    public int getCondition() {
        String METHOD = "getCondition";
        Trace.methodBegin(this, "getCondition");
        if (this.conditionInfo != null) {
            Integer condition = (Integer)this.conditionInfo.first();
            Trace.methodEnd(this, "getCondition");
            return condition;
        }
        Trace.methodEnd(this, "getCondition");
        return 2;
    }

    public SortedSet getConditionInfo() {
        String METHOD = "getConditionInfo";
        Trace.methodBegin(this, "getConditionInfo");
        Trace.methodEnd(this, "getConditionInfo");
        return this.conditionInfo;
    }

    public SortedSet getSummaryTypeInfo() {
        String METHOD = "getTypeInfo";
        Trace.methodBegin(this, "getTypeInfo");
        TreeSet<Integer> typeSet = new TreeSet<Integer>();
        if (this.objectType == 10) {
            typeSet.add(new Integer(6));
            return typeSet;
        }
        if (this.conditionInfo.contains(new Integer(9))) {
            typeSet.add(new Integer(1));
        }
        if (this.objectType == 2) {
            typeSet.add(new Integer(2));
        } else if (this.objectType == 4 || this.objectType == 6 || this.objectType == 7) {
            typeSet.add(new Integer(3));
        } else if (this.conditionInfo.contains(new Integer(17))) {
            typeSet.add(new Integer(4));
        } else if (this.type.equalsIgnoreCase("Snap")) {
            typeSet.add(new Integer(5));
        } else {
            typeSet.add(new Integer(0));
        }
        Trace.methodEnd(this, "getTypeInfo");
        return typeSet;
    }

    public Set getPopCondition() {
        String METHOD = "getPopCondition";
        Trace.methodBegin(this, "getPopCondition");
        Trace.methodEnd(this, "getPopCondition");
        return this.popCondition;
    }

    public String getWwn() {
        String METHOD = "getWwn";
        Trace.methodBegin(this, "getWwn");
        if (this.wwn == null) {
            Trace.methodEnd(this, "getWwn");
            return "";
        }
        Trace.methodEnd(this, "getWwn");
        return this.wwn;
    }

    public String getType() {
        String METHOD = "getType";
        Trace.methodBegin(this, "getType");
        Trace.methodEnd(this, "getType");
        return this.type;
    }

    public Date getCreationDate() {
        String METHOD = "getCreationDate";
        Trace.methodBegin(this, "getCreationDate");
        if (this.creationDate == null) {
            try {
                this.getInstallDate();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getCreationDate", "Errors retrieving Creation Date.");
                this.creationDate = null;
            }
        }
        if (this.creationDate != null) {
            Trace.methodEnd(this, "getCreationDate");
            return this.creationDate;
        }
        Trace.methodEnd(this, "getCreationDate");
        return new Date();
    }

    public int getSnapshotPoolSize() {
        String METHOD = "getSnapshotPoolSize";
        Trace.methodBegin(this, "getSnapshotPoolSize");
        if (this.snapshotPoolSize == -1) {
            try {
                this.getVolumeCharacteristics();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getSnapshotPoolSize", "Errors retrieving SnapshotPoolSize.");
                this.snapshotPoolSize = 0;
            }
        }
        Trace.methodEnd(this, "getSnapshotPoolSize");
        return this.snapshotPoolSize;
    }

    public int getSnapshotPoolPercentFull() {
        String METHOD = "getSnapshotPoolPercentFull";
        Trace.methodBegin(this, "getSnapshotPoolPercentFull");
        if (this.snapshotPoolPercentFull == -1) {
            try {
                this.getVolumeCharacteristics();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getSnapshotPoolPercentFull", "Errors retrieving SnapshotPoolPercentFull.");
                this.snapshotPoolPercentFull = 0;
            }
        }
        return this.snapshotPoolPercentFull;
    }

    public int getRollbackPercentage() {
        String METHOD = "getRollbackPercentage";
        Trace.methodBegin(this, "getRollbackPercentage");
        if (this.rollbackPercentage == -1) {
            try {
                this.getVolumeCharacteristics();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getRollbackPercentage", "Errors retrieving RollbackPercentage.");
                this.rollbackPercentage = 0;
            }
        }
        Trace.methodEnd(this, "getRollbackPercentage");
        return this.rollbackPercentage;
    }

    public int getRollbackPriority() throws ConfigMgmtException {
        String METHOD = "getRollbackPriority";
        Trace.methodBegin(this, "getRollbackPriority");
        if (this.rollbackPriority == -1) {
            this.getVolumeCharacteristics();
        }
        Trace.methodEnd(this, "getRollbackPriority");
        return this.rollbackPriority;
    }

    public int getRedundancyType() {
        String METHOD = "getRedundancyType";
        Trace.methodBegin(this, "getRedundancyType");
        if (this.objectType == 2) {
            Trace.methodEnd(this, "getRedundancyType");
            return 1;
        }
        if (this.objectType == 4 || this.objectType == 6 || this.objectType == 7) {
            Trace.methodEnd(this, "getRedundancyType");
            return 2;
        }
        if (this.objectType == 10) {
            Trace.methodEnd(this, "getRedundancyType");
            return 4;
        }
        Trace.methodEnd(this, "getRedundancyType");
        return 0;
    }

    public int getNumberOfSnapshots() throws ConfigMgmtException {
        String METHOD = "getNumberOfSnapshots";
        Trace.methodBegin(this, "getNumberOfSnapshots");
        Trace.verbose((Object)this, "getNumberOfSnapshots", "Querying CIM for all attached StorageSynchronized associations.");
        Enumeration storageSyncs = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPStorageSynchronized", "SunStorEdge_DSPStorageVolume", "SystemElement", "SyncedElement", true, false, null);
        Trace.verbose((Object)this, "getNumberOfSnapshots", "Returned from querying CIM for all attached StorageSynchronized associations.");
        Trace.verbose((Object)this, "getNumberOfSnapshots", "Calculating and returning number of snapshots.");
        int snaps = 0;
        if (storageSyncs != null && storageSyncs.hasMoreElements()) {
            while (storageSyncs.hasMoreElements()) {
                CIMInstance synchedElement = (CIMInstance)storageSyncs.nextElement();
                CIMProperty prop = synchedElement.getProperty("ObjectType");
                UnsignedInt16 type = (UnsignedInt16)prop.getValue().getValue();
                if (type.intValue() != 1) continue;
                ++snaps;
            }
        }
        Trace.methodEnd(this, "getNumberOfSnapshots");
        return snaps;
    }

    public Collection getKey() {
        String METHOD = "getKey";
        Trace.methodBegin(this, "getKey");
        Trace.methodEnd(this, "getKey");
        return this.keyProperties;
    }

    public ArrayList getAssociatedVDisks() throws ConfigMgmtException {
        CIMInstance ci;
        String METHOD = "getAssociatedVDisks";
        Trace.methodBegin(this, "getAssociatedVDisks");
        ArrayList<Object> disks = new ArrayList();
        HashMap<String, VDisk> uniqueDisks = new HashMap<String, VDisk>();
        Trace.verbose((Object)this, "getAssociatedVDisks", "Querying CIM for associated StorageExtent Instances via BasedOn");
        Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPBasedOn", "SunStorEdge_DSPStorageExtent", "Dependent", "Antecedent", true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
        Trace.verbose((Object)this, "getAssociatedVDisks", "Returned from querying CIM for associated StorageExtent Instances via BasedOn");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getAssociatedVDisks", "StorageExtent Instances Found");
            while (enumeration.hasMoreElements()) {
                ci = (CIMInstance)enumeration.nextElement();
                Trace.verbose((Object)this, "getAssociatedVDisks", "Creating VDisk Java Objects");
                VDisk vd = new VDisk();
                vd.setInstance(ci);
                vd.init(this.context);
                CIMObjectWrapper.populate(vd, vd.getFieldMap(), ci);
                vd.loadKeys();
                uniqueDisks.put(vd.getName(), vd);
                disks.add(vd);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getAssociatedVDisks", "The instance added to the list: " + vd);
            }
        }
        Trace.verbose((Object)this, "getAssociatedVDisks", "Querying CIM for associated StorageExtent Instances via MetaBasedOn");
        enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPMetaBasedOn", "SunStorEdge_DSPStorageExtent", "Dependent", "Antecedent", true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
        Trace.verbose((Object)this, "getAssociatedVDisks", "Returned from querying CIM for associated StorageExtent Instances via MetaBasedOn");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getAssociatedVDisks", "StorageExtent Instances Found");
            while (enumeration.hasMoreElements()) {
                ci = (CIMInstance)enumeration.nextElement();
                String diskName = (String)ci.getProperty("ElementName").getValue().getValue();
                if (uniqueDisks.containsKey(diskName)) continue;
                Trace.verbose((Object)this, "getAssociatedVDisks", "Creating VDisk Java Objects");
                VDisk vd = new VDisk();
                vd.setInstance(ci);
                vd.init(this.context);
                CIMObjectWrapper.populate(vd, vd.getFieldMap(), ci);
                vd.loadKeys();
                uniqueDisks.put(vd.getName(), vd);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getAssociatedVDisks", "The instance added to the list: " + vd);
            }
        }
        disks = new ArrayList(uniqueDisks.values());
        Trace.methodEnd(this, "getAssociatedVDisks");
        return disks;
    }

    public ArrayList getAssociatedSnapShots() throws ConfigMgmtException {
        String METHOD = "getAssociatedSnapshots";
        Trace.methodBegin(this, "getAssociatedSnapshots");
        ArrayList<SnapShotVolumeCIM> snaps = new ArrayList<SnapShotVolumeCIM>();
        Trace.verbose((Object)this, "getAssociatedSnapshots", "Querying CIM for associated StorageVolume(Replica) Instances");
        Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPStorageSynchronized", "SunStorEdge_DSPStorageVolume", "SystemElement", "SyncedElement", true, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES);
        Trace.verbose((Object)this, "getAssociatedSnapshots", "Returned from querying CIM for associated StorageVolume(Replica) Instances");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getAssociatedSnapshots", "StorageVolume(Replica) Instances Found");
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                CIMProperty cimProp = ci.getProperty("ObjectType");
                UnsignedInt16 type = (UnsignedInt16)cimProp.getValue().getValue();
                if (type.intValue() != 1) continue;
                Trace.verbose((Object)this, "getAssociatedSnapshots", "Creating StorageVolume(Replica) Java Object");
                SnapShotVolumeCIM sv = new SnapShotVolumeCIM();
                sv.setInstance(ci);
                sv.init(this.context);
                CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                sv.loadKeys();
                snaps.add(sv);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getAssociatedSnapshots", "The instance added to the list: " + sv);
            }
        }
        Trace.methodEnd(this, "getAssociatedSnapshots");
        return snaps;
    }

    public ArrayList getInitiatorMappings() throws ConfigMgmtException {
        String METHOD = "getInitiatorMappings";
        Trace.methodBegin(this, "getInitiatorMappings");
        ArrayList mappings = new ArrayList();
        Trace.verbose((Object)this, "getInitiatorMappings", "Calling getMappingsHelper with null search string");
        mappings = this.getMappingsHelper(null);
        Trace.methodEnd(this, "getInitiatorMappings");
        return mappings;
    }

    public InitiatorVolumeMappingInterface getInitiatorMapping(String initiatorName) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = "getInitiatorMapping";
        Trace.methodBegin(this, "getInitiatorMapping");
        ArrayList results = new ArrayList();
        Trace.verbose((Object)this, "getInitiatorMapping", "Calling getMappingsHelper looking for: " + initiatorName);
        results = this.getMappingsHelper(initiatorName);
        if (!results.isEmpty()) {
            Trace.methodEnd(this, "getInitiatorMapping");
            return (InitiatorVolumeMappingInterface)results.get(0);
        }
        Trace.error((Object)this, "getInitiatorMapping", "Initiator not found to be mapped");
        throw new ItemNotFoundException(initiatorName);
    }

    public String getPopname() {
        String METHOD = "getPopname";
        Trace.methodBegin(this, "getPopname");
        if (this.name == null) {
            Trace.methodEnd(this, "getPopname");
            return "";
        }
        Trace.methodEnd(this, "getPopname");
        return this.name;
    }

    public CIMInstance getInstance() {
        String METHOD = "getInstance";
        Trace.methodBegin(this, "getInstance");
        Trace.methodEnd(this, "getInstance");
        return this.instance;
    }

    public String getSystemCreationClassName() {
        String METHOD = "getSystemCreationClassName";
        Trace.methodBegin(this, "getSystemCreationClassName");
        Trace.methodEnd(this, "getSystemCreationClassName");
        return this.systemCreationClassName;
    }

    public String getSystemName() {
        String METHOD = "getSystemName";
        Trace.methodBegin(this, "getSystemName");
        Trace.methodEnd(this, "getSystemName");
        return this.systemName;
    }

    public String getCreationClassName() {
        String METHOD = "getCreationClassName";
        Trace.methodBegin(this, "getCreationClassName");
        Trace.methodEnd(this, "getCreationClassName");
        return this.creationClassName;
    }

    public String getDeviceID() {
        String METHOD = "getDeviceID";
        Trace.methodBegin(this, "getDeviceID");
        Trace.methodEnd(this, "getDeviceID");
        return this.deviceID;
    }

    public int getObjectType() {
        String METHOD = "getObjectType";
        Trace.methodBegin(this, "getObjectType");
        Trace.methodEnd(this, "getObjectType");
        return this.objectType;
    }

    private void getAssociatedNames() throws ConfigMgmtException {
        String METHOD = "getAssociatedNames";
        Trace.methodBegin(this, "getAssociatedNames");
        if (this.instance != null) {
            Trace.verbose((Object)this, "getAssociatedNames", "Querying CIM for associated StoragePool Instance");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPAllocatedFromStoragePool", "SunStorEdge_DSPStoragePool", "Dependent", "Antecedent", true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
            Trace.verbose((Object)this, "getAssociatedNames", "Returned from querying CIM for associated StoragePool Instance");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getAssociatedNames", "StoragePool Instance Found");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                CIMValue cv = ci.getProperty("ElementName").getValue();
                this.poolName = cv != null ? (String)cv.getValue() : "";
                if (this.storageDomainName == null) {
                    StoragePool sp = new StoragePool();
                    sp.setInstance(ci);
                    sp.init(this.context);
                    CIMObjectWrapper.populate(sp, sp.getFieldMap(), ci);
                    ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
                    prop.add(new CIMProperty("InstanceID", new CIMValue((Object)sp.getInstanceID())));
                    sp.setKey(prop);
                    this.storageDomainName = sp.getStorageDomainName();
                }
                Trace.verbose((Object)this, "getAssociatedNames", "Querying CIM for associated StorageCapabilities.");
                Enumeration enum2 = this.handle.associators(ci.getObjectPath(), "SunStorEdge_DSPElementCapabilities", "SunStorEdge_DSPStorageCapabilities", "ManagedElement", "Capabilities", true, false, ConstantsEnt.StorageCapabilitiesProperties.PROP_LIST);
                Trace.verbose((Object)this, "getAssociatedNames", "Returned from querying CIM for associated StorageCapabilities.");
                if (enum2 != null && enum2.hasMoreElements()) {
                    Trace.verbose((Object)this, "getAssociatedNames", "StorageCapabilities Instance Found.");
                    CIMInstance profCI = (CIMInstance)enum2.nextElement();
                    Trace.verbose((Object)this, "getAssociatedNames", "Getting Profile Name");
                    CIMValue profCV = profCI.getProperty("ElementName").getValue();
                    this.profileName = profCV != null ? (String)profCV.getValue() : "";
                    Trace.verbose((Object)this, "getAssociatedNames", "StoragePool found: " + this.profileName);
                }
            } else {
                Trace.verbose((Object)this, "getAssociatedNames", "No StoragePool Found");
            }
        }
        Trace.methodEnd(this, "getAssociatedNames");
    }

    private void getInstallDate() throws ConfigMgmtException {
        CIMValue cv;
        String METHOD = "getInstallDate";
        Trace.methodBegin(this, "getInstallDate");
        CIMProperty cp = this.instance.getProperty("InstallDate");
        if (cp != null && (cv = cp.getValue()).getValue() != null) {
            this.creationDate = ((CIMDateTime)cv.getValue()).getCalendar().getTime();
        }
        Trace.methodEnd(this, "getInstallDate");
    }

    private CIMInstance getVolumeCharacteristics() throws ConfigMgmtException {
        String METHOD = "getVolumeCharacteristics";
        Trace.methodBegin(this, "getVolumeCharacteristics");
        CIMInstance ci = null;
        Trace.verbose((Object)this, "getVolumeCharacteristics", "Querying CIM for associated DSPStorageSettingWithHints Instance");
        Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPStorageSettingWithHints", "ManagedElement", "SettingData", true, false, null);
        Trace.verbose((Object)this, "getVolumeCharacteristics", "Returned from querying CIM for associated DSPStorageSettingWithHints Instance");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getVolumeCharacteristics", "DSPStorageSettingWithHints Instance Found");
            ci = (CIMInstance)enumeration.nextElement();
            CIMValue sizeCV = ci.getProperty("SnapshotPoolPercent").getValue();
            if (sizeCV != null) {
                UnsignedInt16 size = (UnsignedInt16)sizeCV.getValue();
                this.snapshotPoolSize = size.intValue();
            } else {
                Trace.error((Object)this, "getVolumeCharacteristics", "Error retrieving DSPStorageSettingWithHints 'SnapshotPoolPercent'");
                this.snapshotPoolSize = 0;
            }
            CIMValue percentCV = ci.getProperty("SnapshotPoolPercentFull").getValue();
            if (percentCV != null) {
                UnsignedInt16 percent = (UnsignedInt16)percentCV.getValue();
                this.snapshotPoolPercentFull = percent.intValue();
            } else {
                Trace.error((Object)this, "getVolumeCharacteristics", "Error retrieving DSPStorageSettingWithHints 'SnapshotPoolPercentFull'");
                this.snapshotPoolPercentFull = 0;
            }
            CIMValue c_policy = ci.getProperty("SnapshotPolicy").getValue();
            if (c_policy != null) {
                UnsignedInt16 policy = (UnsignedInt16)c_policy.getValue();
                if (policy != null) {
                    this.snapshotPolicy = policy.intValue();
                } else {
                    Trace.error((Object)this, "getVolumeCharacteristics", "Error retrieving snapshot policy value. Setting value to VOLUME_SNAPSHOT_POLICY_FAVOR_DEFAULT: 0");
                    this.snapshotPolicy = 0;
                }
            } else {
                Trace.error((Object)this, "getVolumeCharacteristics", "Error retrieving DSPStorageSettingWithHints 'SnapShotPolicy'");
                this.snapshotPolicy = 0;
            }
            CIMValue c_priority = ci.getProperty("RollbackPriority").getValue();
            if (c_priority != null) {
                UnsignedInt16 priority = (UnsignedInt16)c_priority.getValue();
                if (priority != null) {
                    this.rollbackPriority = priority.intValue();
                } else {
                    Trace.error((Object)this, "getVolumeCharacteristics", "Error retrieving rollback priority value. Setting value to default: 128");
                    this.rollbackPriority = 128;
                }
            } else {
                Trace.error((Object)this, "getVolumeCharacteristics", "Error retrieving DSPStorageSettingWithHints 'RollbackPriority'");
                this.rollbackPriority = 128;
            }
        }
        Trace.verbose((Object)this, "getVolumeCharacteristics", "Querying CIM for associated StorageSynchronized instance");
        String role = "SystemElement";
        if (this.isSnapshot()) {
            role = "SyncedElement";
        }
        Enumeration syncs = this.handle.references(this.instance.getObjectPath(), "SunStorEdge_DSPStorageSynchronized", role, true, false, null);
        Trace.verbose((Object)this, "getVolumeCharacteristics", "Returned from querying CIM for associated StorageSynchronized instance");
        if (syncs != null && syncs.hasMoreElements()) {
            CIMInstance syncInstance = (CIMInstance)syncs.nextElement();
            CIMValue cvRoll = syncInstance.getProperty("RollbackPercentageComplete").getValue();
            if (cvRoll != null) {
                this.rollbackPercentage = ((UnsignedInt16)cvRoll.getValue()).intValue();
            } else {
                Trace.error((Object)this, "getVolumeCharacteristics", "Could not find RollbackPercentage");
                this.rollbackPercentage = 0;
            }
            Trace.verbose((Object)this, "getVolumeCharacteristics", "StorageSynchronized instance found.");
        } else {
            Trace.verbose((Object)this, "getVolumeCharacteristics", "StorageSynchronized instance not found.");
            this.rollbackPercentage = 0;
        }
        Trace.methodEnd(this, "getVolumeCharacteristics");
        return ci;
    }

    public void setName(String name) throws ConfigMgmtException, BadParameterException {
        String METHOD = "setName";
        Trace.methodBegin(this, "setName");
        Trace.verbose((Object)this, "setName", "Validating name: " + name);
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        msv.validateName(name);
        Trace.verbose((Object)this, "setName", "Name: " + name + " validated, setting...");
        this.name = name;
        Trace.methodEnd(this, "setName");
    }

    public void setDescription(String description) throws BadParameterException {
        String METHOD = "setDescription";
        Trace.methodBegin(this, "setDescription");
        Trace.verbose((Object)this, "setDescription", "Validating description: " + description);
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.validateDescription(description);
        Trace.verbose((Object)this, "setDescription", "Description: " + description + " validated, setting...");
        this.description = description;
        Trace.methodEnd(this, "setDescription");
    }

    public void setPopname(String popname) {
        String METHOD = "setPopname";
        Trace.methodBegin(this, "setPopname");
        this.name = popname;
        Trace.methodEnd(this, "setPopname");
    }

    public void setVolumeGroupName(String volumeGroupName) throws BadParameterException {
        String METHOD = "setVolumeGroupName";
        Trace.methodBegin(this, "setVolumeGroupName");
        this.volumeGroupName = volumeGroupName;
        Trace.methodEnd(this, "setVolumeGroupName");
    }

    public void setBlockSize(BigInteger blockSize) {
        String METHOD = "setBlockSize";
        Trace.methodBegin(this, "setBlockSize");
        this.blockSize = blockSize;
        Trace.methodEnd(this, "setBlockSize");
    }

    public void setConsumableBlocks(BigInteger consumableBlockSize) {
        String METHOD = "setConsumableBlockSize";
        Trace.methodBegin(this, "setConsumableBlockSize");
        this.consumableBlocks = consumableBlockSize;
        Trace.methodEnd(this, "setConsumableBlockSize");
    }

    public void setWwn(String wwn) {
        String METHOD = "setWwn";
        Trace.methodBegin(this, "setWwn");
        this.wwn = wwn;
        Trace.methodEnd(this, "setWwn");
    }

    public void setStorageDomainName(String storageDomainName) {
        String METHOD = "setStorageDomainName";
        Trace.methodBegin(this, "setStorageDomainName");
        this.storageDomainName = storageDomainName;
        Trace.methodEnd(this, "setStorageDomainName");
    }

    public void setState(int state) {
        String METHOD = "setState";
        Trace.methodBegin(this, "setState");
        this.state = state;
        Trace.methodEnd(this, "setState");
    }

    public void setType(String type) {
        String METHOD = "setType";
        Trace.methodBegin(this, "setType");
        this.type = type;
        Trace.methodEnd(this, "setType");
    }

    public void setPopCondition(Set popCondition) {
        String METHOD = "setPopCondition";
        Trace.methodBegin(this, "setPopCondition");
        if (popCondition != null) {
            TreeSet<Integer> sortedStatus = new TreeSet<Integer>();
            Object[] objs = popCondition.toArray();
            block27: for (int i = 0; i < objs.length; ++i) {
                Integer statusVal = (Integer)objs[i];
                switch (statusVal) {
                    case 0: {
                        sortedStatus.add(new Integer(2));
                        continue block27;
                    }
                    case 2: {
                        sortedStatus.add(new Integer(0));
                        continue block27;
                    }
                    case 3: {
                        sortedStatus.add(new Integer(1));
                        continue block27;
                    }
                    case 6: {
                        sortedStatus.add(new Integer(3));
                        continue block27;
                    }
                    case 7: {
                        sortedStatus.add(new Integer(4));
                        continue block27;
                    }
                    case 11: {
                        sortedStatus.add(new Integer(5));
                        continue block27;
                    }
                    case 12: {
                        sortedStatus.add(new Integer(6));
                        continue block27;
                    }
                    case 13: {
                        sortedStatus.add(new Integer(7));
                        continue block27;
                    }
                    case 16: {
                        sortedStatus.add(new Integer(8));
                        continue block27;
                    }
                    case 32768: {
                        sortedStatus.add(new Integer(9));
                        continue block27;
                    }
                    case 32769: {
                        sortedStatus.add(new Integer(10));
                        continue block27;
                    }
                    case 32770: {
                        sortedStatus.add(new Integer(11));
                        continue block27;
                    }
                    case 32771: {
                        sortedStatus.add(new Integer(12));
                        continue block27;
                    }
                    case 32772: {
                        sortedStatus.add(new Integer(13));
                        continue block27;
                    }
                    case 32773: {
                        sortedStatus.add(new Integer(14));
                        continue block27;
                    }
                    case 32774: {
                        sortedStatus.add(new Integer(15));
                        continue block27;
                    }
                    case 32783: {
                        sortedStatus.add(new Integer(15));
                        continue block27;
                    }
                    case 32775: {
                        sortedStatus.add(new Integer(16));
                        continue block27;
                    }
                    case 32776: {
                        sortedStatus.add(new Integer(17));
                        continue block27;
                    }
                    case 32777: {
                        sortedStatus.add(new Integer(18));
                        continue block27;
                    }
                    case 32778: {
                        sortedStatus.add(new Integer(19));
                        continue block27;
                    }
                    case 32779: {
                        sortedStatus.add(new Integer(20));
                        continue block27;
                    }
                    case 32780: {
                        sortedStatus.add(new Integer(21));
                        continue block27;
                    }
                    case 32781: {
                        sortedStatus.add(new Integer(22));
                        continue block27;
                    }
                    case 32782: {
                        sortedStatus.add(new Integer(23));
                    }
                }
            }
            if (sortedStatus.contains(new Integer(4))) {
                if (sortedStatus.contains(new Integer(12))) {
                    Trace.verbose((Object)this, "setPopCondition", "Found canceled rollback, replacing PR with PR Canceled.");
                    sortedStatus.remove(new Integer(12));
                    sortedStatus.add(new Integer(24));
                } else if (sortedStatus.contains(new Integer(13))) {
                    Trace.verbose((Object)this, "setPopCondition", "Found cancelled rollback, replacing PRC with PR Canceled.");
                    sortedStatus.remove(new Integer(13));
                    sortedStatus.add(new Integer(24));
                }
            }
            this.conditionInfo = sortedStatus;
        } else {
            this.conditionInfo = null;
        }
        Trace.methodEnd(this, "setPopCondition");
    }

    public void setCreationDate(Date creationDate) {
        String METHOD = "setCreationDate";
        Trace.methodBegin(this, "setCreationDate");
        this.creationDate = creationDate;
        Trace.methodEnd(this, "setCreationDate");
    }

    public void setInstance(CIMInstance instance) {
        String METHOD = "setInstance";
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
        Trace.methodEnd(this, "setInstance");
    }

    public void setSystemCreationClassName(String sccn) {
        String METHOD = "setSystemCreationClassName";
        Trace.methodBegin(this, "setSystemCreationClassName");
        this.systemCreationClassName = sccn;
        Trace.methodEnd(this, "setSystemCreationClassName");
    }

    public void setSystemName(String sn) {
        String METHOD = "setSystemName";
        Trace.methodBegin(this, "setSystemName");
        this.systemName = sn;
        Trace.methodEnd(this, "setSystemName");
    }

    public void setCreationClassName(String ccn) {
        String METHOD = "setCreationClassName";
        Trace.methodBegin(this, "setCreationClassName");
        this.creationClassName = ccn;
        Trace.methodEnd(this, "setCreationClassName");
    }

    public void setDeviceID(String deviceID) {
        String METHOD = "setDeviceID";
        Trace.methodBegin(this, "setDeviceID");
        this.deviceID = deviceID;
        Trace.methodEnd(this, "setDeviceID");
    }

    public void setObjectType(int objectType) {
        String METHOD = "setObjectType";
        Trace.methodBegin(this, "setObjectType");
        this.objectType = objectType;
        Trace.methodEnd(this, "setObjectType");
    }

    public void setKey(Collection props) {
        String METHOD = "setKey";
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
        Trace.methodEnd(this, "setKey");
    }

    public MethodCallStatus createMapping(InitiatorVolumeMappingInterface mapping) throws ConfigMgmtException {
        String METHOD = "createMapping";
        Trace.methodBegin(this, "createMapping");
        Initiator initiator = (Initiator)mapping.getObject();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "createMapping", "Calling mappingCreationHelper with mapping attributes: " + mapping.getLun() + " " + mapping.getPermissions() + " " + this.name + " " + initiator.getName());
        }
        MethodCallStatus methodCallStatus = initiator.mappingCreationHelper(mapping.getLun(), mapping.getPermissions(), this.instance, initiator.getInstance());
        Trace.methodEnd(this, "createMapping");
        return methodCallStatus;
    }

    public MethodCallStatus createMapping(int lun, Set permissions, InitiatorInterface initiator) throws ConfigMgmtException {
        String METHOD = "createMapping";
        Trace.methodBegin(this, "createMapping");
        Initiator init = (Initiator)initiator;
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "createMapping", "Calling mappingCreationHelper with mapping attributes: " + new Integer(lun).toString() + " " + permissions + " " + this.name + " " + init.getName());
        }
        MethodCallStatus methodCallStatus = init.mappingCreationHelper(new Integer(lun).toString(), permissions, this.instance, init.getInstance());
        Trace.methodEnd(this, "createMapping");
        return methodCallStatus;
    }

    public MethodCallStatus createMapping(Set permissions, InitiatorInterface initiator) throws ConfigMgmtException {
        String METHOD = "createMapping";
        Trace.methodBegin(this, "createMapping");
        Initiator init = (Initiator)initiator;
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "createMapping", "Calling mappingCreationHelper with mapping attributes: " + init.getNextAvailableLUN() + " " + permissions + " " + this.name + " " + init.getName());
        }
        MethodCallStatus methodCallStatus = init.mappingCreationHelper(new Integer(init.getNextAvailableLUN()).toString(), permissions, this.instance, init.getInstance());
        Trace.methodEnd(this, "createMapping");
        return methodCallStatus;
    }

    public MethodCallStatus removeMapping(InitiatorInterface initiator) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = "removeMapping";
        Trace.methodBegin(this, "removeMapping");
        ArrayList mappings = new ArrayList();
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        Trace.verbose((Object)this, "removeMapping", "Querying CIM for associated SCSIProtocolController Instance");
        Enumeration enumSCSI = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPProtocolControllerForUnit", "SunStorEdge_DSPSCSIProtocolController", "Dependent", "Antecedent", true, false, null);
        Trace.verbose((Object)this, "removeMapping", "Returned from querying CIM for associated SCSIProtocolController Instance");
        if (enumSCSI != null && enumSCSI.hasMoreElements()) {
            Trace.verbose((Object)this, "removeMapping", "SCSIProtocolController Instance Found");
            while (enumSCSI.hasMoreElements()) {
                CIMInstance scsi = (CIMInstance)enumSCSI.nextElement();
                CIMValue initiatorName = scsi.getProperty("AssociatedInitiator").getValue();
                String curName = new String();
                if (initiatorName != null) {
                    curName = (String)initiatorName.getValue();
                } else {
                    Trace.error((Object)this, "removeMapping", "Errors retrieving SCSIProtocolController 'AssignedInitiator'");
                }
                if (!curName.equals(((Initiator)initiator).getInstanceID())) continue;
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "removeMapping", "Initiator Instance: " + initiator.getName() + " Found");
                }
                CIMArgument[] inArgs = new CIMArgument[2];
                CIMArgument[] outArgs = new CIMArgument[1];
                inArgs[0] = new CIMArgument("ProtocolController", new CIMValue((Object)scsi.getObjectPath()));
                inArgs[1] = new CIMArgument("Device", new CIMValue((Object)this.instance.getObjectPath()));
                outArgs = new CIMArgument[1];
                Trace.verbose((Object)this, "removeMapping", "Getting the relevant StorageDomain");
                CIMObjectPath controllerConfigurationServiceObjectPath = ServiceFinder.getService(this.handle, initiator.getStorageDomain(), 1);
                Trace.verbose((Object)this, "removeMapping", "ControllerConfigurationService object path is: " + controllerConfigurationServiceObjectPath);
                Trace.verbose((Object)this, "removeMapping", "Calling DetachDevice");
                CIMValue returnCodeValue = this.handle.invokeMethod(controllerConfigurationServiceObjectPath, "DetachDevice", inArgs, outArgs);
                Trace.verbose((Object)this, "removeMapping", "Returned from calling DetachDevice");
                int retVal = (Integer)returnCodeValue.getValue();
                methodCallStatus.setReturnCode(retVal);
                Trace.verbose((Object)this, "removeMapping", "Return code: " + retVal);
                Trace.methodEnd(this, "removeMapping");
                return methodCallStatus;
            }
        }
        Trace.error((Object)this, "removeMapping", "Initiator Not Found to be Mapped");
        throw new ItemNotFoundException(initiator.getName());
    }

    public MethodCallStatus extend(BigInteger size) throws ConfigMgmtException, BadParameterException {
        String METHOD = "extend";
        Trace.methodBegin(this, "extend");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        if (size.compareTo(BigInteger.ZERO) != 0) {
            if (size.compareTo(this.getSize()) == -1) {
                Trace.error((Object)this, "extend", "Invalid size for extension, too small.");
                throw new BadParameterException(size.toString(), "error.bizobj.volumeSizeTooSmall");
            }
            if (size.compareTo(ConstantsEnt.StorageVolumeProperties.MAX_VOLUME_SIZE) == 1) {
                Trace.error((Object)this, "extend", "Invalid size for extension, too large.");
                throw new BadParameterException(size.toString(), "error.bizobj.volumeSizeTooBig");
            }
        }
        if (size.compareTo(ConstantsEnt.StorageVolumeProperties.MAX_VOLUME_SIZE) == 1) {
            Trace.error((Object)this, "extend", "Invalid size for extension, too large.");
            throw new BadParameterException(size.toString(), "error.bizobj.volumeSizeTooBig");
        }
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue(null)), new CIMArgument("ElementType", new CIMValue((Object)new UnsignedInt16(2))), new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Goal", new CIMValue(null)), new CIMArgument("Size", new CIMValue((Object)new UnsignedInt64(size))), new CIMArgument("InPool", new CIMValue(null)), new CIMArgument("TheElement", new CIMValue((Object)this.instance.getObjectPath())), new CIMArgument("CowPool", new CIMValue(null))};
        CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("TheElement", new CIMValue(null))};
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomainName(), 0);
        Trace.verbose((Object)this, "extend", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "extend", "Calling CreateStorageVolume with extended size");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyElementFromStoragePool", inArgs, outArgs);
        Trace.verbose((Object)this, "extend", "Returned from calling CreateStorageVolume with extended size");
        int retVal = (Integer)returnCodeValue.getValue();
        methodCallStatus.setReturnCode(retVal);
        Trace.verbose((Object)this, "extend", "Return code: " + retVal);
        Trace.methodEnd(this, "extend");
        return methodCallStatus;
    }

    public MethodCallStatus createSnapshot(String name, int snapNum, int snapChange) throws ConfigMgmtException, BadParameterException {
        String METHOD = "createSnapshot";
        Trace.methodBegin(this, "createSnapshot");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        Trace.verbose((Object)this, "createSnapshot", "Validating parameters");
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        msv.validateName(name);
        if (snapChange < 0 || snapChange > 100) {
            Trace.error((Object)this, "createSnapshot", "Invalid snap change.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_SNAP_CHANGE, null, "Snap change is invalid."), 300);
        }
        if (snapNum < 0 || snapNum > 8) {
            Trace.error((Object)this, "createSnapshot", "Invalid snap number.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_SNAP_NUMBER, null, "Snap number is invalid."), 300);
        }
        ManageStoragePools msp = new ManageStoragePools();
        msp.init(this.context, null);
        StoragePool poolObj = new StoragePool();
        try {
            poolObj = (StoragePool)msp.getItemByName(this.getStoragePoolName(), this.getStorageDomainName());
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "createSnapshot", "StorageDomainName: " + this.getStorageDomainName() + " not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{this.getStorageDomainName()}, "StorageDomain specified not found."), 100);
        }
        if (poolObj == null) {
            Trace.error((Object)this, "createSnapshot", "StoragePool: " + this.getStoragePoolName() + " not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{this.getStoragePoolName()}, "StoragePool specified not found."), 100);
        }
        Trace.verbose((Object)this, "createSnapshot", "Querying CIM for associated StorageCapabilities Instance");
        Enumeration enumeration = this.handle.associators(poolObj.getInstance().getObjectPath(), "SunStorEdge_DSPElementCapabilities", "SunStorEdge_DSPStorageCapabilities", "ManagedElement", "Capabilities", true, false, ConstantsEnt.StorageCapabilitiesProperties.PROP_LIST);
        Trace.verbose((Object)this, "createSnapshot", "Returned from querying CIM for associated StorageCapabilities Instance");
        CIMArgument[] createSettingOutArgs = new CIMArgument[1];
        CIMArgument[] createSettingInArgs = new CIMArgument[1];
        CIMInstance setting = new CIMInstance();
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "createSnapshot", "StorageCapabilities Instance Found");
            CIMInstance profile = (CIMInstance)enumeration.nextElement();
            createSettingInArgs[0] = new CIMArgument("SettingType", new CIMValue((Object)new UnsignedInt16(2)));
            Trace.verbose((Object)this, "createSnapshot", "Calling CreateSetting");
            CIMValue settingCodeValue = this.handle.invokeMethod(profile.getObjectPath(), "CreateSetting", createSettingInArgs, createSettingOutArgs);
            Trace.verbose((Object)this, "createSnapshot", "Returned from calling CreateSetting");
            Trace.verbose((Object)this, "createSnapshot", "Setting snapshot pool size for setting");
            CIMObjectPath settingPath = (CIMObjectPath)createSettingOutArgs[0].getValue().getValue();
            setting = this.handle.getInstance(settingPath, false, true, true);
            try {
                setting.setProperty("SnapshotPoolPercent", new CIMValue((Object)new UnsignedInt16(snapNum * snapChange)));
            }
            catch (CIMException ce) {
                Trace.error((Object)this, "createSnapshot", "Errors setting snapshot pool percent.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Errors setting snapshot pool percent."), 100);
            }
            this.handle.setInstance(settingPath, setting);
        }
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)name)), new CIMArgument("SourceElement", new CIMValue((Object)this.instance.getObjectPath())), new CIMArgument("TargetSettingGoal", new CIMValue((Object)setting.getObjectPath())), new CIMArgument("TargetPool", new CIMValue(null)), new CIMArgument("CopyType", new CIMValue((Object)new UnsignedInt16(4)))};
        CIMArgument[] outArgs = new CIMArgument[2];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomainName(), 0);
        Trace.verbose((Object)this, "createSnapshot", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "createSnapshot", "Calling CreateReplica");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateReplica", inArgs, outArgs);
        Trace.verbose((Object)this, "createSnapshot", "Returned from calling CreateReplica");
        int retVal = (Integer)returnCodeValue.getValue();
        methodCallStatus.setReturnCode(retVal);
        Trace.verbose((Object)this, "createSnapshot", "Return code: " + retVal);
        Trace.methodEnd(this, "createSnapshot");
        return methodCallStatus;
    }

    public MethodCallStatus deleteSnapshot(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = "deleteSnapshot";
        Trace.methodBegin(this, "deleteSnapshot");
        MethodCallStatus mcs = new MethodCallStatus();
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        Trace.verbose((Object)this, "deleteSnapshot", "Calling ManageStorageVolumes.delete() with the StorageVolume(Replica)");
        mcs = msv.delete(key);
        Trace.methodEnd(this, "deleteSnapshot");
        return mcs;
    }

    public MethodCallStatus resetSnapshot() throws ConfigMgmtException {
        String METHOD = "resetSnapshot";
        Trace.methodBegin(this, "resetSnapshot");
        MethodCallStatus mcs = new MethodCallStatus();
        Trace.verbose((Object)this, "resetSnapshot", "Querying CIM for associated StorageSynchronized instance");
        if (!this.isSnapshot()) {
            mcs.setReturnCode(5);
            Trace.methodEnd(this, "resetSnapshot");
            return mcs;
        }
        Trace.verbose((Object)this, "resetSnapshot", "Querying CIM for associated StorageSynchronized instance");
        Enumeration enumeration = this.handle.references(this.instance.getObjectPath(), "SunStorEdge_DSPStorageSynchronized", "SyncedElement", true, false, null);
        Trace.verbose((Object)this, "resetSnapshot", "Returned from querying CIM for associated StorageSynchronized instance");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            Trace.error((Object)this, "resetSnapshot", "StorageSynchronized instance not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "StorageSynchronized instance not found."), 100);
        }
        CIMInstance syncInstance = (CIMInstance)enumeration.nextElement();
        Trace.verbose((Object)this, "resetSnapshot", "StorageSynchronized instance found.");
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Operation", new CIMValue((Object)new UnsignedInt16(4))), new CIMArgument("Synchronization", new CIMValue((Object)syncInstance.getObjectPath()))};
        CIMArgument[] outArgs = new CIMArgument[1];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomainName(), 0);
        Trace.verbose((Object)this, "resetSnapshot", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "resetSnapshot", "Calling ModifySynchronization");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ModifySynchronization", inArgs, outArgs);
        Trace.verbose((Object)this, "resetSnapshot", "Returned from calling ModifySynchronization");
        int retVal = (Integer)returnCodeValue.getValue();
        mcs.setReturnCode(retVal);
        Trace.verbose((Object)this, "resetSnapshot", "Return code: " + retVal);
        Trace.methodEnd(this, "resetSnapshot");
        return mcs;
    }

    public MethodCallStatus removeSnapshotPool() throws ConfigMgmtException {
        String METHOD = "removeSnapshotPool";
        Trace.methodBegin(this, "removeSnapshotPool");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        if (this.getNumberOfSnapshots() == 0) {
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Volume", new CIMValue((Object)this.instance.getObjectPath()))};
            CIMArgument[] outArgs = new CIMArgument[]{};
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomainName(), 0);
            Trace.verbose((Object)this, "removeSnapshotPool", "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "removeSnapshotPool", "Calling ModifySynchronization");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "DeleteSnapshotPool", inArgs, outArgs);
            Trace.verbose((Object)this, "removeSnapshotPool", "Returned from calling DeleteSnapshotPool");
            int retVal = (Integer)returnCodeValue.getValue();
            methodCallStatus.setReturnCode(retVal);
            Trace.verbose((Object)this, "removeSnapshotPool", "Return code: " + retVal);
        } else {
            methodCallStatus.setReturnCode(6);
        }
        Trace.methodEnd(this, "removeSnapshotPool");
        return methodCallStatus;
    }

    public boolean isSnapshot() {
        String METHOD = "isSnapshot";
        Trace.methodBegin(this, "isSnapshot");
        if (this.type.equals("Snap")) {
            Trace.methodEnd(this, "isSnapshot");
            return true;
        }
        Trace.methodEnd(this, "isSnapshot");
        return false;
    }

    public boolean isRollbackInProgress() {
        String METHOD = "isRollbackInProgress";
        Trace.methodBegin(this, "isRollbackInProgress");
        if (this.conditionInfo != null) {
            if ((this.conditionInfo.contains(new Integer(12)) || this.conditionInfo.contains(new Integer(13))) && !this.conditionInfo.contains(new Integer(4))) {
                Trace.methodEnd(this, "isRollbackInProgress");
                return true;
            }
            Trace.methodEnd(this, "isRollbackInProgress");
            return false;
        }
        Trace.methodEnd(this, "isRollbackInProgress");
        return false;
    }

    public boolean isMirrorComponent() {
        String METHOD = "isMirrorComponent";
        Trace.methodBegin(this, "isMirrorComponent");
        if (this.objectType == 3) {
            Trace.methodEnd(this, "isMirrorComponent");
            return true;
        }
        Trace.methodEnd(this, "isMirrorComponent");
        return false;
    }

    public Collection getFieldMap() throws ConfigMgmtException {
        String METHOD = "getFieldMap";
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("popname", "ElementName", false, false));
            this.fieldMap.add(new MapElement("description", "Description", false, true));
            this.fieldMap.add(new MapElement("wwn", "Name", true, false));
            this.fieldMap.add(new MapElement("blockSize", "BlockSize", true, false));
            this.fieldMap.add(new MapElement("consumableBlocks", "ConsumableBlocks", true, false));
            this.fieldMap.add(new MapElement("state", "VolumeState", true, true));
            this.fieldMap.add(new MapStringArrayToString("type", "OtherIdentifyingInfo", true, true, 0));
            this.fieldMap.add(new MapElement("systemCreationClassName", "SystemCreationClassName", true, false));
            this.fieldMap.add(new MapElement("systemName", "SystemName", true, false));
            this.fieldMap.add(new MapElement("creationClassName", "CreationClassName", true, false));
            this.fieldMap.add(new MapElement("deviceID", "DeviceID", true, false));
            this.fieldMap.add(new MapElement("storageDomainName", "StorageDomain", true, true));
            this.fieldMap.add(new MapElement("objectType", "ObjectType", true, false));
            this.fieldMap.add(new MapArrayToSet("popCondition", "OperationalStatus", true, false));
        }
        Trace.methodEnd(this, "getFieldMap");
        return this.fieldMap;
    }

    public void loadKeys() {
        String METHOD = "loadKeys";
        Trace.methodBegin(this, "loadKeys");
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("SystemCreationClassName", new CIMValue((Object)this.getSystemCreationClassName())));
        prop.add(new CIMProperty("SystemName", new CIMValue((Object)this.getSystemName())));
        prop.add(new CIMProperty("CreationClassName", new CIMValue((Object)this.getCreationClassName())));
        prop.add(new CIMProperty("DeviceID", new CIMValue((Object)this.getDeviceID())));
        this.setKey(prop);
        Trace.methodEnd(this, "loadKeys");
    }

    public String toString() {
        String METHOD = "toString";
        Trace.methodBegin(this, "toString");
        if (Trace.isTraceEnabled(this)) {
            Trace.methodEnd(this, "toString");
            return "\nStorageVolume with:\n       CIMObjectPath: " + this.instance.getObjectPath() + "\n       key(s): SystemCreationClassName - " + this.systemCreationClassName + "\n       : SystemName - " + this.systemName + "\n       : CreationClassName - " + this.creationClassName + "\n       : DeviceID - " + this.deviceID + "\n       name: " + this.getName() + "\n       description: " + this.getDescription() + "\n       storage domain name: " + this.getStorageDomainName() + "\n       WWN: " + this.getWwn() + "\n       total size: " + this.getSize() + "\n       capacity: " + this.getSize() + "\n       state: " + this.getState() + "\n       condition: " + this.getCondition() + "\n       type: " + this.getType() + "\n       creation date: " + this.getCreationDate();
        }
        Trace.methodEnd(this, "toString");
        return "";
    }

    public int getNumAllocatedSnapshots() throws ConfigMgmtException {
        String METHOD = "getNumAllocatedSnapshots";
        Trace.methodBegin(this, "getNumAllocatedSnapshots");
        this.snapshotPropertiesLoader();
        Trace.methodEnd(this, "getNumAllocatedSnapshots");
        return this.snapshotCount;
    }

    public int getSnapshotWriteActivity() throws ConfigMgmtException {
        String METHOD = "getNumAllocatedSnapshots";
        Trace.methodBegin(this, "getNumAllocatedSnapshots");
        this.snapshotPropertiesLoader();
        Trace.methodEnd(this, "getNumAllocatedSnapshots");
        return this.writeActivity;
    }

    public StoragePoolInterface getStoragePool() throws ConfigMgmtException {
        String METHOD = "getStoragePool";
        Trace.methodBegin(this, "getStoragePool");
        CIMInstance ci_pool = null;
        StoragePool pool = null;
        Enumeration alloc_enum = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPAllocatedFromStoragePool", "SunStorEdge_DSPStoragePool", "Dependent", "Antecedent", true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
        Trace.verbose((Object)this, "getStoragePool", "Returned from querying CIM for associated StoragePool Instance");
        if (alloc_enum == null || !alloc_enum.hasMoreElements()) {
            Trace.error((Object)this, "getStoragePool", "StoragePool could not be found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.POOL_NOT_FOUND, null, "Snapshot pool could not be found."), 300);
        }
        Trace.verbose((Object)this, "getStoragePool", "StoragePool Instance Found");
        ci_pool = (CIMInstance)alloc_enum.nextElement();
        pool = new StoragePool();
        pool.setInstance(ci_pool);
        pool.init(this.context);
        CIMObjectWrapper.populate(pool, pool.getFieldMap(), ci_pool);
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("InstanceID", new CIMValue((Object)pool.getInstanceID())));
        pool.setKey(prop);
        Trace.methodEnd(this, "getStoragePool");
        return pool;
    }

    public StoragePoolInterface getSnapshotReserveStoragePool() throws ConfigMgmtException {
        String METHOD = "getSnapshotReserveStoragePool";
        Trace.methodBegin(this, "getSnapshotReserveStoragePool");
        StoragePool pool = null;
        CIMInstance ci_pool = null;
        Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "Querying CIM for associated StorageExtent through MetaBasedOn association");
        Enumeration meta_enum = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPMetaBasedOn", "SunStorEdge_DSPStorageExtent", "Dependent", "Antecedent", true, false, null);
        Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "Returned from querying CIM for associated StorageExtent through MetaBasedOn association");
        if (meta_enum != null && meta_enum.hasMoreElements()) {
            Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "StorageExtent (COW) Instance Found");
            CIMInstance ci = (CIMInstance)meta_enum.nextElement();
            Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "Querying CIM for associated StoragePool through CONCRETE COMPONENT association");
            Enumeration conc_enum = this.handle.associators(ci.getObjectPath(), "SunStorEdge_DSPConcreteComponent", "SunStorEdge_DSPStoragePool", "PartComponent", "GroupComponent", true, false, null);
            Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "Returned from querying CIM for associated StoragePool through CONCRETE COMPONENT association");
            if (conc_enum != null && conc_enum.hasMoreElements()) {
                Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "StoragePool Instance Found");
                ci_pool = (CIMInstance)conc_enum.nextElement();
                pool = new StoragePool();
                pool.setInstance(ci_pool);
                pool.init(this.context);
                CIMObjectWrapper.populate(pool, pool.getFieldMap(), ci_pool);
                ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
                prop.add(new CIMProperty("InstanceID", new CIMValue((Object)pool.getInstanceID())));
                pool.setKey(prop);
            }
        } else {
            Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "MetadBasedOn not found.");
            if (this.getSnapshotPoolSize() > 0) {
                pool = (StoragePool)this.getStoragePool();
            }
        }
        Trace.methodEnd(this, "getSnapshotReserveStoragePool");
        return pool;
    }

    public int getSnapshotPolicy() throws ConfigMgmtException {
        String METHOD = "getSnapshotPolicy";
        Trace.methodBegin(this, "getSnapshotPolicy");
        if (this.snapshotPolicy == -1) {
            this.getVolumeCharacteristics();
        }
        Trace.methodEnd(this, "getSnapshotPolicy");
        return this.snapshotPolicy;
    }

    public MethodCallStatus createSnapshotPool(StoragePoolInterface snapPool, int snapNum, int snapChange, int snapPolicy) throws ConfigMgmtException {
        String METHOD = "createSnapshotPool";
        Trace.methodBegin(this, "createSnapshotPool");
        Trace.methodEnd(this, "createSnapshotPool");
        return this.createSnapshotPool((StoragePool)snapPool, snapNum, snapChange, snapPolicy, null);
    }

    protected MethodCallStatus createSnapshotPool(StoragePoolInterface snapPool, int snapNum, int snapChange, int snapPolicy, MirrorComponentEnt1Interface snapComp) throws BadParameterException, ConfigMgmtException {
        String METHOD = "createSnapshotPool";
        Trace.methodBegin(this, "createSnapshotPool");
        MethodCallStatus methodCallStatus = null;
        CIMInstance ci_snapshotProps = this.snapshotPropertiesLoader();
        if (snapNum != this.snapshotCount || snapChange != this.writeActivity || this.snapshotPolicy != snapPolicy) {
            Trace.verbose((Object)this, "createSnapshotPool", "creating snapshot pool");
            boolean found = false;
            for (int i = 0; i < StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS.length && !found; ++i) {
                if (StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS[i] != snapChange) continue;
                found = true;
            }
            if (!found) {
                Trace.error((Object)this, "createSnapshotPool", "Invalid snap change.");
                throw new BadParameterException(new Integer(snapChange).toString(), "error.bizobj.snapChangeInvalid");
            }
            if (snapNum < 0 || snapNum > 32) {
                Trace.error((Object)this, "createSnapshotPool", "Invalid snap number.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_SNAP_NUMBER, null, "Snap number is invalid."), 300);
            }
            if (snapPolicy != -1 && snapPolicy != 0 && snapPolicy != 1 && snapPolicy != 0) {
                Trace.error((Object)this, "createSnapshotPool", "Invalid snap policy.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_SNAP_POLICY, null, "Snapshot policy is invalid."), 300);
            }
            StorageProfile pool_profile = ((StoragePool)snapPool).getStorageProfile();
            if (pool_profile != null && pool_profile.getVirtualizationStrategy() == 2) {
                Trace.error((Object)this, "createSnapshotPool", "Invalid virtualization strategy.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_VIRT_STRATEGY, null, "Virtualization strategy is invalid."), 300);
            }
            StoragePool sp = null;
            sp = snapComp != null ? (StoragePool)((MirrorComponentCIM)snapComp).getStoragePool() : (StoragePool)this.getStoragePool();
            Enumeration enumeration = this.handle.associators(sp.getInstance().getObjectPath(), "SunStorEdge_DSPElementCapabilities", "SunStorEdge_DSPStorageCapabilities", "ManagedElement", "Capabilities", true, false, ConstantsEnt.StorageCapabilitiesProperties.PROP_LIST);
            Trace.verbose((Object)this, "createSnapshotPool", "Returned from querying CIM for associated StorageCapabilities Instance");
            CIMArgument[] createSettingOutArgs = new CIMArgument[1];
            CIMArgument[] createSettingInArgs = new CIMArgument[1];
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance profileSettings = (CIMInstance)enumeration.nextElement();
                createSettingInArgs[0] = new CIMArgument("SettingType", new CIMValue((Object)new UnsignedInt16(2)));
                Trace.verbose((Object)this, "createSnapshotPool", "Calling CreateSetting");
                CIMValue settingCodeValue = this.handle.invokeMethod(profileSettings.getObjectPath(), "CreateSetting", createSettingInArgs, createSettingOutArgs);
                Trace.verbose((Object)this, "createSnapshotPool", "Returned from calling CreateSetting");
                Trace.verbose((Object)this, "createSnapshotPool", "Setting the Snapshot Pool percent size");
                CIMObjectPath settingPath = (CIMObjectPath)createSettingOutArgs[0].getValue().getValue();
                CIMInstance setting = this.handle.getInstance(settingPath, false, true, true);
                try {
                    setting.setProperty("SnapshotCount", new CIMValue((Object)new UnsignedInt16(snapNum)));
                    setting.setProperty("WriteActivity", new CIMValue((Object)new UnsignedInt16(snapChange)));
                    setting.setProperty("SnapshotPoolPercent", new CIMValue((Object)new UnsignedInt16(snapNum * snapChange)));
                    if (snapPolicy != -1) {
                        setting.setProperty("SnapshotPolicy", new CIMValue((Object)new UnsignedInt16(snapPolicy)));
                    }
                    this.handle.setInstance(settingPath, setting);
                }
                catch (CIMException ce) {
                    Trace.error((Object)this, "createSnapshotPool", "Errors setting snapshot properties");
                    throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Errors setting snapshot properties."), 100);
                }
                CIMArgument[] inArgs = snapComp != null ? new CIMArgument[9] : new CIMArgument[]{new CIMArgument("ElementName", new CIMValue(null)), new CIMArgument("ElementType", new CIMValue((Object)new UnsignedInt16(2))), new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Goal", new CIMValue((Object)setting.getObjectPath())), new CIMArgument("Size", new CIMValue((Object)new UnsignedInt64(this.getSize()))), new CIMArgument("InPool", new CIMValue(null)), new CIMArgument("TheElement", new CIMValue((Object)this.instance.getObjectPath())), new CIMArgument("CowPool", new CIMValue((Object)snapPool.getInstance().getObjectPath()))};
                if (snapComp != null) {
                    inArgs[8] = new CIMArgument("snapComponent", new CIMValue((Object)((MirrorComponentCIM)snapComp).getInstance().getObjectPath()));
                }
                CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("TheElement", new CIMValue(null))};
                CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomainName(), 0);
                Trace.verbose((Object)this, "createSnapshotPool", "Calling ConfServiceObjectPath");
                CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyElementFromStoragePool", inArgs, outArgs);
                Trace.verbose((Object)this, "createSnapshotPool", "Returned from calling ConfServiceObjectPath");
                int retVal = (Integer)returnCodeValue.getValue();
                this.snapshotCount = snapNum;
                this.writeActivity = snapChange;
                methodCallStatus = new MethodCallStatus();
                methodCallStatus.setReturnCode(retVal);
                Trace.verbose((Object)this, "extend", "Return code: " + retVal);
            }
        }
        Trace.methodEnd(this, "createSnapshotPool");
        return methodCallStatus;
    }

    public MethodCallStatus extendSnapshotPool(StoragePoolInterface snapPool, int snapNum, int snapChange) throws BadParameterException, ConfigMgmtException {
        String METHOD = "extendSnapshotPool";
        Trace.methodBegin(this, "extendSnapshotPool");
        MethodCallStatus methodCallStatus = this.createSnapshotPool(snapPool, snapNum, snapChange, -1);
        Trace.methodEnd(this, "extendSnapshotPool");
        return methodCallStatus;
    }

    public MethodCallStatus extendSnapshotPool(int snapNum, int snapChange) throws BadParameterException, ConfigMgmtException {
        String METHOD = "extendSnapshotPool";
        Trace.methodBegin(this, "extendSnapshotPool");
        StoragePool snapPool = (StoragePool)this.getSnapshotReserveStoragePool();
        MethodCallStatus methodCallStatus = null;
        if (snapPool != null) {
            methodCallStatus = this.extendSnapshotPool(snapPool, snapNum, snapChange);
        }
        Trace.methodEnd(this, "extendSnapshotPool");
        return methodCallStatus;
    }

    public void setSnapshotPolicy(int policy) throws BadParameterException, ConfigMgmtException {
        int pol;
        UnsignedInt16 p_value;
        CIMValue c_policy;
        String METHOD = "setSnapshotPolicy";
        Trace.methodBegin(this, "setSnapshotPolicy");
        CIMInstance ci = this.getVolumeCharacteristics();
        if (ci != null && (c_policy = ci.getProperty("SnapshotPolicy").getValue()) != null && (p_value = (UnsignedInt16)c_policy.getValue()) != null && (pol = p_value.intValue()) != policy) {
            try {
                ci.setProperty("SnapshotPolicy", new CIMValue((Object)new UnsignedInt16(policy)));
            }
            catch (CIMException cime) {
                Trace.error((Object)this, "setSnapshotPolicy", "CIMException - Exception thrown when set new snapshot policy: " + (Object)((Object)cime));
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Problems setting snapshot policy."), 100);
            }
            Trace.verbose((Object)this, "setSnapshotPolicy", "Setting snapshot policy");
            this.handle.setInstance(ci.getObjectPath(), ci);
            Trace.verbose((Object)this, "setSnapshotPolicy", "Returned from setting snapshot policy");
            this.snapshotPolicy = pol;
        }
        Trace.methodEnd(this, "setSnapshotPolicy");
    }

    public ArrayList getAssociatedReplicationSets() throws ConfigMgmtException {
        String METHOD = "getAssociatedReplicationSets";
        Trace.methodBegin(this, "getAssociatedReplicationSets");
        ArrayList list = null;
        ManageReplicationServicesEnt1Interface mgmtRepSet = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
        mgmtRepSet.init(this.context, null, null);
        list = (ArrayList)mgmtRepSet.getReplicationSetListByVolume(this.instance.getKeys());
        Trace.methodEnd(this, "getAssociatedReplicationSets");
        return list;
    }

    private CIMInstance snapshotPropertiesLoader() throws ConfigMgmtException {
        String METHOD = "snapshotPropertiesLoader";
        Trace.methodBegin(this, "snapshotPropertiesLoader");
        CIMInstance ci = null;
        if (this.writeActivity == -1 || this.snapshotCount == -1) {
            Trace.verbose((Object)this, "snapshotPropertiesLoader", "Querying CIM for associated SyntheticSettingData Instance");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPSyntheticElementSettingData", "SunStorEdge_DSPSyntheticSettingData", "ManagedElement", "SettingData", true, false, null);
            Trace.verbose((Object)this, "snapshotPropertiesLoader", "Returned from querying CIM for associated SyntheticSettingData Instance");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "snapshotPropertiesLoader", "SyntheticSettingData Instance Found");
                ci = (CIMInstance)enumeration.nextElement();
                CIMValue c_snapshotCount = ci.getProperty("SnapshotCount").getValue();
                CIMValue c_writeActivity = ci.getProperty("WriteActivity").getValue();
                if (c_snapshotCount != null && c_writeActivity != null) {
                    this.snapshotCount = ((UnsignedInt16)c_snapshotCount.getValue()).intValue();
                    this.writeActivity = ((UnsignedInt16)c_writeActivity.getValue()).intValue();
                } else {
                    Trace.error((Object)this, "snapshotPropertiesLoader", "Error retreiving snapshotcount and writeactivity");
                }
            } else {
                int snapSize = this.getSnapshotPoolSize();
                if (snapSize != 0) {
                    Trace.verbose((Object)this, "snapshotPropertiesLoader", "Guessing what are the snapshotCount and writeActivity values");
                    boolean found = false;
                    int i = 0;
                    int j = 0;
                    for (i = 0; !found && i <= 32; ++i) {
                        for (j = 0; !found && j < StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS.length; ++j) {
                            Trace.verbose((Object)this, "snapshotPropertiesLoader", "Checking #:" + i + ", Activity:" + StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS[j]);
                            int guess = i * StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS[j];
                            if (guess != snapSize) continue;
                            found = true;
                            this.snapshotCount = i;
                            this.writeActivity = StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS[j];
                        }
                    }
                } else {
                    this.snapshotCount = 0;
                    this.writeActivity = StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS[0];
                }
            }
        }
        Trace.methodEnd(this, "snapshotPropertiesLoader");
        return ci;
    }

    public void setRollbackPriority(int priority) throws ConfigMgmtException {
        int tempPriority;
        UnsignedInt16 p_value;
        CIMValue priorityVal;
        String METHOD = "setRollbackPriority";
        Trace.methodBegin(this, "setRollbackPriority");
        CIMInstance ci = this.getVolumeCharacteristics();
        if (ci != null && (priorityVal = ci.getProperty("RollbackPriority").getValue()) != null && (p_value = (UnsignedInt16)priorityVal.getValue()) != null && (tempPriority = p_value.intValue()) != priority) {
            try {
                ci.setProperty("RollbackPriority", new CIMValue((Object)new UnsignedInt16(priority)));
            }
            catch (CIMException cime) {
                Trace.error((Object)this, "setRollbackPriority", "CIMException - Exception thrown when setting new rollback priority: " + (Object)((Object)cime));
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Problems setting rollback priority"), 100);
            }
            Trace.verbose((Object)this, "setRollbackPriority", "Setting rollback priority");
            this.handle.setInstance(ci.getObjectPath(), ci);
            Trace.verbose((Object)this, "setRollbackPriority", "Returned from setting snapshot policy");
            this.rollbackPriority = tempPriority;
        }
        Trace.methodEnd(this, "setRollbackPriority");
    }

    public static void validate(int property, Object newValue, Object oldValue) throws ConfigMgmtException {
        String METHOD = "validate";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$StorageVolume == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$StorageVolume = StorageVolume.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$StorageVolume, "validate");
        switch (property) {
            case 0: {
                if (oldValue != null || newValue == null) break;
                String name = (String)newValue;
                if (name.length() > 16) {
                    throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.NAME_TOO_LONG, null, "Name is too long."), 300);
                }
                if (Pattern.matches("[A-Za-z0-9\\_\\-]+", name)) break;
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_NAME_CHARS, null, "Name contains invalid chars."), 300);
            }
            case 1: {
                if (oldValue != null || newValue == null) break;
                String desc = (String)newValue;
                if (desc.length() > 64) {
                    throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.DESCRIPTION_TOO_LONG, null, "Description is too long."), 300);
                }
                if (Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", desc)) break;
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_DESCRIPTION_CHARS, null, "Description contains invalid chars."), 300);
            }
            case 2: {
                BigInteger size;
                if (oldValue != null || (size = (BigInteger)newValue).compareTo(BigInteger.ZERO) == 0) break;
                if (size.compareTo(ConstantsEnt.StorageVolumeProperties.MIN_VOLUME_SIZE) == -1) {
                    throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.VOLUME_SIZE_TOO_SMALL, null, "Size is too small."), 300);
                }
                if (size.compareTo(ConstantsEnt.StorageVolumeProperties.MAX_VOLUME_SIZE) != 1) break;
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.VOLUME_SIZE_TOO_BIG, null, "Size is too large."), 300);
            }
            case 3: {
                Integer snapCount;
                int snapInt;
                if (oldValue != null || (snapInt = (snapCount = (Integer)newValue).intValue()) >= 0 && snapInt <= 32) break;
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_SNAP_NUMBER, null, "Snapshot count is invalid."), 300);
            }
            case 4: {
                if (oldValue != null) break;
                Integer snapActivity = (Integer)newValue;
                int snapAct = snapActivity;
                if (snapAct == 0 || snapAct == 10 || snapAct == 20 || snapAct == 40 || snapAct == 50 || snapAct == 75 || snapAct == 100) {
                    return;
                }
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_SNAP_CHANGE, null, "Snapshot activity is invalid."), 300);
            }
            case 5: {
                if (oldValue != null) break;
                Integer snapshotPolicy = (Integer)newValue;
                int snapPol = snapshotPolicy;
                if (snapPol == 0 || snapPol == 1) {
                    return;
                }
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_SNAP_POLICY, null, "Snapshot policy is invalid."), 300);
            }
        }
        Trace.methodEnd(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$StorageVolume == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$StorageVolume = StorageVolume.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$StorageVolume, "validate");
    }

    public void removeFromAllGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "removeFromAllGroups");
    }

    public String getStatus() throws ConfigMgmtException {
        Trace.methodBegin(this, "getStatus");
        return null;
    }

    public String getTrayId() throws ConfigMgmtException {
        Trace.methodBegin(this, "getTrayId");
        return null;
    }

    public String getRaidGroupName() throws ConfigMgmtException {
        Trace.methodBegin(this, "getRaidGroupName");
        return null;
    }

    public String getVolumePermissions() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumePermissions");
        return null;
    }

    public void setLUN(int lun) {
    }

    public int getLUN() throws ConfigMgmtException {
        Trace.methodBegin(this, "getLUN");
        return 0;
    }

    public String getVolumeGroup() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumeGroup");
        return null;
    }

    public String getT4Name() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Name");
        return null;
    }

    public void setVolumePermissions(String volumePermissions) {
    }

    public MethodCallStatus delete() throws ConfigMgmtException {
        String METHOD = "delete";
        Trace.methodBegin(this, "delete");
        return null;
    }

    public Set getUsageByVolume() {
        return this.usageByVolume;
    }

    public void setUsageByVolume(Set usageByVolume) {
        this.usageByVolume = usageByVolume;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Props {
        public static final int NAME = 0;
        public static final int DESC = 1;
        public static final int SIZE = 2;
        public static final int SNAP_COUNT = 3;
        public static final int SNAP_ACTIVITY = 4;
        public static final int SNAP_POLICY = 5;
    }
}

