/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirrorComponentCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirroredVolumeCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationSetCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;

public class ManageStorageVolumes
implements ManageStorageVolumesInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        String METHOD = new String("init");
        Trace.methodBegin(this, METHOD);
        if (context == null) {
            Trace.error((Object)this, METHOD, "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, METHOD, "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    private ArrayList enumToList(Enumeration enumeration) throws ConfigMgmtException {
        String METHOD = "enumToList";
        Trace.methodBegin(this, "enumToList");
        ArrayList<StorageVolume> enumToList = new ArrayList<StorageVolume>();
        Hashtable<String, MirroredVolumeCIM> wwn_mirrors = null;
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                MirroredVolumeCIM mv;
                Trace.verbose((Object)this, "enumToList", "Getting StorageVolume type");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                CIMProperty cp = ci.getProperty("ObjectType");
                UnsignedInt16 objectType = (UnsignedInt16)cp.getValue().getValue();
                int type = objectType.intValue();
                Trace.verbose((Object)this, "enumToList", "StorageVolume type: " + type);
                if (type == 1 || type == 4 || type == 5) continue;
                if (type == 3) {
                    Vector info;
                    Trace.verbose((Object)this, "enumToList", "Getting MirroredVolume Java object");
                    MirrorComponentCIM mc = new MirrorComponentCIM();
                    mc.setInstance(ci);
                    mc.init(this.context);
                    CIMObjectWrapper.populate(mc, mc.getFieldMap(), ci);
                    mc.loadKeys();
                    if (wwn_mirrors == null) {
                        wwn_mirrors = new Hashtable();
                    }
                    if ((mv = (MirroredVolumeCIM)mc.getParentMirror()) != null && wwn_mirrors.get(mv.getWwn()) == null) {
                        wwn_mirrors.put(mv.getWwn(), mv);
                        if (Trace.isTraceEnabled(this)) {
                            Trace.verbose((Object)this, "enumToList", "The instance added to the list: " + mv);
                        }
                    }
                    CIMValue cv = ci.getProperty("OtherIdentifyingInfo").getValue();
                    String volType = new String();
                    if (cv != null && (info = (Vector)cv.getValue()).size() != 0) {
                        volType = (String)info.get(0);
                    }
                    if (!volType.equals("Split")) continue;
                    enumToList.add(mc);
                    continue;
                }
                if (type == 2) {
                    String v_wwn;
                    if (wwn_mirrors == null) {
                        wwn_mirrors = new Hashtable<String, MirroredVolumeCIM>();
                    }
                    if (wwn_mirrors.get(v_wwn = (String)(cp = ci.getProperty("Name")).getValue().getValue()) != null) continue;
                    Trace.verbose((Object)this, "enumToList", "Creating MirroredVolume Java object");
                    mv = new MirroredVolumeCIM();
                    mv.setInstance(ci);
                    mv.init(this.context);
                    CIMObjectWrapper.populate(mv, mv.getFieldMap(), ci);
                    mv.loadKeys();
                    wwn_mirrors.put(mv.getWwn(), mv);
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, "enumToList", "The instance added to the list: " + mv);
                    continue;
                }
                Trace.verbose((Object)this, "enumToList", "Creating StorageVolume Java object");
                StorageVolume sv = new StorageVolume();
                sv.setInstance(ci);
                sv.init(this.context);
                CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                sv.loadKeys();
                enumToList.add(sv);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "enumToList", "The instance added to the list: " + sv);
            }
        }
        if (wwn_mirrors != null) {
            Enumeration e = wwn_mirrors.elements();
            while (e.hasMoreElements()) {
                enumToList.add((StorageVolume)e.nextElement());
            }
        }
        return enumToList;
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        String METHOD = new String("getItemsBySystem");
        Trace.methodBegin(this, METHOD);
        ArrayList volumes = new ArrayList();
        try {
            Trace.verbose((Object)this, METHOD, "Querying CIM for StorageVolume Instances");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageVolume"), false, false, true, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES);
            Trace.verbose((Object)this, METHOD, "Returned from querying CIM for StorageVolume Instances");
            volumes = this.enumToList(enumeration);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain all the StorageVolume instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StorageVolume instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain all the StorageVolume instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StorageVolume instances.", e);
        }
        return volumes;
    }

    public ArrayList getItemsByStorageProfile(String name) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = new String("getItemsByStorageProfile");
        Trace.methodBegin(this, METHOD);
        ArrayList volumes = new ArrayList();
        try {
            ManageStoragePools msp = new ManageStoragePools();
            msp.init(this.context, null);
            Trace.verbose((Object)this, METHOD, "Getting the associated StoragePools");
            ArrayList pools = msp.getItemsByStorageProfile(name);
            if (pools.size() != 0) {
                Trace.verbose((Object)this, METHOD, "Getting associated Volumes for each Pool");
                for (int i = 0; i < pools.size(); ++i) {
                    StoragePool pool = (StoragePool)pools.get(i);
                    if (Trace.isTraceEnabled(this)) {
                        Trace.verbose((Object)this, METHOD, "Getting Volumes for Pool: " + pool.getName());
                    }
                    volumes.addAll(pool.getAssociatedVolumes());
                }
            } else {
                Trace.verbose((Object)this, METHOD, "No StoragePools found for this StorageProfile");
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, METHOD, "StorageProfile: " + name + " not found." + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain all the StorageVolume instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StorageVolume instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain all the StorageVolume instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StorageVolume instances.", e);
        }
        return volumes;
    }

    public ArrayList getItemsByStorageDomain(String name) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = new String("getItemsByStorageDomain");
        Trace.methodBegin(this, METHOD);
        ArrayList volumes = new ArrayList();
        try {
            Trace.verbose((Object)this, METHOD, "Checking if StorageDomain exists.");
            Enumeration domains = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageDomain where ElementName = '" + name + "'");
            if (domains == null || !domains.hasMoreElements()) {
                Trace.error((Object)this, METHOD, "StorageDomain : " + name + " not found.");
                throw new ItemNotFoundException(name);
            }
            Trace.verbose((Object)this, METHOD, "Querying CIM for StorageVolume with SD: " + name);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageVolume where StorageDomain = '" + name + "'");
            Trace.verbose((Object)this, METHOD, "Returned from querying CIM for StorageVolume with SD: " + name);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, METHOD, "StorageVolumes Found.");
                volumes = this.enumToList(enumeration);
            } else {
                Trace.verbose((Object)this, METHOD, "No instance returned when trying to obtain the list of StorageVolumes");
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, METHOD, "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain all the StorageVolume instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StorageVolume instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain all the StorageVolume instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StorageVolume instances.", e);
        }
        return volumes;
    }

    public ArrayList getItemsByStoragePool(String poolName, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList volumes;
        block7: {
            String METHOD = new String("getItemsByStoragePool");
            Trace.methodBegin(this, METHOD);
            volumes = new ArrayList();
            try {
                Trace.verbose((Object)this, METHOD, "Querying CIM for StoragePool: " + poolName);
                ManageStoragePools msp = new ManageStoragePools();
                msp.init(this.context, null);
                StoragePool pool = (StoragePool)msp.getItemByName(poolName, domainName);
                Trace.verbose((Object)this, METHOD, "Returned from querying CIM for StoragePool: " + poolName);
                if (pool != null) {
                    Trace.verbose((Object)this, METHOD, "Querying CIM for associated StorageVolume Instances");
                    Enumeration enumeration = this.handle.associators(pool.getInstance().getObjectPath(), "SunStorEdge_DSPAllocatedFromStoragePool", "SunStorEdge_DSPStorageVolume", "Antecedent", "Dependent", true, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES);
                    Trace.verbose((Object)this, METHOD, "Returned from querying CIM for associated StorageVolume Instances");
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        volumes.addAll(this.enumToList(enumeration));
                    }
                    break block7;
                }
                Trace.error((Object)this, METHOD, "StoragePool: " + poolName + " Not Found.");
                throw new ItemNotFoundException(poolName);
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)this, METHOD, "ItemNotFound: " + infe);
                throw infe;
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, METHOD, "Failed: " + cme);
                throw cme;
            }
            catch (NullPointerException npe) {
                Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain all the StorageVolume instances: " + npe);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StorageVolume instances.", npe);
            }
            catch (Exception e) {
                Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain all the StorageVolume instances: " + e);
                throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StorageVolume instances.", e);
            }
        }
        return volumes;
    }

    public ArrayList getItemsByStoragePool(StoragePoolInterface pool) throws ConfigMgmtException {
        String METHOD = "getItemsByStoragePool(StoragePool)";
        Trace.methodBegin(this, "getItemsByStoragePool(StoragePool)");
        ArrayList volumes = new ArrayList();
        try {
            Trace.verbose((Object)this, "getItemsByStoragePool(StoragePool)", "Querying CIM for associated StorageVolume Instances");
            Enumeration enumeration = this.handle.associators(pool.getInstance().getObjectPath(), "SunStorEdge_DSPAllocatedFromStoragePool", "SunStorEdge_DSPStorageVolume", "Antecedent", "Dependent", true, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES);
            Trace.verbose((Object)this, "getItemsByStoragePool(StoragePool)", "Returned from querying CIM for associated StorageVolume Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                volumes.addAll(this.enumToList(enumeration));
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByStoragePool(StoragePool)", "Failed: " + cme);
            throw cme;
        }
        Trace.methodBegin(this, "getItemsByStoragePool(StoragePool)");
        return volumes;
    }

    public ArrayList getItemsByVDisk(String name, int filter) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = new String("getItemsByVDisk");
        Trace.methodBegin(this, METHOD);
        ArrayList volumes = new ArrayList();
        try {
            ManageVDisks mvd = new ManageVDisks();
            mvd.init(this.context, null);
            VDisk disk = (VDisk)mvd.getItemByName(name);
            if (disk == null) {
                Trace.error((Object)this, METHOD, "VDisk: " + name + " not found");
                throw new ItemNotFoundException(name);
            }
            Trace.verbose((Object)this, METHOD, "Getting associated Volumes");
            volumes = disk.getAssociatedVolumes(filter);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, METHOD, "VDisk: " + name + " not found." + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain all the StorageVolume instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StorageVolume instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain all the StorageVolume instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StorageVolume instances.", e);
        }
        return volumes;
    }

    public ArrayList getItemsByArray(String arrayName, int filter) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = new String("getItemsByArray");
        Trace.methodBegin(this, METHOD);
        return this.getItemsByTray(arrayName, null, filter);
    }

    public ArrayList getItemsByTray(String arrayName, String trayId, int filter) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = new String("getItemsByTray");
        Trace.methodBegin(this, METHOD);
        HashMap<String, Object> volumeMap = new HashMap<String, Object>();
        try {
            ManageVDisks mv = new ManageVDisks();
            mv.init(this.context, null);
            ArrayList vdisks = mv.getItemsByTray(arrayName, trayId);
            int size = vdisks.size();
            Set usage = null;
            ReplicationSetCIM repSet = null;
            StorageVolume volume = null;
            int v_size = -1;
            for (int i = 0; i < size; ++i) {
                VDisk vDisk = (VDisk)vdisks.get(i);
                ArrayList avols = vDisk.getAssociatedVolumes(filter);
                v_size = avols.size();
                for (int j = 0; j < v_size; ++j) {
                    if (avols.get(j) instanceof ReplicationSetCIM) {
                        repSet = (ReplicationSetCIM)volumeMap.get(((ReplicationSetCIM)avols.get(j)).getName());
                        if (repSet == null) {
                            repSet = (ReplicationSetCIM)avols.get(j);
                            volumeMap.put(repSet.getName(), repSet);
                            continue;
                        }
                        usage = repSet.getUsageByRepSet();
                        usage.addAll(((ReplicationSetCIM)avols.get(j)).getUsageByRepSet());
                        repSet.setUsageByRepSet(usage);
                        continue;
                    }
                    volume = (StorageVolume)volumeMap.get(((StorageVolume)avols.get(j)).getName());
                    if (volume == null) {
                        volume = (StorageVolume)avols.get(j);
                        volumeMap.put(volume.getName(), volume);
                        continue;
                    }
                    usage = volume.getUsageByVolume();
                    usage.addAll(((StorageVolume)avols.get(j)).getUsageByVolume());
                    volume.setUsageByVolume(usage);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        ArrayList volumes = new ArrayList();
        volumes.addAll(volumeMap.values());
        return volumes;
    }

    public ArrayList getItemsByDisk(String arrayName, String trayId, int diskId, int filter) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = new String("getItemsByDisk");
        Trace.methodBegin(this, METHOD);
        ArrayList volumes = new ArrayList();
        try {
            ManageVDisks mv = new ManageVDisks();
            mv.init(this.context, null);
            ArrayList vdisks = mv.getItemsByDisk(arrayName, trayId, diskId);
            int size = vdisks.size();
            for (int i = 0; i < size; ++i) {
                VDisk vDisk = (VDisk)vdisks.get(i);
                volumes.addAll(vDisk.getAssociatedVolumes(filter));
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        return volumes;
    }

    public StorageVolumeInterface getItemByName(String volName, String poolName, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = new String("getItemByName");
        Trace.methodBegin(this, METHOD);
        StorageVolumeInterface sv = null;
        sv = this.getItemByName(volName);
        if (sv != null) {
            if (!sv.getStorageDomainName().equals(domainName)) {
                Trace.error((Object)this, "getItemByName", "StorageDomain : " + domainName + " not found.");
                throw new ItemNotFoundException(domainName);
            }
            if (poolName != null && !sv.getStoragePoolName().equals(poolName)) {
                Trace.error((Object)this, "getItemByName", "StoragePool: " + poolName + " not Found.");
                throw new ItemNotFoundException(poolName);
            }
        }
        return sv;
    }

    public StorageVolumeInterface getItemByName(String name) throws ConfigMgmtException {
        String METHOD = "getItemByName";
        Trace.methodBegin(this, "getItemByName");
        StorageVolume svi = null;
        try {
            Trace.verbose((Object)this, "getItemByName", "Querying CIM for StorageVolume: " + name);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageVolume where ElementName = '" + name + "'");
            Trace.verbose((Object)this, "getItemByName", "Returned from querying CIM for StorageVolume: " + name);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemByName", "StorageVolume: " + name + " Found.");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemByName", "Creating StorageVolume Java Object");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    CIMProperty cp = ci.getProperty("ObjectType");
                    UnsignedInt16 objectType = (UnsignedInt16)cp.getValue().getValue();
                    int type = objectType.intValue();
                    if (type == 2) {
                        MirroredVolumeCIM mv = new MirroredVolumeCIM();
                        mv.setInstance(ci);
                        mv.init(this.context);
                        CIMObjectWrapper.populate(mv, mv.getFieldMap(), ci);
                        mv.loadKeys();
                        svi = mv;
                        continue;
                    }
                    if (type == 3) {
                        MirrorComponentCIM mc = new MirrorComponentCIM();
                        mc.setInstance(ci);
                        mc.init(this.context);
                        CIMObjectWrapper.populate(mc, mc.getFieldMap(), ci);
                        mc.loadKeys();
                        svi = mc;
                        continue;
                    }
                    StorageVolume sv = new StorageVolume();
                    sv.setInstance(ci);
                    sv.init(this.context);
                    CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                    sv.loadKeys();
                    svi = sv;
                }
            }
            if (svi == null) {
                Trace.verbose((Object)this, "getItemByName", "No instance returned when trying to obtain the StorageVolume: " + name);
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByName", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByName", "NullPointerException - Null returned when trying to obtain the StorageVolume instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the StorageVolume instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByName", "Exception - Exception thrown when trying to obtain all the StorageVolume instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StorageVolume instances.", e);
        }
        return svi;
    }

    public StorageVolumeInterface getByKey(Collection key) throws ConfigMgmtException {
        String METHOD = new String("getByKey");
        Trace.methodBegin(this, METHOD);
        StorageVolume svi = null;
        if (key != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStorageVolume", new Vector(key));
            Trace.verbose((Object)this, METHOD, "Querying CIM for StorageVolume Instance matching key(s)");
            CIMInstance ci = this.handle.getInstance(objPath, false, true, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES);
            Trace.verbose((Object)this, METHOD, "Returned from querying CIM for StorageVolume Instance matching key(s)");
            if (ci != null) {
                CIMProperty cp = ci.getProperty("ObjectType");
                UnsignedInt16 objectType = (UnsignedInt16)cp.getValue().getValue();
                int type = objectType.intValue();
                if (type == 2) {
                    MirroredVolumeCIM mv = new MirroredVolumeCIM();
                    mv.setInstance(ci);
                    mv.init(this.context);
                    CIMObjectWrapper.populate(mv, mv.getFieldMap(), ci);
                    mv.loadKeys();
                    svi = mv;
                } else if (type == 3) {
                    MirrorComponentCIM mc = new MirrorComponentCIM();
                    mc.setInstance(ci);
                    mc.init(this.context);
                    CIMObjectWrapper.populate(mc, mc.getFieldMap(), ci);
                    mc.loadKeys();
                    svi = mc;
                } else {
                    StorageVolume sv = new StorageVolume();
                    sv.setInstance(ci);
                    sv.init(this.context);
                    CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                    sv.loadKeys();
                    svi = sv;
                }
            }
        } else {
            Trace.error((Object)this, METHOD, "Key object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object is null.");
        }
        if (svi == null) {
            Trace.verbose((Object)this, METHOD, "No instance returned when trying to obtain the StorageVolumes");
            return null;
        }
        return svi;
    }

    public MethodCallStatus createVLV(String name, VDiskInterface vdisk, String storagePoolName, String storageDomainName) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        String METHOD = new String("createVLV");
        Trace.methodBegin(this, METHOD);
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        VDisk imp_vdisk = (VDisk)vdisk;
        try {
            ManageStoragePools msp = new ManageStoragePools();
            msp.init(this.context, null);
            StoragePool pool = (StoragePool)msp.getItemByName(storagePoolName, storageDomainName);
            if (pool == null) {
                Trace.error((Object)this, METHOD, "StoragePool: " + storagePoolName + " not found in StorageDomain: " + storageDomainName);
                throw new ItemNotFoundException(storagePoolName);
            }
            this.validateName(name);
            CIMArgument[] inArgs = new CIMArgument[2];
            CIMArgument[] outArgs = new CIMArgument[2];
            inArgs[0] = new CIMArgument("ElementName", new CIMValue((Object)name));
            inArgs[1] = new CIMArgument("InExtent", new CIMValue((Object)imp_vdisk.getInstance().getObjectPath()));
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, storageDomainName, 0);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, METHOD, "Configuration service object path is: " + confServiceObjectPath);
            }
            Trace.verbose((Object)this, METHOD, "Calling CreateOrModifyElementFromStorageExtent");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyElementFromStorageExtent", inArgs, outArgs);
            Trace.verbose((Object)this, METHOD, "Returned from calling CreateOrModifyElementFromStorageExtent");
            methodCallStatus.setReturnCode((Integer)returnCodeValue.getValue());
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, METHOD, "Return code: " + methodCallStatus.getReturnCode());
            }
            if (methodCallStatus.getReturnCode() != 0) {
                return methodCallStatus;
            }
            inArgs = new CIMArgument[6];
            outArgs = new CIMArgument[3];
            inArgs[0] = new CIMArgument("ElementName", new CIMValue(null));
            inArgs[1] = new CIMArgument("Goal", new CIMValue(null));
            inArgs[2] = new CIMArgument("Size", new CIMValue(null));
            inArgs[3] = new CIMArgument("InPools", new CIMValue(null));
            StorageVolume newVLV = (StorageVolume)this.getItemByName(name);
            if (newVLV == null) {
                Trace.error((Object)this, METHOD, "Could not find newly created VLV.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Could not find newly created VLV.");
            }
            Vector<String> extents = new Vector<String>();
            extents.add(newVLV.getInstance().getObjectPath().toString());
            extents.add(imp_vdisk.getInstance().getObjectPath().toString());
            inArgs[4] = new CIMArgument("InExtents", new CIMValue(extents, new CIMDataType(22)));
            inArgs[5] = new CIMArgument("Pool", new CIMValue((Object)pool.getInstance().getObjectPath()));
            Trace.verbose((Object)this, METHOD, "Calling CreateOrModifyStoragePool");
            returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyStoragePool", inArgs, outArgs);
            Trace.verbose((Object)this, METHOD, "Returned from calling CreateOrModifyStoragePool");
            methodCallStatus.setReturnCode((Integer)returnCodeValue.getValue());
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, METHOD, "Return code: " + methodCallStatus.getReturnCode());
            }
        }
        catch (BadParameterException bpe) {
            Trace.error((Object)this, METHOD, "BadParameter: " + bpe);
            throw bpe;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, METHOD, "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to create VLV: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems creating VLV.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to create VLV: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems creating VLV.", e);
        }
        return methodCallStatus;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = new String("delete");
        Trace.methodBegin(this, METHOD);
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, METHOD, "Getting specified StorageVolume");
            StorageVolumeInterface sv = this.getByKey(key);
            if (sv == null) {
                Trace.error((Object)this, METHOD, "StorageVolume specified not found.");
                throw new ItemNotFoundException("StorageVolume");
            }
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("TheElement", new CIMValue((Object)sv.getInstance().getObjectPath()))};
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null))};
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, sv.getStorageDomainName(), 0);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "deleteVolume", "Configuration service object path is: " + confServiceObjectPath);
            }
            Trace.verbose((Object)this, METHOD, "Calling ReturnToStoragePool");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ReturnToStoragePool", inArgs, outArgs);
            Trace.verbose((Object)this, METHOD, "Returned from calling ReturnToStoragePool");
            int retVal = (Integer)returnCodeValue.getValue();
            methodCallStatus.setReturnCode(retVal);
            Trace.verbose((Object)this, METHOD, "Return code: " + retVal);
            return methodCallStatus;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, METHOD, "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to delete the StorageVolume instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems deleting StorageVolume instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to delete StorageVolume: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems deleting StorageVolume.", e);
        }
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
        String METHOD = new String("validateName");
        Trace.methodBegin(this, METHOD);
        if (name != null) {
            if (name.length() > 16) {
                Trace.error((Object)this, METHOD, "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-]+", name)) {
                Trace.error((Object)this, "validateName", "Name: " + name + " contains invalid characters.");
                throw new BadParameterException(name, "error.bizobj.invalidCharacter");
            }
            StorageVolume volume = (StorageVolume)this.getItemByName(name);
            if (volume != null) {
                Trace.error((Object)this, METHOD, "Name: " + name + " already exists.");
                throw new BadParameterException(name, "error.objectAlreadyExists");
            }
        } else {
            Trace.error((Object)this, METHOD, "Name is null.");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
    }

    public void validateDescription(String description) throws BadParameterException {
        String METHOD = new String("validateDescription");
        Trace.methodBegin(this, METHOD);
        if (description != null) {
            if (description.length() > 64) {
                Trace.error((Object)this, METHOD, "Description: " + description + " is too long.");
                throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", description)) {
                Trace.error((Object)this, METHOD, "Description: " + description + " contains invalid characters.");
                throw new BadParameterException(description, "error.bizobj.invalidDescCharacter");
            }
        }
    }

    public ManageStorageVolumes.VolumeComparator getVolumeComparator(Locale l) {
        return null;
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return null;
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
    }

    public MethodCallStatus createVolume(String name, String t4Name, String raidGroupName, BigInteger size, String volumePermissions, int lun, String volumeGroup) throws ConfigMgmtException {
        Trace.methodBegin(this, "createVolume");
        return null;
    }

    public int[] getAvailableLUNNumbers(T4Interface t4) throws ConfigMgmtException {
        Trace.methodBegin(this, "getAvailableLUNNumbers");
        return null;
    }

    private CIMArgument[] getInArgs(String name, RaidGroupInterface raidGroup, BigInteger size, int lun, String volPermissions) {
        return null;
    }

    public void setRestriction(int restriction) {
        Trace.methodBegin(this, "setRestriction");
    }

    public MethodCallStatus createStorageVolume(String name, String description, BigInteger size, String storagePoolName, String storageDomainName, boolean stripeAll, int snapNum, int snapChange, String snapShotStoragePoolName, int snapShotPolicy) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        String METHOD = "createStorageVolume";
        Trace.methodBegin(this, "createStorageVolume");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "createStorageVolume", "Validating parameters");
            this.validateDescription(description);
            if (size.compareTo(BigInteger.ZERO) != 0) {
                if (size.compareTo(ConstantsEnt.StorageVolumeProperties.MIN_VOLUME_SIZE) == -1) {
                    Trace.error((Object)this, "createStorageVolume", "Invalid size for extension, too small.");
                    throw new BadParameterException(size.toString(), "error.bizobj.volumeSizeTooSmall");
                }
                if (size.compareTo(ConstantsEnt.StorageVolumeProperties.MAX_VOLUME_SIZE) == 1) {
                    Trace.error((Object)this, "createStorageVolume", "Invalid size for extension, too large.");
                    throw new BadParameterException(size.toString(), "error.bizobj.volumeSizeTooBig");
                }
            }
            boolean found = false;
            for (int i = 0; i < StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS.length && !found; ++i) {
                if (StorageVolumeEnt1Interface.VOLUME_SNAPSHOT_ACTIVITY_LEVELS[i] != snapChange) continue;
                found = true;
            }
            if (!found) {
                Trace.error((Object)this, "createStorageVolume", "Invalid snap change.");
                throw new BadParameterException(new Integer(snapChange).toString(), "error.bizobj.snapChangeInvalid");
            }
            if (snapNum < 0 || snapNum > 32) {
                Trace.error((Object)this, "createStorageVolume", "Invalid snap number.");
                throw new BadParameterException(new Integer(snapNum).toString(), "error.bizobj.snapNumberInvalid");
            }
            if (snapShotPolicy != 0 && snapShotPolicy != 1 && snapShotPolicy != 0) {
                Trace.error((Object)this, "createStorageVolume", "Invalid snap policy.");
                throw new BadParameterException(new Integer(snapShotPolicy).toString(), "error.bizobj.snapPolicyInvalid");
            }
            Trace.verbose((Object)this, "createStorageVolume", "Verifying StoragePool name: " + storagePoolName + " exist and StorageDomain: " + storageDomainName + "exist.");
            ManageStoragePools msp = new ManageStoragePools();
            msp.init(this.context, null);
            StoragePool pool = null;
            try {
                pool = (StoragePool)msp.getItemByName(storagePoolName, storageDomainName);
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)this, "createStorageVolume", "StorageDomain: " + storageDomainName + " not found.");
                throw new ItemNotFoundException(storageDomainName);
            }
            if (pool == null) {
                Trace.error((Object)this, "createStorageVolume", "StoragePool: " + storagePoolName + " not found.");
                throw new ItemNotFoundException(storagePoolName);
            }
            StoragePool cowPool = null;
            try {
                if (snapShotStoragePoolName != null) {
                    cowPool = (StoragePool)msp.getItemByName(snapShotStoragePoolName, storageDomainName);
                }
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)this, "createStorageVolume", "StorageDomain: " + storageDomainName + " not found.");
                throw new ItemNotFoundException(storageDomainName);
            }
            if (cowPool == null && snapNum > 0) {
                Trace.error((Object)this, "createStorageVolume", ":SnapShotStoragePool " + snapShotStoragePoolName + " not found.");
                throw new ItemNotFoundException(snapShotStoragePoolName);
            }
            Trace.verbose((Object)this, "createStorageVolume", "Querying CIM for associated StorageCapabilities Instance");
            Enumeration enumeration = this.handle.associators(pool.getInstance().getObjectPath(), "SunStorEdge_DSPElementCapabilities", "SunStorEdge_DSPStorageCapabilities", "ManagedElement", "Capabilities", true, false, ConstantsEnt.StorageCapabilitiesProperties.PROP_LIST);
            Trace.verbose((Object)this, "createStorageVolume", "Returned from querying CIM for associated StorageCapabilities Instance");
            CIMArgument[] createSettingOutArgs = new CIMArgument[1];
            CIMArgument[] createSettingInArgs = new CIMArgument[1];
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance profile = (CIMInstance)enumeration.nextElement();
                createSettingInArgs[0] = new CIMArgument("SettingType", new CIMValue((Object)new UnsignedInt16(2)));
                Trace.verbose((Object)this, "createStorageVolume", "Calling CreateSetting");
                CIMValue settingCodeValue = this.handle.invokeMethod(profile.getObjectPath(), "CreateSetting", createSettingInArgs, createSettingOutArgs);
                Trace.verbose((Object)this, "createStorageVolume", "Returned from calling CreateSetting");
                Trace.verbose((Object)this, "createStorageVolume", "Setting the Snapshot Pool percent size");
                CIMObjectPath settingPath = (CIMObjectPath)createSettingOutArgs[0].getValue().getValue();
                CIMInstance setting = this.handle.getInstance(settingPath, false, true, true);
                setting.setProperty("SnapshotCount", new CIMValue((Object)new UnsignedInt16(snapNum)));
                setting.setProperty("WriteActivity", new CIMValue((Object)new UnsignedInt16(snapChange)));
                setting.setProperty("SnapshotPoolPercent", new CIMValue((Object)new UnsignedInt16(snapNum * snapChange)));
                setting.setProperty("SnapshotPolicy", new CIMValue((Object)new UnsignedInt16(snapShotPolicy)));
                setting.setProperty("StripeAll", new CIMValue((Object)new Boolean(stripeAll)));
                this.handle.setInstance(settingPath, setting);
            }
            CIMArgument[] inArgs = new CIMArgument[8];
            CIMObjectPath profilePath = (CIMObjectPath)createSettingOutArgs[0].getValue().getValue();
            inArgs[0] = new CIMArgument("ElementName", new CIMValue((Object)name));
            inArgs[1] = new CIMArgument("ElementType", new CIMValue((Object)new UnsignedInt16(2)));
            inArgs[2] = new CIMArgument("Job", new CIMValue(null));
            inArgs[3] = new CIMArgument("Goal", new CIMValue((Object)profilePath));
            inArgs[4] = new CIMArgument("Size", new CIMValue((Object)new UnsignedInt64(size)));
            inArgs[5] = new CIMArgument("InPool", new CIMValue((Object)pool.getInstance().getObjectPath()));
            inArgs[6] = new CIMArgument("TheElement", new CIMValue(null));
            inArgs[7] = cowPool != null ? new CIMArgument("CowPool", new CIMValue((Object)cowPool.getInstance().getObjectPath())) : new CIMArgument("CowPool", new CIMValue(null));
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("TheElement", new CIMValue(null))};
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, storageDomainName, 0);
            Trace.verbose((Object)this, "createVolume", "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "createStorageVolume", "Calling CreateStorageVolume");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyElementFromStoragePool", inArgs, outArgs);
            Trace.verbose((Object)this, "createStorageVolume", "Returned from calling CreateStorageVolume");
            int retVal = (Integer)returnCodeValue.getValue();
            methodCallStatus.setReturnCode(retVal);
            Trace.verbose((Object)this, "createStorageVolume", "Return code: " + retVal);
            if (retVal == 0 && description != null && !description.equals("")) {
                StorageVolume vol = (StorageVolume)this.getItemByName(name);
                if (vol != null) {
                    Trace.verbose((Object)this, "createStorageVolume", "Setting description");
                    vol.setDescription(description);
                    vol.save();
                } else {
                    Trace.verbose((Object)this, "createStorageVolume", "Could not set description, StorageVolume could not be found");
                }
            }
            Trace.methodEnd(this, "createStorageVolume");
            return methodCallStatus;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "createStorageVolume", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (BadParameterException bpe) {
            Trace.error((Object)this, "createStorageVolume", "Invalid Parameter: " + bpe);
            throw bpe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createStorageVolume", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "createStorageVolume", "NullPointerException - Null returned when trying to create the StorageVolume instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems creating the StorageVolume instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "createStorageVolume", "Exception - Exception thrown when trying to  create StorageVolume: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems creating StorageVolume.", e);
        }
    }

    public MethodCallStatus createStorageVolume(String name, String description, BigInteger size, String storagePoolName, String storageDomainName, boolean stripeAll) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        String METHOD = "createStorageVolume";
        MethodCallStatus mcs = null;
        mcs = this.createStorageVolume(name, description, size, storagePoolName, storageDomainName, stripeAll, 0, 10, null, 0);
        return mcs;
    }

    public void create(Properties prop) throws ConfigMgmtException {
        String METHOD = "create";
    }

    public ArrayList getItemsByArray(String arrayName) throws ConfigMgmtException, ItemNotFoundException {
        return this.getItemsByArray(arrayName, 2);
    }

    public ArrayList getItemsByDisk(String arrayName, String trayId, int diskId) throws ConfigMgmtException, ItemNotFoundException {
        return this.getItemsByDisk(arrayName, trayId, diskId, 2);
    }

    public ArrayList getItemsByTray(String arrayName, String trayId) throws ConfigMgmtException, ItemNotFoundException {
        return this.getItemsByTray(arrayName, trayId, 2);
    }

    public ArrayList getItemsByVDisk(String name) throws ConfigMgmtException, ItemNotFoundException {
        return this.getItemsByVDisk(name, 2);
    }

    public boolean doesVDiskHaveVolumes(String name) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doesVDiskHaveVolumes";
        Trace.methodBegin(this, "doesVDiskHaveVolumes");
        ManageVDisks mvd = new ManageVDisks();
        mvd.init(this.context, null);
        VDisk vdisk = (VDisk)mvd.getItemByName(name);
        if (vdisk != null) {
            return vdisk.doesVDiskHaveVolumes();
        }
        Trace.error((Object)this, "doesVDiskHaveVolumes", "VDisk: " + name + " not found");
        throw new ItemNotFoundException(name);
    }

    public boolean doesArrayHaveVolumes(String arrayName) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doesArrayHaveVolumes";
        Trace.methodBegin(this, "doesArrayHaveVolumes");
        return this.doesTrayHaveVolumes(arrayName, null);
    }

    public boolean doesTrayHaveVolumes(String arrayName, String trayId) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doesTrayHaveVolumes";
        Trace.methodBegin(this, "doesTrayHaveVolumes");
        ManageVDisks mv = new ManageVDisks();
        mv.init(this.context, null);
        ArrayList vdisks = mv.getItemsByTray(arrayName, trayId);
        int size = vdisks.size();
        for (int i = 0; i < size; ++i) {
            VDisk vdisk = (VDisk)vdisks.get(i);
            if (!vdisk.doesVDiskHaveVolumes()) continue;
            return true;
        }
        return false;
    }

    public boolean doesDiskHaveVolumes(String arrayName, String trayId, int diskId) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doesDiskHaveVolumes";
        Trace.methodBegin(this, "doesDiskHaveVolumes");
        ManageVDisks mv = new ManageVDisks();
        mv.init(this.context, null);
        ArrayList vdisks = mv.getItemsByDisk(arrayName, trayId, diskId);
        int size = vdisks.size();
        if (vdisks.size() > 0) {
            VDisk vdisk = (VDisk)vdisks.get(0);
            return vdisk.doesVDiskHaveVolumes();
        }
        return false;
    }
}

