/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageDomain;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageDomainConfigurationServiceBuilder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageSystem;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class ManageStorageDomains
implements ManageStorageDomainsInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private CIMObjectPath storageDomainConfigServiceObjPath = null;
    private SearchFilter filter;

    public ManageStorageDomains() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.filter = filter;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public List getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getListSystem");
        return this.getItemList();
    }

    public StorageDomainInterface getItemByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByName");
        String query = "Select * from SunStorEdge_DSPStorageDomain where ElementName = '" + name + "'";
        Trace.verbose((Object)this, "getItemByName", "Querying CIM for StorageDomain: " + name);
        Enumeration e = CIMObjectWrapper.execQuery(this.context.getClient(), query);
        Trace.verbose((Object)this, "getItemByName", "Returned from querying CIM for StorageDomain: " + name);
        StorageDomain sd = null;
        if (e != null && e.hasMoreElements()) {
            Trace.verbose((Object)this, "getItemByName", "StorageDomain: " + name + " Found.");
            while (e.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemByName", "Creating StorageDomain Java Object");
                CIMInstance sdCimInstance = (CIMInstance)e.nextElement();
                sd = this.loadSDProperties(sdCimInstance);
            }
        }
        if (sd == null) {
            Trace.error((Object)this, "getItemByName", "StorageDomain: " + name + " not found.");
            throw new ZeroCIMInstanceReturnedException("ZERO_CIM_INSTANCE_RETURNED", "No StorageDomain object found for Name: " + name);
        }
        return sd;
    }

    public StorageDomainInterface getByKey(Collection props) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        StorageDomain sd = null;
        if (props != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStorageDomain", new Vector(props));
            Trace.verbose((Object)this, "getByKey", "Querying CIM for StorageDomain matching key(s)");
            CIMInstance sdCimInstance = this.handle.getInstance(objPath, false, true, true, ConstantsEnt.SDProperties.SD_PROP_LIST);
            Trace.verbose((Object)this, "getByKey", "Returned from querying CIM for StorageDomain matching key(s)");
            if (sdCimInstance != null) {
                Trace.verbose((Object)this, "getByKey", "Creating StorageDomain Java Object");
                sd = this.loadSDProperties(sdCimInstance);
            }
        } else {
            Trace.error((Object)this, "getByKey", "Key object is null");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object is null.");
        }
        if (sd == null) {
            Trace.error((Object)this, "getByKey", "StorageDomain matching key(s) not found");
            throw new ZeroCIMInstanceReturnedException("ZERO_CIM_INSTANCE_RETURNED", "No Storage Domain object found for keys: " + props.toString());
        }
        return sd;
    }

    public MethodCallStatus create(String name, String description) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "create");
        Trace.verbose((Object)this, "create", "In params: name: " + name + " description: " + description);
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "create", "Validating creation parameters");
            this.validateName(name);
            this.validateDescription(description);
            CIMInstance dspCIMInstance = StorageSystem.getInstance(this.handle);
            this.storageDomainConfigServiceObjPath = StorageDomainConfigurationServiceBuilder.getInstance(this.handle, dspCIMInstance.getObjectPath());
            Trace.verbose((Object)this, "create", "storageDomainConfServiceObjectPath: " + this.storageDomainConfigServiceObjPath);
            CIMArgument[] cimInArguments = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)name)), new CIMArgument("Description", new CIMValue((Object)description))};
            CIMArgument[] cimOutArguments = new CIMArgument[]{new CIMArgument("StorageDomain", new CIMValue(null))};
            Trace.verbose((Object)this, "create", "Calling CreateStorageDomain");
            CIMValue returnCodeValue = this.handle.invokeMethod(this.storageDomainConfigServiceObjPath, "CreateStorageDomain", cimInArguments, cimOutArguments);
            Trace.verbose((Object)this, "create", "Returned from calling CreateStorageDomain");
            int cimReturnCode = (Integer)returnCodeValue.getValue();
            Trace.verbose((Object)this, "create", "Return value code: " + cimReturnCode);
            if (Trace.isTraceEnabled(this) && cimReturnCode != 0) {
                Trace.verbose((Object)this, "create", "Came back from invoke() with error code: " + cimReturnCode);
            }
            methodCallStatus.setReturnCode(cimReturnCode);
        }
        catch (BadParameterException bpe) {
            Trace.error((Object)this, "create", "Invalid Parameter: " + bpe);
            throw bpe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "create", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "create", "NullPointerException - Null returned when trying to create the StorageDomain instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems creating the StorageDomain instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "create", "Exception - Exception thrown when trying to create StorageDomain: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems creating StorageDomain.", e);
        }
        return methodCallStatus;
    }

    public MethodCallStatus delete(String name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete(String)");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "delete(String)", "Finding specified StorageDomain");
            StorageDomain sd = new StorageDomain();
            try {
                sd = (StorageDomain)this.getItemByName(name);
            }
            catch (ZeroCIMInstanceReturnedException zcie) {
                Trace.error((Object)this, "delete(String)", "StorageDomain: " + name + " not found.");
                throw new ItemNotFoundException(name);
            }
            Trace.verbose((Object)this, "delete(String)", "Calling delete(StorageDomainInterface");
            methodCallStatus = this.delete(sd);
            Trace.verbose((Object)this, "delete(String)", "Returned from calling delete(StorageDomainInterface");
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "delete(String)", "ItemNotFound: " + infe.getMessage());
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "delete(String)", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "delete(String)", "NullPointerException - Null returned when trying to delete the StorageDomain instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems deleting the StorageDomain instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "delete(String)", "Exception - Exception thrown when trying to delete StorageDomain: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems deleting StorageDomain.", e);
        }
        return methodCallStatus;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete(Collection)");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "delete(Collection)", "Finding specified StorageDomain");
            StorageDomain sd = new StorageDomain();
            try {
                sd = (StorageDomain)this.getByKey(key);
            }
            catch (ZeroCIMInstanceReturnedException zcie) {
                Trace.error((Object)this, "delete(String)", "StorageDomain: matching key(s) not found.");
                throw new ItemNotFoundException("StorageDomain");
            }
            Trace.verbose((Object)this, "delete(Collection)", "Calling delete(StorageDomainInterface");
            methodCallStatus = this.delete(sd);
            Trace.verbose((Object)this, "delete(Collection)", "Returned from calling delete(StorageDomainInterface");
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "delete(Collection)", "ItemNotFound: " + infe.getMessage());
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "delete(Collection)", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "delete(Collection)", "NullPointerException - Null returned when trying to delete the StorageDomain instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems deleting the StorageDomain instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "delete(Collection)", "Exception - Exception thrown when trying to delete StorageDomain: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems deleting StorageDomain.", e);
        }
        return methodCallStatus;
    }

    public MethodCallStatus delete(StorageDomainInterface storageDomain) throws ConfigMgmtException {
        Trace.methodBegin(this, "delete(StorageDomainInterface)");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            StorageDomain sd = (StorageDomain)storageDomain;
            Trace.verbose((Object)this, "delete(StorageDomainInterface)", "Calling DeleteInstance");
            this.handle.deleteInstance(sd.getCIMInstance().getObjectPath());
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "delete(StorageDomainInterface)", "StorageDomain deleted: " + sd.getName());
            }
            methodCallStatus.setReturnCode(0);
        }
        catch (ConfigMgmtException cme) {
            CIMException cime = (CIMException)((Object)cme.getEmbededException());
            Object[] params = cime.getParams();
            Integer retVal = (Integer)params[0];
            int val = retVal;
            if (val >= 32768 && val <= 65535 || val >= 0 && val <= 6) {
                methodCallStatus.setReturnCode(retVal);
                return methodCallStatus;
            }
            Trace.error((Object)this, "delete(StorageDomainInstance)", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "delete(StorageDomainInterface)", "NullPointerException - Null returned when trying to delete the StorageDomain instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems deleting the StorageDomain instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "delete(StorageDomainInterface)", "Exception - Exception thrown when trying to delete StorageDomain: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems deleting StorageDomain.", e);
        }
        return methodCallStatus;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        Trace.methodBegin(this, "getNextAvailableName");
        return "";
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
        StorageDomain domain = null;
        Trace.methodBegin(this, "validateName");
        if (name != null) {
            if (name.length() > 16) {
                Trace.error((Object)this, "validateName", "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-]+", name)) {
                Trace.error((Object)this, "validateName", "Name: " + name + " contains invalid characters.");
                throw new BadParameterException(name, "error.bizobj.invalidCharacter");
            }
            try {
                domain = (StorageDomain)this.getItemByName(name);
            }
            catch (ZeroCIMInstanceReturnedException zcir) {
                Trace.error((Object)this, "validateName", "Name: " + name + " does not exist.");
            }
        } else {
            Trace.error((Object)this, "validateName", "Name: " + name + " already exists.");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
        if (domain != null) {
            throw new BadParameterException(name, "error.objectAlreadyExists");
        }
    }

    public void validateDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "validateDescription");
        if (description != null) {
            if (description.length() > 64) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " is too long.");
                throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", description)) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " contains invalid characters.");
                throw new BadParameterException(description, "error.bizobj.invalidDescCharacter");
            }
        }
    }

    private List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        ArrayList<StorageDomain> sdList = new ArrayList<StorageDomain>();
        try {
            CIMObjectPath sdOP = new CIMObjectPath("SunStorEdge_DSPStorageDomain");
            Trace.verbose((Object)this, "getItemList", "Querying CIM for StorageDomain Instances");
            Enumeration sdEnum = this.handle.enumerateInstances(sdOP, false, false, true, false, null);
            Trace.verbose((Object)this, "getItemList", "Returned from querying CIM for StorageDomain Instances");
            if (sdEnum != null && sdEnum.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemList", "StorageDomain Instances Found");
                while (sdEnum.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemList", "Creating StorageDomain Java Object");
                    CIMInstance sdCimInstance = (CIMInstance)sdEnum.nextElement();
                    StorageDomain sd = this.loadSDProperties(sdCimInstance);
                    sdList.add(sd);
                    Trace.verbose((Object)this, "getItemList", "Added StorageDomain Java Object");
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemList", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemList", "NullPointerException - Null returned when trying to obtain StorageDomain instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems obtaining StorageDomain instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemList", "Exception - Exception thrown when trying to obtain StorageDomains: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems obtaining StorageDomains.", e);
        }
        return sdList;
    }

    protected StorageDomain loadSDProperties(CIMInstance sdCimInstance) throws ConfigMgmtException {
        Trace.methodBegin(this, "loadSDProperties");
        StorageDomain sd = new StorageDomain();
        sd.init(this.context);
        sd.setCIMInstance(sdCimInstance);
        ArrayList<MapElement> sdProp = new ArrayList<MapElement>();
        MapElement elem1 = new MapElement("name", "ElementName", true, false);
        MapElement elem2 = new MapElement("description", "Description", false, true);
        MapElement elem3 = new MapElement("systemName", "Name", true, false);
        MapElement elem4 = new MapElement("creationClzName", "CreationClassName", true, false);
        sdProp.add(elem1);
        sdProp.add(elem2);
        sdProp.add(elem3);
        sdProp.add(elem4);
        CIMObjectWrapper.populate(sd, sdProp, sdCimInstance);
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("CreationClassName", new CIMValue((Object)sd.getCreationClzName())));
        prop.add(new CIMProperty("Name", new CIMValue((Object)sd.getSystemName())));
        sd.setKey(prop);
        return sd;
    }
}

