/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageFiberChannelPortsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.FiberChannelPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ManageFiberChannelPorts
implements ManageFiberChannelPortsInterface {
    private CIMOMHandleWrapper handle;
    private ConfigContext context;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        ArrayList<FiberChannelPort> fcpList = new ArrayList<FiberChannelPort>();
        try {
            Trace.verbose((Object)this, "getItemsBySystem", "Querying the CIM for FCPort Instances");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPFCPort"), false, false, true, false, ConstantsEnt.FCPortProperties.PROP_LIST);
            Trace.verbose((Object)this, "getItemsBySystem", "Returned from querying the CIM for FCPort Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemsBySystem", "FCPort Instances Found");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemsBySystem", "Creating FiberChannelPort Java Object");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    FiberChannelPort fcp = new FiberChannelPort();
                    fcp.setInstance(ci);
                    fcp.init(this.context);
                    CIMObjectWrapper.populate(fcp, fcp.getFieldMap(), ci);
                    fcp.loadKeys();
                    fcpList.add(fcp);
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, "getItemsBySystem", "The instance added to the list: " + fcp);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsBySystem", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsBySystem", "NullPointerException - Null returned when trying to obtain all the FiberChannelPort instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the FiberChannelPort instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsBySystem", "Exception - Exception thrown when trying to obtain all the FiberChannelPort instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the FiberChannelPort instances.", e);
        }
        Trace.verbose((Object)this, "getItemsBySystem", "Returning FiberChannelPort Java Objects Found.");
        return fcpList;
    }

    public FiberChannelPortInterface getItemByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByName");
        FiberChannelPort fcp = null;
        try {
            Trace.verbose((Object)this, "getItemByName", "Querying CIM for FCPort Instance: " + name);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPFCPort where ElementName = '" + name + "'");
            Trace.verbose((Object)this, "getItemByName", "Returned from querying CIM for FCPort Instance: " + name);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemByName", "FCPort Instance: " + name + " Found.");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemByName", "Creating FiberChannelPort Java object.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    fcp = new FiberChannelPort();
                    fcp.setInstance(ci);
                    fcp.init(this.context);
                    CIMObjectWrapper.populate(fcp, fcp.getFieldMap(), ci);
                    fcp.loadKeys();
                    Trace.verbose((Object)this, "getItemByName", "Finished creating FiberChannelPort Java object.");
                }
            }
            if (fcp == null) {
                Trace.verbose((Object)this, "getItemByName", "No instance returned when trying to obtain the FiberChannelPort: " + name);
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByName", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByName", "NullPointerException - Null returned when trying to obtain the FiberChannelPort instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the FiberChannelPort instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByName", "Exception - Exception thrown when trying to obtain the FiberChannelPort instance: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the FiberChannelPort instance.", e);
        }
        return fcp;
    }

    public FiberChannelPortInterface getByKey(Collection key) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        FiberChannelPort fcp = null;
        try {
            if (key != null) {
                CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPFCPort", new Vector(key));
                Trace.verbose((Object)this, "getByKey", "Query CIM for FCPort Instance matching key(s)");
                CIMInstance ci = this.handle.getInstance(objPath, false, true, false, ConstantsEnt.FCPortProperties.PROP_LIST);
                Trace.verbose((Object)this, "getByKey", "Returned from query CIM for FCPort Instance matching key(s)");
                if (ci != null) {
                    Trace.verbose((Object)this, "getByKey", "FCPort Instance matching key(s) found.");
                    Trace.verbose((Object)this, "getByKey", "Creating FiberChannelPort Java object.");
                    fcp = new FiberChannelPort();
                    fcp.setInstance(ci);
                    fcp.init(this.context);
                    CIMObjectWrapper.populate(fcp, fcp.getFieldMap(), ci);
                    fcp.loadKeys();
                    Trace.verbose((Object)this, "getByKey", "Finished creating FiberChannelPort Java object.");
                }
            } else {
                Trace.error((Object)this, "getByKey", "Key object is null.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object is null.");
            }
            if (fcp == null) {
                Trace.verbose((Object)this, "getByKey", "No instance returned when trying to obtain the FiberChannelPort");
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getByKey", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getByKey", "NullPointerException - Null returned when trying to obtain the FiberChannelPort instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the FiberChannelPort instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getByKey", "Exception - Exception thrown when trying to obtain the FiberChannelPort instance: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the FiberChannelPort instance.", e);
        }
        Trace.verbose((Object)this, "getByKey", "Returning FiberChannelPort matching key(s)");
        return fcp;
    }
}

