/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.RaidLevel;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfileParameters;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.util.ArrayList;
import java.util.Collection;
import javax.wbem.cim.CIMInstance;
import org.w3c.dom.Element;

public abstract class StorageProfileCommon
implements StorageProfileInterface {
    protected ConfigContext context;
    protected CIMOMHandleWrapper handle;
    protected CIMInstance instance;
    protected String name;
    protected String instanceID;
    protected String productVersion;
    protected String description;
    protected int segmentSize;
    protected int accessDirectionHint;
    protected int accessBandwidthWeight;
    protected int virtualizationStrategy;
    protected int stripeSize;
    protected int numberOfDisks;
    protected int snapshotPoolPercent;
    protected int dataRedundancy;
    protected int packageRedundancy;
    protected boolean noSinglePointOfFailure;
    protected int raidLevel;
    protected boolean hotSpare;
    protected boolean factoryProfile;
    protected int importStatus = -1;
    private boolean createdFromXML = false;
    public static final String XML_PROFILE = "sscs_storage_profile";
    protected static final String XML_PROFILE_B = "<sscs_storage_profile>";
    protected static final String XML_PROFILE_E = "</sscs_storage_profile>";
    protected static final String XML_NAME = "profile_name";
    protected static final String XML_NAME_B = "<profile_name>";
    protected static final String XML_NAME_E = "</profile_name>";
    protected static final String XML_VERSION = "product_version";
    protected static final String XML_VERSION_B = "<product_version>";
    protected static final String XML_VERSION_E = "</product_version>";
    protected static final String XML_DESCRIPTION = "profile_description";
    protected static final String XML_DESCRIPTION_B = "<profile_description>";
    protected static final String XML_DESCRIPTION_E = "</profile_description>";
    protected static final String XML_RAID_LEVEL = "raid_level";
    protected static final String XML_RAID_LEVEL_B = "<raid_level>";
    protected static final String XML_RAID_LEVEL_E = "</raid_level>";
    protected static final String XML_SEGMENT_SIZE = "segment_size";
    protected static final String XML_SEGMENT_SIZE_B = "<segment_size>";
    protected static final String XML_SEGMENT_SIZE_E = "</segment_size>";
    protected static final String XML_READ_AHEAD_MODE = "read_ahead_mode";
    protected static final String XML_READ_AHEAD_MODE_B = "<read_ahead_mode>";
    protected static final String XML_READ_AHEAD_MODE_E = "</read_ahead_mode>";
    protected static final String XML_ARRAY_TYPE = "array_type";
    protected static final String XML_ARRAY_TYPE_B = "<array_type>";
    protected static final String XML_ARRAY_TYPE_E = "</array_type>";
    protected static final String XML_NUMBER_OF_DISKS = "number_of_disks";
    protected static final String XML_NUMBER_OF_DISKS_B = "<number_of_disks>";
    protected static final String XML_NUMBER_OF_DISKS_E = "</number_of_disks>";
    protected static final String XML_DEDICATED_HOT_SPARE = "dedicated_hot_spare";
    protected static final String XML_DEDICATED_HOT_SPARE_B = "<dedicated_hot_spare>";
    protected static final String XML_DEDICATED_HOT_SPARE_E = "</dedicated_hot_spare>";
    protected static final String XML_FACTORY_PROFILE = "factory_profile";
    protected static final String XML_FACTORY_PROFILE_B = "<factory_profile>";
    protected static final String XML_FACTORY_PROFILE_E = "</factory_profile>";
    protected Collection keyProperties;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$StorageProfileCommon;

    public abstract String getCIMObjectName();

    protected abstract String getCIMPropNameForName();

    public abstract String[] getCIMObjectPropertyNames();

    public abstract Collection getFieldMap();

    protected abstract Collection getKeyCollection();

    protected abstract StorageProfileParameters getProfileParameters();

    protected abstract void populatePersistedProfile(StorageProfileInterface var1) throws ConfigMgmtException, BadParameterException;

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        this.setRaidLevelHelper();
        if (this.createdFromXML) {
            String msg = "Not allowed to call save for imported profile: " + this.getName();
            Trace.error((Object)this, "save", msg);
            throw new ConfigMgmtException("PERSIST_PROFILES_ERROR", msg);
        }
        if (this.stripeSize == -1) {
            this.stripeSize = 0;
        }
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveFromXML(ConfigContext context) throws ConfigMgmtException, BadParameterException {
        String METHOD_NAME = "saveFromXML()";
        Trace.methodBegin(this, "saveFromXML()");
        this.context = context;
        this.handle = context.getClient();
        this.setRaidLevelHelper();
        if (!this.createdFromXML) {
            String msg = "Not allowed to call saveFromXML for non-imported profile: " + this.getName();
            Trace.error((Object)this, "saveFromXML()", msg);
            throw new ConfigMgmtException("PERSIST_PROFILES_ERROR", msg);
        }
        if (this.isFactoryProfile()) {
            // empty if block
        }
        if (this.importStatus == 0 || this.importStatus == 2) {
            this.createInstanceUsingManager();
            return;
        }
        if (this.importStatus == 3) {
            this.updateExistingPersistedProfile();
            return;
        }
        String msg = "Not allowed to import profile: " + this.getName() + " with import status: " + this.importStatus;
        Trace.verbose((Object)this, "saveFromXML()", msg);
        throw new ConfigMgmtException("PROFILE_IN_USE_ERROR", msg);
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.instance.getObjectPath(), false, true, false, this.getCIMObjectPropertyNames());
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
        }
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getDescription() {
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public int getSegmentSize() {
        Trace.methodBegin(this, "getSegmentSize");
        return this.segmentSize;
    }

    public boolean isReadAheadEnabled() {
        Trace.methodBegin(this, "isReadAheadEnabled");
        return this.accessDirectionHint <= 5;
    }

    public int getRAIDLevel() {
        Trace.methodBegin(this, "getRAIDLevel");
        return this.raidLevel;
    }

    public int getArrayType() {
        Trace.methodBegin(this, "getArrayType");
        return StorageProfileCommon.convertAccessBandwidthWeightToArrayType(this.accessBandwidthWeight);
    }

    public int getNumberOfDisks() {
        Trace.methodBegin(this, "getNumberOfDisks");
        return this.numberOfDisks;
    }

    public int getVirtualizationStrategy() {
        Trace.methodBegin(this, "getVirtualizationStrategy");
        return this.virtualizationStrategy;
    }

    public int getStripeSize() {
        Trace.methodBegin(this, "getStripeSize");
        return this.stripeSize;
    }

    public boolean dedicatedSpareExists() {
        Trace.methodBegin(this, "dedicatedSpareExists");
        return this.hotSpare;
    }

    public boolean isInUse() throws ConfigMgmtException {
        Trace.methodBegin(this, "isInUse");
        ArrayList pools = new ArrayList();
        try {
            Trace.verbose((Object)this, "isInUse", "Finding any associated StoragePools.");
            pools = this.getAssocPools();
            return pools.size() != 0;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "isInUse:Failed: ", cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "isInUse:NullPointerException - Null returned when trying to obtain in use state: ", (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting in use state.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "isInUse:Exception - Exception thrown when trying to obtain in use state: ", (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting in use state.", e);
        }
    }

    public boolean isFactoryProfile() {
        Trace.methodBegin(this, "isFactoryProfile");
        return this.factoryProfile;
    }

    public abstract ArrayList getAssocPools() throws ConfigMgmtException;

    public ArrayList getAssocVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocVolumes");
        ArrayList volumes = new ArrayList();
        try {
            Trace.verbose((Object)this, "getAssocVolumes", "Getting the associated StoragePools.");
            ArrayList assocPools = this.getAssocPools();
            if (assocPools.size() != 0) {
                Trace.verbose((Object)this, "getAssocVolumes", "StoragePool Instances Found.");
                ArrayList poolVolumes = new ArrayList();
                StoragePoolInterface poolInstance = null;
                ManageStorageVolumesInterface msv = ManageStorageVolumesFactory.getManager();
                msv.init(this.context, null);
                for (int i = 0; i < assocPools.size(); ++i) {
                    Trace.verbose((Object)this, "getAssocVolumes", "Getting associated StorageVolumes for StoragePool.");
                    poolInstance = (StoragePoolInterface)assocPools.get(i);
                    poolVolumes = msv.getItemsByStoragePool(poolInstance.getName(), poolInstance.getStorageDomainName());
                    volumes.addAll(poolVolumes);
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, "getAssocVolumes", "The instances added to the list: " + poolVolumes);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssocVolumes:Failed: ", cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssocVolumes: NullPointerException - Null returned when trying to obtain all the StorageVolume  instances: " + npe, (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StorageVolume instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssocVolumes: Exception - Exception thrown when trying to obtain all the StorageVolume instances: " + e, (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StorageVolume instances.", e);
        }
        return volumes;
    }

    public Collection getKey() {
        Trace.methodBegin(this, "getKey");
        return this.keyProperties;
    }

    public String getPopname() {
        Trace.methodBegin(this, "getPopname");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getProductVersion() {
        Trace.methodBegin(this, "getProductVersion");
        return this.productVersion;
    }

    public int getAccessDirectionHint() {
        Trace.methodBegin(this, "getAccessDirectionHint");
        return this.accessDirectionHint;
    }

    public int getAccessBandwidthWeight() {
        Trace.methodBegin(this, "getAccessBandwidthWeight");
        return this.accessBandwidthWeight;
    }

    public int getSnapshotPoolPercent() {
        Trace.methodBegin(this, "getSnapshotPoolPercent");
        return this.snapshotPoolPercent;
    }

    public int getDataRedundancy() {
        Trace.methodBegin(this, "getDataRedundancy");
        return this.dataRedundancy;
    }

    public int getPackageRedundancy() {
        Trace.methodBegin(this, "getPackageRedundancy");
        return this.packageRedundancy;
    }

    public boolean getNoSinglePointOfFailure() {
        Trace.methodBegin(this, "getNoSinglePointOfFailure");
        return this.noSinglePointOfFailure;
    }

    public boolean getFactoryProfile() {
        Trace.methodBegin(this, "getFactoryProfile");
        return this.factoryProfile;
    }

    public String getInstanceID() {
        Trace.methodBegin(this, "getInstanceID");
        return this.instanceID;
    }

    public int getImportStatus() {
        return this.importStatus;
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.instance;
    }

    public void setName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "setName");
        ManageStorageProfilesInterface msp = ManageStorageProfilesFactory.getManager();
        msp.init(this.context, null);
        Trace.verbose((Object)this, "setName", "Validating name: " + name);
        msp.validateName(name);
        Trace.verbose((Object)this, "setName", "Name: " + name + " validated, setting...");
        this.name = name;
    }

    public void setDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "setDescription");
        ManageStorageProfilesInterface msp = ManageStorageProfilesFactory.getManager();
        Trace.verbose((Object)this, "setDescription", "Validating description: " + description);
        msp.validateDescription(description);
        Trace.verbose((Object)this, "setDescription", "Description: " + description + " validated, setting...");
        this.description = description;
    }

    public void setSegmentSize(int segmentSize) throws BadParameterException {
        Trace.methodBegin(this, "setSegmentSize");
        if (segmentSize == 2 || segmentSize == 3 || segmentSize == 0 || segmentSize == 4 || segmentSize == 1) {
            this.segmentSize = segmentSize;
            return;
        }
        Trace.error((Object)this, "setSegmentSize", "Invalid Segment Size specified: " + segmentSize);
        throw new BadParameterException("" + segmentSize, "error.bizobj.segmentSizeInvalid");
    }

    public void setReadAhead(boolean readAheadEnabled) {
        Trace.methodBegin(this, "setReadAhead");
        this.accessDirectionHint = StorageProfileCommon.convertReadAheadToAccessDirectionHint(readAheadEnabled);
    }

    public void setRAIDLevel(int raidLevel) throws BadParameterException {
        Trace.methodBegin(this, "setRAIDLevel");
        if (raidLevel == 0 || raidLevel == 1 || raidLevel == 5) {
            this.raidLevel = raidLevel;
            return;
        }
        Trace.error((Object)this, "setRAIDLevel", "Invalid RAID Level specified: " + raidLevel);
        throw new BadParameterException("" + raidLevel, "error.bizobj.raidLevelInvalid");
    }

    public void setArrayType(int arrayType) throws BadParameterException {
        Trace.methodBegin(this, "setArrayType");
        int abw = StorageProfileCommon.convertArrayTypeToAccessBandwidthWeight(arrayType);
        if (abw < 0) {
            Trace.error((Object)this, "setArrayType", "Invalid Array Type specified: " + arrayType);
            throw new BadParameterException("" + arrayType, "error.bizobj.arrayTypeInvalid");
        }
        this.accessBandwidthWeight = abw;
    }

    public void setNumberOfDisks(int numberOfDisks) throws BadParameterException {
        Trace.methodBegin(this, "setNumberOfDisks");
        if (numberOfDisks >= 0 && numberOfDisks <= 14) {
            this.numberOfDisks = numberOfDisks;
            return;
        }
        Trace.error((Object)this, "setNumberOfDisks", "Invalid Number of Disks specified: " + numberOfDisks);
        throw new BadParameterException("" + numberOfDisks, "error.bizobj.numDisksInvalid");
    }

    public void setVirtualizationStrategy(int virtualizationStrategy) throws BadParameterException {
        Trace.methodBegin(this, "setVirtualizationStrategy");
        if (virtualizationStrategy == 0 || virtualizationStrategy == 1 || virtualizationStrategy == 2) {
            this.virtualizationStrategy = virtualizationStrategy;
            return;
        }
        Trace.error((Object)this, "setVirtualizationStrategy", "Invalid Virtualization Strategy specified: " + virtualizationStrategy);
        throw new BadParameterException("" + virtualizationStrategy, "error.bizobj.virtStrategyInvalid");
    }

    public void setStripeSize(int stripeSize) throws BadParameterException {
        Trace.methodBegin(this, "setStripeSize");
        if (this.virtualizationStrategy == 0) {
            this.stripeSize = -1;
            return;
        }
        if (stripeSize == 0 || stripeSize == 6 || stripeSize == 2 || stripeSize == 3 || stripeSize == 4 || stripeSize == 1 || stripeSize == 5) {
            this.stripeSize = stripeSize;
            return;
        }
        if (stripeSize == -1) {
            this.stripeSize = 0;
            return;
        }
        Trace.error((Object)this, "setStripeSize", "Invalid Stripe Size specified: " + stripeSize);
        throw new BadParameterException("" + stripeSize, "error.bizobj.stripeSizeInvalid");
    }

    public void setDedicatedSpare(boolean dedicatedSpareExists) {
        Trace.methodBegin(this, "setDedicatedSpare");
        this.hotSpare = dedicatedSpareExists;
    }

    public void setImportStatus(int importStatus) {
        this.importStatus = importStatus;
    }

    public void setPopname(String popname) {
        Trace.methodBegin(this, "setPopname");
        this.name = popname;
    }

    public void setInstanceID(String instanceID) {
        Trace.methodBegin(this, "setInstanceID");
        this.instanceID = instanceID;
    }

    public void setProductVersion(String productVersion) {
        Trace.methodBegin(this, "setProductVersion");
        this.productVersion = productVersion;
    }

    public void setAccessDirectionHint(int accessDirectionHint) {
        Trace.methodBegin(this, "setAccessDirectionHint");
        this.accessDirectionHint = accessDirectionHint;
    }

    public void setAccessBandwidthWeight(int accessBandwidthWeight) {
        Trace.methodBegin(this, "setAccessBandwidthWeight");
        this.accessBandwidthWeight = accessBandwidthWeight;
    }

    public void setSnapshotPoolPercent(int snapshotPoolPercent) {
        Trace.methodBegin(this, "setSnapshotPoolPercent");
        this.snapshotPoolPercent = snapshotPoolPercent;
    }

    public void setDataRedundancy(int dataRedundancy) {
        Trace.methodBegin(this, "setDataRedundancy");
        this.dataRedundancy = dataRedundancy;
    }

    public void setPackageRedundancy(int packageRedundancy) {
        Trace.methodBegin(this, "setPackageRedundancy");
        this.packageRedundancy = packageRedundancy;
    }

    public void setNoSinglePointOfFailure(boolean noSinglePointOfFailure) {
        Trace.methodBegin(this, "setNoSinglePointOfFailure");
        this.noSinglePointOfFailure = noSinglePointOfFailure;
    }

    public void setFactoryProfile(boolean factoryProfile) {
        Trace.methodBegin(this, "setFactoryProfile");
        this.factoryProfile = factoryProfile;
    }

    public void setInstance(CIMInstance instance) {
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
    }

    public void setKey(Collection props) {
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
    }

    public void getRaidLevelHelper() {
        RaidLevel rl = new RaidLevel(this.noSinglePointOfFailure, this.dataRedundancy, this.packageRedundancy);
        this.hotSpare = rl.getDedicatedSpare();
        this.raidLevel = rl.getRaidLevel();
    }

    public void setRaidLevelHelper() {
        RaidLevel rl = new RaidLevel(this.raidLevel, this.hotSpare);
        this.dataRedundancy = rl.getDataRedundancy();
        this.packageRedundancy = rl.getPackageRedundancy();
        this.noSinglePointOfFailure = rl.getNoSinglePointOfFailure();
    }

    public void loadKeys() {
        Trace.methodBegin(this, "loadKeys");
        this.getRaidLevelHelper();
        this.setKey(this.getKeyCollection());
    }

    public static int convertArrayTypeToAccessBandwidthWeight(int arrayType) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$StorageProfileCommon == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$StorageProfileCommon = StorageProfileCommon.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.StorageProfileCommon")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$StorageProfileCommon, "convertArrayTypeToBandwidthWeight");
        int abw = -1;
        switch (arrayType) {
            case 2: {
                abw = 0;
                break;
            }
            case 5: {
                abw = 2;
                break;
            }
            case 3: {
                abw = 4;
                break;
            }
            case 0: {
                abw = 6;
                break;
            }
            case 4: {
                abw = 8;
                break;
            }
            case 1: {
                abw = 10;
            }
        }
        return abw;
    }

    public static int convertAccessBandwidthWeightToArrayType(int abw) {
        int atype = -1;
        switch (abw) {
            case 0: 
            case 1: {
                atype = 2;
                break;
            }
            case 2: 
            case 3: {
                atype = 5;
                break;
            }
            case 4: 
            case 5: {
                atype = 3;
                break;
            }
            case 6: 
            case 7: {
                atype = 0;
                break;
            }
            case 8: 
            case 9: {
                atype = 4;
                break;
            }
            case 10: {
                atype = 1;
            }
        }
        return atype;
    }

    public static int convertReadAheadToAccessDirectionHint(boolean rAhead) {
        if (rAhead) {
            return 0;
        }
        return 10;
    }

    public void populateFromXMLElement(Element profile) throws Exception {
        String METHOD_NAME = "populateFromXMLElement(Element)";
        Trace.methodBegin(this, "populateFromXMLElement(Element)");
        this.createdFromXML = true;
        Element name = XMLUtils.findElement(profile, XML_NAME);
        Element version = XMLUtils.findElement(profile, XML_VERSION);
        Element description = XMLUtils.findElement(profile, XML_DESCRIPTION);
        Element raidLevel = XMLUtils.findElement(profile, XML_RAID_LEVEL);
        Element segmentSize = XMLUtils.findElement(profile, XML_SEGMENT_SIZE);
        Element readaheadMode = XMLUtils.findElement(profile, XML_READ_AHEAD_MODE);
        Element arrayType = XMLUtils.findElement(profile, XML_ARRAY_TYPE);
        Element numberOfDisks = XMLUtils.findElement(profile, XML_NUMBER_OF_DISKS);
        Element dedicatedHotSpare = XMLUtils.findElement(profile, XML_DEDICATED_HOT_SPARE);
        Element factoryProfile = XMLUtils.findElement(profile, XML_FACTORY_PROFILE);
        this.name = XMLUtils.getElementValue(name);
        this.description = XMLUtils.getElementValue(description);
        this.productVersion = XMLUtils.getElementValue(version);
        this.raidLevel = Integer.parseInt(XMLUtils.getElementValue(raidLevel));
        this.segmentSize = StorageProfileCommon.getSegmentSizeInt(XMLUtils.getElementValue(segmentSize));
        this.accessDirectionHint = StorageProfileCommon.convertReadAheadToAccessDirectionHint(StorageProfileCommon.getBooleanFromOnOrOff(XMLUtils.getElementValue(readaheadMode)));
        String numDisks = XMLUtils.getElementValue(numberOfDisks);
        if (numDisks.equalsIgnoreCase("variable")) {
            numDisks = "0";
        }
        this.numberOfDisks = Integer.parseInt(numDisks);
        this.hotSpare = StorageProfileCommon.getBooleanFromYesOrNo(XMLUtils.getElementValue(dedicatedHotSpare));
        this.accessBandwidthWeight = StorageProfileCommon.convertArrayTypeToAccessBandwidthWeight(StorageProfileCommon.getArrayTypeInt(XMLUtils.getElementValue(arrayType)));
        this.factoryProfile = factoryProfile.equals(profile) ? false : StorageProfileCommon.getBooleanFromYesOrNo(XMLUtils.getElementValue(factoryProfile));
    }

    public boolean equalSettings(StorageProfileInterface targetProfile) {
        String METHOD_NAME = "equalSettings";
        Trace.methodBegin(this, "equalSettings");
        boolean result = false;
        if (this.getRAIDLevel() == targetProfile.getRAIDLevel() && this.getSegmentSize() == targetProfile.getSegmentSize() && this.isReadAheadEnabled() == targetProfile.isReadAheadEnabled() && this.getNumberOfDisks() == targetProfile.getNumberOfDisks() && this.dedicatedSpareExists() == targetProfile.dedicatedSpareExists() && this.getArrayType() == targetProfile.getArrayType()) {
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "equalSettings", "Profile <" + this.getName() + "> has equal settings as the profile <" + targetProfile.getName());
            }
            result = true;
        }
        return result;
    }

    private void createInstanceUsingManager() throws ConfigMgmtException, BadParameterException {
        String METHOD_NAME = "createInstanceUsingManager()";
        Trace.methodBegin(this, "createInstanceUsingManager()");
        ManageStorageProfilesInterface mgr = ManageStorageProfilesFactory.getManager();
        mgr.init(this.context, null);
        StorageProfileParameters param = this.getProfileParameters();
        MethodCallStatus mcs = mgr.createStorageProfile(param);
        if (mcs.getReturnCode() != 0) {
            String msg = "Failed to create profile instance: " + this.getName() + " with failure code: " + mcs.getReturnCode();
            Trace.verbose((Object)this, "createInstanceUsingManager()", msg);
            throw new ConfigMgmtException("PERSIST_PROFILES_ERROR", msg);
        }
        StorageProfileInterface persistedProfile = mgr.getItemByName(this.getName());
        if (persistedProfile == null || !(persistedProfile instanceof StorageProfileCommon)) {
            String msg = "Unable to find profile: " + this.getName() + " after creating it.";
            Trace.error((Object)this, "createInstanceUsingManager()", msg);
            throw new ConfigMgmtException("error.systemError", msg);
        }
        Trace.verbose((Object)this, "createInstanceUsingManager()", "Reloading from persisted data.");
        StorageProfileCommon pCommon = (StorageProfileCommon)persistedProfile;
        this.setInstance(pCommon.getInstance());
        this.importStatus = -1;
        this.createdFromXML = false;
        this.reload();
    }

    private void updateExistingPersistedProfile() throws ConfigMgmtException, BadParameterException {
        String METHOD_NAME = "updateExistingPersistedProfile()";
        Trace.methodBegin(this, "updateExistingPersistedProfile()");
        ManageStorageProfilesInterface mgr = ManageStorageProfilesFactory.getManager();
        mgr.init(this.context, null);
        StorageProfileInterface persistedProfile = mgr.getItemByName(this.getName());
        if (persistedProfile == null || !(persistedProfile instanceof StorageProfileCommon)) {
            String msg = "Unable to find profile: " + this.getName() + " for updating it.";
            Trace.error((Object)this, "updateExistingPersistedProfile()", msg);
            throw new ConfigMgmtException("error.systemError", msg);
        }
        this.populatePersistedProfile(persistedProfile);
        Trace.verbose((Object)this, "updateExistingPersistedProfile()", "Saving changes to persisted profile.");
        persistedProfile.save();
        Trace.verbose((Object)this, "updateExistingPersistedProfile()", "Reloading persisted profile.");
        persistedProfile.reload();
        this.setInstance(((StorageProfileCommon)persistedProfile).getInstance());
        this.importStatus = -1;
        this.createdFromXML = false;
        Trace.verbose((Object)this, "updateExistingPersistedProfile()", "Reloading self.");
        this.reload();
    }

    public static int getSegmentSizeInt(String segmentSize) {
        if (segmentSize.equalsIgnoreCase("4K")) {
            return 0;
        }
        if (segmentSize.equalsIgnoreCase("8K")) {
            return 1;
        }
        if (segmentSize.equalsIgnoreCase("16K")) {
            return 2;
        }
        if (segmentSize.equalsIgnoreCase("32K")) {
            return 3;
        }
        if (segmentSize.equalsIgnoreCase("64K")) {
            return 4;
        }
        return -1;
    }

    public static String getSegmentSizeString(int segmentSize) {
        if (segmentSize == 0) {
            return "4K";
        }
        if (segmentSize == 1) {
            return "8K";
        }
        if (segmentSize == 2) {
            return "16K";
        }
        if (segmentSize == 3) {
            return "32K";
        }
        if (segmentSize == 4) {
            return "64K";
        }
        return null;
    }

    public static boolean getBooleanFromOnOrOff(String onOrOff) {
        return "on".equalsIgnoreCase(onOrOff);
    }

    public static boolean getBooleanFromYesOrNo(String yesOrNo) {
        return "yes".equalsIgnoreCase(yesOrNo);
    }

    public static String getYesOrNoFromBoolean(boolean valid) {
        if (valid) {
            return "yes";
        }
        return "no";
    }

    public static int getArrayTypeInt(String arrayType) {
        if (arrayType.equalsIgnoreCase("Exact Match IOPS")) {
            return 0;
        }
        if (arrayType.equalsIgnoreCase("Exact Match Bandwidth")) {
            return 1;
        }
        if (arrayType.equalsIgnoreCase("Exact Match Capacity")) {
            return 2;
        }
        if (arrayType.equalsIgnoreCase("Best Available Match IOPS")) {
            return 3;
        }
        if (arrayType.equalsIgnoreCase("Best Available Match Bandwidth")) {
            return 4;
        }
        if (arrayType.equalsIgnoreCase("Best Available Match Capacity")) {
            return 5;
        }
        return -1;
    }

    public static String getArrayTypeString(int arrayType) {
        if (arrayType == 0) {
            return "Exact Match IOPS";
        }
        if (arrayType == 1) {
            return "Exact Match Bandwidth";
        }
        if (arrayType == 2) {
            return "Exact Match Capacity";
        }
        if (arrayType == 3) {
            return "Best Available Match IOPS";
        }
        if (arrayType == 4) {
            return "Best Available Match Bandwidth";
        }
        if (arrayType == 5) {
            return "Best Available Match Capacity";
        }
        return null;
    }

    public String toString() {
        if (Trace.isTraceEnabled(this)) {
            return "\nStorageProfile with:\n     CIMObjectPath: " + (this.instance == null ? "null" : this.instance.getObjectPath().toString()) + "\n     name: " + this.getName() + "\n    key(s): " + this.getInstanceID() + "\n     description: " + this.getDescription() + "\n     product version: " + this.productVersion + "\n    segment size: " + this.getSegmentSize() + "\n     read ahead: " + this.isReadAheadEnabled() + "\n     array type: " + this.getArrayType() + "\n     RAID level: " + this.getRAIDLevel() + "\n     number of disks: " + this.getNumberOfDisks() + "\n     virt. type: " + this.getVirtualizationStrategy() + "\n     stripe size: " + this.getStripeSize() + "\n     dedicated spare: " + this.dedicatedSpareExists();
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

