/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public abstract class StoragePoolCommon
implements StoragePoolInterface {
    protected ConfigContext context;
    protected CIMOMHandleWrapper handle;
    protected CIMInstance instance;
    protected CIMObjectPath objectPath;
    protected String profileName;
    protected String domainName;
    protected String name;
    protected String description;
    protected BigInteger totalCapacity;
    protected BigInteger allocatedCapacity;
    protected BigInteger unallocatedCapacity;
    protected String instanceID;
    protected Collection keyProperties;
    protected CIMObjectPath capObjectPath;
    protected ArrayList fieldMap;

    protected abstract String getCIMPropNameForName();

    public abstract String getCIMObjectName();

    public abstract String getElementCapabilitiesCIMClassName();

    public abstract String getStorageCapabilitiesCIMClassName();

    public abstract String getHostedStoragePoolCIMClassName();

    public abstract String getStorageDomainCIMClassName();

    public abstract String[] getStorageDomainCIMPropertyNames();

    public abstract String getStorageDomainCIMPropNameForName();

    public abstract void addImplementationSpecificElements();

    protected abstract void getAssociatedStorageCapabilities() throws ConfigMgmtException;

    protected abstract void getAssociatedDomain() throws ConfigMgmtException;

    public abstract ArrayList getAssociatedVDisks() throws ConfigMgmtException;

    public abstract MethodCallStatus addStorageToPool(String var1) throws ConfigMgmtException, ItemNotFoundException;

    public abstract String[] getCIMObjectPropertyNames();

    protected abstract CIMArgument[] buildInArgsForAddStorage(CIMObjectPath var1, List var2, BigInteger var3) throws ConfigMgmtException;

    public abstract boolean isInUse();

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.verbose((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.objectPath, false, true, false, this.getCIMObjectPropertyNames());
        this.domainName = null;
        this.profileName = null;
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getDescription() {
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public abstract String getProfileName();

    public String getStorageDomainName() {
        Trace.methodBegin(this, "getStorageDomainName");
        if (this.domainName == null) {
            try {
                this.getAssociatedDomain();
            }
            catch (ConfigMgmtException cme) {
                Trace.verbose((Object)this, "getStorageDomainName", "Exception when trying to obtain storage domain name.");
            }
        }
        return this.domainName;
    }

    public BigInteger getStorageCapacity() {
        Trace.methodBegin(this, "getStorageCapacity");
        if (this.totalCapacity != null) {
            return this.totalCapacity;
        }
        return new BigInteger("-100");
    }

    public BigInteger getAllocatedCapacity() {
        Trace.methodBegin(this, "getAllocatedCapacity");
        if (this.totalCapacity != null) {
            return this.totalCapacity.subtract(this.unallocatedCapacity);
        }
        return new BigInteger("-100");
    }

    public BigInteger getUnAllocatedCapacity() {
        Trace.methodBegin(this, "getUnAllocatedCapacity");
        return this.unallocatedCapacity;
    }

    public Collection getKey() {
        Trace.methodBegin(this, "getKey");
        return this.keyProperties;
    }

    public ArrayList getAssociatedVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssociatedVolumes");
        return null;
    }

    public String getPopname() {
        Trace.methodBegin(this, "getPopname");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getInstanceID() {
        Trace.methodBegin(this, "getInstanceID");
        return this.instanceID;
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.instance;
    }

    public void setName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "setName");
        Trace.verbose((Object)this, "setName", "Validating name: " + name);
        ManageStoragePoolsInterface msp = ManageStoragePoolsFactory.getManager();
        msp.init(this.context, null);
        try {
            msp.validateName(name, this.getStorageDomainName());
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "setName", "StorageDomain:" + this.getStorageDomainName() + " not found.");
            throw new ConfigMgmtException("error.systemError", "StorageDomain: " + this.getStorageDomainName() + " not found.", infe);
        }
        Trace.verbose((Object)this, "setName", "Name successfully validated, setting name...");
        this.name = name;
    }

    public void setDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "setDescription");
        Trace.verbose((Object)this, "setDescription", "Validating description: " + this.name);
        ManageStoragePoolsInterface msp = ManageStoragePoolsFactory.getManager();
        msp.validateDescription(description);
        Trace.verbose((Object)this, "setName", "Description successfully validated, setting description...");
        this.description = description;
    }

    public void setPopname(String popname) {
        Trace.methodBegin(this, "setPopname");
        this.name = popname;
    }

    public void setInstanceID(String instanceID) {
        Trace.methodBegin(this, "setInstanceID");
        this.instanceID = instanceID;
    }

    public void setTotalCapacity(BigInteger totalCapacity) {
        Trace.methodBegin(this, "setTotalCapacity");
        this.totalCapacity = totalCapacity;
    }

    public void setUnallocatedCapacity(BigInteger unallocatedCapacity) {
        Trace.methodBegin(this, "setUnallocatedCapacity");
        this.unallocatedCapacity = unallocatedCapacity;
    }

    public void setInstance(CIMInstance instance) {
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
        if (this.objectPath == null) {
            Trace.verbose((Object)this, "setInstance", "Setting object path.");
            this.objectPath = instance.getObjectPath();
        }
    }

    public void setKey(Collection props) {
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
    }

    public Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        return null;
    }

    public MethodCallStatus addStorageToPool(List raidSetGroups, int numDisks) throws ConfigMgmtException {
        String METHOD = "addStorageToPool(List)";
        Trace.methodBegin(this, "addStorageToPool(List)");
        return null;
    }

    public abstract MethodCallStatus addStorageToPool(BigInteger var1, int var2) throws ConfigMgmtException;

    protected MethodCallStatus makeCallToAddStorage(CIMArgument[] inArgs) throws ConfigMgmtException {
        String METHOD = "makeCallToAddStorage(CIMArgument[])";
        Trace.methodBegin(this, "makeCallToAddStorage(CIMArgument[])");
        return null;
    }

    protected CIMObjectPath getNewSetting(int numDisks) throws ConfigMgmtException {
        String METHOD = "getNewSetting(int)";
        Trace.methodBegin(this, "getNewSetting(int)");
        return null;
    }

    protected CIMArgument[] buildOutArgsForAddStorage() {
        return null;
    }

    public List findVDisksForStealing(boolean requireSameDomain) throws ConfigMgmtException {
        return null;
    }

    protected void loadKeys() {
        Trace.methodBegin(this, "loadKeys");
    }

    public String toString() {
        return "\nStoragePool with:\n \tCIMObjectPath: " + this.objectPath + "\n \tname: " + this.getName() + "\n\tkey(s): " + this.getInstanceID() + "\n \tdescription: " + this.getDescription() + "\n \tprofile name: " + this.getProfileName() + "\n\tdomain name: " + this.getStorageDomainName() + "\n \ttotal capacity: " + this.getStorageCapacity() + "\n\tallocated capacity: " + this.getAllocatedCapacity() + "\n\tunallocated capacity: " + this.getUnAllocatedCapacity();
    }
}

