/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RaidSetGroup {
    private int arrayType;
    private int weight = 0;
    private BigInteger capacity;
    private List breakdowns;

    public RaidSetGroup(PoolBreakdownForTray pbd, int poolIndex, int arrayType) throws ConfigMgmtException {
        Trace.constructor(this);
        RaidSetBreakdown rsb = new RaidSetBreakdown(pbd, poolIndex);
        this.arrayType = arrayType;
        this.breakdowns = new ArrayList();
        this.capacity = new BigInteger("0");
        this.addBreakdown(pbd, poolIndex);
    }

    public RaidSetGroup(RaidSetGroup rsg) {
        this.arrayType = rsg.getArrayType();
        this.weight = rsg.getWeight();
        this.capacity = new BigInteger(rsg.getCapacity().toString());
        this.breakdowns = (List)((ArrayList)rsg.getBreakdowns()).clone();
    }

    public void addBreakdown(PoolBreakdownForTray pbd, int poolIndex) throws ConfigMgmtException {
        Trace.verbose((Object)this, "addBreakdown", " method begin with poolIndex: " + poolIndex);
        this.breakdowns.add(new RaidSetBreakdown(pbd, poolIndex));
        this.capacity = this.capacity.add(pbd.getPoolCapacity(poolIndex));
        int t4ArrayType = pbd.getTray().getT4Interface().getArrayConfigurationType();
        int arrayTypeMult = AvailableSpaceForRaidSets.getArrayTypeMultiplier(this.arrayType, t4ArrayType);
        this.weight += arrayTypeMult;
    }

    public int getWeight() {
        return this.weight;
    }

    public BigInteger getCapacity() {
        return this.capacity;
    }

    public List getBreakdowns() {
        return this.breakdowns;
    }

    public int getArrayType() {
        return this.arrayType;
    }

    public class RaidSetBreakdown {
        private PoolBreakdownForTray pbd;
        private int poolIndex;

        RaidSetBreakdown(PoolBreakdownForTray pbd, int poolIndex) {
            Trace.verbose((Object)this, "Constructor:", " entered with PoolBreakdownForTray: " + pbd + " and poolIndex: " + poolIndex);
            this.poolIndex = poolIndex;
            this.pbd = pbd;
        }

        public int getIndex() {
            return this.poolIndex;
        }

        public PoolBreakdownForTray getBreakdown() {
            return this.pbd;
        }
    }
}

