/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.StorageProfileCommon;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfileParameters;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.ParseException;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ManageStorageProfilesCommon
implements ManageStorageProfilesInterface {
    protected ConfigContext context;
    protected CIMOMHandleWrapper handle;
    private static final int SYMBOL_TABLE_SIZE = 2039;
    public static final String PROFILE_XSD_PATH_KEY = "profile-xsd-path";
    public static final String DEFAULT_PROFILE_XSD_PATH = "/opt/se6x20/resources/ImportStorageProfiles.xsd";
    private static final String PROPERTY_SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String PROPERTY_GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String FEATURE_NAMESPACE = "http://xml.org/sax/features/namespaces";
    private static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String FEATURE_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String FEATURE_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String XML_ROOT_B = "<sscs_storage_profiles xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
    private static final String XML_ROOT_E = "</sscs_storage_profiles>";
    protected StorageProfileCommon myChildForConstants = this.getChildClassInstance();
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$core$impl$CIMObjectWrapper;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ManageStorageProfilesCommon;

    public abstract StorageProfileCommon getChildClassInstance();

    protected abstract void populateCIMInstancePropertiesForCreation(CIMInstance var1, StorageProfileParameters var2) throws ConfigMgmtException;

    private String getSchemaFileName() throws ConfigMgmtException {
        String profileXsdPath = (String)Repository.getRepository().getProperty(PROFILE_XSD_PATH_KEY);
        if (profileXsdPath == null) {
            profileXsdPath = DEFAULT_PROFILE_XSD_PATH;
        }
        return profileXsdPath;
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    protected abstract ArrayList enumToList(Enumeration var1) throws ConfigMgmtException;

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        ArrayList profiles = new ArrayList();
        try {
            Trace.verbose((Object)this, "getItemsBySystem", "Querying CIM for StorageSettingWithHints Instance");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath(this.myChildForConstants.getCIMObjectName()), false, false, true, false, this.myChildForConstants.getCIMObjectPropertyNames());
            Trace.verbose((Object)this, "getItemsBySystem", "Returned from querying CIM for StorageSettingWithHints Instance");
            profiles = this.enumToList(enumeration);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsBySystem:Failed: ", cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsBySystem:NullPointerException - Null returned when trying to obtain all the StorageProfile instances: ", (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StorageProfile instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsBySystem:Exception - Exception thrown when trying to obtain all the StorageProfile instances: ", (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StorageProfile instances.", e);
        }
        return profiles;
    }

    public StorageProfileInterface getItemByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByName");
        StorageProfileInterface sp = null;
        try {
            Trace.verbose((Object)this, "getItemByName", "Querying CIM for StorageProfile Instance matching: " + name);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from " + this.myChildForConstants.getCIMObjectName() + " where " + this.myChildForConstants.getCIMPropNameForName() + " = '" + name + "'");
            Trace.verbose((Object)this, "getItemByName", "Returned from querying CIM for StorageProfile Instance matching: " + name);
            ArrayList profileList = this.enumToList(enumeration);
            if (profileList.size() > 0) {
                sp = (StorageProfileInterface)profileList.get(0);
            }
            if (sp == null) {
                Trace.verbose((Object)this, "getItemByName", "No instances returned when trying to obtain the StorageProfile: " + name);
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByName:Failed: ", cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByName:NullPointerException - Null returned when trying to obtain the StorageProfile instance: ", (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the StorageProfile instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByName:Exception - Exception thrown when trying to obtain the StorageProfile instance: ", (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the StorageProfile instance.", e);
        }
        return sp;
    }

    public StorageProfileInterface getByKey(Collection key) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        StorageProfileCommon sp = null;
        try {
            if (key != null) {
                CIMObjectPath objPath = new CIMObjectPath(this.myChildForConstants.getCIMObjectName(), new Vector(key));
                Trace.verbose((Object)this, "getByKey", "Querying CIM for StorageProfile Instance matching key(s)");
                CIMInstance ci = this.handle.getInstance(objPath, false, true, false, this.myChildForConstants.getCIMObjectPropertyNames());
                Trace.verbose((Object)this, "getByKey", "Returned from querying CIM for StorageProfile Instance matching key(s)");
                if (ci != null) {
                    Trace.verbose((Object)this, "getByKey", "Creating StorageProfile Java object");
                    sp = this.getChildClassInstance();
                    sp.setInstance(ci);
                    sp.init(this.context);
                    CIMObjectWrapper.populate(sp, sp.getFieldMap(), ci);
                    sp.loadKeys();
                }
            } else {
                Trace.error((Object)this, "getByKey", "Key object is null.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object is null.");
            }
            if (sp == null) {
                Trace.verbose((Object)this, "getByKey", "No instance returned when trying to obtain the StorageProfile");
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Object[] params;
            Object p_val;
            Trace.error((Object)this, "getByKey", "Failed: " + cme);
            CIMException cime = (CIMException)((Object)cme.getEmbededException());
            if (cime != null && (p_val = (params = cime.getParams())[0]) instanceof String && cime.getID().equals("CIM_ERR_NOT_FOUND")) {
                return null;
            }
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getByKey:NullPointerException - Null returned when trying to obtain the StorageProfile instance: ", (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the StorageProfile instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getByKey: Exception - Exception thrown when trying to obtain the StorageProfile instance: ", (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the StorageProfile instance.", e);
        }
        return sp;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        Trace.methodBegin(this, "getNextAvailableName");
        int MAX_PROFILES_TRY = 10000;
        HashSet<String> usedNamesSet = new HashSet<String>();
        try {
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select " + this.myChildForConstants.getCIMPropNameForName() + " from " + this.myChildForConstants.getCIMObjectName());
            while (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance inst = (CIMInstance)enumeration.nextElement();
                CIMProperty nameProp = inst.getProperty(this.myChildForConstants.getCIMPropNameForName());
                if (nameProp == null || nameProp.getValue() == null || nameProp.getValue().getValue() == null) continue;
                usedNamesSet.add((String)nameProp.getValue().getValue());
            }
            String nextAvailableName = "profile";
            for (int i = 1; i < 10000; ++i) {
                if (usedNamesSet.contains(nextAvailableName + i)) {
                    continue;
                }
                Trace.verbose((Object)this, "getNextAvailableName", "Found available name: " + nextAvailableName + i);
                return nextAvailableName + i;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getNextAvailableName:Failed: ", cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getNextAvailableName: NullPointerException - Null returned when trying to obtain the next available StorageProfile name.", (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the next available StorageProfile name.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getNextAvailableName: Exception - Exception thrown when trying to obtain next available creation name.", (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting next available creation name.", e);
        }
        return null;
    }

    public MethodCallStatus createStorageProfile(StorageProfileParameters params) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "createStorageProfile");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            this.validateName(params.getName());
            this.validateDescription(params.getDescription());
            CIMObjectPath cop = new CIMObjectPath(this.myChildForConstants.getCIMObjectName());
            CIMClass cimClass = this.handle.getClass(cop, false, true, false, null);
            CIMInstance cimInstance = cimClass.newInstance();
            Trace.verbose((Object)this, "createStorageProfile", "Setting Instance Properties");
            this.populateCIMInstancePropertiesForCreation(cimInstance, params);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$CIMObjectWrapper == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$CIMObjectWrapper = ManageStorageProfilesCommon.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$CIMObjectWrapper, "createInstance", "The instance to be created: " + cimInstance);
            }
            CIMObjectPath path = this.handle.createInstance(cop, cimInstance);
            methodCallStatus.setReturnCode(0);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$CIMObjectWrapper == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$CIMObjectWrapper = ManageStorageProfilesCommon.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$CIMObjectWrapper, "createInstance", "The instance with object path " + path + " successfully created.");
            }
        }
        catch (BadParameterException bpe) {
            Trace.error((Object)this, "createStorageProfile:Invalid Parameter: ", (ConfigMgmtException)bpe);
            throw bpe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createStorageProfile:Failed: ", cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "createStorageProfile: NullPointerException - Null returned when trying to create the StorageProfile: " + npe, (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems creating StorageProfile.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "createStorageProfile: Exception - Exception thrown when trying to create StorageProfile: " + e, (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems creating StorageProfile.", e);
        }
        return methodCallStatus;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "delete", "Getting the StorageProfile to delete");
            StorageProfileCommon profile = (StorageProfileCommon)this.getByKey(key);
            if (profile == null) {
                Trace.error((Object)this, "delete", "Specified StorageProfile for deletion not found.");
                throw new ItemNotFoundException("StorageProfile");
            }
            Trace.verbose((Object)this, "delete", "Calling DeleteInstance");
            this.handle.deleteInstance(profile.getInstance().getObjectPath());
            Trace.verbose((Object)this, "delete", "Returned from calling DeleteInstance");
            methodCallStatus.setReturnCode(0);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "delete", "ItemNotFoundException: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Integer retVal;
            int val;
            Object[] params;
            Object p_val;
            Trace.error((Object)this, "delete", "Failed: " + cme);
            CIMException cime = (CIMException)((Object)cme.getEmbededException());
            if (cime != null && (p_val = (params = cime.getParams())[0]) instanceof Integer && ((val = (retVal = (Integer)p_val).intValue()) >= 32768 && val <= 65535 || val >= 0 && val <= 6)) {
                methodCallStatus.setReturnCode(retVal);
                return methodCallStatus;
            }
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "delete: NullPointerException - Null returned when trying to delete the StorageProfile: " + npe, (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems deleting the StorageProfile.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "delete: Exception - Exception thrown when trying to delete the StorageProfile: " + e, (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems deleting the StorageProfile.", e);
        }
        return methodCallStatus;
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "validateName");
        if (name != null) {
            if (name.length() > 32) {
                Trace.error((Object)this, "validateName", "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-]+", name)) {
                Trace.error((Object)this, "validateName", "Name: " + name + " contains invalid characters.");
                throw new BadParameterException(name, "error.bizobj.invalidCharacter");
            }
            StorageProfileInterface profile = this.getItemByName(name);
            if (profile != null) {
                Trace.error((Object)this, "validateName", "Name: " + name + " already exists.");
                throw new BadParameterException(name, "error.objectAlreadyExists");
            }
        } else {
            Trace.error((Object)this, "validateName", "Name is null.");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
    }

    public void validateDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "validateDescription");
        if (description != null) {
            if (description.length() > 256) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " is too long.");
                throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", description)) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " contains invalid characters.");
                throw new BadParameterException(description, "error.bizobj.invalidDescCharacter");
            }
        }
    }

    public List getXmlContentsForImport(String xml) throws ConfigMgmtException, ParseException, Exception {
        int i;
        this.validateXml(xml);
        StringReader reader = new StringReader(xml);
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(reader));
        List theProfiles = this.buildListFromDoc(document.getDocumentElement());
        HashMap<String, StorageProfileCommon> profileMap = new HashMap<String, StorageProfileCommon>();
        ArrayList existingProfiles = this.getItemsBySystem();
        int sizeL = existingProfiles == null ? 0 : existingProfiles.size();
        for (i = 0; i < sizeL; ++i) {
            StorageProfileCommon p = (StorageProfileCommon)existingProfiles.get(i);
            profileMap.put(p.getName(), p);
        }
        for (i = 0; i < theProfiles.size(); ++i) {
            StorageProfileCommon newProfile = (StorageProfileCommon)theProfiles.get(i);
            StorageProfileCommon systemProfile = (StorageProfileCommon)profileMap.get(newProfile.getName());
            if (systemProfile == null) {
                List dups = ManageStorageProfilesCommon.getProfilesWithDuplicateSettings(newProfile, existingProfiles);
                if (dups.size() == 0) {
                    newProfile.setImportStatus(0);
                    continue;
                }
                newProfile.setImportStatus(2);
                continue;
            }
            if (systemProfile.isInUse()) {
                newProfile.setImportStatus(1);
                continue;
            }
            if (systemProfile.equalSettings(newProfile)) {
                newProfile.setImportStatus(4);
                continue;
            }
            newProfile.setImportStatus(3);
        }
        return theProfiles;
    }

    public String getExportXml(List profileList) throws ItemNotFoundException, ConfigMgmtException {
        String METHOD = "getExportXml(List)";
        Trace.methodBegin(this, "getExportXml(List)");
        List profiles = profileList;
        if (profileList == null) {
            profiles = this.getItemsBySystem();
        }
        StringBuffer theXml = new StringBuffer(1024);
        theXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        theXml.append("<sscs_storage_profiles xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        int pSize = profiles.size();
        for (int i = 0; i < pSize; ++i) {
            StorageProfileInterface thisProfile = (StorageProfileInterface)profiles.get(i);
            theXml.append(thisProfile.toXml());
        }
        theXml.append(XML_ROOT_E);
        return theXml.toString();
    }

    private void validateXml(String theXml) throws ParseException, Exception {
        String METHOD_NAME = "validateXml";
        Trace.methodBegin(this, "validateXml");
        SAXParser saxparser = null;
        SymbolTable symbolTable = new SymbolTable(2039);
        XMLGrammarPreparser preparser = new XMLGrammarPreparser(symbolTable);
        XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        preparser.setProperty(PROPERTY_GRAMMAR_POOL, (Object)grammarPool);
        preparser.setFeature(FEATURE_NAMESPACE, true);
        preparser.setFeature(FEATURE_VALIDATION, true);
        preparser.setFeature(FEATURE_SCHEMA_VALIDATION, true);
        preparser.setFeature(FEATURE_SCHEMA_FULL_CHECKING, true);
        try {
            Grammar g = preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", new XMLInputSource(null, this.getSchemaFileName(), null));
        }
        catch (IOException ioe) {
            Trace.verbose((Object)this, "validateXml", (Throwable)ioe);
            throw ioe;
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature(FEATURE_SCHEMA_VALIDATION, true);
        spf.setFeature(FEATURE_SCHEMA_FULL_CHECKING, true);
        spf.setFeature(FEATURE_NAMESPACE, true);
        spf.setFeature(FEATURE_VALIDATION, true);
        spf.setNamespaceAware(true);
        spf.setValidating(true);
        saxparser = spf.newSAXParser();
        saxparser.setProperty(PROPERTY_SYMBOL_TABLE, symbolTable);
        saxparser.setProperty(PROPERTY_GRAMMAR_POOL, grammarPool);
        StringReader reader = new StringReader(theXml);
        ArrayList parseErrors = new ArrayList();
        Trace.verbose((Object)this, "validateXml", "begin parsing xml...");
        saxparser.parse(new InputSource(reader), (DefaultHandler)new ParseHandler(parseErrors));
        Trace.verbose((Object)this, "validateXml", "done parsing xml...");
        if (parseErrors.size() > 0) {
            throw new ParseException(parseErrors);
        }
    }

    private synchronized List buildListFromDoc(Element root) throws Exception {
        String methodName = "buildListFromDoc";
        ArrayList<StorageProfileCommon> theList = new ArrayList<StorageProfileCommon>();
        List profiles = XMLUtils.listNamedChildElements(root, "sscs_storage_profile");
        int pSize = profiles.size();
        for (int i = 0; i < pSize; ++i) {
            Element profile = (Element)profiles.get(i);
            StorageProfileCommon newProfile = this.getChildClassInstance();
            newProfile.populateFromXMLElement(profile);
            theList.add(newProfile);
        }
        return theList;
    }

    public static List getProfilesWithDuplicateSettings(StorageProfileInterface profile, List allProfiles) {
        String METHOD_NAME = "getProfilesWithDuplicateSettings";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ManageStorageProfilesCommon == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ManageStorageProfilesCommon = ManageStorageProfilesCommon.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ManageStorageProfilesCommon")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ManageStorageProfilesCommon, "getProfilesWithDuplicateSettings");
        ArrayList forReturn = new ArrayList();
        int sizeL = allProfiles == null ? 0 : allProfiles.size();
        for (int i = 0; i < sizeL; ++i) {
            if (!profile.equalSettings((StorageProfileInterface)allProfiles.get(i))) continue;
            forReturn.add(allProfiles.get(i));
        }
        return forReturn;
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ParseHandler
    extends DefaultHandler {
        private List errors;

        public ParseHandler(List l) {
            this.errors = l;
        }

        public void error(SAXParseException e) {
            this.errors.add("Line " + e.getLineNumber() + ": " + e.getMessage());
        }

        public void fatalError(SAXParseException e) {
            this.errors.add("Line " + e.getLineNumber() + ": " + e.getMessage());
        }
    }
}

