/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.StoragePoolCommon;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public abstract class ManageStoragePoolsCommon
implements ManageStoragePoolsInterface {
    protected ConfigContext context;
    protected CIMOMHandleWrapper handle;
    protected StoragePoolCommon myChildForConstants = this.getChildClassInstance();
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ManageStoragePoolsCommon;

    protected abstract StoragePoolCommon getChildClassInstance();

    public abstract ArrayList getItemsByStorageProfile(String var1) throws ConfigMgmtException, ItemNotFoundException;

    public abstract CIMArgument[] buildInputArguments(String var1, CIMObjectPath var2, String var3) throws ConfigMgmtException;

    public abstract boolean doesVolumeRestrictionExist(VDiskInterface var1) throws ConfigMgmtException;

    public abstract CIMObjectPath getConfigurationServicePath(String var1) throws ConfigMgmtException;

    public abstract List findVDisksForStealing(boolean var1, String var2, String var3) throws ConfigMgmtException;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.verbose((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    protected ArrayList enumToList(Enumeration enumeration) throws ConfigMgmtException {
        Trace.methodBegin(this, "enumToList");
        ArrayList<StoragePoolCommon> enumToList = new ArrayList<StoragePoolCommon>();
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "enumToList", "Creating StoragePool Java objects");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                StoragePoolCommon sp = this.getChildClassInstance();
                sp.setInstance(ci);
                sp.init(this.context);
                Trace.verbose((Object)this, "enumToList", "Marija konj. " + ci);
                CIMObjectWrapper.populate(sp, sp.getFieldMap(), ci);
                sp.loadKeys();
                enumToList.add(sp);
                Trace.verbose((Object)this, "enumToList", "The instance added to the list: " + sp);
            }
        }
        return enumToList;
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        ArrayList pools = new ArrayList();
        try {
            Trace.verbose((Object)this, "getItemsBySystem", "Querying CIM for StoragePool instances.");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath(this.myChildForConstants.getCIMObjectName()), true, false, true, false, this.myChildForConstants.getCIMObjectPropertyNames());
            Trace.verbose((Object)this, "getItemsBySystem", "Returned from querying CIM for StoragePool instances.");
            pools = this.enumToList(enumeration);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsBySystem", cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsBySystem", (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StoragePool instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsBySystem", (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StoragePool instances.", e);
        }
        return pools;
    }

    public abstract ArrayList getItemsByStorageDomain(String var1) throws ConfigMgmtException, ItemNotFoundException;

    public StoragePoolInterface getItemByName(String name, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        String methodName = "getItemByName";
        Trace.methodBegin(this, methodName);
        try {
            Trace.verbose((Object)this, methodName, "Getting StoragePools by domain.");
            ArrayList items = this.getItemsByStorageDomain(domainName);
            Trace.verbose((Object)this, methodName, "Searching for the specified StoragePool.");
            for (int i = 0; i < items.size(); ++i) {
                StoragePoolInterface spi = (StoragePoolInterface)items.get(i);
                if (!spi.getName().equals(name)) continue;
                return spi;
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, methodName, (Throwable)infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, methodName, (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the StoragePool instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, methodName, (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the StoragePool instance.", e);
        }
        return null;
    }

    public StoragePoolInterface getByKey(Collection key) throws ConfigMgmtException {
        StoragePoolCommon sp;
        block6: {
            String methodName = "getByKey";
            Trace.methodBegin(this, methodName);
            sp = null;
            try {
                if (key != null) {
                    CIMObjectPath objPath = new CIMObjectPath(this.myChildForConstants.getCIMObjectName(), new Vector(key));
                    Trace.verbose((Object)this, methodName, "Querying CIM for StoragePool matching key(s)");
                    CIMInstance ci = this.handle.getInstance(objPath, false, true, false, this.myChildForConstants.getCIMObjectPropertyNames());
                    Trace.verbose((Object)this, methodName, "Returned from querying CIM for StoragePool matching key(s)");
                    if (ci != null) {
                        Trace.verbose((Object)this, methodName, "Creating StoragePool java object.");
                        sp = this.getChildClassInstance();
                        sp.setInstance(ci);
                        sp.init(this.context);
                        CIMObjectWrapper.populate(sp, sp.getFieldMap(), ci);
                        sp.loadKeys();
                    }
                    break block6;
                }
                Trace.error((Object)this, methodName, "Key object passed is null.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object passed is null.");
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, methodName, "Failed: " + cme);
                throw cme;
            }
            catch (NullPointerException npe) {
                Trace.error((Object)this, methodName, "NullPointerException - Null returned when trying to obtain the StoragePool instance: " + npe);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the StoragePool instance.", npe);
            }
            catch (Exception e) {
                Trace.verbose((Object)this, methodName, "Exception - Exception thrown when trying to obtain the StoragePool instance: " + e);
                throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the StoragePool instance.", e);
            }
        }
        return sp;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        String methodName = "getNextAvailableName";
        Trace.methodBegin(this, methodName);
        int MAX_PROFILES_TRY = 10000;
        HashSet<String> usedNamesSet = new HashSet<String>();
        try {
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select " + this.myChildForConstants.getCIMPropNameForName() + " from " + this.myChildForConstants.getCIMObjectName());
            while (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance inst = (CIMInstance)enumeration.nextElement();
                CIMProperty nameProp = inst.getProperty(this.myChildForConstants.getCIMPropNameForName());
                if (nameProp == null || nameProp.getValue() == null || nameProp.getValue().getValue() == null) continue;
                usedNamesSet.add((String)nameProp.getValue().getValue());
            }
            String nextAvailableName = "profile";
            for (int i = 1; i < 10000; ++i) {
                if (usedNamesSet.contains(nextAvailableName + i)) {
                    continue;
                }
                Trace.verbose((Object)this, methodName, "Found available name: " + nextAvailableName + i);
                return nextAvailableName + i;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, methodName, "NullPointerException - Null returned when trying to obtain the next available StoragePool name.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the next available StoragePool name.", npe);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, methodName, "Exception - Exception thrown when trying to obtain the next available creation name.");
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the next available creation name.", e);
        }
        return null;
    }

    public MethodCallStatus createStoragePool(String name, String description, String storageProfileName, String storageDomainName) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        String methodName = "createStoragePool";
        Trace.methodBegin(this, methodName);
        try {
            Trace.verbose((Object)this, methodName, "Validating parameters.");
            this.validateName(name, storageDomainName);
            this.validateDescription(description);
            MethodCallStatus callStatus = new MethodCallStatus();
            Trace.verbose((Object)this, methodName, "Retrieving specified StorageProfile");
            ManageStorageProfilesInterface msp = ManageStorageProfilesFactory.getManager();
            msp.init(this.context, null);
            StorageProfileInterface spi = msp.getItemByName(storageProfileName);
            if (spi == null) {
                Trace.verbose((Object)this, methodName, "StorageProfile: " + storageProfileName + " not found.");
                throw new ItemNotFoundException(storageProfileName);
            }
            CIMArgument[] inArgs = this.buildInputArguments(name, spi.getInstance().getObjectPath(), storageDomainName);
            CIMArgument[] outArgs = this.buildOutputArguments();
            CIMObjectPath confServiceObjectPath = this.getConfigurationServicePath(storageDomainName);
            Trace.verbose((Object)this, methodName, "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, methodName, "Calling CreateOrModifyStoragePool.");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyStoragePool", inArgs, outArgs);
            Trace.verbose((Object)this, "createStoragePool", "Returned from calling CreateOrModifyStoragePool with return code: " + returnCodeValue);
            callStatus.setReturnCode(((UnsignedInt32)returnCodeValue.getValue()).intValue());
            if (callStatus.getReturnCode() == 0) {
                CIMObjectPath poolPath = (CIMObjectPath)outArgs[2].getValue().getValue();
                Trace.verbose((Object)this, methodName, "Object path of the created pool is: " + poolPath);
                StoragePoolInterface pool = null;
                if (poolPath != null) {
                    pool = this.getByKey(poolPath.getKeys());
                    Trace.verbose((Object)this, methodName, "Got the new pool.");
                }
                if (pool != null) {
                    Trace.verbose((Object)this, methodName, "Setting description");
                    pool.setDescription(description);
                    pool.save();
                } else {
                    Trace.verbose((Object)this, methodName, "Could not set description, StoragePool could not be found.");
                }
            }
            return callStatus;
        }
        catch (BadParameterException bpe) {
            Trace.error((Object)this, methodName, (ConfigMgmtException)bpe);
            throw bpe;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, methodName, (Throwable)infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, methodName, (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems creating the StoragePool instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, methodName, (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems creating StoragePool.", e);
        }
    }

    public CIMArgument[] buildOutputArguments() {
        Trace.methodBegin(this, "buildOutputArguments");
        CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("Pool", new CIMValue(null))};
        return outArgs;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        String methodName = "delete";
        Trace.methodBegin(this, methodName);
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "delete", "Getting StoragePool to delete");
            StoragePoolInterface pool = this.getByKey(key);
            if (pool == null) {
                Trace.verbose((Object)this, methodName, "StoragePool with keys: " + key + " could not be found.");
                throw new ItemNotFoundException(key.toString());
            }
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Pool", new CIMValue((Object)pool.getInstance().getObjectPath()))};
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null))};
            CIMObjectPath confServiceObjectPath = this.getConfigurationServicePath(pool.getStorageDomainName());
            Trace.verbose((Object)this, methodName, "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, methodName, "Calling DeleteStoragePool");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "DeleteStoragePool", inArgs, outArgs);
            Trace.verbose((Object)this, methodName, "Returned from calling DeleteStoragePool with return code: " + returnCodeValue);
            methodCallStatus.setReturnCode(((UnsignedInt32)returnCodeValue.getValue()).intValue());
            return methodCallStatus;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, methodName, "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, methodName, (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems deleting the StoragePool instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, methodName, "Exception - Exception thrown when trying to delete StoragePool: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems deleting StoragePool.", e);
        }
    }

    public void validateName(String name, String domainName) throws ConfigMgmtException, ItemNotFoundException, BadParameterException {
        String methodName = "validateName";
        Trace.methodBegin(this, methodName);
        if (name != null) {
            if (name.length() > 16) {
                Trace.error((Object)this, methodName, "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-]+", name)) {
                Trace.error((Object)this, methodName, "Name: " + name + " contains invalid characters.");
                throw new BadParameterException(name, "error.bizobj.invalidCharacter");
            }
            StoragePoolInterface pool = null;
            try {
                if (domainName != null) {
                    pool = this.getItemByName(name, domainName);
                }
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)this, methodName, "StorageDomain: " + domainName + "  not found");
                throw new ItemNotFoundException(domainName);
            }
            if (pool != null) {
                Trace.error((Object)this, methodName, "Name: " + name + " already exists.");
                throw new BadParameterException(name, "error.objectAlreadyExists");
            }
        } else {
            Trace.error((Object)this, methodName, "Name passed is null.");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
    }

    public void validateDescription(String description) throws BadParameterException {
        String methodName = "validateDescription";
        Trace.methodBegin(this, methodName);
        if (description != null) {
            if (description.length() > 64) {
                Trace.error((Object)this, methodName, "Description: " + description + " is too long.");
                throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", description)) {
                Trace.error((Object)this, methodName, "Description: " + description + " contains invalid characters.");
                throw new BadParameterException(description, "error.bizobj.invalidDescCharacter");
            }
        }
    }

    public static boolean areProfilesCompatible(StorageProfileInterface fromP, StorageProfileInterface toP) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ManageStoragePoolsCommon == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ManageStoragePoolsCommon = ManageStoragePoolsCommon.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ManageStoragePoolsCommon")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ManageStoragePoolsCommon, "areProfilesCompatible");
        return fromP.getRAIDLevel() == toP.getRAIDLevel() && fromP.getSegmentSize() == toP.getSegmentSize() && (fromP.isReadAheadEnabled() && toP.isReadAheadEnabled() || !fromP.isReadAheadEnabled() && !toP.isReadAheadEnabled()) && (fromP.dedicatedSpareExists() && toP.dedicatedSpareExists() || !fromP.dedicatedSpareExists() && !toP.dedicatedSpareExists()) && fromP.getNumberOfDisks() == toP.getNumberOfDisks() && (fromP.getArrayType() == toP.getArrayType() || toP.getArrayType() == 5 || toP.getArrayType() == 4 || toP.getArrayType() == 3);
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

