/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.RaidSetGroup;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AvailableSpaceForRaidSets {
    private List poolBreakdowns;
    private HashMap availSizes;
    private List arraysToConsider;
    private boolean haveGeneratedListOfSizes = false;
    private List suitableArrays;
    private ConfigContext context;
    private int arrayType;
    private int segmentSize;
    private boolean readAheadMode;
    private int numberOfDisks;
    private int raidLevel;
    private boolean usesDedicatedSpare;
    public static final int VALID_ARRAY = 0;
    public static final int INVALID_ARRAY_NOT_HEALTHY = 1;
    public static final int INVALID_ARRAY_WRONG_ARRAY_TYPE = 2;
    public static final int INVALID_ARRAY_WRONG_READAHEAD_MODE = 3;
    public static final int INVALID_ARRAY_WRONG_SEGMENT_SIZE = 4;
    private static final int MULTIPLIER_BEST_MATCH = 1000;
    private static final int MULTIPLIER_SECOND_MATCH = 1;
    private static final int MULTIPLIER_WORST_MATCH = 0;
    private static final int MULTIPLIER_NO_MATCH = 0;
    private static final int MAX_NUMBER_CLOSE_RSG = 5;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets;

    public AvailableSpaceForRaidSets(ConfigContext context, int arrayType, int segmentSize, boolean readAheadMode, int numberOfDisks, int raidLevel, boolean usesDedicatedSpare, List arraysToConsider) throws ConfigMgmtException {
        Trace.constructor(this);
        this.context = context;
        this.arrayType = arrayType;
        this.segmentSize = segmentSize;
        this.readAheadMode = readAheadMode;
        this.numberOfDisks = numberOfDisks;
        this.raidLevel = raidLevel;
        this.usesDedicatedSpare = usesDedicatedSpare;
        this.arraysToConsider = arraysToConsider;
        this.poolBreakdowns = new ArrayList();
        this.findSuitableArrays();
        this.processTraysOnArrays();
    }

    public AvailableSpaceForRaidSets(ConfigContext context, int arrayType, int segmentSize, boolean readAheadMode, int numberOfDisks, int raidLevel, boolean usesDedicatedSpare) throws ConfigMgmtException {
        Trace.constructor(this);
        this.context = context;
        this.arrayType = arrayType;
        this.segmentSize = segmentSize;
        this.readAheadMode = readAheadMode;
        this.numberOfDisks = numberOfDisks;
        this.raidLevel = raidLevel;
        this.usesDedicatedSpare = usesDedicatedSpare;
        this.poolBreakdowns = new ArrayList();
        this.findSuitableArrays();
        this.processTraysOnArrays();
    }

    public List getAvailableSizes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAvailableSizes()");
        if (!this.haveGeneratedListOfSizes) {
            this.generateListOfSizes();
            this.haveGeneratedListOfSizes = true;
        }
        return Collections.list(Collections.enumeration(this.availSizes.keySet()));
    }

    public List getRaidSetBreakdowns() {
        return this.poolBreakdowns;
    }

    public RaidSetGroup getRaidSetGroupForSize(BigInteger requestedSize) throws ConfigMgmtException {
        Trace.methodBegin(this, "getRaidSetGroupForSize()");
        if (!this.haveGeneratedListOfSizes) {
            this.generateListOfSizes();
            this.haveGeneratedListOfSizes = true;
        }
        return (RaidSetGroup)this.availSizes.get(requestedSize);
    }

    public List findClosestRaidSetGroupsForSize(BigInteger requestedSize) throws ConfigMgmtException {
        Trace.methodBegin(this, "findClosestRaidSetGroupsForSize()");
        if (!this.haveGeneratedListOfSizes) {
            this.generateListOfSizes();
            this.haveGeneratedListOfSizes = true;
        }
        ArrayList<BigInteger> caps = new ArrayList<BigInteger>();
        ArrayList<BigInteger> distances = new ArrayList<BigInteger>();
        Iterator iter = this.availSizes.keySet().iterator();
        while (iter.hasNext()) {
            BigInteger current = (BigInteger)iter.next();
            BigInteger diff = requestedSize.subtract(current).abs();
            int capsSize = distances.size();
            if (capsSize == 0) {
                caps.add(current);
                distances.add(diff);
                continue;
            }
            int placementIndex = -1;
            for (int j = 0; j < capsSize && placementIndex < 0; ++j) {
                BigInteger c = (BigInteger)distances.get(j);
                if (c.compareTo(diff) <= 0) continue;
                placementIndex = j;
            }
            if (placementIndex < 0) continue;
            caps.add(placementIndex, current);
            distances.add(placementIndex, diff);
            while (caps.size() > 5) {
                caps.remove(5);
                distances.remove(5);
            }
        }
        int capsSize = caps.size();
        ArrayList<RaidSetGroup> forReturn = new ArrayList<RaidSetGroup>();
        for (int i = 0; i < capsSize; ++i) {
            forReturn.add(this.getRaidSetGroupForSize((BigInteger)caps.get(i)));
        }
        return forReturn;
    }

    private synchronized void findSuitableArrays() throws ConfigMgmtException {
        String METHOD = "findSuitableArrays()";
        Trace.methodBegin(this, "findSuitableArrays()");
        if (this.arraysToConsider == null) {
            ManageT4sInterface mt4 = ManageT4sFactory.getManager();
            mt4.init(this.context, null);
            this.arraysToConsider = mt4.getItemList();
            if (this.arraysToConsider == null) {
                Trace.verbose((Object)this, "findSuitableArrays()", "No arrays exist, thus none are suitable.");
                return;
            }
        }
        if (this.suitableArrays == null) {
            this.suitableArrays = new ArrayList();
            int allArraysSize = this.arraysToConsider.size();
            for (int i = 0; i < allArraysSize; ++i) {
                T4Interface t4 = (T4Interface)this.arraysToConsider.get(i);
                if (0 != AvailableSpaceForRaidSets.isSuitableArray(t4, this.arrayType, this.segmentSize, this.readAheadMode)) continue;
                this.suitableArrays.add(t4);
            }
        }
        Trace.verbose((Object)this, "findSuitableArrays()", "ENDMethod");
    }

    public static int isSuitableArray(T4Interface t4, int arrayType, int segmentSize, boolean readAheadMode) {
        int rc = 0;
        String METHOD = "isSuitableArray";
        Class CLASS = class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets = AvailableSpaceForRaidSets.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets;
        Trace.methodBegin(CLASS, "isSuitableArray");
        try {
            if (2 == t4.getHealthStatus()) {
                if (AvailableSpaceForRaidSets.meetsArrayType(arrayType, t4.getArrayConfigurationType())) {
                    if (t4.hasConfiguredStorage()) {
                        if (!AvailableSpaceForRaidSets.meetsSegSize(segmentSize, t4.getBlockSize())) {
                            rc = 4;
                            Trace.verbose(CLASS, "isSuitableArray", "Found non-suitable array with wrong segment size: " + t4.getClusterName());
                        } else if (!AvailableSpaceForRaidSets.meetsReadAhead(readAheadMode, t4.getReadaheadMode())) {
                            rc = 3;
                            Trace.verbose(CLASS, "isSuitableArray", "Found non-suitable array with wrong read ahead mode: " + t4.getClusterName());
                        } else {
                            Trace.verbose(CLASS, "isSuitableArray", "Found suitable array with existing raid sets: " + t4.getClusterName());
                        }
                    } else {
                        Trace.verbose(CLASS, "isSuitableArray", "Found suitable array without existing raid sets: " + t4.getClusterName());
                    }
                } else {
                    rc = 2;
                    if (Trace.isTraceEnabled(CLASS)) {
                        Trace.verbose(CLASS, "isSuitableArray", "Skipping array: " + t4.getClusterName() + " with wrong array type: " + t4.getArrayConfigurationType());
                    }
                }
            } else {
                rc = 1;
                Trace.verbose(CLASS, "isSuitableArray", "Skipping unhealthy array: " + t4.getClusterName() + " with health code: " + t4.getHealthStatus());
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error(CLASS, cme);
            rc = 1;
        }
        return rc;
    }

    public static boolean meetsArrayType(int arrayType, int t4sArrayType) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets = AvailableSpaceForRaidSets.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets, "meetsArrayType(int)");
        boolean result = false;
        switch (arrayType) {
            case 3: 
            case 4: 
            case 5: {
                result = true;
                break;
            }
            case 0: {
                if (t4sArrayType != 8 && t4sArrayType != 2) break;
                result = true;
                break;
            }
            case 1: {
                if (t4sArrayType != 4 && t4sArrayType != 1) break;
                result = true;
                break;
            }
            case 2: {
                if (t4sArrayType != 12 && t4sArrayType != 3) break;
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static int getArrayTypeMultiplier(int arrayType, int t4sArrayType) {
        switch (arrayType) {
            case 5: {
                if (t4sArrayType == 12 || t4sArrayType == 3) {
                    return 1000;
                }
                if (t4sArrayType == 8 || t4sArrayType == 2) {
                    return 1;
                }
                if (t4sArrayType != 4 && t4sArrayType != 1) break;
                return 0;
            }
            case 4: {
                if (t4sArrayType == 4 || t4sArrayType == 1) {
                    return 1000;
                }
                if (t4sArrayType == 8 || t4sArrayType == 2) {
                    return 1;
                }
                if (t4sArrayType != 12 && t4sArrayType != 3) break;
                return 0;
            }
            case 3: {
                if (t4sArrayType == 8 || t4sArrayType == 2) {
                    return 1000;
                }
                if (t4sArrayType == 4 || t4sArrayType == 1) {
                    return 1;
                }
                if (t4sArrayType != 12 && t4sArrayType != 3) break;
                return 0;
            }
            case 0: {
                if (t4sArrayType != 8) break;
                return 1000;
            }
            case 1: {
                if (t4sArrayType != 4) break;
                return 1000;
            }
            case 2: {
                if (t4sArrayType != 12) break;
                return 1000;
            }
        }
        return 0;
    }

    public static boolean meetsSegSize(int segmentSize, int segSize) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets = AvailableSpaceForRaidSets.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets, "meetsSegSize");
        boolean result = false;
        if (segmentSize == 0) {
            if (segSize == 4096) {
                result = true;
            }
        } else if (segmentSize == 1) {
            if (segSize == 8192) {
                result = true;
            }
        } else if (segmentSize == 2) {
            if (segSize == 16384) {
                result = true;
            }
        } else if (segmentSize == 3) {
            if (segSize == 32768) {
                result = true;
            }
        } else if (segmentSize == 4 && segSize == 65536) {
            result = true;
        }
        return result;
    }

    public static boolean meetsReadAhead(boolean readAheadMode, int readAhead) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets = AvailableSpaceForRaidSets.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets, "meetsReadAhead");
        boolean result = true;
        if (readAheadMode && readAhead == 0) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets = AvailableSpaceForRaidSets.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets, "meetsReadAhead", "Both read ahead values on.");
            result = true;
        } else if (!readAheadMode && readAhead > 0) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets = AvailableSpaceForRaidSets.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets, "meetsReadAhead", "Both read ahead values off.");
            result = true;
        } else {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets = AvailableSpaceForRaidSets.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$AvailableSpaceForRaidSets, "meetsReadAhead", "Values do not match.");
            result = false;
        }
        return result;
    }

    private void processTraysOnArrays() throws ConfigMgmtException {
        String METHOD = "processTraysOnArrays";
        Trace.methodBegin(this, "processTraysOnArrays");
        Iterator arrayI = this.suitableArrays.iterator();
        while (arrayI.hasNext()) {
            T4Interface t4 = (T4Interface)arrayI.next();
            Trace.verbose((Object)this, "processTraysOnArrays", "Processing trays on array with IP: " + t4.getClusterName());
            List t4Trays = t4.getTrays();
            Iterator trayIter = t4Trays.iterator();
            while (trayIter.hasNext()) {
                TrayInterface tray = (TrayInterface)trayIter.next();
                Trace.verbose((Object)this, "processTraysOnArrays", "Processing tray: " + tray.getId() + " on array with IP: " + t4.getClusterName());
                boolean finished = false;
                int numRaidSets = 2;
                while (!finished) {
                    PoolBreakdownForTray pbd = tray.getPoolBreakdownForTray(numRaidSets, numRaidSets * this.numberOfDisks, this.raidLevel, this.usesDedicatedSpare);
                    if (pbd.canBeSupported()) {
                        finished = true;
                        Trace.verbose((Object)this, "processTraysOnArrays", "Found room for " + numRaidSets + " Raid Sets on tray: " + tray.getId() + " on array with IP: " + t4.getClusterName());
                        this.poolBreakdowns.add(pbd);
                        continue;
                    }
                    if (numRaidSets > 1) {
                        --numRaidSets;
                        continue;
                    }
                    Trace.verbose((Object)this, "processTraysOnArrays", "No room for Raid Sets on tray: " + tray.getId() + " on array with IP: " + t4.getClusterName());
                    finished = true;
                }
            }
        }
        Trace.verbose((Object)this, "processTraysOnArrays", "ENDMethod");
    }

    private void generateListOfSizes() throws ConfigMgmtException {
        String METHOD = "generateListOfSizes";
        Trace.methodBegin(this, "generateListOfSizes");
        Object currentGroup = null;
        ArrayList allGroups = new ArrayList();
        HashMap highestWeightForCapacity = new HashMap();
        HashMap allGroupsIndexByCapacity = new HashMap();
        int bdsSize = this.poolBreakdowns.size();
        for (int sizeI = 0; sizeI < bdsSize; ++sizeI) {
            PoolBreakdownForTray pbd = (PoolBreakdownForTray)this.poolBreakdowns.get(sizeI);
            for (int i = 0; i < pbd.getNumPools(); ++i) {
                int allGroupsSize = allGroups.size();
                for (int j = 0; j < allGroupsSize; ++j) {
                    RaidSetGroup existing = (RaidSetGroup)allGroups.get(j);
                    RaidSetGroup newGroup = new RaidSetGroup(existing);
                    newGroup.addBreakdown(pbd, i);
                    this.updateIfRequired(allGroups, allGroupsIndexByCapacity, highestWeightForCapacity, newGroup);
                }
                if (i != 0) continue;
                RaidSetGroup newRsg = new RaidSetGroup(pbd, i, this.arrayType);
                this.updateIfRequired(allGroups, allGroupsIndexByCapacity, highestWeightForCapacity, newRsg);
            }
            Trace.verbose((Object)this, "generateListOfSizes", "Now have allGroups size: " + allGroups.size());
        }
        this.availSizes = new HashMap();
        int allGroupsSize = allGroups.size();
        for (int j = 0; j < allGroupsSize; ++j) {
            RaidSetGroup rsg = (RaidSetGroup)allGroups.get(j);
            Trace.verbose((Object)this, "generateListOfSizes", "Adding entry with cap: " + rsg.getCapacity() + " and weight: " + rsg.getWeight());
            if (rsg.getCapacity().compareTo(new BigInteger("2199023255552")) != -1) continue;
            this.availSizes.put(rsg.getCapacity(), rsg);
        }
        Trace.verbose((Object)this, "generateListOfSizes", "Computed the following number of possible sorted sizes: " + this.availSizes.size());
        Trace.verbose((Object)this, "generateListOfSizes", "ENDMethod");
    }

    private void updateIfRequired(ArrayList allGroups, HashMap allGroupsIndexByCapacity, HashMap highestWeightForCapacity, RaidSetGroup newRsg) {
        String METHOD = "updateIfRequired";
        Integer weight = (Integer)highestWeightForCapacity.get(newRsg.getCapacity());
        if (weight != null) {
            if (weight < newRsg.getWeight()) {
                int replaceIndex = (Integer)allGroupsIndexByCapacity.get(newRsg.getCapacity());
                Trace.verbose((Object)this, "updateIfRequired", "replacing at index: " + replaceIndex);
                allGroups.set(replaceIndex, newRsg);
                highestWeightForCapacity.put(newRsg.getCapacity(), new Integer(newRsg.getWeight()));
            }
        } else {
            Trace.verbose((Object)this, "updateIfRequired", "new entry");
            int nextIndex = allGroups.size();
            allGroups.add(newRsg);
            allGroupsIndexByCapacity.put(newRsg.getCapacity(), new Integer(nextIndex));
            highestWeightForCapacity.put(newRsg.getCapacity(), new Integer(newRsg.getWeight()));
        }
    }

    public List getArraysToConsider() {
        return this.arraysToConsider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

