/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.Job;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMInstance;
import org.w3c.dom.Element;

public class StorageProfile
implements Serializable,
Cloneable,
Constants.ArrayType,
Constants.ProfileProperties,
Constants.Exceptions,
Constants.RAIDLevel,
Constants.ObjectValidation,
Constants.T4 {
    private String name;
    private String originalName;
    private boolean nameChanged;
    private boolean settingsChanged;
    private boolean isNewProfile;
    private String description;
    private String productVersion;
    private int raidLevel = -1;
    private int segmentSize = -1;
    private int readaheadMode = -1;
    private String numberOfDrives;
    private int dedicatedHotSpare = -1;
    private int importStatus = -1;
    private int arrayType = -1;
    private static final int[] VALID_RAID_LEVELS = new int[]{0, 1, 5};
    private static final int[] VALID_SEGMENT_SIZES = new int[]{4096, 8192, 16384, 32768, 65536};
    private static final String PROFILE_NAME_PATTERN = "^[\\w]+[\\w \\-]*$";
    private static final String PROFILE_DESCRIPTION_PATTERN = "^[\\w]*[\\w \\-\\.]*$";
    private static final String READ_AHEAD_MODE_ON_S = "on";
    private static final String READ_AHEAD_MODE_OFF_S = "off";
    private static final String DEDICATED_HOT_SPARE_YES_S = "yes";
    private static final String DEDICATED_HOT_SPARE_NO_S = "no";
    public static final String XML_PROFILE = "sscs_storage_profile";
    private static final String XML_PROFILE_B = "<sscs_storage_profile>";
    private static final String XML_PROFILE_E = "</sscs_storage_profile>";
    private static final String XML_NAME = "profile_name";
    private static final String XML_NAME_B = "<profile_name>";
    private static final String XML_NAME_E = "</profile_name>";
    private static final String XML_VERSION = "product_version";
    private static final String XML_VERSION_B = "<product_version>";
    private static final String XML_VERSION_E = "</product_version>";
    private static final String XML_DESCRIPTION = "profile_description";
    private static final String XML_DESCRIPTION_B = "<profile_description>";
    private static final String XML_DESCRIPTION_E = "</profile_description>";
    private static final String XML_RAID_LEVEL = "raid_level";
    private static final String XML_RAID_LEVEL_B = "<raid_level>";
    private static final String XML_RAID_LEVEL_E = "</raid_level>";
    private static final String XML_SEGMENT_SIZE = "segment_size";
    private static final String XML_SEGMENT_SIZE_B = "<segment_size>";
    private static final String XML_SEGMENT_SIZE_E = "</segment_size>";
    private static final String XML_READ_AHEAD_MODE = "read_ahead_mode";
    private static final String XML_READ_AHEAD_MODE_B = "<read_ahead_mode>";
    private static final String XML_READ_AHEAD_MODE_E = "</read_ahead_mode>";
    private static final String XML_ARRAY_TYPE = "array_type";
    private static final String XML_ARRAY_TYPE_B = "<array_type>";
    private static final String XML_ARRAY_TYPE_E = "</array_type>";
    private static final String XML_NUMBER_OF_DISKS = "number_of_disks";
    private static final String XML_NUMBER_OF_DISKS_B = "<number_of_disks>";
    private static final String XML_NUMBER_OF_DISKS_E = "</number_of_disks>";
    private static final String XML_DEDICATED_HOT_SPARE = "dedicated_hot_spare";
    private static final String XML_DEDICATED_HOT_SPARE_B = "<dedicated_hot_spare>";
    private static final String XML_DEDICATED_HOT_SPARE_E = "</dedicated_hot_spare>";

    public StorageProfile(String name, String description, int raidLevel, int segmentSize, int readaheadMode, String numberOfDrives, int dedicatedHotSpare, int arrayType) {
        Trace.constructor(this);
        this.name = name;
        this.description = description;
        this.productVersion = "Maserati_Patch_03";
        this.raidLevel = raidLevel;
        this.segmentSize = segmentSize;
        this.readaheadMode = readaheadMode;
        this.numberOfDrives = numberOfDrives;
        this.dedicatedHotSpare = dedicatedHotSpare;
        this.arrayType = arrayType;
        this.isNewProfile = true;
    }

    public StorageProfile(Element profile) throws Exception {
        Trace.constructor(this);
        Element name = XMLUtils.findElement(profile, XML_NAME);
        Element version = XMLUtils.findElement(profile, XML_VERSION);
        Element description = XMLUtils.findElement(profile, XML_DESCRIPTION);
        Element raidLevel = XMLUtils.findElement(profile, XML_RAID_LEVEL);
        Element segmentSize = XMLUtils.findElement(profile, XML_SEGMENT_SIZE);
        Element readaheadMode = XMLUtils.findElement(profile, XML_READ_AHEAD_MODE);
        Element arrayType = XMLUtils.findElement(profile, XML_ARRAY_TYPE);
        Element numberOfDisks = XMLUtils.findElement(profile, XML_NUMBER_OF_DISKS);
        Element dedicatedHotSpare = XMLUtils.findElement(profile, XML_DEDICATED_HOT_SPARE);
        this.name = XMLUtils.getElementValue(name);
        this.description = XMLUtils.getElementValue(description);
        this.productVersion = XMLUtils.getElementValue(version);
        this.raidLevel = Integer.parseInt(XMLUtils.getElementValue(raidLevel));
        this.segmentSize = StorageProfile.getSegmentSizeInt(XMLUtils.getElementValue(segmentSize));
        this.readaheadMode = StorageProfile.getReadaheadModeInt(XMLUtils.getElementValue(readaheadMode));
        this.numberOfDrives = XMLUtils.getElementValue(numberOfDisks);
        this.dedicatedHotSpare = StorageProfile.getDedicatedHotSpareInt(XMLUtils.getElementValue(dedicatedHotSpare));
        this.arrayType = StorageProfile.getArrayTypeInt(XMLUtils.getElementValue(arrayType));
    }

    public String getName() {
        return this.name;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public int getRaidLevel() {
        return this.raidLevel;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public int getReadaheadMode() {
        return this.readaheadMode;
    }

    public String getNumberOfDrives() {
        return this.numberOfDrives;
    }

    public int getDedicatedHotSpare() {
        return this.dedicatedHotSpare;
    }

    public int getArrayType() {
        return this.arrayType;
    }

    public int getImportStatus() {
        return this.importStatus;
    }

    public String getImportStatusString() {
        if (this.importStatus == 3) {
            return "Conflicting";
        }
        if (this.importStatus == 0) {
            return "New";
        }
        if (this.importStatus == 1) {
            return "In Use";
        }
        if (this.importStatus == 2) {
            return "Duplicate Settings";
        }
        if (this.importStatus == 4) {
            return "Exists";
        }
        return "Unknown";
    }

    public void setName(String name) {
        String methodName = "setName";
        Trace.methodBegin(this, methodName);
        if (!this.nameChanged && name != null && !name.equals(this.name)) {
            this.nameChanged = true;
            this.originalName = this.name;
            Trace.verbose((Object)this, methodName, "Profile name has been changed from <" + this.originalName + "> to <" + name);
        }
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setRaidLevel(int raidLevel) {
        if (raidLevel != this.raidLevel) {
            this.raidLevel = raidLevel;
            this.settingsChanged = true;
        }
    }

    public void setSegmentSize(int segmentSize) {
        if (segmentSize != this.segmentSize) {
            this.segmentSize = segmentSize;
            this.settingsChanged = true;
        }
    }

    public void setReadaheadMode(int readaheadMode) {
        if (readaheadMode != this.readaheadMode) {
            this.readaheadMode = readaheadMode;
            this.settingsChanged = true;
        }
    }

    public void setNumberOfDrives(String numberOfDrives) {
        if (numberOfDrives != null && !numberOfDrives.equalsIgnoreCase(this.numberOfDrives)) {
            this.numberOfDrives = numberOfDrives;
            this.settingsChanged = true;
        }
    }

    public void setDedicatedHotSpare(int dedicatedHotSpare) {
        if (dedicatedHotSpare != this.dedicatedHotSpare) {
            this.dedicatedHotSpare = dedicatedHotSpare;
            this.settingsChanged = true;
        }
    }

    public void setArrayType(int arrayType) {
        if (arrayType != this.arrayType) {
            this.arrayType = arrayType;
            this.settingsChanged = true;
        }
    }

    public void setImportStatus(int status) {
        this.importStatus = status;
    }

    public synchronized void save(ConfigContext context) throws ConfigMgmtException {
        String methodName = "save";
        Trace.methodBegin(this, methodName);
        this.validateProfileValues();
        this.validateProfileIntegrity();
        if (!this.isNewProfile) {
            ManageT4sInterface mt4s = ManageT4sFactory.getManager();
            mt4s.init(context, null);
            if (!mt4s.areAllArraysHealthy()) {
                String message = "Unable to modify profile - at least one array not healthy.";
                Trace.verbose((Object)this, methodName, message);
                ConfigMgmtException cme = new ConfigMgmtException("NOT_ALL_ARRAYS_HEALTHY", message);
                throw cme;
            }
        }
    }

    public void validateProfileIntegrity() throws ConfigMgmtException {
        String methodName = "validateProfileIntegrity";
        Trace.methodBegin(this, methodName);
        if (this.getRaidLevel() == 0 && "14".equals(this.getNumberOfDrives()) && this.getDedicatedHotSpare() == 1) {
            String message = "Can not create profile with RAID 0, 14 disks, and dedicated hot spare .";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("storage.mgmt.profile.error.rl0_nd14.dhs", new String[]{this.getName()}, message, null);
        }
        if ("14".equals(this.getNumberOfDrives()) && this.getDedicatedHotSpare() == 1) {
            String message = "Can not create profile with 14 disks and dedicated hot spare.";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("storage.mgmt.profile.error.nd14.dhs", new String[]{this.getName()}, message, null);
        }
        if (this.getRaidLevel() == 0 && this.getDedicatedHotSpare() == 1) {
            String message = "Can not create profile with RAID level 0 and dedicated hot spare.";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("storage.mgmt.profile.error.rl0.dhs", new String[]{this.getName()}, message, null);
        }
        if (this.getRaidLevel() == 5 && "2".equals(this.getNumberOfDrives())) {
            String message = "Can not create profile with RAID level 5 and 2 disks.";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("storage.mgmt.profile.error.rl5.nd2", new String[]{this.getName()}, message, null);
        }
        Trace.verbose((Object)this, methodName, "Profile <" + this.getName() + "> passes all integrity checks.");
    }

    public void validateProfileValues() throws ConfigMgmtException {
        String methodName = "validateProfileValues";
        Trace.methodBegin(this, methodName);
        this.validateString(this.getName(), false, PROFILE_NAME_PATTERN, 32, "INVALID_PROFILE_NAME");
        this.validateString(this.getDescription(), true, PROFILE_DESCRIPTION_PATTERN, 256, "INVALID_PROFILE_DESCRIPTION");
        this.validateValueAgainstArray(this.getRaidLevel(), VALID_RAID_LEVELS, "INVALID_PROFILE_RAID_LEVEL");
        this.validateValueAgainstArray(this.getSegmentSize(), VALID_SEGMENT_SIZES, "INVALID_PROFILE_SEGMENT_SIZE");
        if (this.getReadaheadMode() != 0 && this.getReadaheadMode() != 1) {
            String message = "Invalid readahead mode value <" + this.getReadaheadMode() + ">";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("INVALID_PROFILE_READAHEAD_MODE", message);
        }
        if (!"variable".equals(this.getNumberOfDrives())) {
            int numberOfDrivesInt = -1;
            boolean numberOfDrivesValid = true;
            try {
                numberOfDrivesInt = Integer.parseInt(this.getNumberOfDrives());
            }
            catch (NumberFormatException nfe) {
                numberOfDrivesValid = false;
            }
            if (numberOfDrivesInt < 2 || numberOfDrivesInt > 14) {
                numberOfDrivesValid = false;
            }
            if (!numberOfDrivesValid) {
                String message = "Invalid number of drives value <" + this.getNumberOfDrives() + ">";
                Trace.verbose((Object)this, methodName, message);
                throw new ConfigMgmtException("INVALID_PROFILE_NUMBER_OF_DRIVES", message);
            }
        }
        if (this.getDedicatedHotSpare() != 0 && this.getDedicatedHotSpare() != 1) {
            String message = "Invalid dedicated hot spare value <" + this.getDedicatedHotSpare() + ">";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("INVALID_PROFILE_DEDICATED_HOT_SPARE", message);
        }
        if (this.getArrayType() < 0 || this.getArrayType() > 5) {
            String message = "Invalid array type value <" + this.getArrayType() + ">";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("INVALID_PROFILE_ARRAY_TYPE", message);
        }
        Trace.verbose((Object)this, methodName, "Profile <" + this.getName() + "> passes all validity checks.");
    }

    private void validateString(String stringForValidation, boolean allowNull, String pattern, int maxLenght, String exceptionKey) throws ConfigMgmtException {
        String methodName = "validateString";
        Trace.methodBegin(this, methodName);
        if (stringForValidation == null) {
            if (allowNull) {
                return;
            }
            String message = "Null string passed.";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException(exceptionKey, message);
        }
        if (Pattern.matches(pattern, stringForValidation)) {
            if (stringForValidation.length() > maxLenght) {
                String message = "Invalid string passed <" + stringForValidation + ">";
                Trace.verbose((Object)this, methodName, message);
                throw new ConfigMgmtException(exceptionKey, message);
            }
        } else {
            String message = "Invalid string passed <" + stringForValidation + ">";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException(exceptionKey, message);
        }
    }

    private void validateValueAgainstArray(int value, int[] array, String exceptionKey) throws ConfigMgmtException {
        String methodName = "validateValueAgainstArray";
        Trace.methodBegin(this, methodName);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return;
        }
        String message = "Invalid value passed <" + value + ">";
        Trace.verbose((Object)this, methodName, message);
        throw new ConfigMgmtException(exceptionKey, message);
    }

    public synchronized void delete(ConfigContext context) throws ConfigMgmtException {
        String methodName = "delete";
        Trace.methodBegin(this, methodName);
        ManageT4sInterface mt4s = ManageT4sFactory.getManager();
        mt4s.init(context, null);
        if (!mt4s.areAllArraysHealthy()) {
            String message = "Unable to delete profile - at least one array not healthy.";
            Trace.verbose((Object)this, methodName, message);
            ConfigMgmtException cme = new ConfigMgmtException("NOT_ALL_ARRAYS_HEALTHY", message);
            throw cme;
        }
        if (this.inUse(context)) {
            ConfigMgmtException cme = new ConfigMgmtException("PROFILE_IN_USE_ERROR", "Trying to delete a profile that is in use.");
            Trace.error((Object)this, cme);
            throw cme;
        }
        StorageProfile profile = null;
        ManageStorageProfiles profileManager = ManageStorageProfiles.getInstance();
        try {
            profile = profileManager.getProfile(this.name);
        }
        catch (ItemNotFoundException infe) {
            ConfigMgmtException cme = new ConfigMgmtException("error.objectNotFound", "Trying to delete a profile that's not on the list");
            Trace.error((Object)this, cme);
            throw cme;
        }
        profileManager.deleteProfileFromList(profile);
    }

    public boolean inUse(ConfigContext context) throws ConfigMgmtException {
        String methodName = "inUse";
        Trace.methodBegin(this, methodName);
        boolean inUse = false;
        Enumeration poolCapabilities = CIMObjectWrapper.execQuery(context.getClient(), "Select * from SunStorEdge_6120PoolStorageCapabilities where Description = '" + (this.nameChanged ? this.originalName : this.name) + "'");
        inUse = poolCapabilities != null && poolCapabilities.hasMoreElements() ? true : this.inUsePending(context);
        if (Trace.isTraceEnabled(this)) {
            if (inUse) {
                Trace.verbose((Object)this, methodName, "Profile " + (this.nameChanged ? this.originalName : this.name) + " is in use.");
            } else {
                Trace.verbose((Object)this, methodName, "Profile " + (this.nameChanged ? this.originalName : this.name) + " is not in use.");
            }
        }
        return inUse;
    }

    private boolean inUsePending(ConfigContext context) throws ConfigMgmtException {
        String methodName = "isUsePending";
        Trace.methodBegin(this, methodName);
        boolean inUsePending = false;
        Enumeration jobs = CIMObjectWrapper.execQuery(context.getClient(), "Select * from SunStorEdge_6120CreateStoragePoolJob where Profile = '" + (this.nameChanged ? this.originalName : this.name) + "'");
        if (jobs != null) {
            while (jobs.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)jobs.nextElement();
                String ipAddr = null;
                try {
                    ipAddr = (String)ci.getProperty("SystemName").getValue().getValue();
                }
                catch (NullPointerException npe) {
                    ConfigMgmtException cme = new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems extracting SystemName ConcreteJob property.");
                    Trace.error((Object)this, cme);
                    throw cme;
                }
                Job j = new Job(ci, context, ipAddr);
                if (!j.isActive()) continue;
                inUsePending = true;
                Trace.verbose((Object)this, methodName, "Profile will be in use.");
                break;
            }
        }
        return inUsePending;
    }

    public List getProfilesWithDuplicateSettings(ConfigContext context) throws ConfigMgmtException {
        String methodName = "getProfilesWithDuplicateSettings";
        Trace.methodBegin(this, methodName);
        ArrayList<StorageProfile> profilesWithDuplicateSettings = new ArrayList<StorageProfile>();
        List allProfiles = ManageStorageProfiles.getInstance().getItemList(context, 0);
        Iterator iter = allProfiles.iterator();
        while (iter.hasNext()) {
            StorageProfile element = (StorageProfile)iter.next();
            if (!this.equalSettings(element)) continue;
            profilesWithDuplicateSettings.add(element);
            if (!Trace.isTraceEnabled(this)) continue;
            Trace.verbose((Object)this, methodName, "Profile <" + element.getName() + "> has the same settings as <" + this.getName() + "> profile.");
        }
        return profilesWithDuplicateSettings;
    }

    public int getMinNeededDataDrives() throws ConfigMgmtException {
        String methodName = "getMinNeededDataDrives";
        Trace.methodBegin(this, methodName);
        if ("variable".equals(this.getNumberOfDrives())) {
            if (5 == this.getRaidLevel()) {
                return 3;
            }
            return 2;
        }
        try {
            return Integer.parseInt(this.getNumberOfDrives());
        }
        catch (NumberFormatException nfe) {
            ConfigMgmtException cme = new ConfigMgmtException("error.applicationError", "Number of drives not valid integer.", nfe);
            Trace.error((Object)this, cme);
            throw cme;
        }
    }

    public boolean canBeAppliedToTray(TrayInterface tray) throws ConfigMgmtException {
        boolean usesDedicatedHotSpare;
        String methodName = "canBeAppliedToTray";
        Trace.methodBegin(this, methodName);
        boolean bl = usesDedicatedHotSpare = this.dedicatedHotSpare != 0;
        return tray.getRaidGroups().size() < 2 && tray.getDisksAvailableForPool(usesDedicatedHotSpare).size() >= this.getMinNeededDataDrives();
    }

    public boolean meetTheSettings(StorageProfile otherProfile) {
        Trace.methodBegin(this, "meetTheSettings");
        boolean result = false;
        if (otherProfile != null && this.getRaidLevel() == otherProfile.getRaidLevel() && this.getSegmentSize() == otherProfile.getSegmentSize() && this.getReadaheadMode() == otherProfile.getReadaheadMode() && this.getDedicatedHotSpare() == otherProfile.getDedicatedHotSpare() && ("variable".equals(this.getNumberOfDrives()) || this.getNumberOfDrives() != null && this.getNumberOfDrives().equals(otherProfile.getNumberOfDrives())) && this.meetTheArrayType(otherProfile.getArrayType())) {
            result = true;
        }
        return result;
    }

    public boolean meetTheArrayType(int arrayType) {
        Trace.methodBegin(this, "meetTheArrayType");
        boolean result = true;
        switch (arrayType) {
            case 0: 
            case 3: {
                if (this.getArrayType() != 1 && this.getArrayType() != 2) break;
                result = false;
                break;
            }
            case 1: 
            case 4: {
                if (this.getArrayType() != 0 && this.getArrayType() != 2) break;
                result = false;
                break;
            }
            case 2: 
            case 5: {
                if (this.getArrayType() != 1 && this.getArrayType() != 0) break;
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean equalSettings(Object obj) {
        String methodName = "equalSettings";
        Trace.methodBegin(this, methodName);
        boolean result = false;
        if (obj != null && obj instanceof StorageProfile) {
            StorageProfile otherProfile = (StorageProfile)obj;
            if (this.getRaidLevel() == otherProfile.getRaidLevel() && this.getSegmentSize() == otherProfile.getSegmentSize() && this.getReadaheadMode() == otherProfile.getReadaheadMode() && this.getNumberOfDrives() != null && this.getNumberOfDrives().equals(otherProfile.getNumberOfDrives()) && this.getDedicatedHotSpare() == otherProfile.getDedicatedHotSpare() && this.getArrayType() == otherProfile.getArrayType()) {
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, methodName, "Profile <" + this.getName() + "> has equal settings as the profile <" + otherProfile.getName());
                }
                result = true;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof StorageProfile) {
            String tmpName;
            StorageProfile otherProfile = (StorageProfile)obj;
            String string = tmpName = this.nameChanged ? this.originalName : this.name;
            if (tmpName != null && tmpName.equals(otherProfile.getName())) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        String methodName = "toString";
        Trace.methodBegin(this, methodName);
        return "StorageProfile instance with: \n name: " + this.name + "\n description: " + this.description + "\n productVersion: " + this.productVersion + "\n raidLevel: " + this.raidLevel + "\n segmentSize: " + this.segmentSize + "\n readaheadMode: " + this.readaheadMode + "\n numberOfDrives: " + this.numberOfDrives + "\n dedicatedHotSpare: " + this.dedicatedHotSpare + "\n arrayType: " + this.arrayType;
    }

    public String toXml() {
        String methodName = "toXml";
        StringBuffer theXml = new StringBuffer();
        theXml.append("<sscs_storage_profile>\n  ");
        theXml.append(XML_NAME_B + this.name + XML_NAME_E + "\n  ");
        theXml.append(XML_VERSION_B + this.productVersion + XML_VERSION_E + "\n  ");
        theXml.append(XML_DESCRIPTION_B + (this.description == null ? "" : this.description) + XML_DESCRIPTION_E + "\n  ");
        theXml.append(XML_RAID_LEVEL_B + this.raidLevel + XML_RAID_LEVEL_E + "\n  ");
        theXml.append(XML_SEGMENT_SIZE_B + StorageProfile.getSegmentSizeString(this.segmentSize) + XML_SEGMENT_SIZE_E + "\n  ");
        theXml.append(XML_READ_AHEAD_MODE_B + StorageProfile.getReadaheadModeString(this.readaheadMode) + XML_READ_AHEAD_MODE_E + "\n  ");
        theXml.append(XML_ARRAY_TYPE_B + StorageProfile.getArrayTypeString(this.arrayType) + XML_ARRAY_TYPE_E + "\n  ");
        theXml.append(XML_NUMBER_OF_DISKS_B + this.numberOfDrives + XML_NUMBER_OF_DISKS_E + "\n  ");
        theXml.append(XML_DEDICATED_HOT_SPARE_B + StorageProfile.getDedicatedHotSpareString(this.dedicatedHotSpare) + XML_DEDICATED_HOT_SPARE_E + "\n");
        theXml.append("</sscs_storage_profile>\n");
        return theXml.toString();
    }

    public static int getSegmentSizeInt(String segmentSize) {
        if (segmentSize.equalsIgnoreCase("4K")) {
            return 4096;
        }
        if (segmentSize.equalsIgnoreCase("8K")) {
            return 8192;
        }
        if (segmentSize.equalsIgnoreCase("16K")) {
            return 16384;
        }
        if (segmentSize.equalsIgnoreCase("32K")) {
            return 32768;
        }
        if (segmentSize.equalsIgnoreCase("64K")) {
            return 65536;
        }
        return -1;
    }

    public static String getSegmentSizeString(int segmentSize) {
        if (segmentSize == 4096) {
            return "4K";
        }
        if (segmentSize == 8192) {
            return "8K";
        }
        if (segmentSize == 16384) {
            return "16K";
        }
        if (segmentSize == 32768) {
            return "32K";
        }
        if (segmentSize == 65536) {
            return "64K";
        }
        return null;
    }

    public static int getArrayTypeInt(String arrayType) {
        if (arrayType.equalsIgnoreCase("Exact Match IOPS")) {
            return 0;
        }
        if (arrayType.equalsIgnoreCase("Exact Match Bandwidth")) {
            return 1;
        }
        if (arrayType.equalsIgnoreCase("Exact Match Capacity")) {
            return 2;
        }
        if (arrayType.equalsIgnoreCase("Best Available Match IOPS")) {
            return 3;
        }
        if (arrayType.equalsIgnoreCase("Best Available Match Bandwidth")) {
            return 4;
        }
        if (arrayType.equalsIgnoreCase("Best Available Match Capacity")) {
            return 5;
        }
        return -1;
    }

    public static String getArrayTypeString(int arrayType) {
        if (arrayType == 0) {
            return "Exact Match IOPS";
        }
        if (arrayType == 1) {
            return "Exact Match Bandwidth";
        }
        if (arrayType == 2) {
            return "Exact Match Capacity";
        }
        if (arrayType == 3) {
            return "Best Available Match IOPS";
        }
        if (arrayType == 4) {
            return "Best Available Match Bandwidth";
        }
        if (arrayType == 5) {
            return "Best Available Match Capacity";
        }
        return null;
    }

    public static String getDedicatedHotSpareString(int dedicatedHotSpare) {
        if (dedicatedHotSpare > 0) {
            return DEDICATED_HOT_SPARE_YES_S;
        }
        if (dedicatedHotSpare == 0) {
            return DEDICATED_HOT_SPARE_NO_S;
        }
        return null;
    }

    public static int getDedicatedHotSpareInt(String dedicatedHotSpare) {
        if (dedicatedHotSpare.equalsIgnoreCase(DEDICATED_HOT_SPARE_YES_S)) {
            return 1;
        }
        if (dedicatedHotSpare.equalsIgnoreCase(DEDICATED_HOT_SPARE_NO_S)) {
            return 0;
        }
        return -1;
    }

    public static String getReadaheadModeString(int readaheadMode) {
        if (readaheadMode > 0) {
            return READ_AHEAD_MODE_OFF_S;
        }
        if (readaheadMode == 0) {
            return READ_AHEAD_MODE_ON_S;
        }
        return null;
    }

    public static int getReadaheadModeInt(String readAhead) {
        if (readAhead.equalsIgnoreCase(READ_AHEAD_MODE_OFF_S)) {
            return 1;
        }
        if (readAhead.equalsIgnoreCase(READ_AHEAD_MODE_ON_S)) {
            return 0;
        }
        return -1;
    }
}

