/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.Job;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;

public class JobManager
implements JobManagerInterface {
    private ConfigContext context;
    private List itemList;
    private List pendingList;
    private boolean showAllJobs;
    private SearchFilter searchFilter;
    private String jobClassName = "SunStorEdge_6120ConcreteJob";

    public boolean getShowAllJobs() {
        return this.showAllJobs;
    }

    public void setShowAllJobs(boolean showAll) {
        this.showAllJobs = showAll;
    }

    public void setJobTypeName(String name) {
        this.jobClassName = name;
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        if (null == this.itemList) {
            Trace.verbose((Object)this, "getItemList", "itemList is null, reinitializing");
            this.createItemList();
            this.populatePendingList();
        }
        if (this.showAllJobs) {
            return this.itemList;
        }
        return this.pendingList;
    }

    public List getCompletedList() throws ConfigMgmtException {
        this.createItemList();
        ArrayList<Job> completedList = new ArrayList<Job>();
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            Job job = (Job)iterator.next();
            if (job.isActive()) continue;
            completedList.add(job);
        }
        return completedList;
    }

    private void createItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "createItemList");
        HashMap<String, String> hm = new HashMap<String, String>();
        this.itemList = new ArrayList();
        try {
            ManageT4sInterface t4Man = ManageT4sFactory.getManager();
            t4Man.init(this.context, null);
            List t4List = t4Man.getItemList();
            Iterator clusterIterator = t4List.iterator();
            while (clusterIterator.hasNext()) {
                T4Interface t4Instance = (T4Interface)clusterIterator.next();
                Trace.verbose((Object)this, "createItemList", "got t4 instance");
                if (t4Instance.getHealthStatus() != 2) {
                    Trace.verbose((Object)this, "createItemList", "skipping unhealthy array: " + t4Instance.getName());
                    continue;
                }
                CIMInstance clusterInstance = t4Instance.getInstance();
                String arrayName = t4Instance.getName();
                String ipAddr = t4Instance.getClusterName();
                hm.put(ipAddr, arrayName);
                Trace.verbose((Object)this, "createItemList", "have healthy array = " + arrayName + " with ipaddr: " + ipAddr);
            }
            CIMObjectPath jobOP = new CIMObjectPath(this.jobClassName);
            Enumeration jobEnum = this.context.getClient().enumerateInstances(jobOP, false, false, true, false, null);
            while (jobEnum.hasMoreElements()) {
                CIMInstance jobInstance = (CIMInstance)jobEnum.nextElement();
                CIMProperty instId = jobInstance.getProperty("InstanceID");
                if (this.searchFilter != null && !this.searchFilter.passesFilter(jobInstance) || null == instId || null == instId.getValue()) continue;
                String val = (String)instId.getValue().getValue();
                String[] chunks = val.split(":");
                if (chunks.length == 4) {
                    String jobIp = chunks[0];
                    if (!hm.containsKey(jobIp)) continue;
                    Trace.verbose((Object)this, "createItemList", "adding Job");
                    this.itemList.add(new Job(jobInstance, this.context, (String)hm.get(jobIp)));
                    continue;
                }
                Trace.verbose((Object)this, "createItemList", "skipping job we shouldnt see.");
            }
            Trace.verbose((Object)this, "createItemList", "Sort the job list");
            Collections.sort(this.itemList, new JobComparator(this.context.getLocale()));
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createItemList", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void populatePendingList() {
        Trace.methodBegin(this, "populatePendingList");
        this.pendingList = new ArrayList();
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            Job job = (Job)iterator.next();
            if (!job.isActive()) continue;
            this.pendingList.add(job);
        }
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        this.context = context;
        this.searchFilter = filter;
        this.itemList = null;
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reset");
        this.init(this.context, null);
    }

    public JobInterface get(CIMInstance instance, String arrayName) throws ConfigMgmtException {
        return new Job(instance, this.context, arrayName);
    }

    public JobInterface get(CIMObjectPath path, String arrayName) throws ConfigMgmtException {
        return new Job(path, this.context, arrayName);
    }

    public JobInterface getItemByUniqueID(String uniqueID) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus createUIJob(String name, String uniqueID, String step, Vector tasks) throws ConfigMgmtException {
        return null;
    }

    private class JobComparator
    implements Comparator {
        Collator collator = null;

        JobComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof Job && element2 instanceof Job) {
                key1 = this.collator.getCollationKey(((Job)element1).getSortKey());
                key2 = this.collator.getCollationKey(((Job)element2).getSortKey());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

