/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.ent1.Job;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class JobManager
implements JobManagerInterface {
    private ConfigContext context;
    private List itemList;
    private List pendingList;
    private List completedList;
    private boolean showAllJobs;
    private SearchFilter searchFilter;
    private String jobClassName = "SunStorEdge_DSPConcreteJob";

    public boolean getShowAllJobs() {
        return this.showAllJobs;
    }

    public void setShowAllJobs(boolean showAll) {
        this.showAllJobs = showAll;
    }

    public void setJobTypeName(String name) {
        this.jobClassName = name;
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        if (null == this.itemList) {
            Trace.verbose((Object)this, "getItemList", "itemList is null, reinitializing");
            this.createItemList();
            this.populateCompletedList();
            this.populatePendingList();
        }
        if (this.showAllJobs) {
            return this.itemList;
        }
        return this.pendingList;
    }

    private void createItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "createItemList");
        this.itemList = new ArrayList();
        try {
            Trace.verbose((Object)this, "createItemList", "Querying the CIM for ConcreteJob Instances");
            Enumeration enumeration = this.context.getClient().enumerateInstances(new CIMObjectPath("SunStorEdge_DSPConcreteJob"), false, false, true, false, null);
            Trace.verbose((Object)this, "createItemList", "Returned from querying the CIM for ConcreteJob Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "createItemList", "ConcreteJob Instances Found");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "createItemList", "Creating ConcreteJob Java Object");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    this.itemList.add(new Job(ci, this.context, null));
                }
            }
            Trace.verbose((Object)this, "createItemList", "Sort the job list");
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createItemList", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public List getCompletedList() throws ConfigMgmtException {
        try {
            if (null == this.itemList) {
                Trace.verbose((Object)this, "getCompletedList", "itemList is null, reinitializing");
                this.createItemList();
                this.populateCompletedList();
            }
            return this.completedList;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getCompletedList", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void populatePendingList() {
        Trace.methodBegin(this, "populatePendingList");
        this.pendingList = new ArrayList();
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            Job job = (Job)iterator.next();
            if (!job.isActive()) continue;
            this.pendingList.add(job);
        }
    }

    private void populateCompletedList() {
        Trace.methodBegin(this, "populateCompletedList");
        this.completedList = new ArrayList();
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            Job job = (Job)iterator.next();
            if (job.isActive()) continue;
            this.completedList.add(job);
        }
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        this.context = context;
        this.searchFilter = filter;
        this.itemList = null;
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reset");
        this.init(this.context, null);
    }

    public JobInterface get(CIMInstance instance, String arrayName) throws ConfigMgmtException {
        return new Job(instance, this.context, null);
    }

    public JobInterface get(CIMObjectPath path, String arrayName) throws ConfigMgmtException {
        return new Job(path, this.context, null);
    }

    public JobInterface getItemByUniqueID(String uniqueID) throws ConfigMgmtException {
        this.setShowAllJobs(true);
        this.itemList = null;
        List jobList = this.getItemList();
        for (int i = 0; i < jobList.size(); ++i) {
            Job job = (Job)jobList.get(i);
            if (!job.getUniqueID().equals(uniqueID)) continue;
            return job;
        }
        return null;
    }

    public MethodCallStatus createUIJob(String name, String uniqueID, String step, Vector tasks) throws ConfigMgmtException {
        Trace.methodBegin(this, "createUIJob");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Name", new CIMValue((Object)name)), new CIMArgument("ElementName", new CIMValue((Object)uniqueID)), new CIMArgument("Description", new CIMValue((Object)step)), new CIMArgument("Tasks", new CIMValue(tasks, new CIMDataType(22)))};
        CIMArgument[] outArgs = new CIMArgument[]{};
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.context.getClient(), "DEFAULT", 0);
        Trace.verbose((Object)this, "createUIJob", "Calling CreateUIJob");
        CIMValue returnCodeValue = this.context.getClient().invokeMethod(confServiceObjectPath, "CreateUIJob", inArgs, outArgs);
        int retVal = (Integer)returnCodeValue.getValue();
        Trace.verbose((Object)this, "createUIJob", "CreateUIJob return with code: " + retVal);
        methodCallStatus.setReturnCode(retVal);
        return methodCallStatus;
    }

    private class JobComparator
    implements Comparator {
        Collator collator = null;

        JobComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof Job && element2 instanceof Job) {
                key1 = this.collator.getCollationKey(((Job)element1).getSortKey());
                key2 = this.collator.getCollationKey(((Job)element2).getSortKey());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

