/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapArrayToSet;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class Job
implements JobInterface,
Constants.JobProperties,
Constants.OperationalStatusValues {
    private Set statusSet;
    private String id;
    private String name;
    private String uniqueID;
    private String sortKey;
    private String description;
    private Date startTime;
    private Date endTime;
    private int percentComplete;
    private String notifyEmail;
    private ConfigContext configContext;
    private CIMInstance instance;
    private CIMObjectPath path;
    private int errorCode;
    private String errorDescription;
    private String jobStatus;
    private Vector taskResults;
    private Vector tasks;
    private Vector taskResultTypes;
    private int taskFailureCount;
    static HashMap keys;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$jobs$business$impl$ent1$Job;

    public Job(CIMInstance instance, ConfigContext configContext, String array) throws ConfigMgmtException {
        Trace.constructor(this);
        this.init(configContext, instance);
    }

    public Job(CIMObjectPath path, ConfigContext configContext, String array) throws ConfigMgmtException {
        Trace.constructor(this);
        try {
            String methodName = "constructor";
            Trace.verbose((Object)this, methodName, "Have Context: " + (configContext != null));
            Trace.verbose((Object)this, methodName, "Have Path: " + (path != null));
            Trace.verbose((Object)this, methodName, "Have Client: " + (configContext.getClient() != null));
            CIMInstance instance = configContext.getClient().getInstance(path, false, true, false, this.getPropertyNames());
            this.init(configContext, instance);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "constructor", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public void init(ConfigContext configContext, CIMInstance instance) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.configContext = configContext;
        this.instance = instance;
        this.path = instance.getObjectPath();
        CIMObjectWrapper.populate(this, this.getFieldMap(), instance);
    }

    private Collection getFieldMap() {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$jobs$business$impl$ent1$Job == null ? (class$com$sun$netstorage$array$mgmt$cfg$jobs$business$impl$ent1$Job = Job.class$("com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.ent1.Job")) : class$com$sun$netstorage$array$mgmt$cfg$jobs$business$impl$ent1$Job, "getFieldMap");
        ArrayList<MapElement> fieldMap = new ArrayList<MapElement>();
        fieldMap.add(new MapElement("id", "InstanceID", true, false));
        fieldMap.add(new MapElement("startTime", "StartTime", true, true));
        fieldMap.add(new MapElement("endTime", "ElapsedTime", true, true));
        fieldMap.add(new MapElement("notifyEmail", "Notify", false, true));
        fieldMap.add(new MapElement("percentComplete", "PercentComplete", false, false));
        fieldMap.add(new MapElement("description", "Description", false, true));
        fieldMap.add(new MapElement("name", "Name", true, true));
        fieldMap.add(new MapElement("errorCode", "ErrorCode", true, false));
        fieldMap.add(new MapElement("errorDescription", "ErrorDescription", true, true));
        fieldMap.add(new MapArrayToSet("statusSet", "OperationalStatus", true, false));
        fieldMap.add(new MapElement("jobStatus", "JobStatus", false, true));
        fieldMap.add(new MapElement("uniqueID", "ElementName", true, true));
        fieldMap.add(new MapElement("taskFailureCount", "TaskFailureCount", true, false));
        return fieldMap;
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.configContext.getClient());
    }

    public void delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        try {
            this.configContext.getClient().deleteInstance(this.instance.getObjectPath());
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "delete", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUniqueID() {
        if (this.uniqueID == null) {
            return "";
        }
        return this.uniqueID;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getSortKey() {
        StringBuffer l_key = null;
        if (this.sortKey == null) {
            DecimalFormat nf = new DecimalFormat("00000");
            StringTokenizer st = new StringTokenizer(this.getId(), ":");
            l_key = new StringBuffer(st.nextToken());
            String tok = null;
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
            }
            l_key.append(nf.format(new Integer(tok)));
            Trace.verbose((Object)this, "getSortKey", "Sort key for job " + this.getId() + " is " + l_key);
        }
        if (l_key != null) {
            this.sortKey = l_key.toString();
        }
        return this.sortKey;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return new String("N/A");
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        if (this.endTime == null || this.isActive()) {
            return new Date();
        }
        long end = this.startTime.getTime() + this.endTime.getTime();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(end);
        return cal.getTime();
    }

    public String getNotifyEmail() {
        return this.notifyEmail;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setNotifyEmail(String notifyEmail) {
        this.notifyEmail = notifyEmail;
    }

    public void setPercentComplete(int percentComplete) {
        this.percentComplete = percentComplete;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void kill() throws ConfigMgmtException {
        Trace.methodBegin(this, "kill");
        CIMArgument[] cimInArguments = new CIMArgument[]{new CIMArgument("DeleteOnKill", CIMValue.FALSE)};
        CIMArgument[] cimOutArguments = new CIMArgument[]{};
        try {
            CIMValue returnCodeValue = this.configContext.getClient().invokeMethod(this.path, "KillJob", cimInArguments, cimOutArguments);
            Trace.verbose((Object)this, "kill", "Obtained return value: " + returnCodeValue);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "kill", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public String getArray() {
        return "";
    }

    protected final String[] getPropertyNames() {
        Trace.methodBegin(this, "getPropertyNames");
        String[] names = new String[this.getFieldMap().size()];
        int i = 0;
        Iterator iterator = this.getFieldMap().iterator();
        while (iterator.hasNext()) {
            MapElement element = (MapElement)iterator.next();
            names[i] = element.getCimProperty();
            ++i;
        }
        return names;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public boolean isActive() {
        return !(this.getStatusSet().contains(new Integer(17)) | this.getStatusSet().contains(new Integer(6)) | this.getStatusSet().contains(new Integer(14)));
    }

    public CIMObjectPath getObjectPath() {
        return this.instance.getObjectPath();
    }

    public CIMInstance getInstance() {
        return this.instance;
    }

    public Set getStatusSet() {
        return this.statusSet;
    }

    public void setStatusSet(Set statusSet) {
        this.statusSet = statusSet;
    }

    public Integer getStatus() {
        Integer status = null;
        if (this.getStatusSet().contains(new Integer(17))) {
            if (this.getStatusSet().contains(new Integer(2))) {
                status = Constants.JobProperties.JOB_STATUS_OK_DONE;
            } else if (this.getStatusSet().contains(new Integer(6))) {
                status = Constants.JobProperties.JOB_STATUS_ERROR_DONE;
            } else if (this.getStatusSet().contains(new Integer(14))) {
                status = Constants.JobProperties.JOB_STATUS_ABORTED_DONE;
            }
        } else if (this.getStatusSet().contains(new Integer(2))) {
            status = Constants.JobProperties.JOB_STATUS_RUNNING;
        } else if (this.getStatusSet().contains(new Integer(6))) {
            status = Constants.JobProperties.JOB_STATUS_ERROR_DONE;
        } else if (this.getStatusSet().contains(new Integer(15))) {
            status = Constants.JobProperties.JOB_STATUS_DORMANT;
        }
        return status;
    }

    static HashMap getKeys() {
        if (null == keys) {
            keys = new HashMap();
            keys.put(Constants.JobProperties.JOB_STATUS_ABORTED_DONE, "job.status.aborted.done");
            keys.put(Constants.JobProperties.JOB_STATUS_DORMANT, "job.status.dormant");
            keys.put(Constants.JobProperties.JOB_STATUS_ERROR_DONE, "job.status.error.done");
            keys.put(Constants.JobProperties.JOB_STATUS_OK_DONE, "job.status.ok.done");
            keys.put(Constants.JobProperties.JOB_STATUS_RUNNING, "job.status.running");
        }
        return keys;
    }

    public String getStatusKey() {
        return (String)Job.getKeys().get(this.getStatus());
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        try {
            this.instance = this.configContext.getClient().getInstance(this.path, false, true, false, this.getPropertyNames());
            this.init(this.configContext, this.instance);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "reload", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public void setConfigContext(ConfigContext argCC) {
        this.configContext = argCC;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("==========Job Details:\n");
        sb.append("\n\t");
        sb.append("\n\t");
        sb.append("Name:");
        sb.append(this.name);
        sb.append("\n\t");
        sb.append("Description:");
        sb.append(this.description);
        sb.append("\n\t");
        sb.append("End Time:");
        sb.append(this.endTime);
        sb.append("\n\t");
        sb.append("Error Code:");
        sb.append(this.errorCode);
        sb.append("\n\t");
        sb.append("Error Description:");
        sb.append(this.errorDescription);
        sb.append("\n\t");
        sb.append("ID:");
        sb.append(this.id);
        sb.append("\n\t");
        sb.append("Notify Email:");
        sb.append(this.notifyEmail);
        sb.append("\n\t");
        sb.append("Percent Complete:");
        sb.append(this.percentComplete);
        sb.append("\n\t");
        sb.append("Start Time:");
        sb.append(this.startTime);
        sb.append("\n\t");
        sb.append("Job Status:");
        sb.append(this.jobStatus);
        sb.append("\n\t");
        sb.append("Status Set:");
        sb.append(this.statusSet);
        sb.append("\n\t");
        sb.append("Unique ID:");
        sb.append(this.uniqueID);
        sb.append("\n\t");
        sb.append("Active?");
        sb.append(this.isActive());
        sb.append("\n========================\n");
        return sb.toString();
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public void setTaskResult(int taskIndex, String result, boolean success) {
        if (this.taskResults == null) {
            this.getAssociatedTaskInfo();
        }
        this.taskResults.set(taskIndex, result);
        this.taskResultTypes.set(taskIndex, new Boolean(success));
        if (!success) {
            ++this.taskFailureCount;
        }
        try {
            this.instance.updatePropertyValue(new CIMProperty("TaskResults", new CIMValue(this.taskResults, new CIMDataType(22))));
            this.instance.updatePropertyValue(new CIMProperty("TaskResultTypes", new CIMValue(this.taskResultTypes, new CIMDataType(23))));
            this.instance.updatePropertyValue(new CIMProperty("TaskFailureCount", new CIMValue((Object)new UnsignedInt16(this.taskFailureCount), new CIMDataType(2))));
            this.configContext.getClient().setInstance(this.instance.getObjectPath(), this.instance);
        }
        catch (Exception cme) {
            // empty catch block
        }
    }

    public String getTaskResult(int taskIndex) {
        Object[] results = this.taskResults.toArray();
        if (results != null) {
            return (String)results[taskIndex];
        }
        return "";
    }

    public void getAssociatedTaskInfo() {
        CIMValue cvResults = this.instance.getProperty("TaskResults").getValue();
        this.taskResults = cvResults != null ? (Vector)cvResults.getValue() : new Vector();
        CIMValue cvTasks = this.instance.getProperty("Tasks").getValue();
        this.tasks = cvTasks != null ? (Vector)cvTasks.getValue() : new Vector();
        CIMValue cvTypes = this.instance.getProperty("TaskResultTypes").getValue();
        this.taskResultTypes = cvTypes != null ? (Vector)cvTypes.getValue() : new Vector();
    }

    public int getTaskFailureCount() {
        return this.taskFailureCount;
    }

    public void setTaskFailureCount(int taskFailureCount) {
        this.taskFailureCount = taskFailureCount;
    }

    public Vector getTaskResults() {
        if (this.taskResults == null) {
            this.getAssociatedTaskInfo();
        }
        return this.taskResults;
    }

    public String getTask(int taskIndex) {
        if (this.tasks == null) {
            this.getAssociatedTaskInfo();
        }
        if (this.tasks.size() > 0) {
            return (String)this.tasks.get(taskIndex);
        }
        return "";
    }

    public Vector getTasks() {
        if (this.tasks == null) {
            this.getAssociatedTaskInfo();
        }
        return this.tasks;
    }

    public boolean isResultTypeSuccess(int taskIndex) {
        if (this.taskResultTypes == null) {
            this.getAssociatedTaskInfo();
        }
        if (this.taskResultTypes.size() > 0) {
            return (Boolean)this.taskResultTypes.get(taskIndex) == true;
        }
        return false;
    }

    public Vector getTaskResultTypes() {
        if (this.taskResultTypes == null) {
            this.getAssociatedTaskInfo();
        }
        return this.taskResultTypes;
    }

    public boolean isUIJob() {
        return this.instance.getClassName().equalsIgnoreCase("SunStorEdge_DSPUIJob");
    }

    public String getUIJobStatus(String successStr, String pendingStr, String sepStr, String delimitStr) {
        String status = new String();
        if (this.isUIJob()) {
            Vector tasks = this.getTasks();
            int nTasks = tasks.size();
            for (int i = 0; i < nTasks; ++i) {
                status = status.concat(this.getTask(i));
                status = status.concat(sepStr);
                String result = this.getTaskResult(i);
                boolean success = this.isResultTypeSuccess(i);
                status = success ? status.concat(successStr) : (result.length() > 0 ? status.concat(result) : status.concat(pendingStr));
                if (i >= nTasks - 1) continue;
                status = status.concat(delimitStr);
            }
        }
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

