/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageVolumeCopyInterface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.VolumeCopyMO;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageArraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageArraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.HLVolumeBundle;
import devmgr.versioned.symbol.LegacyVolRef;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PremiumFeature;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.SnapshotVolume;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeActionProgress;
import devmgr.versioned.symbol.VolumeCopy;
import devmgr.versioned.symbol.VolumeCopyCandidate;
import devmgr.versioned.symbol.VolumeCopyCandidateList;
import devmgr.versioned.symbol.VolumeCopyCreationDescriptor;
import devmgr.versioned.symbol.VolumeCopyParamsUpdateDescriptor;
import devmgr.versioned.symbol.VolumeCopyPriority;
import devmgr.versioned.symbol.VolumeCopyRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class ManageVolumeCopy
implements ManageVolumeCopyInterface {
    public static final String VOLUME_COPY_ID_PREFIX = "VC:";
    ConfigContext cfgctx;
    Scope scope;
    SearchFilter filter;
    private static final String sccs_id = "@(#)ManageVolumeCopy.java 1.34    05/07/12 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy;

    public void init(ConfigContext context, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = context;
        this.scope = s;
        this.filter = f;
    }

    public List getVolumeCopyReferencesList() throws ConfigMgmtException {
        List list = null;
        return list;
    }

    private boolean isVolumeCopyLicensed(StorageArray sa, int capNum) {
        PremiumFeature[] pfa = sa.getPremiumFeatures();
        if (pfa != null) {
            for (int i = 0; i < pfa.length; ++i) {
                int myCapNum = pfa[i].getCapability().getValue();
                if (capNum != myCapNum) continue;
                return pfa[i].getIsEnabled();
            }
        }
        return false;
    }

    public void start(Object key, Properties props) throws ConfigMgmtException {
        String cpyWwn;
        String METHOD_NAME = "start";
        Trace.methodBegin(this, "start");
        Object symClient = null;
        ObjectBundleManager manager = null;
        String myWwn = null;
        StorageArray sa = null;
        Object srcAbsRef = null;
        Object targAbsRef = null;
        Object vcDesc = null;
        boolean priority = false;
        boolean idleProt = false;
        Map myKeys = null;
        if (key instanceof Map) {
            myKeys = (Map)key;
        } else if (key instanceof String) {
            myKeys = Convert.keyAsStringToMap((String)key);
        }
        if (myKeys == null) {
            Trace.error((Object)this, "start", "missing key obj");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "missing key obj");
        }
        myWwn = (String)myKeys.get("array");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "start", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        if ((cpyWwn = (String)myKeys.get("copyWwn")) == null) {
            Trace.error((Object)this, "start", "missing copy wwn");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing COPY_WWN property");
        }
        String cpyRef = (String)myKeys.get("copyRef");
        if (cpyRef == null) {
            Trace.error((Object)this, "start", "missing copy ref");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing COPY_REF property");
        }
        try {
            manager = ObjectBundleManager.getInstance();
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            sa = bundle.getSa();
            if (!this.isVolumeCopyLicensed(sa, 14)) {
                Trace.error((Object)this, "start", "license disabled");
                throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
            }
            VolumeCopyRef vcr = new VolumeCopyRef();
            vcr.setRefToken(Convert.stringToBytes(cpyRef));
            String[] vols = this.getVolNames(bundle, cpyRef);
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            command.execute(121, (XDRType)vcr, (XDRType)rc, true);
            Trace.verbose((Object)this, "start", "Return code:" + rc.getValue());
            if (rc.getValue() != 1) {
                LogAPI.staticLog((String)"VOLUMECOPY_START_ERROR ", (String[])new String[]{vols[0], vols[1], ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "start error");
            }
            try {
                LogAPI.staticLog((String)"VOLUMECOPY_START", (String[])new String[]{vols[0], vols[1], ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "start", "RPC error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "start", "IO error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
    }

    public void stop(Object key, Properties props) throws ConfigMgmtException {
        String cpyWwn;
        String METHOD_NAME = "stop";
        Trace.methodBegin(this, "stop");
        Object symClient = null;
        ObjectBundleManager manager = null;
        String myWwn = null;
        StorageArray sa = null;
        Object srcAbsRef = null;
        Object targAbsRef = null;
        Object vcDesc = null;
        boolean priority = false;
        boolean idleProt = false;
        Map myKeys = null;
        if (key instanceof Map) {
            myKeys = (Map)key;
        } else if (key instanceof String) {
            myKeys = Convert.keyAsStringToMap((String)key);
        }
        if (myKeys == null) {
            Trace.error((Object)this, "stop", "missing key obj");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "missing key obj");
        }
        myWwn = (String)myKeys.get("array");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "stop", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        if ((cpyWwn = (String)myKeys.get("copyWwn")) == null) {
            Trace.error((Object)this, "stop", "missing copy wwn");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing COPY_WWN property");
        }
        String cpyRef = (String)myKeys.get("copyRef");
        if (cpyRef == null) {
            Trace.error((Object)this, "stop", "missing copy ref");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing COPY_REF property");
        }
        try {
            manager = ObjectBundleManager.getInstance();
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            sa = bundle.getSa();
            if (!this.isVolumeCopyLicensed(sa, 14)) {
                Trace.error((Object)this, "stop", "license disabled");
                throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
            }
            VolumeCopyRef vcr = new VolumeCopyRef();
            vcr.setRefToken(Convert.stringToBytes(cpyRef));
            String[] vols = this.getVolNames(bundle, cpyRef);
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            command.execute(122, (XDRType)vcr, (XDRType)rc, true);
            Trace.verbose((Object)this, "stop", "Return code:" + rc.getValue());
            if (rc.getValue() != 1) {
                LogAPI.staticLog((String)"VOLUMECOPY_STOP_ERROR", (String[])new String[]{vols[0], vols[1], ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "stop error");
            }
            try {
                LogAPI.staticLog((String)"VOLUMECOPY_STOP", (String[])new String[]{vols[0], vols[1], ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "stop", "RPC error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "stop", "IO error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String cpyWwn;
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        Object symClient = null;
        ObjectBundleManager manager = null;
        String myWwn = null;
        Object srcAbsRef = null;
        Object targAbsRef = null;
        Object vcDesc = null;
        int priority = 0;
        boolean idleProt = false;
        StorageArray sa = null;
        Map myKeys = null;
        if (key instanceof Map) {
            myKeys = (Map)key;
        } else if (key instanceof String) {
            myKeys = Convert.keyAsStringToMap((String)key);
        }
        if (myKeys == null) {
            Trace.error((Object)this, "modify", "missing key obj");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "missing key obj");
        }
        myWwn = (String)myKeys.get("array");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "modify", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        if ((cpyWwn = (String)myKeys.get("copyWwn")) == null) {
            Trace.error((Object)this, "modify", "missing copy wwn");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing COPY_WWN property");
        }
        String cpyRef = (String)myKeys.get("copyRef");
        if (cpyRef == null) {
            Trace.error((Object)this, "modify", "missing copy reference");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing COPY_REF property");
        }
        String priorityString = props.getProperty("priority");
        if (priorityString == null) {
            Trace.error((Object)this, "modify", "missing priority");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing PRIORITY property");
        }
        priority = Integer.parseInt(priorityString);
        String writeProtString = props.getProperty("protect");
        if (writeProtString == null) {
            Trace.error((Object)this, "modify", "missing protect priority");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing IDEL_PROTECT property");
        }
        if ("enable".equals(writeProtString) || Boolean.TRUE.toString().equals(writeProtString)) {
            idleProt = true;
        }
        try {
            manager = ObjectBundleManager.getInstance();
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            sa = bundle.getSa();
            if (!this.isVolumeCopyLicensed(sa, 14)) {
                Trace.error((Object)this, "modify", "license disabled");
                throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
            }
            VolumeCopyParamsUpdateDescriptor vcUpdate = new VolumeCopyParamsUpdateDescriptor();
            VolumeCopyPriority vcp = new VolumeCopyPriority();
            vcp.setValue(priority);
            vcUpdate.setCopyPriority(vcp);
            vcUpdate.setIdleTargetWriteProt(idleProt);
            VolumeCopyRef vcr = new VolumeCopyRef();
            vcr.setRefToken(Convert.stringToBytes(cpyRef));
            vcUpdate.setVolCopyRef(vcr);
            String[] vols = this.getVolNames(bundle, cpyRef);
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            command.execute(120, (XDRType)vcUpdate, (XDRType)rc, true);
            Trace.verbose((Object)this, "modify", "Return code:" + rc.getValue());
            if (rc.getValue() != 1) {
                LogAPI.staticLog((String)"VOLUMECOPY_MODIFY_ERROR", (String[])new String[]{vols[0], vols[1], ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
            }
            try {
                LogAPI.staticLog((String)"VOLUMECOPY_MODIFY", (String[])new String[]{vols[0], vols[1], ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "modify", "RPC error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "modify", "IO error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
    }

    public List getVolumeCopyTargetList(Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "getVolumeCopyTargetList";
        Trace.methodBegin(this, "getVolumeCopyTargetList");
        ObjectBundleManager manager = null;
        List vctList = new ArrayList();
        VolumeCopyCandidateList targetList = null;
        VolumeCopyCandidate[] targCandidates = null;
        VolumeCopyCandidateList srcList = null;
        Object loopVolWwn = null;
        Object srcCadAbsRef = null;
        String volWwn = null;
        String srcKeyAsStrg = props.getProperty("sourceKeyAsString");
        if (srcKeyAsStrg != null) {
            Map keyMap = Convert.keyAsStringToMap(srcKeyAsStrg);
            volWwn = (String)keyMap.get("volumeWwn");
        } else {
            volWwn = props.getProperty("sourceWwn");
        }
        if (volWwn == null) {
            Trace.error((Object)this, "getVolumeCopyTargetList", "missing volume wwn");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing SOURCE_WWN property");
        }
        if (this.scope == null) {
            Trace.error((Object)this, "getVolumeCopyTargetList", "missing scope");
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing scope");
        }
        String arrayWwn = Convert.scopeToArrayKey(this.scope);
        if (arrayWwn == null) {
            Trace.error((Object)this, "getVolumeCopyTargetList", "missing wwn");
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing array wwn");
        }
        manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = manager.getObjectBundle(arrayWwn);
        StorageArray sa = bundle.getSa();
        if (!this.isVolumeCopyLicensed(sa, 14)) {
            Trace.error((Object)this, "getVolumeCopyTargetList", "license disabled");
            throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
        }
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            srcList = new VolumeCopyCandidateList();
            command.execute(124, null, (XDRType)srcList, false);
            if (srcList == null) {
                Trace.verbose((Object)this, "getVolumeCopyTargetList", "source candidates null");
                return vctList;
            }
            String volRef = this.getVolumeReference(bundle, volWwn);
            if (volRef == null) {
                Trace.error((Object)this, "getVolumeCopyTargetList", "source volume reference null");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "source volume reference null");
            }
            AbstractVolRef avr = this.getAbsRefFromCandidateList(srcList, volRef);
            if (avr == null) {
                Trace.error((Object)this, "getVolumeCopyTargetList", "source not a copy candidate");
                throw new ConfigMgmtException("source.volume.not.copy.candidate", "Source volume not a copy candidate.");
            }
            targetList = new VolumeCopyCandidateList();
            command.execute(123, (XDRType)avr, (XDRType)targetList, false);
            if (targetList == null) {
                Trace.verbose((Object)this, "getVolumeCopyTargetList", "targets null");
                return vctList;
            }
            targCandidates = targetList.getVolumeCopyCandidate();
            if (targCandidates == null || targCandidates.length == 0) {
                Trace.verbose((Object)this, "getVolumeCopyTargetList", "target candidates null");
                return vctList;
            }
            Map volumeMap = this.populateVolumeRefVolumeMap(bundle.getVolume());
            StringBuffer patternString = new StringBuffer();
            for (int i = 0; i < targCandidates.length; ++i) {
                AbstractVolRef volTargRef = targCandidates[i].getVolumeRef();
                String targCadRef = Convert.bytesToString(volTargRef.getRefToken());
                Volume ozVol = (Volume)volumeMap.get(targCadRef);
                if (ozVol == null) continue;
                patternString.append(Convert.bytesToString(ozVol.getWorldWideName()));
                if (i >= targCandidates.length - 1) continue;
                patternString.append("|");
            }
            Pattern pattern = Pattern.compile(patternString.toString());
            SearchFilter volumeFilter = new SearchFilter("wwn", pattern);
            ManageVolumes volumeManager = new ManageVolumes();
            volumeManager.init(this.cfgctx, this.scope, volumeFilter);
            vctList = volumeManager.getItemList();
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "getVolumeCopyTargetList", "RPC error");
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "getVolumeCopyTargetList", "IO error");
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        return vctList;
    }

    public List getSourceVolume(String volRef) throws ConfigMgmtException {
        List list = null;
        return list;
    }

    public List getTargetVolume(String volRef) throws ConfigMgmtException {
        List list = null;
        return list;
    }

    public void create(Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "create";
        Trace.methodBegin(this, "create");
        SYMbolAPIClientV1 symClient = null;
        ObjectBundleManager manager = null;
        VolumeCopyCandidateList targetList = null;
        VolumeCopyCandidateList srcList = null;
        String myWwn = null;
        StorageArray sa = null;
        AbstractVolRef srcAbsRef = null;
        LegacyVolRef targAbsRef = null;
        VolumeCopyCreationDescriptor vcDesc = null;
        String ctrlRefStrg = null;
        String startCopy = null;
        ReturnCodeWithRef rcWref = null;
        String vol0 = null;
        String vol1 = null;
        int priority = 0;
        boolean idleProt = false;
        myWwn = props.getProperty("array");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "create", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_WWN_REQUIRED.getKey(), "missing wwn");
            }
        }
        String[] controllers = ObjectBundleManager.getInstance().getControlerReferences(myWwn);
        ctrlRefStrg = props.getProperty("controller");
        if (ctrlRefStrg == null) {
            ctrlRefStrg = controllers[0];
        }
        String srcWwn = null;
        String srcKeyAsStrg = props.getProperty("sourceKeyAsString");
        if (srcKeyAsStrg != null) {
            Map keyMap = Convert.keyAsStringToMap(srcKeyAsStrg);
            srcWwn = (String)keyMap.get("volumeWwn");
        } else {
            srcWwn = props.getProperty("sourceVolRef");
        }
        if (srcWwn == null) {
            Trace.error((Object)this, "create", "missing source key");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "source property missing");
        }
        String targWwn = null;
        String targKeyAsStrg = props.getProperty("targetKeyAsString");
        if (targKeyAsStrg != null) {
            Map keyMap = Convert.keyAsStringToMap(srcKeyAsStrg);
            targWwn = (String)keyMap.get("volumeWwn");
        } else {
            targWwn = props.getProperty("targetVolRef");
        }
        if (targWwn == null) {
            Trace.error((Object)this, "create", "missing target key");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "target property missing");
        }
        String priorityString = props.getProperty("priority");
        if (priorityString == null) {
            Trace.error((Object)this, "create", "missing priority key");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "priority property missing");
        }
        priority = Integer.parseInt(priorityString);
        String writeProtString = props.getProperty("protect");
        if (writeProtString == null) {
            Trace.error((Object)this, "create", "missing protect key");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "protect property missing.");
        }
        if (writeProtString.equals("enable")) {
            idleProt = true;
        }
        startCopy = props.getProperty("start");
        try {
            manager = ObjectBundleManager.getInstance();
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            sa = bundle.getSa();
            if (!this.isVolumeCopyLicensed(sa, 14)) {
                Trace.error((Object)this, "start", "license disabled");
                throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
            }
            symClient = manager.getAuthorizedClientForController(myWwn, ctrlRefStrg);
            srcList = symClient.getVolumeCopySourceCandidates();
            if (srcList == null) {
                Trace.error((Object)this, "create", "source list null");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "source list null");
            }
            String srcVolRef = this.getVolumeReference(bundle, srcWwn);
            vol0 = this.getVolName(bundle, srcVolRef);
            if (srcVolRef == null) {
                Trace.error((Object)this, "create", "source volume not found");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "source volume not found");
            }
            srcAbsRef = this.getAbsRefFromCandidateList(srcList, srcVolRef);
            if (srcAbsRef == null) {
                Trace.error((Object)this, "create", "source not a copy candidate");
                throw new ConfigMgmtException("source.volume.not.copy.candidate", "Source volume not a copy candidate.");
            }
            targetList = symClient.getVolumeCopyTargetCandidates(srcAbsRef);
            String targVolRef = this.getVolumeReference(bundle, targWwn);
            if (targVolRef == null) {
                Trace.error((Object)this, "create", "target was removed");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), new String[]{targWwn}, "target volume not found", null);
            }
            vol1 = this.getVolName(bundle, targVolRef);
            targAbsRef = this.getAbsRefFromTargetList(targetList, targVolRef);
            if (targAbsRef == null) {
                Trace.error((Object)this, "create", "target not a copy candidate");
                throw new ConfigMgmtException(ErrorCode.VOLCOPY_TARGET_NOT_CANDIDATE.getKey(), "target volume not a copy candidate");
            }
            vcDesc = new VolumeCopyCreationDescriptor();
            vcDesc.setCopyPriority(new VolumeCopyPriority(priority));
            vcDesc.setIdleTargetWriteProt(idleProt);
            vcDesc.setSourceVolume(srcAbsRef);
            vcDesc.setTargetVolume(targAbsRef);
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            rcWref = new ReturnCodeWithRef();
            command.execute(118, (XDRType)vcDesc, (XDRType)rcWref, true);
            Trace.verbose((Object)this, "create", "Return code:" + rcWref.getReturnCode().getValue());
            if (rcWref.getReturnCode().getValue() != 1) {
                LogAPI.staticLog((String)"VOLUMECOPY_CREATE_ERROR", (String[])new String[]{vol0, vol1, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rcWref.getReturnCode().getValue()), "create failed");
            }
            try {
                LogAPI.staticLog((String)"VOLUMECOPY_CREATE", (String[])new String[]{vol0, vol1, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (startCopy != null) {
                VolumeCopyRef vcr = new VolumeCopyRef();
                vcr.setRefToken(rcWref.getRef().getRefToken());
                command = new CommandProcessor(myWwn);
                ReturnCode rc = new ReturnCode();
                command.execute(121, (XDRType)vcr, (XDRType)rc, true);
                Trace.verbose((Object)this, "start", "Return code:" + rc.getValue());
                if (rc.getValue() != 1) {
                    LogAPI.staticLog((String)"VOLUMECOPY_START_ERROR ", (String[])new String[]{vol0, vol1, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "start error");
                }
                try {
                    LogAPI.staticLog((String)"VOLUMECOPY_START", (String[])new String[]{vol0, vol1, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "create", "RPC error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "create", "IO error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD_NAME = "delete";
        Trace.methodBegin(this, "delete");
        Object symClient = null;
        ObjectBundleManager manager = null;
        String myWwn = null;
        VolumeCopyRef vcRef = null;
        MethodCallStatus mcs = new MethodCallStatus();
        Object errorDesc = null;
        Map key = null;
        Object ed = null;
        if (list == null || list.size() == 0) {
            Trace.error((Object)this, "delete", "null or empty list");
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "null or empty list");
        }
        mcs.setReturnCode(0);
        int listSize = list.size();
        myWwn = (String)((Map)list.get(0)).get("arrayRef");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "delete", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
        StorageArray sa = bundle.getSa();
        if (!this.isVolumeCopyLicensed(sa, 14)) {
            Trace.error((Object)this, "delete", "license disabled");
            throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
        }
        try {
            for (int i = 0; i < listSize; ++i) {
                key = (Map)list.get(i);
                String cpyRef = (String)key.get("copyRef");
                vcRef = new VolumeCopyRef();
                byte[] token = Convert.stringToBytes(cpyRef);
                vcRef.setRefToken(token);
                String[] vols = this.getVolNames(bundle, cpyRef);
                ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
                CommandProcessor command = new CommandProcessor(myWwn);
                ReturnCode rc = new ReturnCode();
                command.execute(119, (XDRType)vcRef, (XDRType)rc, true);
                Trace.verbose((Object)this, "delete", "Return code:" + rc.getValue());
                boolean remove_succeeded = false;
                if (rc.getValue() != 1) {
                    if (!this.isVolumeCopyCompleted(bundle, cpyRef)) {
                        ReturnCode retCode = new ReturnCode();
                        Trace.verbose((Object)this, "delete", "Attempting stopVolumeCopy...");
                        command.execute(122, (XDRType)vcRef, (XDRType)retCode, true);
                        if (retCode.getValue() == 1) {
                            Trace.verbose((Object)this, "delete", "...worked, retry removeVolumeCopy");
                            command.execute(119, (XDRType)vcRef, (XDRType)retCode, true);
                            if (retCode.getValue() == 1) {
                                remove_succeeded = true;
                            } else {
                                Trace.error((Object)this, "delete", "removeVolumeCopy() ReturnCode " + retCode.getValue());
                            }
                        } else {
                            Trace.error((Object)this, "delete", "stopVolumeCopy() ReturnCode " + retCode.getValue());
                        }
                    }
                } else {
                    remove_succeeded = true;
                }
                if (!remove_succeeded) {
                    LogAPI.staticLog((String)"VOLUMECOPY_DELETE_ERROR", (String[])new String[]{vols[0], vols[1], ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    mcs.addErrorDescriptor(new ErrorDescriptor(OZErrorCode.getErrorCode(ErrorCode.ERROR_REMOVE_COPY_PAIR.getKey(), rc.getValue())));
                    continue;
                }
                try {
                    LogAPI.staticLog((String)"VOLUMECOPY_DELETE", (String[])new String[]{vols[0], vols[1], ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    continue;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "delete", "RPC error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "delete", "IO error");
            LogAPI.staticLog((String)"VOLUMECOPY_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
        return mcs;
    }

    private boolean isVolumeCopyCompleted(ObjectBundle bundle, String copyRef) throws ConfigMgmtException {
        VolumeCopy[] vc = bundle.getHighLevelVolBundle().getVolumeCopy();
        int length = vc != null ? vc.length : 0;
        for (int i = 0; i < length; ++i) {
            String volCopyRef = Convert.bytesToString(vc[i].getVolcopyRef().getRefToken());
            if (!volCopyRef.equals(copyRef) || vc[i].getStatus().getValue() != 2) continue;
            return true;
        }
        return false;
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        ArrayList vcList = new ArrayList();
        this.populateItemList(vcList, true);
        return vcList;
    }

    private void populateItemList(List vcList, boolean fillProgress) throws ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "populateItemList";
        ObjectBundleManager manager = null;
        Object src = null;
        Object target = null;
        Object srcList = null;
        Object targetList = null;
        String arrayWwn = null;
        Object ctrlRefStrg = null;
        Object ctrlLoopString = null;
        Object startCopy = null;
        Object ctrls = null;
        boolean altIndex = false;
        boolean connectedToCtrl2 = false;
        if (this.scope == null) {
            Trace.error((Object)this, "getItemList", "Scope not set.");
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope not set.");
        }
        arrayWwn = Convert.scopeToArrayKey(this.scope);
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        Trace.verbose((Object)this, "populateItemList", "got the bundle");
        String volScopeWwn = this.getSourceWwnKeyAsStringScope();
        this.validateFilterContent(this.filter);
        String volFilterWwn = this.getTargetWwnKeyAsStringFilter();
        manager = ObjectBundleManager.getInstance();
        try {
            HLVolumeBundle hlvb = bundle.getHighLevelVolBundle();
            VolumeCopy[] vcs = hlvb.getVolumeCopy();
            Volume[] vcVols = bundle.getVolume();
            if (vcs != null && vcs.length != 0 && vcVols != null && vcVols.length != 0) {
                this.fillTheList(vcList, arrayWwn, connectedToCtrl2, bundle, volScopeWwn, volFilterWwn, vcs, vcVols, fillProgress);
            }
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "getItemList", "RPC error");
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "getItemList", "IO error");
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        Trace.verbose((Object)this, "populateItemList", "List generated");
    }

    private void fillTheList(List vcList, String arrayWwn, boolean connectedToCtrl2, ObjectBundle bundle, String volScopeWwn, String volFilterWwn, VolumeCopy[] vcs, Volume[] vcVols, boolean fillProgress) throws SEItemNotFoundException, RPCError, IOException, ConfigMgmtException {
        String METHOD_NAME = "fillTheList";
        int length1 = vcs.length;
        Controller[] ctrls = bundle.getController();
        Controller ctrl1 = ctrls[0];
        ctrl1 = ctrls[0];
        ControllerRef cntrlRef = ctrl1.getControllerRef();
        String ctrl1Ref = Convert.bytesToString(cntrlRef.getRefToken());
        String ctrl2Ref = null;
        if (ctrls.length > 1) {
            Controller ctrl2 = ctrls[1];
            cntrlRef = ctrl2.getControllerRef();
            ctrl2Ref = Convert.bytesToString(cntrlRef.getRefToken());
        }
        VolumeCopy[] ordered = new VolumeCopy[length1];
        this.orderVolumeCopiesByControllers(ordered, vcs, length1, ctrl1Ref, ctrl2Ref);
        Map volumeMap = this.populateVolumeRefVolumeMap(vcVols);
        Map snapshotMap = this.populateSnapshotRefSnapshotMap(bundle.getHighLevelVolBundle().getSnapshotVol());
        Trace.verbose((Object)this, "fillTheList", "getClient");
        CommandProcessor command = new CommandProcessor(arrayWwn);
        command.setPreferredController(ctrl1Ref);
        Trace.verbose((Object)this, "fillTheList", "Go in the loop");
        for (int i = 0; i < length1; ++i) {
            VolumeCopy vcVolume = ordered[i];
            AbstractVolRef avr = vcVolume.getSourceVolume();
            LegacyVolRef lvf = vcVolume.getTargetVolume();
            String avrRefString = Convert.bytesToString(avr.getRefToken());
            String lvfRefString = Convert.bytesToString(lvf.getRefToken());
            Volume srcVol = (Volume)volumeMap.get(avrRefString);
            Volume targetVol = (Volume)volumeMap.get(lvfRefString);
            SnapshotVolume srcSnap = (SnapshotVolume)snapshotMap.get(avrRefString);
            if (srcVol == null && srcSnap == null || targetVol == null) continue;
            String srcVolName = null;
            String srcVolWwn = null;
            String srcVolID = null;
            if (srcVol != null) {
                srcVolName = UnicodeTranslator.getString((byte[])srcVol.getLabel().getValue());
                srcVolWwn = Convert.bytesToString(srcVol.getWorldWideName());
                srcVolID = ManageVolumes.getVolumeID(srcVol.getWorldWideName());
            } else {
                srcVolName = UnicodeTranslator.getString((byte[])srcSnap.getLabel().getValue());
                srcVolWwn = Convert.bytesToString(srcSnap.getWorldWideName());
                srcVolID = ManageVolumes.getVolumeID(srcSnap.getWorldWideName());
            }
            String targetVolWwn = Convert.bytesToString(targetVol.getWorldWideName());
            String targetVolID = ManageVolumes.getVolumeID(targetVol.getWorldWideName());
            String targetVolName = UnicodeTranslator.getString((byte[])targetVol.getLabel().getValue());
            if (srcVolWwn == null || targetVolWwn == null || volScopeWwn != null && !volScopeWwn.equals(srcVolWwn) || volFilterWwn != null && !volFilterWwn.equals(targetVolWwn)) continue;
            if (Convert.bytesToString(vcVolume.getCurrentManager().getRefToken()).equals(ctrl2Ref) && !connectedToCtrl2 && fillProgress) {
                command.setPreferredController(ctrl2Ref);
                connectedToCtrl2 = true;
            }
            VolumeActionProgress vap = new VolumeActionProgress();
            if (fillProgress) {
                command.execute(41, (XDRType)vcVolume.getVolcopyRef(), (XDRType)vap, false);
            }
            VolumeCopyMO mo = this.populateVolumeCopyMO(vcVolume, arrayWwn, avrRefString, srcVolWwn, srcVolName, lvfRefString, targetVolWwn, targetVolName, srcVolID, targetVolID, vap);
            vcList.add(mo);
            if (this.filter != null && "keyAsString".equals(this.filter.getSearchField())) break;
        }
    }

    private String getSourceWwnKeyAsStringScope() {
        String keyAsString;
        String srcWwn = null;
        if (this.scope != null && (keyAsString = (String)this.scope.getAttribute("volume")) != null) {
            Map map = Convert.keyAsStringToMap(keyAsString);
            srcWwn = (String)map.get("volumeWwn");
        }
        return srcWwn;
    }

    private String getTargetWwnKeyAsStringFilter() {
        String keyAsString;
        String volumeWwn = null;
        if (this.filter != null && !this.filter.isEmpty() && this.filter.getSearchField().equals("keyAsString") && (keyAsString = this.filter.getSearchString()) != null) {
            Map map = Convert.keyAsStringToMap(keyAsString);
            volumeWwn = (String)map.get("volumeWwn");
        }
        return volumeWwn;
    }

    private void validateFilterContent(SearchFilter filter) throws ConfigMgmtException {
        String searchField;
        String METHOD_NAME = "validateFilterContent";
        if (!(filter == null || (searchField = filter.getSearchField()) != null && (searchField.equals("name") || searchField.equals("wwn") || searchField.equals("keyAsString")))) {
            Trace.verbose((Object)this, "validateFilterContent", "Search field not supported: " + searchField);
            throw new ConfigMgmtException("error.search.field.not.supported", "error.search.field.not.supported: " + searchField);
        }
    }

    private void orderVolumeCopiesByControllers(VolumeCopy[] ordered, VolumeCopy[] vcs, int length1, String ctrl1Ref, String ctrl2Ref) {
        int j;
        int cnt = 0;
        for (j = 0; j < length1; ++j) {
            if (!Convert.bytesToString(vcs[j].getCurrentManager().getRefToken()).equals(ctrl1Ref)) continue;
            ordered[cnt] = vcs[j];
            ++cnt;
        }
        for (j = 0; j < length1; ++j) {
            VolumeCopy vcVolume = vcs[j];
            if (!Convert.bytesToString(vcs[j].getCurrentManager().getRefToken()).equals(ctrl2Ref)) continue;
            ordered[cnt] = vcs[j];
            ++cnt;
        }
    }

    private Map populateVolumeRefVolumeMap(Volume[] volumes) {
        HashMap<String, Volume> volumeMap = new HashMap<String, Volume>();
        int length = volumes == null ? 0 : volumes.length;
        for (int i = 0; i < length; ++i) {
            volumeMap.put(Convert.bytesToString(volumes[i].getVolumeRef().getRefToken()), volumes[i]);
        }
        return volumeMap;
    }

    private Map populateSnapshotRefSnapshotMap(SnapshotVolume[] snapshots) {
        HashMap<String, SnapshotVolume> snapshotMap = new HashMap<String, SnapshotVolume>();
        int length = snapshots == null ? 0 : snapshots.length;
        for (int i = 0; i < length; ++i) {
            snapshotMap.put(Convert.bytesToString(snapshots[i].getSnapshotRef().getRefToken()), snapshots[i]);
        }
        return snapshotMap;
    }

    private VolumeCopyMO populateVolumeCopyMO(VolumeCopy vcVolume, String arrayWwn, String avrRefString, String srcVolWwn, String srcVolName, String lvfRefString, String targetVolWwn, String targetVolName, String srcVolID, String targetVolID, VolumeActionProgress vap) {
        VolumeCopyMO mo = new VolumeCopyMO();
        mo.setController(Convert.bytesToString(vcVolume.getCurrentManager().getRefToken()));
        mo.setArrayWwn(arrayWwn);
        mo.setMyCopyCompleteTime(vcVolume.getCopyCompleteTime());
        mo.setMyCopyStartTime(vcVolume.getCopyStartTime());
        mo.setMyHandle(vcVolume.getVolcopyHandle());
        mo.setMyIdleTargetWriteProt(vcVolume.getIdleTargetWriteProt());
        mo.setMyPriority(vcVolume.getCopyPriority().getValue());
        mo.setStatus(vcVolume.getStatus().getValue());
        mo.setVolumeCopyRef(Convert.bytesToString(vcVolume.getVolcopyRef().getRefToken()));
        mo.setVolumeCopyWwn(Convert.bytesToString(vcVolume.getWorldWideName()));
        mo.setSourceVolumeRef(avrRefString);
        mo.setSourceVolumeWwn(srcVolWwn);
        mo.setSourceVolumeName(srcVolName);
        mo.setTargetVolumeRef(lvfRefString);
        mo.setTargetVolumeWwn(targetVolWwn);
        mo.setTargetVolumeName(targetVolName);
        StringBuffer name = new StringBuffer(VOLUME_COPY_ID_PREFIX);
        name.append(srcVolID).append(":").append(targetVolID);
        mo.setName(name.toString());
        mo.setMyPercentComplete(vap.getPercentComplete());
        mo.setMyCopyTimeToCompletion(vap.getTimeToCompletion());
        Map key = ManageVolumeCopy.getVolumeCopyKeyMap(mo.getArrayWwn(), mo.getVolumeCopyRef(), mo.getVolumeCopyWwn(), mo.getTargetVolumeWwn(), mo.getTargetVolumeRef());
        mo.setKey(key);
        return mo;
    }

    private AbstractVolRef getAbsRefFromCandidateList(VolumeCopyCandidateList list, String volRef) {
        Trace.methodBegin(this, "getAbsRefFromCandidateList");
        VolumeCopyCandidate[] candidates = null;
        if (list != null) {
            candidates = list.getVolumeCopyCandidate();
            for (int i = 0; i < candidates.length; ++i) {
                AbstractVolRef absRef = candidates[i].getVolumeRef();
                String cadRef = Convert.bytesToString(absRef.getRefToken());
                if (!volRef.equals(cadRef)) continue;
                return absRef;
            }
        }
        return null;
    }

    private LegacyVolRef getAbsRefFromTargetList(VolumeCopyCandidateList list, String volRef) {
        Trace.methodBegin(this, "getAbsRefFromTargetList");
        VolumeCopyCandidate[] candidates = null;
        if (list != null) {
            candidates = list.getVolumeCopyCandidate();
            for (int i = 0; i < candidates.length; ++i) {
                AbstractVolRef absRef = candidates[i].getVolumeRef();
                String cadRef = Convert.bytesToString(absRef.getRefToken());
                if (!volRef.equals(cadRef)) continue;
                LegacyVolRef lvr = new LegacyVolRef();
                lvr.setRefToken(absRef.getRefToken());
                return lvr;
            }
        }
        return null;
    }

    private String getVolumeReference(ObjectBundle bundle, String volWwn) {
        SnapshotVolume[] ozSnaps;
        Trace.methodBegin(this, "getVolumeReference");
        Volume[] ozVols = bundle.getVolume();
        if (ozVols != null || ozVols.length > 0) {
            for (int j = 0; j < ozVols.length; ++j) {
                Volume ozVol = ozVols[j];
                String myWwn = Convert.bytesToString(ozVol.getWorldWideName());
                if (!volWwn.equals(myWwn)) continue;
                return Convert.bytesToString(ozVol.getVolumeRef().getRefToken());
            }
        }
        if ((ozSnaps = bundle.getHighLevelVolBundle().getSnapshotVol()) != null || ozSnaps.length > 0) {
            for (int j = 0; j < ozSnaps.length; ++j) {
                SnapshotVolume ozSnap = ozSnaps[j];
                String myWwn = Convert.bytesToString(ozSnap.getWorldWideName());
                if (!volWwn.equals(myWwn)) continue;
                return Convert.bytesToString(ozSnap.getSnapshotRef().getRefToken());
            }
        }
        return null;
    }

    private String getVolumeWWN(ObjectBundle bundle, AbstractVolRef absRef) {
        Trace.methodBegin(this, "getVolumeWWN");
        String srcRef = Convert.bytesToString(absRef.getRefToken());
        Volume[] ozVols = bundle.getVolume();
        if (ozVols != null || ozVols.length > 0) {
            for (int j = 0; j < ozVols.length; ++j) {
                Volume ozVol = ozVols[j];
                String srcVolRef = Convert.bytesToString(ozVol.getVolumeRef().getRefToken());
                if (!srcRef.equals(srcVolRef)) continue;
                return Convert.bytesToString(ozVol.getWorldWideName());
            }
        }
        return null;
    }

    private String getVolName(ObjectBundle bundle, String vRef) {
        String rs = "?";
        Trace.methodBegin(this, "getVolName");
        Volume[] vcVols = bundle.getVolume();
        Object volName = null;
        if (vcVols != null || vcVols.length != 0) {
            int length2 = vcVols.length;
            for (int j = 0; j < length2; ++j) {
                Volume myVol = vcVols[j];
                String myVolName = UnicodeTranslator.getString((byte[])myVol.getLabel().getValue());
                String myVolRef = Convert.bytesToString(myVol.getVolumeRef().getRefToken());
                if (!vRef.equals(myVolRef)) continue;
                return myVolName;
            }
        }
        return rs;
    }

    private String[] getVolNames(ObjectBundle bundle, String vcRef) {
        String[] rsa = new String[]{"?", "?"};
        HLVolumeBundle hlvb = bundle.getHighLevelVolBundle();
        VolumeCopy[] vcs = hlvb.getVolumeCopy();
        int length1 = vcs.length;
        for (int i = 0; i < length1; ++i) {
            VolumeCopy vcVolume = vcs[i];
            String myVcr = Convert.bytesToString(vcVolume.getVolcopyRef().getRefToken());
            if (!myVcr.equals(vcRef)) continue;
            AbstractVolRef avr = vcVolume.getSourceVolume();
            LegacyVolRef lvf = vcVolume.getTargetVolume();
            String avrRefString = Convert.bytesToString(avr.getRefToken());
            String lvfRefString = Convert.bytesToString(lvf.getRefToken());
            Volume[] vcVols = bundle.getVolume();
            Object srcVolName = null;
            Object targVolName = null;
            if (vcVols == null && vcVols.length == 0) continue;
            int length2 = vcVols.length;
            for (int j = 0; j < length2; ++j) {
                Volume myVol = vcVols[j];
                String myVolName = UnicodeTranslator.getString((byte[])myVol.getLabel().getValue());
                String myVolRef = Convert.bytesToString(myVol.getVolumeRef().getRefToken());
                if (avrRefString.equals(myVolRef)) {
                    rsa[0] = myVolName;
                }
                if (!lvfRefString.equals(myVolRef)) continue;
                rsa[1] = myVolName;
            }
        }
        return rsa;
    }

    public String bytesToStringNoDot(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sbuf.append(Convert.toHex(data[i], 2));
        }
        return sbuf.toString();
    }

    private Collection getBundles() throws ConfigMgmtException {
        Trace.methodBegin(this, "getBundles");
        ArrayList<ObjectBundle> bundles = null;
        if (this.scope != null) {
            String arrayWwn = Convert.scopeToArrayKey(this.scope);
            bundles = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
            bundles.add(ob);
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        return bundles;
    }

    static Map getVolumeCopyKeyMap(String arrayWwn, String copyRef, String copyWwn, String targVolWwn, String targVolRef) {
        HashMap<String, String> key = new HashMap<String, String>(5);
        key.put("array", arrayWwn);
        key.put("copyRef", copyRef);
        key.put("copyWwn", copyWwn);
        key.put("volumeWwn", targVolWwn);
        key.put("volumeRef", targVolRef);
        return key;
    }

    public int getItemCount() throws ConfigMgmtException {
        String METHOD_NAME = "getItemCount";
        Trace.methodBegin(this, "getItemCount");
        ArrayList vcList = new ArrayList();
        this.populateItemList(vcList, false);
        return vcList.size();
    }

    public int getMaxObjects() {
        return 0;
    }

    public static void main(String[] args) {
        long length = 0L;
        MethodCallStatus mcs = null;
        ConfigContext cfgctx = new ConfigContext();
        cfgctx.setAttribute("config-type", new Integer(2));
        cfgctx.setAttribute("array-type", new Integer(0));
        String brickWwn = "60.0A.0B.80.00.13.99.F9.00.00.00.00.40.76.7E.31";
        String srcWwnKey = null;
        String targWwnKey = null;
        String copyReference = null;
        String copyWwn = null;
        String keyAsString = null;
        try {
            Properties props2;
            Scope s = new Scope();
            s.setAttribute("array", brickWwn);
            SearchFilter sf = new SearchFilter();
            s.setAttribute("array", brickWwn);
            ManageArraysInterface mgr1 = ManageArraysFactory.getManager(cfgctx, null, null);
            ManageVolumeCopyInterface mgr = ManageDataServicesFactory.getVolumeCopyManager(cfgctx, s, null);
            int count = mgr.getItemCount();
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? (class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy = ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy")) : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "Current copy count= " + count);
            List vc = mgr.getItemList();
            for (int i = 0; i < vc.size(); ++i) {
                VolumeCopyMO mo = (VolumeCopyMO)vc.get(i);
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "array........: " + mo.getArrayWwn());
                String arrayWWN = (String)mo.getKey().get("array");
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "array(key)...:" + arrayWWN);
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "complete time: " + mo.getCopyCompleteTime());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "start time...: " + mo.getCopyStartTime());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "elapsed milli: " + (mo.getCopyCompleteTime() - mo.getCopyStartTime()));
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "% complete: " + mo.getPercentComplete());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "time to complete: " + mo.getTimeToCompletion());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "copy handle..: " + mo.getHandle());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "writ protect.: " + mo.isIdleTargetWriteProt());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "priority.....: " + mo.getPriority());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "status.......: " + mo.getStatus());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "volcopy ref..: " + mo.getVolumeCopyRef());
                copyReference = mo.getVolumeCopyRef();
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "volcopy wwn..: " + mo.getVolumeCopyWwn());
                copyWwn = mo.getVolumeCopyWwn();
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "src vol ref..: " + mo.getSourceVolumeRef());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "src vol wwn..: " + mo.getSourceVolumeWwn());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "targ vol ref.: " + mo.getTargetVolumeRef());
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "targ vol wwn.: " + mo.getTargetVolumeWwn());
                keyAsString = mo.getKeyAsString();
            }
            Properties props = new Properties();
            props.setProperty("sourceVolRef", srcWwnKey);
            props.setProperty("targetVolRef", targWwnKey);
            props.setProperty("protect", "true");
            props.setProperty("priority", "3");
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? (class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy = ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy")) : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, "main", "===> CREATE: src: " + srcWwnKey + " targ: " + targWwnKey);
            mgr.create(props);
            if (copyReference != null) {
                props2 = new Properties();
                props2.setProperty("array", brickWwn);
                props2.setProperty("copyRef", copyReference);
                props2.setProperty("copyWwn", copyWwn);
                mgr.start(keyAsString, props2);
            }
            if (copyReference != null) {
                props2 = new Properties();
                props2.setProperty("array", brickWwn);
                props2.setProperty("copyRef", copyReference);
                props2.setProperty("copyWwn", copyWwn);
                props2.setProperty("priority", "1");
                props2.setProperty("protect", "disable");
                mgr.modify(keyAsString, props2);
            }
            if (copyReference != null) {
                props2 = new Properties();
                props2.setProperty("array", brickWwn);
                props2.setProperty("copyRef", copyReference);
                props2.setProperty("copyWwn", copyWwn);
                mgr.stop(keyAsString, props2);
            }
            if (copyReference != null) {
                HashMap<String, String> key = new HashMap<String, String>(2);
                ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
                key.put("arrayRef", brickWwn);
                key.put("copyRef", copyReference);
                list.add(key);
                mcs = mgr.delete(list);
            }
        }
        catch (ConfigMgmtException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy == null ? (class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy = ManageVolumeCopy.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy")) : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$ManageVolumeCopy, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String SOURCE_REF = "sourceRef";
        public static final String SOURCE_WWN = "sourceWwn";
        public static final String TARGET_REF = "volumeRef";
        public static final String TARGET_WWN = "volumeWwn";
        public static final String COPY_WWN = "copyWwn";
        public static final String VOLUME_NAME = "volumeName";
        public static final String COPY_REF = "copyRef";
        public static final String PRIORITY = "priority";
        public static final String IDLE_PROTECT = "protect";
        public static final String CNTRL_REF = "controller";
        public static final String START = "start";
        public static final String PROTECT_ENABLE = "enable";
        public static final String PROTECT_DISABLE = "disable";
    }

    public static interface CreateProps {
        public static final String SOURCE_KEY_AS_STRING = "sourceKeyAsString";
        public static final String TARGET_KEY_AS_STRING = "targetKeyAsString";
        public static final String SOURCE_KEY = "sourceVolRef";
        public static final String TARGET_KEY = "targetVolRef";
        public static final String IDLE_PROTECT = "protect";
        public static final String PRIORITY = "priority";
        public static final String COPY_NAME = "name";
    }

    public static interface SearchType {
        public static final String WWN = "wwn";
        public static final String NAME = "name";
        public static final String KEY_AS_STRING = "keyAsString";
    }
}

