/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationParametersEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationGroupCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationSetCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import java.math.BigInteger;
import java.util.Enumeration;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;

public class ReplicationParametersCIM
implements ReplicationParametersEnt1Interface {
    private int role;
    private int syncMode;
    private boolean autoSync;
    private boolean snapBeforeSync;
    private boolean snapSecondary;
    private int priority = 128;
    private int writeCount;
    private BigInteger blockCount;
    private int timeCount;
    private int queueAction;
    private BigInteger queueSize;
    private Object asyncQueueStorage;
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private CIMInstance cimInstance;

    public ReplicationParametersCIM(CIMInstance ci, ConfigContext context) {
        String METHOD = "ReplicationParameters(CIMInstance, ConfigContext)";
        Trace.methodBegin(this, "ReplicationParameters(CIMInstance, ConfigContext)");
        this.context = context;
        this.handle = context.getClient();
        this.cimInstance = ci;
        CIMValue cvRole = ci.getProperty("Role").getValue();
        if (cvRole != null) {
            this.role = ((UnsignedInt16)cvRole.getValue()).intValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: role.");
        }
        CIMValue cvSyncMode = ci.getProperty("Mode").getValue();
        if (cvSyncMode != null) {
            this.syncMode = ((UnsignedInt16)cvSyncMode.getValue()).intValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: syncMode.");
        }
        CIMValue cvAutoSync = ci.getProperty("AutoSynchronize").getValue();
        if (cvAutoSync != null) {
            this.autoSync = (Boolean)cvAutoSync.getValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: autoSync.");
        }
        CIMValue cvSnapBefore = ci.getProperty("SnapBeforeResync").getValue();
        if (cvSnapBefore != null) {
            this.snapBeforeSync = (Boolean)cvSnapBefore.getValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: snapBeforeSync.");
        }
        CIMValue cvSnapSec = ci.getProperty("SnapSecondary").getValue();
        if (cvSnapSec != null) {
            this.snapSecondary = (Boolean)cvSnapSec.getValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: snapSecondary.");
        }
        CIMValue cvWriteCount = ci.getProperty("QueueWrites").getValue();
        if (cvWriteCount != null) {
            this.writeCount = ((UnsignedInt32)cvWriteCount.getValue()).intValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: writeCount.");
        }
        CIMValue cvBlockCount = ci.getProperty("QueueBlockCount").getValue();
        if (cvBlockCount != null) {
            this.blockCount = ((UnsignedInt64)cvBlockCount.getValue()).bigIntValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: blockCount.");
        }
        CIMValue cvTimeCount = ci.getProperty("QueueTime").getValue();
        if (cvTimeCount != null) {
            this.timeCount = ((UnsignedInt32)cvTimeCount.getValue()).intValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: timeCount.");
        }
        CIMValue cvQueueAction = ci.getProperty("QueueAction").getValue();
        if (cvQueueAction != null) {
            this.queueAction = ((UnsignedInt16)cvQueueAction.getValue()).intValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: queueAction.");
        }
        CIMValue cvQueueSize = ci.getProperty("QueueSize").getValue();
        if (cvQueueSize != null) {
            this.queueSize = ((UnsignedInt64)cvQueueSize.getValue()).bigIntValue();
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: queueSize.");
        }
        CIMProperty propPriority = ci.getProperty("ReplicationPriority");
        if (propPriority != null) {
            CIMValue cvPriority = propPriority.getValue();
            if (cvPriority != null) {
                UnsignedInt16 pVal = (UnsignedInt16)cvPriority.getValue();
                if (pVal != null) {
                    this.priority = pVal.intValue();
                } else {
                    Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: priority.");
                }
            } else {
                Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: priority.");
            }
        } else {
            Trace.error((Object)this, "ReplicationParameters(CIMInstance, ConfigContext)", "Could not populate ReplicationParams: priority.");
        }
        Trace.methodEnd(this, "ReplicationParameters(CIMInstance, ConfigContext)");
    }

    public ReplicationParametersCIM(int role, int syncMode, boolean snapBeforeSync, boolean snapSecondary, boolean autoSync, int priority, BigInteger queueSize, int queueAction, BigInteger blockCount, int timeCount, int writeCount) {
        Trace.constructor(this);
        this.role = role;
        this.syncMode = syncMode;
        this.snapBeforeSync = snapBeforeSync;
        this.snapSecondary = snapSecondary;
        this.autoSync = autoSync;
        this.priority = priority;
        this.queueSize = queueSize;
        this.queueAction = queueAction;
        this.blockCount = blockCount;
        this.timeCount = timeCount;
        this.writeCount = writeCount;
        this.asyncQueueStorage = null;
    }

    public int getRole() {
        String METHOD = "getRole";
        Trace.methodBegin(this, "getRole");
        Trace.methodEnd(this, "getRole");
        return this.role;
    }

    public int getSyncMode() {
        String METHOD = "getSyncMode";
        Trace.methodBegin(this, "getSyncMode");
        Trace.methodEnd(this, "getSyncMode");
        return this.syncMode;
    }

    public boolean isAutoSync() {
        String METHOD = "isAutoSync";
        Trace.methodBegin(this, "isAutoSync");
        Trace.methodEnd(this, "isAutoSync");
        return this.autoSync;
    }

    public boolean isSnapBeforeSync() {
        String METHOD = "isSnapBeforeSync";
        Trace.methodBegin(this, "isSnapBeforeSync");
        Trace.methodEnd(this, "isSnapBeforeSync");
        return this.snapBeforeSync;
    }

    public boolean isSnapWithPrimary() {
        String METHOD = "isSnapWithPrimary";
        Trace.methodBegin(this, "isSnapWithPrimary");
        Trace.methodEnd(this, "isSnapWithPrimary");
        return this.snapSecondary;
    }

    public int getAsyncQWriteCount() {
        String METHOD = "getAsyncQWriteCount";
        Trace.methodBegin(this, "getAsyncQWriteCount");
        Trace.methodEnd(this, "getAsyncQWriteCount");
        return this.writeCount;
    }

    public BigInteger getAsyncQBlockCount() {
        String METHOD = "getAsyncQBlockCount";
        Trace.methodBegin(this, "getAsyncQBlockCount");
        Trace.methodEnd(this, "getAsyncQBlockCount");
        return this.blockCount;
    }

    public int getAsyncQTimeCount() {
        String METHOD = "getAsyncQTimeCount";
        Trace.methodBegin(this, "getAsyncQTimeCount");
        Trace.methodEnd(this, "getAsyncQTimeCount");
        return this.timeCount;
    }

    public int getAsyncQAction() {
        String METHOD = "getAsyncQAction";
        Trace.methodBegin(this, "getAsyncQAction");
        Trace.methodEnd(this, "getAsyncQAction");
        return this.queueAction;
    }

    public int getPriority() {
        String METHOD = "getPriority";
        Trace.methodBegin(this, "getPriority");
        Trace.methodEnd(this, "getPriority");
        return this.priority;
    }

    protected BigInteger getAsyncQueueSize(Object obj) {
        String METHOD = "getAsyncQueueSize";
        Trace.methodBegin(this, "getAsyncQueueSize");
        if (obj != null && this.asyncQueueStorage == null) {
            try {
                this.getAsyncQStorage(obj);
            }
            catch (ConfigMgmtException cme) {
                Trace.verbose((Object)this, "getAsyncQueueSize", "AsyncQueue missing");
            }
        }
        Trace.methodEnd(this, "getAsyncQueueSize");
        return this.queueSize;
    }

    public CIMInstance getCIMInstance() {
        String METHOD = "getCIMInstance";
        Trace.methodBegin(this, "getCIMInstance");
        Trace.methodEnd(this, "getCIMInstance");
        return this.cimInstance;
    }

    protected Object getAsyncQStorage(Object repObject) throws ConfigMgmtException {
        String METHOD = "getAsyncQStorage";
        Trace.methodBegin(this, "getAsyncQStorage");
        Trace.verbose((Object)this, "getAsyncQStorage", "Querying the CIM for a StorageExtent or StorageVolume instance.");
        Enumeration enumExtent = this.handle.associators(this.cimInstance.getObjectPath(), "SunStorEdge_DSPReplicationQueue", "CIM_StorageExtent", "Antecedent", "Dependent", true, false, null);
        Trace.verbose((Object)this, "getAsyncQStorage", "Returned from querying the CIM for a StorageExtent or StorageVolume instance");
        if (enumExtent != null && enumExtent.hasMoreElements()) {
            Trace.verbose((Object)this, "getAsyncQStorage", "StorageExtent association instance found.");
            CIMInstance se = (CIMInstance)enumExtent.nextElement();
            if (repObject instanceof ReplicationSetCIM) {
                VDisk vd = new VDisk();
                vd.setInstance(se);
                vd.init(this.context);
                CIMObjectWrapper.populate(vd, vd.getFieldMap(), se);
                vd.loadKeys();
                this.asyncQueueStorage = vd;
            } else if (repObject instanceof ReplicationGroupCIM) {
                StorageVolume vol = new StorageVolume();
                vol.setInstance(se);
                vol.init(this.context);
                CIMObjectWrapper.populate(vol, vol.getFieldMap(), se);
                vol.loadKeys();
                this.asyncQueueStorage = vol;
                this.queueSize = vol.getSize();
            }
        } else {
            Trace.verbose((Object)this, "getAsyncQStorage", "AsyncQueue VDisk or StorageVolume could not be found");
        }
        Trace.methodEnd(this, "getAsyncQStorage");
        return this.asyncQueueStorage;
    }
}

