/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationGroupEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationParametersEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationSetEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationParametersCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationSetCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class ReplicationGroupCIM
implements ReplicationGroupEnt1Interface {
    private String name;
    private String description;
    private String groupWwn;
    private List sets;
    private int role;
    private int syncMode;
    private String peerWwn;
    private ReplicationParametersCIM repParams;
    private StorageVolumeEnt1Interface asyncQueue;
    private BigInteger queueSize;
    private int state = 0;
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private CIMInstance instance;
    private String instanceID;
    private ArrayList keys;

    public ReplicationGroupCIM(CIMInstance ci, ConfigContext context) {
        String METHOD = "ReplicationGroupCIM(CIMInstance, ConfigContext)";
        this.instance = ci;
        this.context = context;
        this.handle = context.getClient();
        CIMValue cvName = ci.getProperty("Name").getValue();
        if (cvName != null) {
            this.name = (String)cvName.getValue();
        } else {
            Trace.error((Object)this, "ReplicationGroupCIM(CIMInstance, ConfigContext)", "Could not populate ReplicationGroup: name.");
        }
        CIMValue cvDesc = ci.getProperty("Description").getValue();
        if (cvDesc != null) {
            this.description = (String)cvDesc.getValue();
        } else {
            Trace.error((Object)this, "ReplicationGroupCIM(CIMInstance, ConfigContext)", "Could not populate ReplicationGroup: description.");
        }
        CIMValue cvInst = ci.getProperty("InstanceID").getValue();
        if (cvInst != null) {
            this.instanceID = (String)cvInst.getValue();
        } else {
            Trace.error((Object)this, "ReplicationGroupCIM(CIMInstance, ConfigContext)", "Could not populate ReplicationGroup: instanceID.");
        }
        CIMValue cvGrpWwn = ci.getProperty("ElementName").getValue();
        if (cvGrpWwn != null) {
            this.groupWwn = (String)cvGrpWwn.getValue();
        } else {
            Trace.error((Object)this, "ReplicationGroupCIM(CIMInstance, ConfigContext)", "Could not populate ReplicationGroup: group wwn.");
        }
        this.role = -1;
        this.syncMode = -1;
        this.queueSize = BigInteger.ZERO;
    }

    public Collection getKey() {
        String METHOD = "getKey";
        Trace.methodBegin(this, "getKey");
        if (this.keys == null) {
            this.keys = new ArrayList();
            this.keys.add(new CIMProperty("InstanceID", new CIMValue((Object)this.instanceID)));
        }
        Trace.methodEnd(this, "getKey");
        return this.keys;
    }

    public String getDescription() {
        String METHOD = "getDescription";
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            return "";
        }
        Trace.methodEnd(this, "getDescription");
        return this.description;
    }

    public String getGroupWwn() {
        String METHOD = "getGroupWwn";
        Trace.methodBegin(this, "getGroupWwn");
        if (this.groupWwn == null) {
            return "";
        }
        Trace.methodEnd(this, "getGroupWwn");
        return Convert.wwnToString(this.groupWwn);
    }

    public String getName() {
        String METHOD = "getName";
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            return "";
        }
        Trace.methodEnd(this, "getName");
        return this.name;
    }

    public String getPeerWwn() throws ConfigMgmtException {
        String METHOD = "getPeerWwn";
        Trace.methodBegin(this, "getPeerWwn");
        if (this.peerWwn == null) {
            this.getReplicationParameters();
        }
        Trace.methodEnd(this, "getPeerWwn");
        String tmpWwn = Convert.wwnToString(this.peerWwn);
        return Convert.toShortRemotePeerWWN(tmpWwn);
    }

    public List getReplicationSets() throws ConfigMgmtException {
        String METHOD = "getReplicationSets";
        Trace.methodBegin(this, "getReplicationSets");
        if (this.sets == null) {
            Trace.verbose((Object)this, "getReplicationSets", "Querying CIM for associated ReplicationSet Instance");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPMemberOfCollection", "SunStorEdge_DSPReplicationSet", "Collection", "Member", true, false, null);
            Trace.verbose((Object)this, "getReplicationSets", "Returned from querying CIM for associated  ReplicationSet  Instance");
            if (enumeration != null && enumeration.hasMoreElements()) {
                this.sets = new ArrayList();
                while (enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    ReplicationSetCIM set = new ReplicationSetCIM(ci, this.context);
                    this.sets.add(set);
                }
            }
        }
        Trace.methodEnd(this, "getReplicationSets");
        return this.sets;
    }

    public int getRole() throws ConfigMgmtException {
        String METHOD = "getReplicationSets";
        Trace.methodBegin(this, "getReplicationSets");
        if (this.role == -1) {
            this.getReplicationParameters();
        }
        Trace.methodEnd(this, "getReplicationSets");
        return this.role;
    }

    public int getSyncMode() throws ConfigMgmtException {
        String METHOD = "getSyncMode";
        Trace.methodBegin(this, "getSyncMode");
        if (this.syncMode == -1) {
            this.getReplicationParameters();
        }
        Trace.methodEnd(this, "getSyncMode");
        return this.syncMode;
    }

    public ReplicationParametersEnt1Interface getReplicationParameters() throws ConfigMgmtException {
        String METHOD = "getReplicationParameters";
        Trace.methodBegin(this, "getReplicationParameters");
        if (this.repParams == null) {
            Trace.verbose((Object)this, "getReplicationParameters", "Querying the CIM for associated ReplicationParameters");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPReplicationParameters", "ManagedElement", "SettingData", true, false, null);
            Trace.verbose((Object)this, "getReplicationParameters", "Returned from querying the CIM for associated ReplicationParameters");
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                this.repParams = new ReplicationParametersCIM(ci, this.context);
                this.peerWwn = (String)ci.getProperty("Peer").getValue().getValue();
                this.role = this.repParams.getRole();
                this.syncMode = this.repParams.getSyncMode();
                this.queueSize = this.repParams.getAsyncQueueSize(this);
            }
        }
        Trace.methodEnd(this, "getReplicationParameters");
        return this.repParams;
    }

    public CIMInstance getCIMInstance() {
        String METHOD = "getCIMInstance";
        Trace.methodBegin(this, "getCIMInstance");
        Trace.methodEnd(this, "getCIMInstance");
        return this.instance;
    }

    public StorageVolumeEnt1Interface getAsyncQStorage() throws ConfigMgmtException {
        String METHOD = "getAsyncQStorage";
        Trace.methodBegin(this, "getAsyncQStorage");
        if (this.asyncQueue == null) {
            this.getReplicationParameters();
            this.asyncQueue = (StorageVolumeEnt1Interface)this.repParams.getAsyncQStorage(this);
        }
        Trace.methodEnd(this, "getAsyncQStorage");
        return this.asyncQueue;
    }

    public BigInteger getAsyncQueueSize() {
        String METHOD = "getAsyncQueueSize";
        Trace.methodBegin(this, "getAsyncQueueSize");
        if (this.asyncQueue == null) {
            try {
                this.getReplicationParameters();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getAsyncQueueSize", "Error getting parameters for the ReplicationGroup");
            }
        }
        Trace.methodEnd(this, "getAsyncQueueSize");
        return this.queueSize;
    }

    public int getState() throws ConfigMgmtException {
        String METHOD = "getState";
        Trace.methodBegin(this, "getState");
        if (this.state == 0) {
            List repSets = this.getReplicationSets();
            int size = repSets.size();
            boolean isRepSync = false;
            for (int i = 0; i < size && !isRepSync; ++i) {
                ReplicationSetEnt1Interface repSet = (ReplicationSetEnt1Interface)repSets.get(i);
                if (repSet.getState() != 1 && repSet.getState() != 2) continue;
                isRepSync = true;
            }
            this.state = isRepSync ? 4 : 3;
        }
        Trace.methodEnd(this, "getState");
        return this.state;
    }

    public boolean contains(Object repKey) throws ConfigMgmtException {
        String METHOD = "contains";
        Trace.methodBegin(this, "contains");
        boolean found = false;
        ReplicationSetEnt1Interface repSet = this.loadObject(repKey);
        if (repSet != null) {
            List repSets = this.getReplicationSets();
            int size = repSets.size();
            for (int i = 0; i < size && !found; ++i) {
                ReplicationSetEnt1Interface repSetTemp = (ReplicationSetEnt1Interface)repSets.get(i);
                if (!repSet.getName().equals(repSetTemp.getName())) continue;
                found = true;
            }
        }
        Trace.methodEnd(this, "contains");
        return found;
    }

    public BigInteger getTotalVolumeCapacity() {
        String METHOD = "getTotalVolumeCapacity";
        BigInteger total = BigInteger.ZERO;
        Trace.methodBegin(this, "getTotalVolumeCapacity");
        if (this.sets == null) {
            try {
                this.getReplicationSets();
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)this, "getTotalVolumeCapacity", "Error retreiving replication sets");
            }
        }
        if (this.sets != null) {
            int size = this.sets.size();
            for (int i = 0; i < size; ++i) {
                ReplicationSetCIM repSet = (ReplicationSetCIM)this.sets.get(i);
                if (repSet == null) continue;
                total = total.add(repSet.getVolumeCapacity());
            }
        }
        Trace.methodEnd(this, "getTotalVolumeCapacity");
        return total;
    }

    private ReplicationSetEnt1Interface loadObject(Object key) throws ConfigMgmtException {
        String METHOD = "loadObject";
        Trace.methodBegin(this, "loadObject");
        ReplicationSetEnt1Interface repSet = null;
        if (key != null) {
            if (key instanceof ReplicationSetEnt1Interface) {
                repSet = (ReplicationSetEnt1Interface)key;
            } else if (key instanceof Collection) {
                ManageReplicationServicesEnt1Interface manager = (ManageReplicationServicesEnt1Interface)ManageDataServicesFactory.getReplicationServicesManager();
                repSet = manager.getReplicationSetByKey((Collection)key);
            }
        }
        Trace.methodEnd(this, "loadObject");
        return repSet;
    }
}

