/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.MirroredVolumeEnt1;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirrorComponentCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.SortedSet;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class MirroredVolumeCIM
extends MirroredVolumeEnt1 {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$ent1$cim$MirroredVolumeCIM;

    protected void initImpl(ConfigContext context) throws ConfigMgmtException {
        String METHOD = "initImpl";
        Trace.methodBegin(this, "initImpl");
        if (context == null) {
            Trace.error((Object)this, "initImpl", "ConfigContext object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ConfigContext object is null."), 100);
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "initImpl", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "CIMOMHandleWrapper object is null."), 100);
        }
        Trace.methodEnd(this, "initImpl");
    }

    public SortedSet getSummaryTypeInfo() {
        String METHOD = "getSummaryTypeInfo";
        Trace.methodBegin(this, "getSummaryTypeInfo");
        SortedSet summaryInfo = super.getSummaryTypeInfo();
        try {
            ArrayList comps = this.getAssociatedComponents();
            for (int i = 0; i < comps.size(); ++i) {
                MirrorComponentCIM tempComp = (MirrorComponentCIM)comps.get(i);
                if (!tempComp.getConditionInfo().contains(new Integer(20)) || !tempComp.getConditionInfo().contains(new Integer(9))) continue;
                summaryInfo.add(new Integer(1));
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getSummaryTypeInfo", "Errors obtaining mirror components.");
        }
        Trace.methodEnd(this, "getSummaryTypeInfo");
        return summaryInfo;
    }

    public int getNumberOfComponents() throws ConfigMgmtException {
        String METHOD = "getNumberOfComponents";
        Trace.methodBegin(this, "getNumberOfComponents");
        Trace.verbose((Object)this, "getNumberOfComponents", "Querying CIM for all attached SynchronizedComponent associations.");
        Enumeration syncComps = this.handle.associators(super.getInstance().getObjectPath(), "SunStorEdge_DSPSynchronizedComponent", "SunStorEdge_DSPStorageVolume", "Dependent", "Antecedent", true, false, null);
        Trace.verbose((Object)this, "getNumberOfComponents", "Returned from querying CIM for all attached SynchronizedComponent associations.");
        Trace.verbose((Object)this, "getNumberOfComponents", "Calculating and returning number of components.");
        int components = 0;
        if (syncComps != null && syncComps.hasMoreElements()) {
            while (syncComps.hasMoreElements()) {
                CIMInstance synchedElement = (CIMInstance)syncComps.nextElement();
                CIMValue val = synchedElement.getProperty("ObjectType").getValue();
                if (val != null) {
                    UnsignedInt16 type = (UnsignedInt16)val.getValue();
                    if (type.intValue() == 1) continue;
                    ++components;
                    continue;
                }
                Trace.error((Object)this, "getNumberOfComponents", "ObjectType is null.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ObjectType is null."), 100);
            }
        }
        Trace.methodEnd(this, "getNumberOfComponents");
        return components;
    }

    public ArrayList getAssociatedComponents() throws ConfigMgmtException {
        String METHOD = "getAssociatedComponents";
        Trace.methodBegin(this, "getAssociatedComponents");
        ArrayList<MirrorComponentCIM> components = new ArrayList<MirrorComponentCIM>();
        Trace.verbose((Object)this, "getAssociatedComponents", "Querying CIM for associated StorageVolume(Component) Instances");
        Enumeration enumeration = this.handle.associators(super.getInstance().getObjectPath(), "SunStorEdge_DSPSynchronizedComponent", "SunStorEdge_DSPStorageVolume", "Dependent", "Antecedent", true, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES);
        Trace.verbose((Object)this, "getAssociatedComponents", "Returned from querying CIM for associated StorageVolume (Component) Instances");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getAssociatedComponents", "StorageVolume(Component) Instances Found");
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                CIMValue cimVal = ci.getProperty("ObjectType").getValue();
                if (cimVal != null) {
                    UnsignedInt16 type = (UnsignedInt16)cimVal.getValue();
                    if (type.intValue() == 1) continue;
                    Trace.verbose((Object)this, "getAssociatedComponents", "Creating MirrorComponent Java Object");
                    MirrorComponentCIM mc = new MirrorComponentCIM();
                    mc.setInstance(ci);
                    mc.init(this.context);
                    CIMObjectWrapper.populate(mc, mc.getFieldMap(), ci);
                    mc.loadKeys();
                    components.add(mc);
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, "getAssociatedComponents", "The instance added to the list: " + mc);
                    continue;
                }
                Trace.error((Object)this, "getAssociatedComponents", "ObjectType is null.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ObjectType is null."), 100);
            }
        }
        Trace.methodEnd(this, "getAssociatedComponents");
        return components;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getAssocPropsImpl() throws ConfigMgmtException {
        String METHOD = "getAssocPropsImpl";
        Trace.methodBegin(this, "getAssocPropsImpl");
        Trace.verbose((Object)this, "getAssocPropsImpl", "Querying CIM for associated DSPStorageSettingWithHints Instance");
        Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPStorageSettingWithHints", "ManagedElement", "SettingData", true, false, null);
        Trace.verbose((Object)this, "getAssocPropsImpl", "Returned from querying CIM for associated DSPStorageSettingWithHints Instance");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getAssocPropsImpl", "DSPStorageSettingWithHints Instance Found");
            CIMInstance ci = (CIMInstance)enumeration.nextElement();
            CIMValue resilverPriorityCV = ci.getProperty("ResyncPriority").getValue();
            if (resilverPriorityCV == null) {
                Trace.error((Object)this, "getAssocPropsImpl", "ResilverPriority is null.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ResilverPriority is null."), 100);
            }
            UnsignedInt16 priority = (UnsignedInt16)resilverPriorityCV.getValue();
            this.resilverPriority = priority.intValue();
            CIMValue isolationPolicyCV = ci.getProperty("MirrorIsolation").getValue();
            if (isolationPolicyCV == null) {
                Trace.error((Object)this, "getAssocPropsImpl", "Isolation Policy is null.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Isolation Policy is null."), 100);
            }
            Boolean policy = (Boolean)isolationPolicyCV.getValue();
            this.isolationPolicy = policy.booleanValue() ? 1 : 0;
        } else {
            Trace.error((Object)this, "getAssocPropsImpl", "DSPStorageSettingWithHints not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "DSPStorageSettingWithHints not found."), 100);
        }
        Trace.methodEnd(this, "getAssocPropsImpl");
    }

    protected void getSnapComponentImpl() throws ConfigMgmtException {
        String METHOD = "getSnapComponentImpl";
        Trace.methodBegin(this, "getSnapComponentImpl");
        Enumeration enumSynchs = this.handle.references(this.getInstance().getObjectPath(), "SunStorEdge_DSPSynchronizedComponent", "Dependent", true, false, null);
        if (enumSynchs != null && enumSynchs.hasMoreElements()) {
            while (enumSynchs.hasMoreElements()) {
                CIMInstance syncComponent = (CIMInstance)enumSynchs.nextElement();
                CIMValue snapCompValue = syncComponent.getProperty("SnapshotComponent").getValue();
                if (snapCompValue != null) {
                    Boolean snapComp = (Boolean)snapCompValue.getValue();
                    if (!snapComp.booleanValue()) continue;
                    Trace.verbose((Object)this, "getSnapComponentImpl", "Found association to snapshot component");
                    CIMValue snapCompPathVal = syncComponent.getProperty("Antecedent").getValue();
                    if (snapCompPathVal != null) {
                        Trace.verbose((Object)this, "getSnapComponentImpl", "Found snap component path");
                        CIMObjectPath objPath = (CIMObjectPath)snapCompPathVal.getValue();
                        CIMInstance ci = this.handle.getInstance(objPath, false, true, false, null);
                        if (ci != null) {
                            Trace.verbose((Object)this, "getSnapComponentImpl", "Creating MirrorComponent Java Object");
                            MirrorComponentCIM mc = null;
                            mc = new MirrorComponentCIM();
                            mc.init(this.context);
                            mc.setInstance(ci);
                            CIMObjectWrapper.populate(mc, mc.getFieldMap(), ci);
                            mc.loadKeys();
                            this.snapComponent = mc;
                            Trace.methodEnd(this, "getSnapComponentImpl");
                            return;
                        }
                        Trace.error((Object)this, "getSnapComponentImpl", "Could not retrieve component from path.");
                        throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve component from path."), 100);
                    }
                    Trace.error((Object)this, "getSnapComponentImpl", "Could not retrieve component from path.");
                    throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve component from path."), 100);
                }
                Trace.error((Object)this, "getSnapComponentImpl", "SnapComponent property is null.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "SnapComponent property is null."), 100);
            }
        }
        Trace.verbose((Object)this, "getSnapComponentImpl", "Could not find any snap component.");
        Trace.methodEnd(this, "getSnapComponentImpl");
    }

    public ArrayList getLogVDisks() throws ConfigMgmtException {
        String METHOD = "getLogVDisks";
        Trace.methodBegin(this, "getLogVDisks");
        ArrayList<VDisk> vdisks = new ArrayList<VDisk>();
        Trace.verbose((Object)this, "getLogVDisks", "Querying CIM for associated StorageExtent Instances");
        Enumeration enumeration = this.handle.associators(super.getInstance().getObjectPath(), "SunStorEdge_DSPBasedOn", "SunStorEdge_DSPStorageExtent", "Dependent", "Antecedent", true, false, null);
        Trace.verbose((Object)this, "getLogVDisks", "Returned from querying CIM for associated StorageExtent Instances");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getLogVDisks", "StorageExtent Instances Found");
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                Trace.verbose((Object)this, "getLogVDisks", "Creating VDisk Java Object");
                VDisk disk = new VDisk();
                disk.setInstance(ci);
                disk.init(this.context);
                CIMObjectWrapper.populate(disk, disk.getFieldMap(), ci);
                disk.loadKeys();
                vdisks.add(disk);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getLogVDisks", "The instance added to the list: " + disk);
            }
        }
        Trace.methodEnd(this, "getLogVDisks");
        return vdisks;
    }

    public ArrayList getLogPools() throws ConfigMgmtException {
        String METHOD = "getLogPools";
        Trace.methodBegin(this, "getLogPools");
        ArrayList<StoragePoolInterface> pools = new ArrayList<StoragePoolInterface>();
        Trace.verbose((Object)this, "getLogPools", "Querying CIM for associated StorageExtent Instances");
        Enumeration enumeration = this.handle.associators(super.getInstance().getObjectPath(), "SunStorEdge_DSPBasedOn", "SunStorEdge_DSPStorageExtent", "Dependent", "Antecedent", true, false, null);
        Trace.verbose((Object)this, "getLogPools", "Returned from querying CIM for associated StorageExtent Instances");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getLogPools", "StorageExtent Instances Found");
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                Trace.verbose((Object)this, "getLogPools", "Creating VDisk Java Object");
                VDisk disk = new VDisk();
                disk.setInstance(ci);
                disk.init(this.context);
                CIMObjectWrapper.populate(disk, disk.getFieldMap(), ci);
                disk.loadKeys();
                StoragePool pool = (StoragePool)disk.getStoragePool();
                if (pools.size() == 0) {
                    pools.add(disk.getStoragePool());
                } else {
                    boolean found = false;
                    for (int i = 0; i < pools.size(); ++i) {
                        StoragePool iterPool = (StoragePool)pools.get(i);
                        if (!iterPool.getInstanceID().equals(pool.getInstanceID())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        pools.add(disk.getStoragePool());
                    }
                }
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getLogPools", "The instance added to the list: " + disk.getStoragePool());
            }
        }
        Trace.methodEnd(this, "getLogPools");
        return pools;
    }

    public MethodCallStatus createSnapshotPool(StoragePoolInterface snapPool, int snapNum, int snapChange, int snapPolicy) throws ConfigMgmtException {
        String METHOD = "createSnapshotPool";
        Trace.methodBegin(this, "createSnapshotPool");
        return this.createSnapshotPool(snapPool, snapNum, snapChange, snapPolicy, this.snapComponent);
    }

    public StoragePoolInterface getSnapshotReserveStoragePool() throws ConfigMgmtException {
        String METHOD = "getSnapshotReserveStoragePool";
        Trace.methodBegin(this, "getSnapshotReserveStoragePool");
        StoragePool pool = null;
        if (this.snapComponent == null) {
            this.getSnapshotComponent();
        }
        if (this.snapComponent == null) {
            return null;
        }
        Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "Querying CIM for associated StorageExtent through MetaBasedOn association");
        Enumeration meta_enum = this.handle.associators(this.snapComponent.getInstance().getObjectPath(), "SunStorEdge_DSPMetaBasedOn", "SunStorEdge_DSPStorageExtent", "Dependent", "Antecedent", true, false, null);
        Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "Returned from querying CIM for associated StorageExtent through MetaBasedOn association");
        if (meta_enum != null && meta_enum.hasMoreElements()) {
            Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "StorageExtent (COW) Instance Found");
            CIMInstance ci = (CIMInstance)meta_enum.nextElement();
            Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "Querying CIM for associated StoragePool through CONCRETE COMPONENT association");
            Enumeration conc_enum = this.handle.associators(ci.getObjectPath(), "SunStorEdge_DSPConcreteComponent", "SunStorEdge_DSPStoragePool", "PartComponent", "GroupComponent", true, false, null);
            Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "Returned from querying CIM for associated StoragePool through CONCRETE COMPONENT association");
            if (conc_enum != null && conc_enum.hasMoreElements()) {
                Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "StoragePool Instance Found");
                CIMInstance ci_pool = (CIMInstance)conc_enum.nextElement();
                pool = new StoragePool();
                pool.setInstance(ci_pool);
                pool.init(this.context);
                CIMObjectWrapper.populate(pool, pool.getFieldMap(), ci_pool);
                pool.loadKeys();
            }
        } else {
            Trace.verbose((Object)this, "getSnapshotReserveStoragePool", "MetadBasedOn not found.");
            if (this.getSnapshotPoolSize() > 0) {
                pool = (StoragePool)((MirrorComponentCIM)this.snapComponent).getStoragePool();
            }
        }
        Trace.methodEnd(this, "getSnapshotReserveStoragePool");
        return pool;
    }

    public void setResilverPriority(int resilverPriority) throws ConfigMgmtException {
        String METHOD = "setResilverPriority";
        Trace.methodBegin(this, "setResilverPriority");
        Trace.verbose((Object)this, "setResilverPriority", "Validating resilver priority.");
        MirroredVolumeCIM.validate(6, new Integer(resilverPriority), null);
        Trace.verbose((Object)this, "setResilverPriority", "Querying CIM for associated DSPStorageSettingWithHints Instance");
        Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPStorageSettingWithHints", "ManagedElement", "SettingData", true, false, null);
        Trace.verbose((Object)this, "setResilverPriority", "Returned from querying CIM for associated DSPStorageSettingWithHints Instance");
        if (enumeration != null && enumeration.hasMoreElements()) {
            int tempPriority;
            UnsignedInt16 p_value;
            CIMValue priorityVal;
            Trace.verbose((Object)this, "setResilverPriority", "DSPStorageSettingWithHints Instance Found");
            CIMInstance ci = (CIMInstance)enumeration.nextElement();
            if (ci != null && (priorityVal = ci.getProperty("ResyncPriority").getValue()) != null && (p_value = (UnsignedInt16)priorityVal.getValue()) != null && (tempPriority = p_value.intValue()) != resilverPriority) {
                try {
                    ci.setProperty("ResyncPriority", new CIMValue((Object)new UnsignedInt16(resilverPriority)));
                }
                catch (CIMException cime) {
                    Trace.error((Object)this, "setResilverPriority", "CIMException - Exception thrown when setting new resilver priority: " + (Object)((Object)cime));
                    throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Errors setting resilver priority.", (Exception)((Object)cime), 100);
                }
                Trace.verbose((Object)this, "setResilverPriority", "Setting resilver priority");
                this.handle.setInstance(ci.getObjectPath(), ci);
                Trace.verbose((Object)this, "setResilverPriority", "Returned from setting resilver priority");
                this.resilverPriority = tempPriority;
            }
        }
        Trace.methodEnd(this, "setResilverPriority");
    }

    public static void validate(int property, Object newValue, Object oldValue) throws ConfigMgmtException {
        String METHOD = "validate";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$ent1$cim$MirroredVolumeCIM == null ? (class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$ent1$cim$MirroredVolumeCIM = MirroredVolumeCIM.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirroredVolumeCIM")) : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$ent1$cim$MirroredVolumeCIM, "validate");
        StorageVolume.validate(property, newValue, oldValue);
        switch (property) {
            case 6: {
                if (oldValue != null) break;
                Integer resilverPriority = (Integer)newValue;
                if (resilverPriority == 64 || resilverPriority == 128 || resilverPriority == 192) {
                    return;
                }
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_RESILVER_PRIORITY, null, "Resilver Priority is invalid."), 300);
            }
            case 7: {
                if (oldValue != null) break;
                Integer isolationPolicy = (Integer)newValue;
                if (isolationPolicy == 1 || isolationPolicy == 0) {
                    return;
                }
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_ISOLATION_POLICY, null, "Isolation Policy is invalid."), 300);
            }
        }
        Trace.methodEnd(class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$ent1$cim$MirroredVolumeCIM == null ? (class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$ent1$cim$MirroredVolumeCIM = MirroredVolumeCIM.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirroredVolumeCIM")) : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$ent1$cim$MirroredVolumeCIM, "validate");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

