/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PoolProfileMergeManager {
    private static final String NO_PROFILE_FOR_THE_POOL = "error.no.profile.for.pool";
    private static final String XML_DATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String MERGED_DATA_START = "<pools-and-profiles>";
    private static final String MERGED_DATA_END = "</pools-and-profiles>";

    public static synchronized Object mergePoolsAndProfiles(Object poolData, Object profileData) throws ConfigMgmtException {
        PoolProfileMergeManager.validatePoolsAndProfiles(poolData, profileData);
        String poolsXML = (String)PoolDataManager.preprocessPoolsToStore(poolData);
        String profilesXML = (String)ProfileDataManager.preprocessProfilesToStore(profileData);
        StringBuffer buf = new StringBuffer(XML_DATA);
        buf.append(MERGED_DATA_START).append("\n");
        buf.append(profilesXML);
        buf.append(poolsXML);
        buf.append(MERGED_DATA_END);
        return buf.toString();
    }

    private static void validatePoolsAndProfiles(Object poolsData, Object profilesData) throws ConfigMgmtException {
        if (poolsData == null) {
            return;
        }
        Map<String, Profile> profileMap = new HashMap();
        if (profilesData instanceof Map) {
            profileMap = (Map)profilesData;
        } else {
            Collection list = (Collection)profilesData;
            int sz = list == null ? 0 : list.size();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Profile p = (Profile)it.next();
                String profileId = (String)p.getKey().get("id");
                profileMap.put(profileId, p);
            }
        }
        Collection pl = null;
        pl = poolsData instanceof Collection ? (Collection)poolsData : ((Map)poolsData).values();
        Iterator it = pl.iterator();
        while (it.hasNext()) {
            PoolData p = (PoolData)it.next();
            if (p.profileId != null && profileMap.get(p.profileId) != null) continue;
            throw new ConfigMgmtException(NO_PROFILE_FOR_THE_POOL, new String[]{p.poolName}, "", new Exception());
        }
    }
}

