/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class LicenseParser {
    protected Document licenseXmlDoc = null;
    private List licenses = null;
    private String arrayID = null;
    private String controllerID = null;
    private String enablerID = null;
    private StringBuffer xmlStringBuffer = null;

    public List getLicenses() {
        return this.licenses;
    }

    public String getArrayID() {
        return this.arrayID;
    }

    public String getControllerID() {
        return this.controllerID;
    }

    public String getEnablerID() {
        return this.enablerID;
    }

    public void setArrayID(String val) {
        this.arrayID = val;
    }

    public void setControllerID(String val) {
        this.controllerID = val;
    }

    public void setEnablerID(String val) {
        this.enablerID = val;
    }

    public void setLicenses(List arrays) {
        this.licenses = arrays;
    }

    public void addLicense(SingleLicense sl) {
        if (null == this.licenses) {
            this.licenses = new ArrayList();
        }
        this.licenses.add(sl);
    }

    public void parseLicense(String xml) throws ConfigMgmtException {
        String METHOD_NAME = "parseLicense";
        this.reset();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.licenseXmlDoc = db.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            Trace.error((Object)this, "parseLicense", (Throwable)e);
            throw new BadParameterException("", "license.xml.corrupt");
        }
        this.parseLicenseAttributes();
        this.parseAllLicenses();
    }

    public String generateXML() {
        this.writeStartXML();
        this.writeAddAllKeys();
        this.writeFinishXML();
        return this.xmlStringBuffer.toString();
    }

    protected void writeStartXML() {
        StringBuffer attributes = new StringBuffer();
        attributes.append(this.getFormattedAttribute("array_id", this.arrayID)).append(this.getFormattedAttribute("controller_id", this.controllerID)).append(this.getFormattedAttribute("enabler_id", this.enablerID));
        this.xmlStringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.xmlStringBuffer.append("<license_keys").append(attributes).append(">\n");
    }

    String getFormattedAttribute(String name, String Value) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ").append(name).append("=\"").append(Value).append("\"");
        return sb.toString();
    }

    protected void writeAddAllKeys() {
        if (null != this.licenses) {
            Iterator iter = this.licenses.iterator();
            SingleLicense sl = null;
            while (iter.hasNext()) {
                sl = (SingleLicense)iter.next();
                this.xmlStringBuffer.append("\t<license_key>\n").append("\t\t<version>").append(sl.version).append("</version>\n").append("\t\t<name>").append(sl.capability).append("</name>\n").append("\t\t<digest>").append(sl.digest).append("</digest>\n").append("\t</license_key>\n");
            }
        }
    }

    protected void writeFinishXML() {
        this.xmlStringBuffer.append("</license_keys>\n");
    }

    protected void parseLicenseAttributes() throws ConfigMgmtException {
        String METHOD_NAME = "parseLicenseAttributes";
        try {
            Element keys = XMLUtils.findElement(this.licenseXmlDoc.getDocumentElement(), "license_keys");
            this.arrayID = keys.getAttribute("array_id");
            this.controllerID = keys.getAttribute("controller_id");
            this.enablerID = keys.getAttribute("enabler_id");
        }
        catch (Exception e) {
            Trace.error((Object)this, "parseLicenseAttributes", (Throwable)e);
            this.reset();
            throw new BadParameterException("", "license.xml.corrupt");
        }
    }

    protected void parseAllLicenses() throws ConfigMgmtException {
        String METHOD_NAME = "parseAllLicenses";
        this.licenses = new ArrayList();
        List licenseKeys = null;
        try {
            licenseKeys = XMLUtils.listNamedChildElements(this.licenseXmlDoc.getDocumentElement(), "license_key");
            if (null != licenseKeys) {
                Iterator iter = licenseKeys.iterator();
                while (iter.hasNext()) {
                    this.licenses.add(this.getSingleLicense((Element)iter.next()));
                }
            }
        }
        catch (ConfigMgmtException cme) {
            throw cme;
        }
        catch (Exception e) {
            Trace.error((Object)this, "parseAllLicenses", (Throwable)e);
            this.reset();
            throw new BadParameterException("", "license.xml.corrupt");
        }
    }

    protected SingleLicense getSingleLicense(Element licenseElement) throws Exception {
        String METHOD_NAME = "getSingleLicense";
        SingleLicense sl = new SingleLicense();
        Element element = null;
        element = XMLUtils.findElement(licenseElement, "version");
        if (null == element) {
            Trace.error((Object)this, "getSingleLicense", "Failed getting version");
            throw new BadParameterException("", "license.xml.corrupt");
        }
        sl.version = XMLUtils.getElementValue(element);
        element = XMLUtils.findElement(licenseElement, "name");
        if (null == element) {
            Trace.error((Object)this, "getSingleLicense", "Failed getting capability");
            throw new BadParameterException("", "license.xml.corrupt");
        }
        sl.capability = XMLUtils.getElementValue(element);
        element = XMLUtils.findElement(licenseElement, "digest");
        if (null == element) {
            Trace.error((Object)this, "getSingleLicense", "Failed getting digest");
            throw new BadParameterException("", "license.xml.corrupt");
        }
        sl.digest = XMLUtils.getElementValue(element);
        return sl;
    }

    private void reset() {
        this.licenses = null;
        this.arrayID = null;
        this.controllerID = null;
        this.enablerID = null;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: LicenseParser <license xml file>");
            System.exit(1);
        }
        try {
            File xmlFile = new File(args[0]);
            FileInputStream FIS = new FileInputStream(xmlFile);
            StringBuffer contents = null;
            contents = new StringBuffer();
            boolean done = false;
            while (!done) {
                byte[] buf = new byte[1024];
                int bytesRead = FIS.read(buf);
                if (bytesRead == -1) {
                    done = true;
                    break;
                }
                contents.append(new String(buf));
            }
            String xml = contents.toString();
            xml = xml.trim();
            System.out.println(xml);
            LicenseParser lp = new LicenseParser();
            lp.parseLicense(xml);
            System.out.println("ARRAY ID      : " + lp.getArrayID());
            System.out.println("CONTROLLER ID : " + lp.getControllerID());
            System.out.println("ENABLER ID    : " + lp.getEnablerID());
            List licenses = lp.getLicenses();
            SingleLicense sl = null;
            for (int i = 0; i < licenses.size(); ++i) {
                sl = (SingleLicense)licenses.get(i);
                System.out.println("");
                System.out.println("  LICENSE      : " + i);
                System.out.println("    VERSION    : " + sl.version);
                System.out.println("    CAPABILITY : " + sl.capability);
                System.out.println("    DIGEST     : " + sl.digest);
            }
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
            e.printStackTrace();
        }
    }

    public static class SingleLicense {
        public String version = null;
        public String capability = null;
        public String digest = null;
    }

    public static interface TagCodes {
        public static final String XML_DATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        public static final String START_KEYS = "<license_keys";
        public static final String END_KEYS = "</license_keys>\n";
        public static final String START_KEY = "\t<license_key>\n";
        public static final String END_KEY = "\t</license_key>\n";
        public static final String START_VERSION = "\t\t<version>";
        public static final String END_VERSION = "</version>\n";
        public static final String START_CAPABILITY = "\t\t<name>";
        public static final String END_CAPABILITY = "</name>\n";
        public static final String START_DIGEST = "\t\t<digest>";
        public static final String END_DIGEST = "</digest>\n";
    }

    public static interface licenseXML {
        public static final String LICENSE_KEYS = "license_keys";
        public static final String LICENSE_KEY = "license_key";
        public static final String CAPABILITY = "name";
        public static final String VERSION = "version";
        public static final String DIGEST = "digest";
        public static final String ARRAY_ATTRIBUTE = "array_id";
        public static final String CONTROLLER_ATTRIBUTE = "controller_id";
        public static final String ENABLER_ATTRIBUTE = "enabler_id";
    }
}

