/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.PoolProfileMergeManager;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.DataCompresser;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.MgmtClientRecord;
import devmgr.versioned.symbol.MgmtClientRecordId;
import devmgr.versioned.symbol.MgmtClientRecordReadDescriptor;
import devmgr.versioned.symbol.MgmtClientRecordReadResult;
import devmgr.versioned.symbol.MgmtClientRecordWriteDescriptor;
import devmgr.versioned.symbol.ReturnCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DACStoreManager {
    private static final int MAX_REC_SIZE = 500;
    public static final String DEFAULT_DATA_FILE_NAME = "profiles6130.xml";
    public static final String DEFAULT_POOL_FILE_NAME = "pools6130.xml";
    public static final String DEFAULT_DATA_DIR_NAME = "/opt/SUNWse6130ui/resources";
    public static final String ALLOW_FILE_FAILOVER = "DACStore-allow-failover";
    public static final String DAC_STORE_VERSION = "DACStore-version";
    private static final int DAC_STORE_DEFAULT_VERSION = 0;
    private static final String NUMBER_OF_RECORDS = "DACStore-number-of-records";
    private String arrayId = null;
    private CommandProcessor command = null;
    private int currentDACStoreVersion = -1;
    private int dacStoreVersionExpected = 0;

    public DACStoreManager(String arrayId) throws SEItemNotFoundException, RPCError, IOException {
        this.arrayId = arrayId;
        this.command = new CommandProcessor(arrayId);
        String strDSV = (String)Repository.getRepository().getProperty(DAC_STORE_VERSION);
        if (strDSV != null) {
            try {
                this.dacStoreVersionExpected = Integer.parseInt(strDSV);
            }
            catch (Throwable t) {
                Trace.error((Object)this, "DACStoreManager", "Missconfiguration, DAC store version set as:" + strDSV);
                Trace.error((Object)this, "DACStoreManager", "Using default version 0");
                this.dacStoreVersionExpected = 0;
            }
        }
    }

    public int storeData(Object dataToStore) throws ConfigMgmtException {
        String methodName = "storeData";
        Trace.methodBegin(this, "storeData");
        this.verifyVersion();
        byte[] compressedData = DataCompresser.compress(dataToStore);
        int numOfRecords = compressedData.length / 500;
        if (compressedData.length % 500 > 0) {
            ++numOfRecords;
        }
        MgmtClientRecord[] mcr = this.createMgmtClientRecords(compressedData, numOfRecords);
        Trace.verbose((Object)this, "storeData", "MgmtRecords created - write");
        MgmtClientRecordWriteDescriptor mcrwd = new MgmtClientRecordWriteDescriptor();
        mcrwd.setRecords(mcr);
        ReturnCode rc = new ReturnCode();
        this.command.setPreferredController(null);
        this.command.execute(160, (XDRType)mcrwd, (XDRType)rc, true);
        if (rc.getValue() != 1) {
            Trace.verbose((Object)this, "storeData", "Error storing data:" + rc.getValue());
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "Write mgmt client records failed");
        }
        Trace.verbose((Object)this, "storeData", "Data stored");
        return numOfRecords;
    }

    public Map reinitilizeDACStore() throws ConfigMgmtException {
        String methodName = "reinitializeDACStore";
        Trace.methodBegin(this, "reinitializeDACStore");
        this.verifyVersion();
        HashMap<String, String> m = new HashMap<String, String>();
        Collection factoryProfiles = ProfileDataManager.getFactoryProfiles();
        Collection factoryPools = PoolDataManager.getDefaultPoolsForArray(this.arrayId);
        Object data = PoolProfileMergeManager.mergePoolsAndProfiles(factoryPools, factoryProfiles);
        int numOfRecords = this.storeData(data);
        m.put(DAC_STORE_VERSION, Integer.toString(this.dacStoreVersionExpected));
        m.put(NUMBER_OF_RECORDS, Integer.toString(numOfRecords));
        Trace.verbose((Object)this, "reinitializeDACStore", "Default data stored");
        LogAPI.staticLog((String)"DAC_STORE_REINITIALIZED", (String[])new String[]{this.arrayId}, (String[])new String[0]);
        return m;
    }

    private void verifyVersion() throws ConfigMgmtException {
        String methodName = "verifyVersion";
        if (this.currentDACStoreVersion < 0) {
            Trace.verbose((Object)this, "verifyVersion", "Get current DAC store version");
            byte[] mrb = this.getMasterRecord(this.arrayId, this.command);
            Map m = this.validateMasterRecord(mrb);
            this.currentDACStoreVersion = Integer.parseInt((String)m.get(DAC_STORE_VERSION));
        }
        Trace.verbose((Object)this, "verifyVersion", "Current DAC store version is:" + this.currentDACStoreVersion);
        Trace.verbose((Object)this, "verifyVersion", "Expected DAC store version is:" + this.dacStoreVersionExpected);
        if (this.currentDACStoreVersion > this.dacStoreVersionExpected) {
            throw new ConfigMgmtException("error.cannot.write.dac.store", new String[]{"" + this.currentDACStoreVersion, "" + this.dacStoreVersionExpected}, "Newer DAC store version found, modification is not allowed", new Exception());
        }
    }

    public Object getProfiles() throws ConfigMgmtException, RPCError, IOException {
        String methodName = "getProfiles";
        Trace.methodBegin(this, "getProfiles");
        Object map = null;
        Object data = null;
        boolean numOfRecords = false;
        Object profiles = null;
        data = this.getDACStoreData();
        try {
            if (data == null) {
                Trace.warn((Object)this, "getProfiles", "The DAC store does not contain any data.");
                Trace.warn((Object)this, "getProfiles", "Attempt to reinitialize the DAC store.");
                return this.reinitializeAndReturnDefaultProfiles();
            }
            profiles = ProfileDataManager.preprocessStoredProfiles(data);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getProfiles", cme);
            Trace.error((Object)this, "getProfiles", "Cannot process data in DAC store");
            Trace.error((Object)this, "getProfiles", "Attempt to reinitialize DAC Store");
            LogAPI.staticLog((String)"DAC_STORE_PROFILES_CORRUPTED", (String[])new String[]{this.arrayId}, (String[])new String[0]);
            return this.reinitializeAndReturnDefaultProfiles();
        }
        return profiles;
    }

    private Map validateMasterRecord(byte[] masterRecordBytes) throws ConfigMgmtException {
        String methodName = "validateMasterRecord";
        Map map = null;
        if (masterRecordBytes == null) {
            Trace.warn((Object)this, "validateMasterRecord", "The master record does not exist.");
            Trace.warn((Object)this, "validateMasterRecord", "The DAC store will be reinitialized.");
            this.currentDACStoreVersion = this.dacStoreVersionExpected;
            map = this.reinitilizeDACStore();
        } else {
            String mgmtRecord = "";
            try {
                mgmtRecord = new String(masterRecordBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                mgmtRecord = new String(masterRecordBytes);
            }
            map = Convert.keyAsStringToMap(mgmtRecord);
            String strNumOfR = (String)map.get(NUMBER_OF_RECORDS);
            String strV = (String)map.get(DAC_STORE_VERSION);
            if (strNumOfR == null || "0".equals(strNumOfR)) {
                Trace.verbose((Object)this, "validateMasterRecord", "The management record retrieved is:" + mgmtRecord);
                Trace.warn((Object)this, "validateMasterRecord", "The DAC store master record reports no data records");
                Trace.warn((Object)this, "validateMasterRecord", "The DAC store will be reinitialized");
                this.currentDACStoreVersion = this.dacStoreVersionExpected;
                map = this.reinitilizeDACStore();
                strNumOfR = (String)map.get(NUMBER_OF_RECORDS);
                strV = (String)map.get(DAC_STORE_VERSION);
            } else if (strV == null) {
                Trace.verbose((Object)this, "validateMasterRecord", "The management record retrieved is:" + mgmtRecord);
                Trace.error((Object)this, "validateMasterRecord", "The DAC store master record does not contain version");
                map.put(DAC_STORE_VERSION, Integer.toString(this.dacStoreVersionExpected));
                strNumOfR = (String)map.get(NUMBER_OF_RECORDS);
                strV = (String)map.get(DAC_STORE_VERSION);
            }
            try {
                this.currentDACStoreVersion = Integer.parseInt(strV);
                int numOfR = Integer.parseInt(strNumOfR);
            }
            catch (NumberFormatException e) {
                Trace.verbose((Object)this, "validateMasterRecord", "The management record retrieved is:" + mgmtRecord);
                Trace.error((Object)this, "validateMasterRecord", "The DAC store does not conatin a valid map");
                Trace.error((Object)this, "validateMasterRecord", "The DAC store will be reinitialized");
                this.currentDACStoreVersion = this.dacStoreVersionExpected;
                map = this.reinitilizeDACStore();
            }
        }
        return map;
    }

    public Object getPools() throws ConfigMgmtException, RPCError, IOException {
        String methodName = "getPools";
        Trace.methodBegin(this, "getPools");
        Object map = null;
        Object data = null;
        boolean numOfRecords = false;
        Object pools = null;
        data = this.getDACStoreData();
        try {
            if (data == null) {
                Trace.warn((Object)this, "getPools", "The DAC store does not contain any data.");
                Trace.warn((Object)this, "getPools", "Attempt to reinitialize the DAC store.");
                return this.reinitializeAndReturnDefaultPools();
            }
            pools = PoolDataManager.preprocessStoredPools(data);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getPools", cme);
            Trace.error((Object)this, "getPools", "Cannot process data in DAC store");
            Trace.error((Object)this, "getPools", "Attempt to reinitialize DAC Store");
            LogAPI.staticLog((String)"DAC_STORE_POOLS_CORRUPTED", (String[])new String[]{this.arrayId}, (String[])new String[0]);
            return this.reinitializeAndReturnDefaultPools();
        }
        return pools;
    }

    private Object getDACStoreData() throws ConfigMgmtException {
        byte[] byteMap = this.getMasterRecord(this.arrayId, this.command);
        Map map = this.validateMasterRecord(byteMap);
        String strNumOfR = (String)map.get(NUMBER_OF_RECORDS);
        int numOfRecords = Integer.parseInt(strNumOfR);
        int start = 1;
        int end = numOfRecords + 2;
        Object data = this.extractDataFromMgmtRecords(start, end);
        return data;
    }

    private Object reinitializeAndReturnDefaultPools() throws ConfigMgmtException {
        Map map = this.reinitilizeDACStore();
        LogAPI.staticLog((String)"DAC_STORE_POOLS_REINITIALIZED", (String[])new String[]{this.arrayId}, (String[])new String[0]);
        return PoolDataManager.preprocessStoredPools(PoolDataManager.preprocessPoolsToStore(PoolDataManager.getDefaultPoolsForArray(this.arrayId)));
    }

    private Object reinitializeAndReturnDefaultProfiles() throws ConfigMgmtException {
        Map map = this.reinitilizeDACStore();
        LogAPI.staticLog((String)"DAC_STORE_PROFILES_REINITIALIZED", (String[])new String[]{this.arrayId}, (String[])new String[0]);
        return ProfileDataManager.preprocessStoredProfiles(ProfileDataManager.preprocessProfilesToStore(ProfileDataManager.getFactoryProfiles()));
    }

    private byte[] getMasterRecord(String arrayId, CommandProcessor command) throws ConfigMgmtException {
        String methodName = "getMasterRecord";
        MgmtClientRecordReadResult mcrrr = this.getRecords(command, 0, 0);
        MgmtClientRecord[] mcr = mcrrr.getRecords();
        if (mcr != null && mcr.length > 0) {
            return mcr[0].getContent();
        }
        return null;
    }

    private Object extractDataFromMgmtRecords(int start, int end) throws ConfigMgmtException {
        String methodName = "extractDataFromMgmtRecords";
        Trace.methodBegin(this, "extractDataFromMgmtRecords");
        Object data = null;
        MgmtClientRecordReadResult result = this.getRecords(this.command, start, end);
        if (result != null && result.getRetCode().getValue() == 1) {
            Trace.verbose((Object)this, "extractDataFromMgmtRecords", "Got records back");
            MgmtClientRecord[] mcr = result.getRecords();
            byte[] compressedData = new byte[mcr.length * 500];
            int offset = 0;
            for (int i = 0; i < mcr.length; ++i) {
                byte[] content = mcr[i].getContent();
                int sz = content.length > 500 ? 500 : content.length;
                for (int j = 0; j < sz; ++j) {
                    compressedData[j + offset] = content[j];
                }
                offset += 500;
            }
            if (mcr.length != 0 && compressedData != null && compressedData.length != 0) {
                data = DataCompresser.decompress(compressedData);
            }
        }
        Trace.verbose((Object)this, "extractDataFromMgmtRecords", "Done extracting data");
        return data;
    }

    private MgmtClientRecord[] createMgmtClientRecords(byte[] compressedData, int numOfRecords) {
        String methodName = "createMgmtClientRecords";
        MgmtClientRecord[] mcr = new MgmtClientRecord[numOfRecords + 1];
        int offset = 0;
        for (int i = 0; i < numOfRecords; ++i) {
            mcr[i] = new MgmtClientRecord();
            MgmtClientRecordId mcrid = new MgmtClientRecordId();
            mcrid.setRecordNum(i + 1);
            mcr[i].setId(mcrid);
            mcr[i].setContent(this.getChunk(i, offset, compressedData));
            offset += mcr[i].getContent().length;
        }
        mcr[numOfRecords] = new MgmtClientRecord();
        MgmtClientRecordId id = new MgmtClientRecordId();
        id.setRecordNum(0);
        mcr[numOfRecords].setId(id);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DAC_STORE_VERSION, Integer.toString(this.dacStoreVersionExpected));
        map.put(NUMBER_OF_RECORDS, Integer.toString(numOfRecords));
        String mapAsString = Convert.keyToString(map);
        try {
            byte[] nrb = mapAsString.getBytes("UTF-8");
            mcr[numOfRecords].setContent(nrb);
            Trace.verbose((Object)this, "createMgmtClientRecords", "The new management record is set to:" + mapAsString + " for array:" + this.arrayId);
        }
        catch (UnsupportedEncodingException e) {
            mcr[numOfRecords].setContent(mapAsString.getBytes());
        }
        return mcr;
    }

    private byte[] getChunk(int chunkId, int offset, byte[] data) {
        byte[] chunk = new byte[500];
        if (data.length > chunkId * 500) {
            for (int i = 0; i < 500 && i + offset < data.length; ++i) {
                chunk[i] = data[i + offset];
            }
        }
        return chunk;
    }

    private MgmtClientRecordReadResult getRecords(CommandProcessor command, int start, int end) throws ConfigMgmtException {
        String methodName = "getRecords";
        Trace.methodBegin(this, "getRecords");
        MgmtClientRecordReadDescriptor mcrrd = new MgmtClientRecordReadDescriptor();
        MgmtClientRecordId riBegin = new MgmtClientRecordId();
        riBegin.setRecordNum(start);
        MgmtClientRecordId riEnd = new MgmtClientRecordId();
        riEnd.setRecordNum(end);
        mcrrd.setRangeBegin(riBegin);
        mcrrd.setRangeEnd(riEnd);
        MgmtClientRecordReadResult mcrrr = new MgmtClientRecordReadResult();
        command.setPreferredController(null);
        command.execute(161, (XDRType)mcrrd, (XDRType)mcrrr, false);
        if (mcrrr.getRetCode().getValue() != 1) {
            Trace.error((Object)this, "getRecords", "Call to get mgmt client records failed with error code:" + mcrrr.getRetCode().getValue());
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + mcrrr.getRetCode().getValue()), "error.reading.records");
        }
        Trace.verbose((Object)this, "getRecords", "Got the records!");
        return mcrrr;
    }

    private Object getProfilesFromFile() throws ConfigMgmtException {
        String methodName = "getProfilesFromFile";
        this.verifyDataDirectory();
        String fileName = "/opt/SUNWse6130ui/resources/" + this.arrayId + "/" + DEFAULT_DATA_FILE_NAME;
        if (!this.verifyFile(fileName)) {
            Collection factoryProfiles = ProfileDataManager.getFactoryProfiles();
            Object data = ProfileDataManager.preprocessProfilesToStore(factoryProfiles);
            this.storeDataToFile(data, fileName);
        }
        Trace.verbose((Object)this, "getProfilesFromFile", "Read profiles file");
        Object data = null;
        try {
            data = this.readFile(fileName);
        }
        catch (FileNotFoundException e) {
            Trace.error((Object)this, "getProfilesFromFile", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (IOException e) {
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (ClassNotFoundException e) {
            Trace.error((Object)this, "getProfilesFromFile", (Throwable)e);
        }
        return data;
    }

    private boolean verifyFile(String fileName) throws ConfigMgmtException {
        String methodName = "verifyFile";
        boolean fileHasData = true;
        File file = new File(fileName);
        try {
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    Trace.error((Object)this, "verifyFile", "Cannot create file:" + fileName);
                    throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
                }
                fileHasData = false;
            } else if (file.length() == 0L) {
                fileHasData = false;
            }
        }
        catch (IOException e) {
            Trace.error((Object)this, "verifyFile", "Cannot create directory:/opt/SUNWse6130ui/resources/" + this.arrayId);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, "/opt/SUNWse6130ui/resources/" + this.arrayId);
        }
        return fileHasData;
    }

    private void copyFile(String source, String dest) {
        if (source.equals(dest)) {
            return;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            int read = in.read();
            while (read >= 0) {
                out.write(read);
                read = in.read();
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            Trace.error((Object)this, "copyFile", (Throwable)e);
        }
    }

    private void verifyDataDirectory() throws ConfigMgmtException {
        String methodName = "verifyDataDirectory";
        if (!new File("/opt/SUNWse6130ui/resources/" + this.arrayId).exists()) {
            Trace.verbose((Object)this, "verifyDataDirectory", "Create directory for array:" + this.arrayId);
            boolean success = new File("/opt/SUNWse6130ui/resources/" + this.arrayId).mkdirs();
            if (!success) {
                Trace.error((Object)this, "verifyDataDirectory", "Cannot create directory:/opt/SUNWse6130ui/resources/" + this.arrayId);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, "/opt/SUNWse6130ui/resources/" + this.arrayId);
            }
        }
    }

    private Object getPoolsFromFile() throws ConfigMgmtException {
        String methodName = "getProfilesFromFile";
        this.verifyDataDirectory();
        String fileName = "/opt/SUNWse6130ui/resources/" + this.arrayId + "/" + DEFAULT_POOL_FILE_NAME;
        if (!this.verifyFile(fileName)) {
            Collection factoryPools = PoolDataManager.getDefaultPoolsForArray(this.arrayId);
            Object data = PoolDataManager.preprocessPoolsToStore(factoryPools);
            this.storeDataToFile(data, fileName);
        }
        Trace.verbose((Object)this, "getProfilesFromFile", "Read profiles file");
        Object data = null;
        try {
            data = this.readFile(fileName);
        }
        catch (FileNotFoundException e) {
            Trace.error((Object)this, "getProfilesFromFile", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (IOException e) {
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (ClassNotFoundException e) {
            Trace.error((Object)this, "getProfilesFromFile", (Throwable)e);
        }
        return data;
    }

    private Object readFile(String fileName) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(fileName);
        ObjectInputStream s = new ObjectInputStream(in);
        Object data = s.readObject();
        return data;
    }

    private Object processPoolExceptionWithFilesFailover(Object data, ConfigMgmtException cme) throws ConfigMgmtException {
        String methodName = "processPoolException";
        if ("PROC_UNAVAILABLE".equals(cme.getMessage())) {
            Trace.error((Object)this, "processPoolException", "The DAC store is not available - upgrade array firmware for array:" + this.arrayId);
            LogAPI.staticLog((String)"DAC_STORE_UNAVAILABLE", (String[])new String[]{this.arrayId}, (String[])new String[0]);
            String allowFiles = (String)Repository.getRepository().getProperty(ALLOW_FILE_FAILOVER);
            if (allowFiles == null || !"true".equals(allowFiles)) {
                throw cme;
            }
        } else {
            throw cme;
        }
        Trace.error((Object)this, "processPoolException", cme.getMessage());
        Trace.error((Object)this, "processPoolException", "Array does not support DAC store - failover to files");
        data = this.getPoolsFromFile();
        return data;
    }

    private void processProfileExceptionWithFileFailover(Object data, ConfigMgmtException cme) throws ConfigMgmtException {
        String methodName = "processProfileExceptionWithFileFailover";
        if ("PROC_UNAVAILABLE".equals(cme.getMessage())) {
            LogAPI.staticLog((String)"DAC_STORE_UNAVAILABLE", (String[])new String[]{this.arrayId}, (String[])new String[0]);
            String allowFiles = (String)Repository.getRepository().getProperty(ALLOW_FILE_FAILOVER);
            if (allowFiles == null || !"true".equals(allowFiles)) {
                throw cme;
            }
        } else {
            throw cme;
        }
        Trace.error((Object)this, "processProfileExceptionWithFileFailover", cme.getMessage());
        Trace.error((Object)this, "processProfileExceptionWithFileFailover", "Array does not support DAC store - failover to files");
        data = this.getProfilesFromFile();
    }

    private void storeDataToFile(Object dataToStore, String fileName) throws ConfigMgmtException {
        String methodName = "storeDataToFile";
        Trace.methodBegin(this, "storeDataToFile");
        try {
            File file = new File(fileName);
            FileOutputStream out = new FileOutputStream(file);
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(dataToStore);
            s.flush();
            s.close();
        }
        catch (IOException e) {
            Trace.error((Object)this, "storeDataToFile", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, e.getMessage());
        }
        Trace.verbose((Object)this, "storeDataToFile", "Data stored to file:" + fileName);
    }
}

