/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayRegManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.Connection;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.util.ObjectPool;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.jrpc.XDRvoid;
import devmgr.versioned.symbol.ChangeQueryDescriptor;
import devmgr.versioned.symbol.MgmtClientRecordReadResult;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithOpaqueData;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.io.IOException;
import org.apache.commons.beanutils.PropertyUtils;

public class CommandProcessor {
    public static final int MAX_TRIES = 25;
    public static final int MAX_WAIT = 500;
    public static int[] INSTANCE_ID = new int[]{0};
    public static int MAX_INSTANCE_ID = 1000;
    public static final String RETURNCODE_PROP = "returnCode";
    public static final String RETCODE_PROP = "retCode";
    String arrayId;
    String password = null;
    String[] controllers;
    String preferredController;
    boolean shouldRetry = true;
    int retryCounter = 0;
    SYMbolAPIClientV1 sym = null;
    long lastConfigGenNumber = -1L;
    int instanceId;
    int lastProcNumber = -1;
    Connection conn;
    boolean allowFailover = true;
    boolean useStorade = false;
    ArrayReg arrayReg = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CommandProcessor(String argArrayId) throws SEItemNotFoundException, RPCError, IOException {
        this.arrayId = argArrayId;
        this.arrayReg = ArrayRegManager.getInstance().getArrayRegistration(this.arrayId);
        if (this.arrayReg != null) {
            this.password = this.arrayReg.getPassword();
        }
        if (Repository.getRepository().getProperty("STORADE_SWITCH") != null && "true".equals((String)Repository.getRepository().getProperty("STORADE_SWITCH"))) {
            this.useStorade = true;
            int[] nArray = INSTANCE_ID;
            // MONITORENTER : INSTANCE_ID
            this.instanceId = INSTANCE_ID[0] > MAX_INSTANCE_ID ? 0 : INSTANCE_ID[0] + 1;
            // MONITOREXIT : nArray
        }
        this.shouldRetry = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(int procNumber, XDRType argument, XDRType result, boolean needsAuthentication) throws ConfigMgmtException {
        String methodName = "execute";
        Trace.methodBegin(this, "execute");
        this.shouldRetry = true;
        ProcedureTimeout procTimeout = new ProcedureTimeout();
        if (argument == null) {
            argument = new XDRvoid();
        }
        try {
            this.lastProcNumber = procNumber;
            Trace.verbose((Object)this, "execute", "Executing procedure:" + procNumber);
            while (this.shouldRetry) {
                if (this.conn == null) {
                    Trace.verbose((Object)this, "execute", "Get connection from the pool");
                    this.conn = (Connection)ObjectPool.getInstance().checkOut(this.arrayId, "6130");
                }
                if (this.preferredController != null) {
                    this.handlePreferredController(result);
                } else {
                    this.sym = (SYMbolAPIClientV1)this.conn.getHandle();
                    if (this.sym == null) {
                        ObjectPool.getInstance().remove(this.arrayId, this.conn);
                        this.conn = (Connection)ObjectPool.getInstance().checkOut(this.arrayId, "6130");
                        this.sym = (SYMbolAPIClientV1)this.conn.getHandle();
                        if (this.sym == null) {
                            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "");
                        }
                    }
                    this.preferredController = this.conn.getCurrentControllerRef();
                }
                if (this.sym == null) {
                    Trace.error((Object)this, "execute", "Cannot get the connection...");
                    if (!this.allowFailover) {
                        this.preferredControllerFailed(result);
                    }
                    if (result == null || this.allowFailover || !(result instanceof ReturnCode) && !(result instanceof ReturnCodeWithRef) && !(result instanceof ReturnCodeWithOpaqueData) && !(result instanceof MgmtClientRecordReadResult)) {
                        Trace.error((Object)this, "execute", "Could not get the connection to any controller - throw exception");
                        throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "");
                    }
                    return;
                }
                try {
                    if (needsAuthentication) {
                        if (this.useStorade && StoradeProxy.isLocked(this.arrayReg.getRegistrationEntryKey(), this.getUniqueObjectId())) {
                            Trace.verbose((Object)this, "execute", "Array is locked - bail");
                            this.closeConnection();
                            throw new ConfigMgmtException("error.array.locked", "");
                        }
                        Trace.verbose((Object)this, "execute", "Authorize");
                        this.conn.authorize();
                    }
                    this.sym.setTimeout(procTimeout.getProcTimeout(procNumber));
                    this.sym.call(procNumber, argument, result);
                }
                catch (RPCError ioe) {
                    if (ioe.getMessage().equals("XDR_MAX_LENGTH")) {
                        throw new ConfigMgmtException(ErrorCode.ERROR_MAX_OPTION_LENGTH.getKey(), ioe.getMessage());
                    }
                    if (ioe.getMessage().equals("ARGS_REJECTED")) {
                        throw new ConfigMgmtException("invalid.arguments", ioe.getMessage());
                    }
                    Trace.verbose((Object)this, "execute", "attempt reconnect");
                    ObjectPool.getInstance().remove(this.arrayId, this.conn);
                    this.getNewConnectionAndRetry(procNumber, argument, result, needsAuthentication);
                }
                catch (IOException ioe) {
                    Trace.verbose((Object)this, "execute", "attempt reconnect");
                    ObjectPool.getInstance().remove(this.arrayId, this.conn);
                    this.getNewConnectionAndRetry(procNumber, argument, result, needsAuthentication);
                }
                this.processResult(result);
            }
        }
        catch (IOException e) {
            ObjectPool.getInstance().remove(this.arrayId, this.conn);
            this.conn = null;
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (RPCError e) {
            if (e.getMessage().equals("XDR_MAX_LENGTH")) {
                throw new ConfigMgmtException(ErrorCode.ERROR_MAX_OPTION_LENGTH.getKey(), e.getMessage());
            }
            ObjectPool.getInstance().remove(this.arrayId, this.conn);
            this.conn = null;
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (NullPointerException npe) {
            if (this.allowFailover) {
                this.preferredController = null;
            }
            try {
                ObjectPool.getInstance().remove(this.arrayId, this.conn);
                this.getNewConnectionAndRetry(procNumber, argument, result, needsAuthentication);
            }
            catch (Exception e) {
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
            }
        }
        finally {
            this.retryCounter = 0;
            this.closeConnection();
        }
        Trace.verbose((Object)this, "execute", "Execute complete");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlePreferredController(XDRType result) throws ConfigMgmtException {
        String methodName = "handlePreferredController";
        Trace.methodBegin(this, "handlePreferredController");
        if (!this.conn.getCurrentControllerRef().equals(this.preferredController)) {
            try {
                this.sym = this.conn.getHandleToOtherController();
                Trace.verbose((Object)this, "handlePreferredController", "Connected - verify controller again");
                if (!this.conn.getCurrentControllerRef().equals(this.preferredController) && !this.allowFailover) {
                    throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "");
                }
                this.preferredController = this.conn.getCurrentControllerRef();
                return;
            }
            catch (ConfigMgmtException cmex) {
                Trace.verbose((Object)this, "handlePreferredController", "Preferred controller is set, but cannot connect to it.");
                ObjectPool.getInstance().remove(this.arrayId, this.conn);
                this.preferredControllerFailed(result);
                if (this.allowFailover) {
                    Trace.verbose((Object)this, "handlePreferredController", "Failover is allowed - attempt new connection to any controller");
                    this.conn = (Connection)ObjectPool.getInstance().checkOut(this.arrayId, "6130");
                    this.sym = (SYMbolAPIClientV1)this.conn.getHandle();
                    if (this.sym != null) return;
                    Trace.error((Object)this, "handlePreferredController", "The connection to the array cannot be obtained.");
                    throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "");
                }
                Trace.verbose((Object)this, "handlePreferredController", "Failover is not allowed");
                this.sym = null;
                if (!(result instanceof ReturnCode) && !(result instanceof ReturnCodeWithRef) && !(result instanceof ReturnCodeWithOpaqueData) && !(result instanceof MgmtClientRecordReadResult)) throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "");
                this.preferredControllerFailed(result);
                return;
            }
        } else {
            this.sym = (SYMbolAPIClientV1)this.conn.getHandle();
            this.preferredController = this.conn.getCurrentControllerRef();
        }
    }

    private void processResult(XDRType result) throws IOException, RPCError {
        int returnCode = 0;
        if (result instanceof ReturnCode) {
            returnCode = ((ReturnCode)result).getValue();
        } else if (!(result instanceof XDRvoid)) {
            try {
                returnCode = ((ReturnCode)PropertyUtils.getProperty((Object)result, (String)RETURNCODE_PROP)).getValue();
            }
            catch (Exception e1) {
                try {
                    returnCode = ((ReturnCode)PropertyUtils.getProperty((Object)result, (String)RETCODE_PROP)).getValue();
                }
                catch (Exception e2) {
                    Trace.verbose((Object)this, "processResult", "no ReturnCode for SYMclient result: " + result);
                    Trace.verbose((Object)this, "processResult - no ReturnCode prop exception: ", e1.getMessage());
                    Trace.verbose((Object)this, "processResult - no RetCode prop exception: ", e2.getMessage());
                }
            }
        }
        this.setReturnCode(returnCode);
    }

    private void preferredControllerFailed(XDRType result) {
        if (result instanceof ReturnCode) {
            ((ReturnCode)result).setValue(13);
        } else if (result instanceof ReturnCodeWithRef) {
            ((ReturnCodeWithRef)result).getReturnCode().setValue(13);
        } else if (result instanceof ReturnCodeWithOpaqueData) {
            ((ReturnCodeWithOpaqueData)result).getReturnCode().setValue(13);
        } else if (result instanceof MgmtClientRecordReadResult) {
            ((MgmtClientRecordReadResult)result).getRetCode().setValue(13);
        }
    }

    private void getNewConnectionAndRetry(int procNumber, XDRType argument, XDRType result, boolean needsAuthentication) throws IOException, RPCError, ConfigMgmtException {
        String methodName = "getNewConnectionAndRetry";
        Trace.methodBegin(this, "getNewConnectionAndRetry");
        int sz = ObjectPool.getInstance().getPoolSize("6130") + 1;
        while (this.shouldRetry && sz >= 0) {
            try {
                this.conn = (Connection)ObjectPool.getInstance().checkOut(this.arrayId, "6130");
                if (this.preferredController != null) {
                    this.handlePreferredController(result);
                    if (this.sym == null) {
                        Trace.verbose((Object)this, "getNewConnectionAndRetry", "Cannot get to the preferred controller");
                        ObjectPool.getInstance().remove(this.arrayId, this.conn);
                        this.conn = null;
                        --sz;
                        continue;
                    }
                }
                if (needsAuthentication) {
                    this.conn.authorize();
                }
                this.sym = (SYMbolAPIClientV1)this.conn.getHandle();
                this.sym.call(procNumber, argument, result);
                this.processResult(result);
            }
            catch (IOException ioe) {
                ObjectPool.getInstance().remove(this.arrayId, this.conn);
                if (--sz < 0) {
                    throw ioe;
                }
                this.conn = null;
            }
            catch (RPCError rpc) {
                ObjectPool.getInstance().remove(this.arrayId, this.conn);
                if (--sz < 0) {
                    throw rpc;
                }
                this.conn = null;
            }
            catch (NullPointerException npe) {
                ObjectPool.getInstance().remove(this.arrayId, this.conn);
                this.conn = null;
                --sz;
                if (!this.allowFailover) continue;
                this.preferredController = null;
            }
        }
        if (sz < 0) {
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "");
        }
    }

    private void closeConnection() {
        String methodName = "closeConnection";
        if (this.conn != null) {
            ObjectPool.getInstance().checkIn(this.arrayId, this.conn);
            this.conn = null;
        }
    }

    public void setReturnCode(int retCode) throws IOException, RPCError {
        String methodName = "setReturnCode";
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "setReturnCode", "Setting return code:" + retCode + " with retry counter:" + this.retryCounter);
        }
        this.shouldRetry = false;
        switch (retCode) {
            case 29: {
                long latestNum = this.getCurrentConfigNumber();
                this.shouldRetry = ++this.retryCounter < 25 && this.lastConfigGenNumber != latestNum;
                this.lastConfigGenNumber = latestNum;
                this.retryWait();
                break;
            }
            case 13: {
                boolean bl = this.shouldRetry = ++this.retryCounter < 25;
                if (this.lastProcNumber == 7) {
                    Trace.verbose((Object)this, "setReturnCode", "Do not force controller during volume creation");
                    this.shouldRetry = false;
                    return;
                }
                try {
                    this.sym = this.conn.getHandleToOtherController();
                    this.preferredController = this.conn.getCurrentControllerRef();
                }
                catch (ConfigMgmtException e) {
                    Trace.verbose((Object)this, "setReturnCode", "Requested alternate controller is not available");
                    this.shouldRetry = false;
                }
                break;
            }
            case 3: {
                this.shouldRetry = ++this.retryCounter < 25;
                this.retryWait();
                break;
            }
            default: {
                this.shouldRetry = false;
            }
        }
    }

    private void retryWait() {
        String methodName = "retryWait";
        if (this.retryCounter > 2) {
            Trace.verbose((Object)this, "retryWait", "Controller must be busy - sleep a little");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public long getCurrentConfigNumber() throws IOException, RPCError {
        ChangeQueryDescriptor chgQuery = new ChangeQueryDescriptor();
        chgQuery.getLastKnown().setConfigGeneration(this.lastConfigGenNumber);
        chgQuery.getLastKnown().setLastCriticalMelSeqNumber(-1L);
        chgQuery.setMaxWait(0);
        if (this.sym == null) {
            if (this.conn != null) {
                ObjectPool.getInstance().remove(this.arrayId, this.conn);
            }
            this.conn = (Connection)ObjectPool.getInstance().checkOut(this.arrayId, "6130");
            this.sym = (SYMbolAPIClientV1)this.conn.getHandle();
            if (this.sym == null) {
                Trace.error((Object)this, "getCurrentConfigNumber", "cannot connect to the array");
                throw new IOException("cannot connect to the array");
            }
        }
        this.sym.setTimeout(10);
        return this.sym.getChangeState(chgQuery).getConfigGeneration();
    }

    public void setPreferredController(String controllerRef) throws SEItemNotFoundException {
        this.preferredController = controllerRef;
    }

    public void setLock(int lockDuration, String lockDescription) throws ConfigMgmtException {
        if (this.useStorade) {
            StoradeProxy.lockResource(this.arrayReg.getResourceName(), this.getUniqueObjectId(), lockDescription, lockDuration);
        }
    }

    public void releaseLock() throws ConfigMgmtException {
        if (this.useStorade) {
            StoradeProxy.unlockResource(this.arrayReg.getResourceName());
        }
    }

    private String getUniqueObjectId() {
        String id = super.toString() + "." + this.instanceId;
        return id;
    }

    public boolean isAllowFailover() {
        return this.allowFailover;
    }

    public void setAllowFailover(boolean allowFailover) {
        this.allowFailover = allowFailover;
    }
}

