/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl;

import com.sun.netstorage.array.mgmt.cfg.core.StorageHealthInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.StorageHealth;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.fm.storade.client.SAClient;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.alarm.AlarmCounts;
import com.sun.netstorage.fm.storade.service.alarm.AlarmQueryService;
import com.sun.netstorage.fm.storade.service.alarm.AlarmSummary;
import com.sun.netstorage.fm.storade.service.device.DeviceMaintenanceService;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.storade.service.lock.LockInfo;
import com.sun.netstorage.fm.storade.service.lock.LockManagerService;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StoradeProxy {
    public static String APP_NAME = "SUN StorEdge6130 Configuration Service";
    public static String LOCK_DESCRIPTION = "Configuration";
    public static String LOCALHOST = "localhost";
    public static String USERNAME = "EM";
    public static int LOCK_DURATION = 60;
    public static int WAIT_FOR_LOCK = 5;
    private static String EM_ARRAY_WWN = "said";
    public static final String STORADE_URL_PARAM = "custom-storade-url";
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy;

    public static List getArrayRegistrations(String arrayRegType) throws ConfigMgmtException {
        String methodName = "getArrayRegistrations";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations");
        ArrayList<ArrayReg> registrations = new ArrayList<ArrayReg>();
        try {
            DeviceProperties filter = new DeviceProperties();
            filter.setActive(true);
            filter.setType(arrayRegType);
            if (Repository.getRepository().getProperty(STORADE_URL_PARAM) == null) {
                filter.setHost(LOCALHOST);
            }
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations", "Connect to storade");
            SAClient client = StoradeProxy.getSAClient();
            DeviceMaintenanceService dms = client.getDeviceMaintenanceService();
            DeviceProperties[] dp = dms.getDeviceList(filter);
            int sz = dp == null ? 0 : dp.length;
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations", "Number of registered arrays:" + sz);
            for (int i = 0; i < sz; ++i) {
                ArrayReg ar = new ArrayReg();
                ar.type = "6130";
                ar.wwn = StoradeProxy.formatWWN(dp[i].getProperty(EM_ARRAY_WWN));
                ar.resourceName = dp[i].getName();
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations", "Set resource name:" + ar.resourceName);
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations", "For array:" + ar.wwn);
                ar.password = dp[i].getPassword();
                if (ar.password == null) {
                    ar.password = "";
                }
                StoradeProxy.fillIPs(dp[i], ar);
                ar.nodeName = dp[i].getWWN();
                ar.registrationEntryKey = dp[i].getKey();
                if (Trace.isTraceEnabled(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy)) {
                    Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations", "Got registration:" + ar);
                }
                registrations.add(ar);
            }
        }
        catch (StoradeException e1) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations", (Throwable)e1);
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations", (Throwable)me);
        }
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getArrayRegistrations", "Done");
        return registrations;
    }

    private static SAClient getSAClient() throws MalformedURLException {
        SAClient client = null;
        if (Repository.getRepository().getProperty(STORADE_URL_PARAM) != null) {
            String url = (String)Repository.getRepository().getProperty(STORADE_URL_PARAM);
            URI agent = null;
            try {
                agent = new URI(url);
                String userInfo = "root:solaris";
                agent = new URI(agent.getScheme(), userInfo, agent.getHost(), agent.getPort(), agent.getPath(), agent.getQuery(), agent.getFragment());
            }
            catch (URISyntaxException e) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getSAClient", (Throwable)e);
            }
            client = new SAClient(agent.toURL());
        } else {
            client = new SAClient();
        }
        return client;
    }

    private static String formatWWN(String SAwwn) {
        String methodName = "formatWWN";
        String formattedWWN = SAwwn;
        if (SAwwn != null && SAwwn.indexOf(":") < 0) {
            char[] wwn = SAwwn.toCharArray();
            int sz = wwn.length + wwn.length / 2 - 1;
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "formatWWN", "Formatted length should be:" + sz);
            char[] fWWN = new char[sz];
            int x = 0;
            for (int i = 0; i < wwn.length; ++i) {
                fWWN[x++] = wwn[i];
                if ((i + 1) % 2 != 0 || i + 1 >= wwn.length) continue;
                fWWN[x++] = ":".charAt(0);
            }
            formattedWWN = new String(fWWN);
        }
        return formattedWWN;
    }

    public static void addRegistration(ArrayReg ar) throws ConfigMgmtException {
        String methodName = "addRegistration";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "addRegistration");
        try {
            DeviceProperties dp = StoradeProxy.fillDeviceProperties(ar, false);
            SAClient client = StoradeProxy.getSAClient();
            DeviceMaintenanceService dms = client.getDeviceMaintenanceService();
            if (Trace.isTraceEnabled(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy)) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "addRegistration", "Register with DeviceProperties:" + dp);
            }
            dp = dms.addDevice(dp);
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "addRegistration", "Registration added:" + dp);
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "addRegistration", (Throwable)e);
            throw new ConfigMgmtException("error.storade." + e.getMessage(), "error.storade.message");
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "addRegistration", (Throwable)me);
        }
    }

    public static void removeRegistration(ArrayReg ar) throws ConfigMgmtException {
        String methodName = "removeRegistration";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "removeRegistration");
        try {
            SAClient client = StoradeProxy.getSAClient();
            DeviceMaintenanceService dms = client.getDeviceMaintenanceService();
            dms.removeDevice(ar.registrationEntryKey);
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "removeRegistration", "Registration removed");
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "removeRegistration", e.getMessage());
            throw new ConfigMgmtException((Exception)((Object)e));
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "removeRegistration", (Throwable)me);
        }
    }

    public static void updateRegistration(ArrayReg ar) throws ConfigMgmtException {
        String methodName = "updateRegistration";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "updateRegistration");
        try {
            DeviceProperties dp = StoradeProxy.fillDeviceProperties(ar, true);
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "updateRegistration", "Updating registration with following properties:" + dp);
            SAClient client = StoradeProxy.getSAClient();
            DeviceMaintenanceService dms = client.getDeviceMaintenanceService();
            dms.updateDeviceProperties(dp);
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "updateRegistration", "Registration updated");
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "updateRegistration", e.getMessage());
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "updateRegistration", (Throwable)e);
            throw new ConfigMgmtException("error.storade." + e.getMessage(), "error.storade.message");
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "updateRegistration", (Throwable)me);
        }
    }

    private static DeviceProperties fillDeviceProperties(ArrayReg ar, boolean modify) throws StoradeException {
        String methodName = "fillDeviceProperties";
        DeviceProperties dp = StoradeProxy.getDeviceProperties(ar, modify);
        if (ar.directIps != null && ar.directIps.length > 0 && ar.directIps[0] != null) {
            dp.setIPNumber(ar.directIps[0]);
            if (modify) {
                dp.setIP(ar.directIps[0]);
            }
        }
        if (ar.directIps != null && ar.directIps.length > 1 && ar.directIps[1] != null) {
            dp.setAlternateIPNumber(ar.directIps[1]);
            if (modify) {
                try {
                    dp.setAlternateIPAddress(ar.directIps[1]);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
        }
        if (ar.proxyIps != null) {
            dp.setManagementAddresses(ar.proxyIps);
        }
        dp.setKey(ar.registrationEntryKey);
        if (ar.password == null) {
            ar.password = "";
        }
        dp.setPassword(ar.password);
        dp.setType("6130");
        String wwn = ar.wwn.replaceAll("\\:", "");
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "fillDeviceProperties", "WWN:" + wwn);
        if (ar.nodeName != null) {
            dp.setWWN(ar.nodeName.replaceAll("\\:", ""));
        }
        dp.setProperty("said", wwn);
        dp.setClass("storage.6130");
        return dp;
    }

    public static DeviceProperties getDeviceProperties(ArrayReg ar, boolean modify) throws StoradeException {
        String methodName = "getDeviceProperties";
        DeviceProperties dp = null;
        if (!modify) {
            dp = new DeviceProperties();
        } else {
            try {
                SAClient client = StoradeProxy.getSAClient();
                DeviceMaintenanceService dms = client.getDeviceMaintenanceService();
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getDeviceProperties", "Search for device with reg. entry key:" + ar.registrationEntryKey);
                dp = dms.getDeviceProperties(ar.registrationEntryKey);
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getDeviceProperties", "Found device properties for update:" + dp);
            }
            catch (MalformedURLException me) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getDeviceProperties", (Throwable)me);
            }
        }
        return dp;
    }

    private static String[] fillIPs(DeviceProperties dp, ArrayReg ar) {
        String methodName = "fillIPs";
        ArrayList<String> ips = new ArrayList<String>();
        if (dp.getIPNumber() != null) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "fillIPs", "ethernet mgmt path detected in registration:" + dp.getIPNumber());
            ips.add(dp.getIPNumber());
        }
        if (dp.getAlternateIPNumber() != null) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "fillIPs", "alternate ethernet mgmt path detected in registration:" + dp.getAlternateIPNumber());
            ips.add(dp.getAlternateIPNumber());
        }
        if (!ips.isEmpty()) {
            ar.directIps = new String[ips.size()];
            for (int i = 0; i < ips.size(); ++i) {
                ar.directIps[i] = (String)ips.get(i);
            }
        }
        String[] sips = dp.getManagementAddresses();
        ar.proxyIps = sips;
        int sz = sips == null ? 0 : sips.length;
        for (int i = 0; i < sz; ++i) {
            if (ips.contains(sips[i])) continue;
            ips.add(sips[i]);
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "fillIPs", "Adding mgm path:" + sips[i]);
        }
        sz = ips == null ? 0 : ips.size();
        String[] saIPs = new String[sz];
        for (int i = 0; i < sz; ++i) {
            saIPs[i] = (String)ips.get(i);
        }
        ar.ips = saIPs;
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "fillIPs", "Done");
        return saIPs;
    }

    public static Map getAlarms() throws ConfigMgmtException {
        String methodName = "getAlarms";
        HashMap<String, StorageHealth> shMap = new HashMap<String, StorageHealth>();
        try {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", "Connect to storade");
            SAClient saClient = StoradeProxy.getSAClient();
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", "Get alarms");
            AlarmQueryService aqs = saClient.getAlarmQueryService();
            AlarmSummary[] as = aqs.getAlarms();
            block9: for (int i = 0; i < as.length; ++i) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", "Device key:" + as[i].getDeviceKey());
                StorageHealth sh = (StorageHealth)shMap.get(as[i].getDeviceKey());
                if (sh == null) {
                    sh = new StorageHealth();
                    sh.setCriticalCount(0);
                    sh.setDownCount(0);
                    sh.setMajorCount(0);
                    sh.setMinorCount(0);
                    sh.setName(as[i].getDeviceName());
                    sh.setObjectItemType(as[i].getDeviceType());
                    sh.setWwn(as[i].getDeviceKey());
                    HashMap<String, String> key = new HashMap<String, String>();
                    key.put("AlarmCountDate", as[i].getDate() + "_" + as[i].getId());
                    sh.setKey(key);
                    shMap.put(as[i].getDeviceKey(), sh);
                }
                switch (as[i].getSeverity()) {
                    case 3: {
                        sh.setCriticalCount(sh.getCriticalCount() + 1);
                        continue block9;
                    }
                    case 2: {
                        sh.setMajorCount(sh.getMajorCount() + 1);
                        continue block9;
                    }
                    case 1: {
                        sh.setMinorCount(sh.getMinorCount() + 1);
                        continue block9;
                    }
                    case 4: {
                        sh.setDownCount(sh.getDownCount() + 1);
                    }
                }
            }
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", (Throwable)e);
            throw new ConfigMgmtException((Exception)((Object)e));
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", (Throwable)me);
        }
        return shMap;
    }

    public static StorageHealthInterface getAlarms(ArrayReg ar) throws ConfigMgmtException {
        String methodName = "getAlarms";
        StorageHealth sh = new StorageHealth();
        try {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", "Connect to storade");
            SAClient saClient = StoradeProxy.getSAClient();
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", "Get alarms");
            AlarmQueryService aqs = saClient.getAlarmQueryService();
            AlarmCounts ac = null;
            if (ar != null) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", "Get alarms for:" + ar.registrationEntryKey);
                ac = aqs.getAlarmCounts("6130:" + ar.registrationEntryKey);
            } else {
                ac = aqs.getAlarmCounts();
            }
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", "Alarms retrieved - set values");
            sh.setCriticalCount(ac.getCritical());
            sh.setDownCount(ac.getDown());
            sh.setMajorCount(ac.getMajor());
            sh.setMinorCount(ac.getMinor());
            if (Trace.isTraceEnabled(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy)) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", sh.toString());
            }
            HashMap<String, String> key = new HashMap<String, String>();
            key.put("AlarmCountDate", "" + ac.getDate().getTime());
            sh.setKey(key);
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", (Throwable)e);
            throw new ConfigMgmtException((Exception)((Object)e));
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getAlarms", (Throwable)me);
        }
        return sh;
    }

    public static boolean isLocked(String resourceName) throws ConfigMgmtException {
        String methodName = "isLocked";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked");
        boolean isLocked = false;
        try {
            SAClient saClient = StoradeProxy.getSAClient();
            LockManagerService lms = saClient.getLockManagerService();
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked", "Check resource:" + resourceName);
            isLocked = lms.isLocked(resourceName);
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked", "Is resource locked:" + isLocked);
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)e);
            throw new ConfigMgmtException((Exception)((Object)e));
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked", (Throwable)me);
        }
        return isLocked;
    }

    public static boolean isLocked(String resourceName, String lockingObject) throws ConfigMgmtException {
        String methodName = "isLocked";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked");
        boolean isLocked = false;
        try {
            SAClient saClient = StoradeProxy.getSAClient();
            LockManagerService lms = saClient.getLockManagerService();
            isLocked = lms.isLocked(resourceName);
            if (isLocked) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked", "Array is locked - check who locked it");
                LockInfo li = lms.getLockInfo(resourceName);
                if (li.getApplication() != null && APP_NAME.equals(li.getApplication())) {
                    Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked", "Locked by this application");
                    if (li.getUser() != null && lockingObject != null && lockingObject.equals(li.getUser())) {
                        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked", "Passed in object locked it - act as if the array is not locked");
                        isLocked = false;
                    }
                }
            }
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked", "Is resource locked:" + isLocked);
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)e);
            throw new ConfigMgmtException((Exception)((Object)e));
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "isLocked", (Throwable)me);
        }
        return isLocked;
    }

    public static void lockResource(String key) throws ConfigMgmtException {
        StoradeProxy.lockResource(key, USERNAME, LOCK_DESCRIPTION, LOCK_DURATION);
    }

    public static void lockResource(String key, String lockingObject, String description, int lockDuration) throws ConfigMgmtException {
        String methodName = "lockResource";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource");
        try {
            SAClient saClient = StoradeProxy.getSAClient();
            LockManagerService lms = saClient.getLockManagerService();
            String myIp = InetAddress.getLocalHost().getHostAddress();
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource", "Set lock from IP:" + myIp);
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource", "For resource:" + key);
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource", "For user:" + lockingObject);
            boolean lockSuccess = lms.lock(key, APP_NAME, description, myIp, lockingObject, lockDuration, WAIT_FOR_LOCK);
            if (!lockSuccess) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource", "Failed to lock resource:" + key);
                throw new ConfigMgmtException("error.failed.to.lock", "Lock was not established ");
            }
        }
        catch (UnknownHostException uhe) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)uhe);
            throw new ConfigMgmtException(uhe);
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)e);
            throw new ConfigMgmtException((Exception)((Object)e));
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource", (Throwable)me);
        }
    }

    public static void unlockResource(String key) throws ConfigMgmtException {
        StoradeProxy.unlockResource(key, USERNAME);
    }

    public static void unlockResource(String key, String username) throws ConfigMgmtException {
        String methodName = "lockResource";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource");
        try {
            SAClient saClient = StoradeProxy.getSAClient();
            LockManagerService lms = saClient.getLockManagerService();
            String myIp = InetAddress.getLocalHost().getHostAddress();
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource", "Unlock from IP:" + myIp);
            lms.unlock(key, APP_NAME, username);
        }
        catch (UnknownHostException uhe) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)uhe);
            throw new ConfigMgmtException(uhe);
        }
        catch (StoradeException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)e);
            throw new ConfigMgmtException((Exception)((Object)e));
        }
        catch (MalformedURLException me) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = StoradeProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "lockResource", (Throwable)me);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

