/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCodeType;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayRegManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.Broadcaster;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MonitorThread;
import com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.DACStoreManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.PoolProfileMergeManager;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManagePerfMonitors;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ObjectPool;
import devmgr.versioned.jrpc.RPCAuthGenerator;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.jrpc.XDRvoid;
import devmgr.versioned.symbol.AccessibleController;
import devmgr.versioned.symbol.ChangeQueryDescriptor;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ControllerTime;
import devmgr.versioned.symbol.DiscoveryResponse;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.SYMbolAuthGenerator;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectBundleManager {
    private int MAX_LOADER_THREADS = 15;
    private int REDUCE_CACHE_TIME_THRESHOLD_THREADS = 25;
    private HashMap arrayWWNIPsMap = new HashMap();
    private HashMap nameIPMap = new HashMap();
    private HashMap ipWWNMap = new HashMap();
    private HashMap _arrayWWNIPsMap = new HashMap();
    private HashMap _nameIPMap = new HashMap();
    private HashMap _ipWWNMap = new HashMap();
    MonitorThread monitorThread = null;
    ThreadLoadAllArrays loadAllArraysThread = null;
    private HashMap allMTs = null;
    private HashMap sickArrays = null;
    private ArrayList goodIPs = null;
    private static ObjectBundleManager mgr = null;
    private long lastAlarmRequestTime = 0L;
    private Map alarmsMap = null;
    private List allArraysSummaryData;
    public Hashtable volumeCreationMap = new Hashtable();
    public static final String UNKNOWN_ARRAY_NAME_KEY = "array.name.unknown";
    public static final String UNKNOWN_ARRAY_CAPACITY = "-1";
    public static final String DEFAULT_ARRAY_PASSWORD = "";
    public static final String UNNAMED_ARRAY_STRING = "array.no.name";
    public static int ARRAY_RESPONSE_WAIT = 5000;
    public static int ARRAY_LOAD_WAIT = 40000;
    public static String ARRAY_RESPONSE_WAIT_PARAM = "array-response-wait";
    public static String ARRAY_LOAD_WAIT_PARAM = "array-load-wait";
    public static long ALARMS_REFRESH_RATE = 180000L;
    private boolean CACHE_ARRAY_SUMMARY_DATA = false;
    private static String CACHE_ARRAY_SUMMARY_DATA_PARAM = "cache-array-summary-data";

    private ObjectBundleManager() {
        Trace.constructor(this);
        List regArrays = ArrayRegManager.getInstance().getRegisteredArrays("6130");
        this.goodIPs = new ArrayList();
        if (Repository.getRepository().getProperty(CACHE_ARRAY_SUMMARY_DATA_PARAM) != null) {
            this.CACHE_ARRAY_SUMMARY_DATA = Boolean.valueOf((String)Repository.getRepository().getProperty(CACHE_ARRAY_SUMMARY_DATA_PARAM));
        }
        if (Repository.getRepository().getProperty(ARRAY_RESPONSE_WAIT_PARAM) != null) {
            try {
                ARRAY_RESPONSE_WAIT = Integer.parseInt((String)Repository.getRepository().getProperty(ARRAY_RESPONSE_WAIT_PARAM));
                Trace.verbose((Object)this, "ObjectBundleManager", "Array response time is set to:" + ARRAY_RESPONSE_WAIT);
            }
            catch (Throwable e) {
                Trace.error((Object)this, "ObjectBundleManager", "ARRAY RESPONSE WAIT parameter is invalid, using defaults");
            }
            if (Repository.getRepository().getProperty(ARRAY_LOAD_WAIT_PARAM) != null) {
                try {
                    ARRAY_LOAD_WAIT = Integer.parseInt((String)Repository.getRepository().getProperty(ARRAY_LOAD_WAIT_PARAM));
                }
                catch (Throwable t) {
                    Trace.error((Object)this, "ObjectBundleManager", "ARRAY LOAD WAIT parameter is invalid, using default");
                }
            }
        }
        this.allArraysSummaryData = this.mapArrays(regArrays);
    }

    public static synchronized ObjectBundleManager getInstance() {
        if (mgr == null) {
            mgr = new ObjectBundleManager();
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List mapArrays(List regArrays) {
        String methodName = "mapArrays";
        int size = regArrays == null ? 0 : regArrays.size();
        Trace.verbose((Object)this, "mapArrays", "Attempt to map:" + size + " arrays");
        this._arrayWWNIPsMap = new HashMap();
        this._nameIPMap = new HashMap();
        this._ipWWNMap = new HashMap();
        if (this.allMTs == null) {
            this.allMTs = new HashMap(20);
        }
        this.sickArrays = new HashMap();
        ArrayList<com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray> arrayDataList = new ArrayList<com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray>(size);
        ArrayList tblList = new ArrayList(size);
        int startIndex = 0;
        while (size > 0) {
            int numOfThreads = size > this.MAX_LOADER_THREADS ? this.MAX_LOADER_THREADS : size;
            tblList = new ArrayList(numOfThreads);
            this.startBundleLoaderThreads(regArrays, numOfThreads, startIndex, tblList);
            ArrayList results = new ArrayList(numOfThreads);
            this.waitForLoaderThreads(results, tblList, false);
            size -= numOfThreads;
            for (int i = 0; i < numOfThreads; ++i) {
                ThreadBundleLoader lTbl = (ThreadBundleLoader)results.get(i);
                SYMbolAPIClientV1 sym = lTbl.getClient();
                ArrayReg ar = lTbl.getArrayReg();
                ObjectBundle bundle = lTbl.getBundle();
                ControllerTime controllerTime = lTbl.getControllerTime();
                if (bundle != null) {
                    SAData saData = null;
                    saData = bundle.getSa().getSaData();
                    if (saData != null) {
                        this.mapOneArray(ar, saData);
                        arrayDataList.add(this.loadSummaryData(ar, controllerTime, bundle, lTbl.isPasswordValid()));
                    } else {
                        Trace.verbose((Object)this, "mapArrays", "Array is sick:" + ar.ips[0]);
                        this.loadUnhealthyArray(ar, 13, arrayDataList);
                    }
                }
                try {
                    if (sym == null) continue;
                    sym.close();
                    continue;
                }
                catch (IOException e1) {
                    Trace.error((Object)this, (Throwable)e1);
                    continue;
                }
                catch (Exception e) {
                    Trace.verbose((Object)this, "mapArrays", "Failed to close connection?");
                }
            }
            startIndex += numOfThreads;
        }
        HashMap hashMap = this.arrayWWNIPsMap;
        synchronized (hashMap) {
            this.arrayWWNIPsMap = this._arrayWWNIPsMap;
            this._arrayWWNIPsMap = null;
        }
        hashMap = this.ipWWNMap;
        synchronized (hashMap) {
            this.ipWWNMap = this._ipWWNMap;
            this._ipWWNMap = null;
        }
        hashMap = this.nameIPMap;
        synchronized (hashMap) {
            this.nameIPMap = this._nameIPMap;
            this._nameIPMap = null;
        }
        return arrayDataList;
    }

    public synchronized Map getAlarms() throws ConfigMgmtException {
        long ct = System.currentTimeMillis();
        if (ct - this.lastAlarmRequestTime >= ALARMS_REFRESH_RATE) {
            if (Repository.getRepository().getProperty("STORADE_SWITCH") != null && Boolean.TRUE.toString().equals((String)Repository.getRepository().getProperty("STORADE_SWITCH"))) {
                this.alarmsMap = StoradeProxy.getAlarms();
            }
            this.lastAlarmRequestTime = ct;
        }
        return this.alarmsMap;
    }

    private void mapOneArray(ArrayReg ar, SAData saData) {
        String methodName = "mapOneArray";
        Trace.verbose((Object)this, "mapOneArray", "Get wwn for array");
        byte[] awwn = saData.getSaId().getWorldWideName();
        String wwn = Convert.bytesToString(awwn).toUpperCase();
        Trace.verbose((Object)this, "mapOneArray", "Map array with wwn:" + ar.wwn);
        this._arrayWWNIPsMap.put(wwn, ar.ips);
        for (int i = 0; i < ar.ips.length; ++i) {
            if (ar.ips[i] == null) continue;
            this._ipWWNMap.put(ar.ips[i], wwn);
        }
        byte[] aName = saData.getStorageArrayLabel().getValue();
        String name = UNKNOWN_ARRAY_NAME_KEY;
        if (aName != null) {
            name = UnicodeTranslator.getString((byte[])aName);
        }
        Trace.verbose((Object)this, "mapOneArray", "Mapped array:" + name);
        this._nameIPMap.put(name, ar.ips);
    }

    private com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray loadSummaryData(ArrayReg ar, ControllerTime controllerTime, ObjectBundle bundle, boolean isPasswordValid) {
        String methodName = "loadSummaryData";
        Trace.methodBegin(this, "loadSummaryData");
        com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray array = new com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray();
        StorageArray sa = bundle.getSa();
        String arrayWWN = Convert.bytesToString(sa.getSaData().getSaId().getWorldWideName()).toUpperCase();
        if (!arrayWWN.equals(ar.wwn)) {
            Trace.error((Object)this, "loadSummaryData", "WWN's do not match for array:" + ar);
        }
        array.setRegisteredPasswordValid(isPasswordValid);
        Trace.verbose((Object)this, "loadSummaryData", "isRegisteredPasswordValid?" + array.getIsRegisteredPasswordValid());
        array.setWwn(arrayWWN);
        SAData data = sa.getSaData();
        if (data.getStorageArrayLabel().getValue() != null) {
            array.setName(UnicodeTranslator.getString((byte[])data.getStorageArrayLabel().getValue()));
        }
        if (array.getName() == null || array.getName().trim().equals(DEFAULT_ARRAY_PASSWORD)) {
            array.setName(UNNAMED_ARRAY_STRING);
        }
        Trace.verbose((Object)this, "loadSummaryData", "ArrayName:" + array.getName());
        if (Repository.getRepository().getProperty("STORADE_SWITCH") != null && Boolean.TRUE.toString().equals((String)Repository.getRepository().getProperty("STORADE_SWITCH"))) {
            this.setHealthFromStorade(ar, array);
        } else {
            array.setHealth(data.getNeedsAttention() ? 3 : 2);
        }
        StringBuffer fwVer = new StringBuffer(DEFAULT_ARRAY_PASSWORD);
        this.getFwVersionFromBytes(data, fwVer);
        array.setFirmwareVersion(fwVer.toString());
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("array", arrayWWN);
        key.put("array_name", array.getName());
        array.setKey(key);
        array.setSerialNumber(ar.getRegistrationEntryKey());
        BigInteger totalRaw = this.getTotalDiskCapacity(bundle);
        array.setRawTotalCapacity(totalRaw);
        array.setRawAvailableCapacity(totalRaw.subtract(this.getTotalVolumeCapacity(bundle)));
        if (controllerTime != null) {
            ControllerTime cTime = controllerTime;
            array.setTime(cTime.getControllerATime());
        }
        array.setNodeWWN(Convert.bytesToString(sa.getRemoteAccessID()));
        array.setRemoteMirroringActive(sa.getRemoteMirroringActive());
        Controller[] ozControllers = bundle.getController();
        for (int i = 0; i < ozControllers.length; ++i) {
            if (ozControllers[i].getPhysicalLocation().getSlot() != 1) continue;
            String ctrlAIP = this.getControllerIp(ozControllers[i]);
            if (ctrlAIP == null) break;
            try {
                array.setNetName(InetAddress.getByName(ctrlAIP).getHostName());
            }
            catch (UnknownHostException e) {
                Trace.verbose((Object)this, "loadSummaryData", "Cannot resolve IP of controller A");
                array.setNetName(ctrlAIP);
            }
            break;
        }
        if (array.getNetName() == null) {
            Trace.verbose((Object)this, "loadSummaryData", "Could not get the IP of the controller A - get ANY IP");
            array.setNetName(ar.getIps()[0]);
        }
        return array;
    }

    private String getControllerIp(Controller ctrl) {
        String methodName = "getControllerIp";
        String ctrlIP = null;
        if (ctrl == null) {
            return ctrlIP;
        }
        NetInterfaceTypeData[] netData = ctrl.getNetInterfaces();
        if (netData == null) {
            return ctrlIP;
        }
        for (int j = 0; j < netData.length && ctrlIP == null; ++j) {
            if (netData[j].getInterfaceType().getValue() != 1 || netData[j].getEthernet() == null) continue;
            ctrlIP = Convert.getIpStrFromInt(netData[j].getEthernet().getIp());
        }
        return ctrlIP;
    }

    private void getFwVersionFromBytes(SAData data, StringBuffer fwVer) {
        byte[] arrayByteFwVersion = data.getFwVersion();
        String tmpString = null;
        for (int countFwVersion = 0; countFwVersion < arrayByteFwVersion.length; ++countFwVersion) {
            tmpString = Integer.toString(arrayByteFwVersion[countFwVersion]);
            if (tmpString.length() == 0) {
                fwVer.append("00");
            } else if (tmpString.length() == 1) {
                fwVer.append("0");
                fwVer.append(tmpString);
            } else {
                fwVer.append(tmpString);
            }
            if (countFwVersion == arrayByteFwVersion.length - 1) continue;
            fwVer.append(".");
        }
    }

    private void setHealthFromStorade(ArrayReg ar, com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray array) {
        String methodName = "setHealthFromStorade";
        if (ar == null || array == null) {
            return;
        }
        try {
            Map am = this.getAlarms();
            if (am != null && am.get(ar.getRegistrationEntryKey()) != null) {
                array.setHealth(3);
            } else {
                array.setHealth(2);
            }
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "setHealthFromStorade", e);
            array.setHealth(1);
        }
    }

    private void loadUnhealthyArray(ArrayReg ar, int cause, List arrayDataList) {
        com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray array = new com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray();
        array.setFirmwareVersion(null);
        array.setHealth(cause);
        array.setRawTotalCapacity(null);
        array.setRawAvailableCapacity(null);
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("array", ar.ips[0]);
        array.setKey(key);
        array.setName(ar.ips[0]);
        arrayDataList.add(array);
        this.sickArrays.put(ar.ips[0], ar.ips);
    }

    private BigInteger getTotalVolumeCapacity(ObjectBundle bundle) {
        Volume[] ozVols = bundle.getVolume();
        int size = ozVols == null ? 0 : ozVols.length;
        long t = 0L;
        for (int i = 0; i < size; ++i) {
            t += ozVols[i].getCapacity();
        }
        return BigInteger.valueOf(t);
    }

    private BigInteger getTotalDiskCapacity(ObjectBundle bundle) {
        Drive[] ozDisks = bundle.getDrive();
        int size = ozDisks == null ? 0 : ozDisks.length;
        long total = 0L;
        for (int i = 0; i < size; ++i) {
            total += ozDisks[i].getRawCapacity();
        }
        return BigInteger.valueOf(total);
    }

    public synchronized Collection discoverArrays() {
        Broadcaster bc = new Broadcaster();
        bc.discover();
        List da = bc.getDiscoveredControllers();
        Collection discoveredList = this.createRegArrayObjects(da);
        if (discoveredList.isEmpty()) {
            Trace.verbose((Object)this, "discoverArray", "No arrays discovered");
        }
        return discoveredList;
    }

    public synchronized MethodCallStatus registerArrays(Collection arRegList) {
        String methodName = "registerArrays";
        Trace.methodBegin(this, "registerArrays");
        MethodCallStatus mcs = new MethodCallStatus();
        ArrayList validatedRegs = new ArrayList();
        if (arRegList != null && !arRegList.isEmpty()) {
            Iterator it = arRegList.iterator();
            while (it.hasNext()) {
                HashMap map;
                ArrayReg ar = (ArrayReg)it.next();
                if (ar.password == null) {
                    ar.password = DEFAULT_ARRAY_PASSWORD;
                }
                if (this.isValidReg(ar, mcs, map = new HashMap())) {
                    validatedRegs.addAll(map.values());
                }
                Trace.verbose((Object)this, "registerArrays", "MCS after validation:" + mcs.getReturnCode());
            }
            Trace.verbose((Object)this, "registerArrays", "ReturnCode:" + mcs.getReturnCode());
            Trace.verbose((Object)this, "registerArrays", "Register array size:" + validatedRegs.size());
            if (validatedRegs != null && !validatedRegs.isEmpty()) {
                MethodCallStatus mcsReg = ArrayRegManager.getInstance().registerArrays(validatedRegs);
                mcs.addErrorDescriptorList(mcsReg.getErrorDescList());
            }
            if (mcs.getErrorDescList() == null || mcs.getErrorDescList().isEmpty()) {
                ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.SUCCESS);
                ed.setMsg("All arrays registered successfully");
                mcs.addErrorDescriptor(ed);
                Trace.verbose((Object)this, "registerArrays", "All Success ReturnCode:" + mcs.getReturnCode());
            }
            this.mapArrays(ArrayRegManager.getInstance().getRegisteredArrays("6130"));
        } else {
            ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.EMPTY_LIST);
            ed.setMsg("Empty list passed");
            mcs.addErrorDescriptor(ed);
        }
        return mcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MethodCallStatus unregisterArrays(Collection al) {
        String methodName = "unregisterArrays";
        MethodCallStatus mcs = new MethodCallStatus();
        ArrayList<String> wwnList = new ArrayList<String>();
        if (al == null || al.isEmpty()) {
            ErrorDescriptor ed = new ErrorDescriptor();
            ed.setErrorCode(ErrorDescriptor.ERROR_EMPTY_LIST);
            ed.setI18nkey(ErrorDescriptor.ERROR_EMPTY_LIST_KEY);
            ed.setMsg("Empty list passed");
            mcs.addErrorDescriptor(ed);
        } else {
            Iterator it = al.iterator();
            while (it.hasNext()) {
                String wwn = ((String)it.next()).toUpperCase();
                Trace.verbose((Object)this, "unregisterArrays", "Unregister array with ID:" + wwn);
                String[] ips = (String[])this.arrayWWNIPsMap.get(wwn);
                if (ips == null) {
                    Trace.verbose((Object)this, "unregisterArrays", "Array ID is not WWN!");
                    if (ArrayRegManager.getInstance().isRegistered(wwn)) {
                        wwnList.add(wwn);
                        continue;
                    }
                    try {
                        InetAddress inet = InetAddress.getByName(wwn);
                        Trace.verbose((Object)this, "unregisterArrays", "This is IP");
                        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(new String[]{wwn}, "6130");
                        if (ar != null) {
                            wwnList.add(ar.wwn);
                            continue;
                        }
                        Trace.verbose((Object)this, "unregisterArrays", "Array with id:" + wwn + " cannot be found");
                        ErrorDescriptor ed = new ErrorDescriptor();
                        ed.setErrorCode(ErrorDescriptor.ERROR_ITEM_NOT_FOUND);
                        ed.setI18nkey(ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY);
                        String[] x = new String[]{wwn};
                        ed.setI18nParams(x);
                        ed.setMsg("Array with wwn:" + wwn + " is not registered");
                        mcs.addErrorDescriptor(ed);
                    }
                    catch (UnknownHostException uhe) {
                        ErrorDescriptor ed = new ErrorDescriptor();
                        ed.setErrorCode(ErrorDescriptor.ERROR_INVALID_IP);
                        ed.setI18nkey(ErrorDescriptor.ERROR_INVALID_IP_KEY);
                        String[] x = new String[]{wwn};
                        ed.setI18nParams(x);
                        ed.setMsg("Array with wwn:" + wwn + " is not registered");
                        mcs.addErrorDescriptor(ed);
                    }
                    continue;
                }
                Trace.verbose((Object)this, "unregisterArrays", "Add wwn:" + wwn);
                wwnList.add(wwn);
            }
            Trace.verbose((Object)this, "unregisterArrays", "MCS before delete:" + mcs.getReturnCode());
            if (!wwnList.isEmpty()) {
                Trace.verbose((Object)this, "unregisterArrays", "Shutdown monitoring threads");
                int sz = wwnList.size();
                for (int i = 0; i < sz; ++i) {
                    if (this.allMTs == null) continue;
                    MonitorThread mt = (MonitorThread)this.allMTs.get((String)wwnList.get(i));
                    if (mt != null) {
                        mt.stopMonitoring = true;
                        mt.interrupt();
                    }
                    ObjectPool.getInstance().flush((String)wwnList.get(i));
                }
                ArrayList i = this.goodIPs;
                synchronized (i) {
                    this.goodIPs.clear();
                }
                Trace.verbose((Object)this, "unregisterArrays", "Remove registrations");
                MethodCallStatus mcsAR = ArrayRegManager.getInstance().removeRegistration(wwnList);
                Trace.verbose((Object)this, "unregisterArrays", "MCS after delete:" + mcsAR.getReturnCode());
                if (mcsAR.getReturnCode() != ErrorCode.SUCCESS.getErrorCode()) {
                    mcs.addErrorDescriptorList(mcsAR.getErrorDescList());
                } else {
                    Trace.verbose((Object)this, "unregisterArrays", "ALL GOOD!");
                    ErrorDescriptor ed = new ErrorDescriptor();
                    ed.setErrorCode(ErrorDescriptor.ERROR_SUCCESS);
                    ed.setI18nkey(ErrorDescriptor.ERROR_SUCCESS_KEY);
                    ed.setMsg("Success");
                    mcs.addErrorDescriptor(ed);
                    ManagePerfMonitors manager = new ManagePerfMonitors();
                    try {
                        manager.delete(wwnList);
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.error((Object)this, "unregisterArrays", cme);
                    }
                }
                this.mapArrays(ArrayRegManager.getInstance().getRegisteredArrays("6130"));
            }
        }
        Trace.verbose((Object)this, "unregisterArrays", "Final MCS:" + mcs.getReturnCode());
        return mcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void modifyRegistration(ArrayReg ar) throws ConfigMgmtException, UnknownHostException {
        String methodName = "modifyRegistration";
        if (ar == null || ar.ips == null || ar.ips.length == 0) {
            throw new ConfigMgmtException(ErrorCode.ERROR_ILLEGAL_ARGUMENT.getKey(), "Invalid array registration");
        }
        ArrayReg original = ArrayRegManager.getInstance().getArrayRegistration(ar.wwn);
        if (original == null) {
            Trace.verbose((Object)this, "modifyRegistration", "This is new array registration");
            ArrayList<ArrayReg> l = new ArrayList<ArrayReg>(1);
            l.add(ar);
            this.registerArrays(l);
        } else {
            int i;
            Trace.verbose((Object)this, "modifyRegistration", "Original registration found");
            int sz = original.directIps == null ? 0 : original.directIps.length;
            ArrayList<String> dips = new ArrayList<String>(sz);
            for (int i2 = 0; i2 < sz; ++i2) {
                dips.add(original.directIps[i2]);
            }
            sz = original.proxyIps == null ? 0 : original.proxyIps.length;
            ArrayList<String> pips = new ArrayList<String>(sz);
            for (i = 0; i < sz; ++i) {
                pips.add(original.proxyIps[i]);
            }
            for (i = 0; i < ar.ips.length; ++i) {
                Trace.verbose((Object)this, "modifyRegistration", "Check IP:" + ar.ips[i]);
                if (dips.contains(ar.ips[i]) || pips.contains(ar.ips[i])) continue;
                InetAddress inet = InetAddress.getByName(ar.ips[i]);
                SYMbolAPIClientV1 sym = this.validateConnectionToIP(inet);
                if (sym != null) {
                    Object controllers = null;
                    boolean isAgent = false;
                    try {
                        DiscoveryResponse dr = sym.discoverControllers();
                        isAgent = dr.getResponseFromAgent();
                        if (isAgent) {
                            Trace.verbose((Object)this, "modifyRegistration", "Add proxy ip");
                            ar.proxyIps = this.addIpToArray(ar.proxyIps, ar.ips[i]);
                        } else {
                            Trace.verbose((Object)this, "modifyRegistration", "Add direct ip");
                            ar.directIps = this.addIpToArray(ar.directIps, ar.ips[i]);
                        }
                        try {
                            sym.close();
                        }
                        catch (Exception e) {
                            Trace.error((Object)this, "modifyRegistration", (Throwable)e);
                        }
                        continue;
                    }
                    catch (RPCError e1) {
                        Trace.error((Object)this, (Throwable)e1);
                        return;
                    }
                    catch (IOException e1) {
                        Trace.error((Object)this, (Throwable)e1);
                        return;
                    }
                }
                Trace.warn((Object)this, "modifyRegistration", "Connection to new IP address cannot be validated. Controller may be offline at the moment.");
                ar.directIps = this.addIpToArray(ar.directIps, ar.ips[i]);
            }
            ArrayRegManager.getInstance().updateRegistration(ar);
            if (this.allMTs != null && this.allMTs.get(ar.getWwn()) != null) {
                MonitorThread mt = (MonitorThread)this.allMTs.get(ar.getWwn());
                if (mt != null) {
                    mt.stopMonitoring = true;
                    mt.interrupt();
                }
                ObjectPool.getInstance().flush(ar.getWwn());
                ArrayList arrayList = this.goodIPs;
                synchronized (arrayList) {
                    for (int i3 = 0; i3 < ar.ips.length; ++i3) {
                        if (!this.goodIPs.contains(ar.ips[i3])) continue;
                        this.goodIPs.remove(ar.ips[i3]);
                    }
                }
            }
            this.refreshArraysSummaryData();
        }
    }

    private Collection createRegArrayObjects(List da) {
        String methodName = "createRegArrayObjects";
        Collection finalList = null;
        HashMap map = new HashMap();
        int size = da == null ? 0 : da.size();
        for (int i = 0; i < size; ++i) {
            InetAddress inet = (InetAddress)da.get(i);
            if (!ArrayRegManager.getInstance().isRegistered(inet, "6130")) {
                Trace.verbose((Object)this, "createRegArrayObjects", "IP:" + inet.getHostAddress() + " is not already registered");
                SYMbolAPIClientV1 sym = null;
                sym = this.validateConnectionToIP(inet);
                if (sym == null) continue;
                try {
                    this.processDiscoveredIP(sym, inet, map, DEFAULT_ARRAY_PASSWORD);
                }
                catch (ConfigMgmtException cme) {
                    // empty catch block
                }
                try {
                    if (sym == null) continue;
                    sym.close();
                }
                catch (Exception e) {
                    Trace.error((Object)this, "createRegArrayObjects", "Error closing the connection:" + e.getMessage());
                }
                continue;
            }
            Trace.verbose((Object)this, "createRegArrayObjects", "IP already registered");
        }
        finalList = map.values();
        if (Trace.isTraceEnabled(this)) {
            if (finalList != null) {
                Trace.verbose((Object)this, "createRegArrayObjects", "Final list size:" + finalList.size());
            } else {
                Trace.verbose((Object)this, "createRegArrayObjects", "Final list is empty?");
            }
        }
        return finalList;
    }

    private void processDiscoveredIP(SYMbolAPIClientV1 sym, InetAddress inet, Map map, String arrayPassword) throws ConfigMgmtException {
        String methodName = "processDiscoveredIP";
        AccessibleController[] controllers = null;
        boolean isAgent = false;
        try {
            DiscoveryResponse dr = sym.discoverControllers();
            isAgent = dr.getResponseFromAgent();
            controllers = dr.getControllers();
        }
        catch (RPCError e1) {
            Trace.error((Object)this, (Throwable)e1);
            throw new ConfigMgmtException("error.discovering.controllers", new String[]{inet.getHostName()}, "general.error", (Exception)((Object)e1));
        }
        catch (IOException e1) {
            Trace.error((Object)this, (Throwable)e1);
            throw new ConfigMgmtException("error.discovering.controllers", new String[]{inet.getHostName()}, "general.error", e1);
        }
        int sz = controllers == null ? 0 : controllers.length;
        Trace.verbose((Object)this, "processDiscoveredIP", "Number of discovered controllers:" + sz + " for ip:" + inet.getHostAddress());
        for (int i = 0; i < sz; ++i) {
            ControllerRef contRef = controllers[i].getThisController();
            SAIdentifier arrayId = controllers[i].getSaId();
            ControllerDescriptor controllerDescriptor = new ControllerDescriptor();
            controllerDescriptor.setSaId(arrayId);
            controllerDescriptor.setControllerRef(contRef);
            try {
                byte[] bwwn;
                ReturnCode rc = sym.bindToController(controllerDescriptor);
                if (rc.getValue() != 1 || (bwwn = sym.getSAData().getSaId().getWorldWideName()) == null) continue;
                String wwn = Convert.bytesToString(bwwn).toUpperCase();
                ArrayReg ar = (ArrayReg)map.get(wwn);
                if (ar == null) {
                    if (!ArrayRegManager.getInstance().isRegistered(wwn)) {
                        ObjectBundle bundle = sym.getObjectGraph();
                        ar = new ArrayReg();
                        ar.type = "6130";
                        ar.password = arrayPassword;
                        ar.wwn = wwn.toUpperCase();
                        ar.registrationEntryKey = this.getRegKey(bundle.getTray(), ar.wwn);
                        ar.nodeName = Convert.bytesToString(bundle.getSa().getRemoteAccessID());
                        String strAName = null;
                        byte[] aName = sym.getSAData().getStorageArrayLabel().getValue();
                        if (aName != null) {
                            strAName = UnicodeTranslator.getString((byte[])aName);
                        }
                        ar.setResourceName(strAName);
                    } else {
                        ar = ArrayRegManager.getInstance().getArrayRegistration(wwn);
                    }
                }
                Trace.verbose((Object)this, "processDiscoveredIP", "Does this ip already exists for this wwn?");
                if (!this.isNewIpForArrayReg(ar, inet.getHostAddress())) continue;
                Trace.verbose((Object)this, "processDiscoveredIP", "No, add it");
                this.addManagementPaths(ar, sym, inet, isAgent);
                map.put(wwn, ar);
                continue;
            }
            catch (RPCError e) {
                Trace.error((Object)this, "processDiscoveredIP", (Throwable)e);
                continue;
            }
            catch (IOException e) {
                Trace.error((Object)this, "processDiscoveredIP", (Throwable)e);
            }
        }
    }

    private String getRegKey(Tray[] tray, String arrayWWN) throws ConfigMgmtException {
        StringBuffer key = new StringBuffer("SUN.");
        for (int i = 0; i < tray.length; ++i) {
            if (tray[i].getType().getValue() != 8) continue;
            String partNumber = tray[i].getPartNumber();
            if (partNumber == null) {
                throw new ConfigMgmtException("error.no.part.number", new String[]{arrayWWN}, "Part number on the controller tray does not exist", null);
            }
            if (partNumber.length() <= 3) {
                throw new ConfigMgmtException("error.invalid.part.number", new String[]{partNumber, arrayWWN}, "Part number for the controller tray is not valid", null);
            }
            key.append(partNumber.substring(3).trim());
            key.append(".");
            String serialNum = tray[i].getSerialNumber();
            if (serialNum == null) {
                throw new ConfigMgmtException("error.no.serial.number", new String[]{arrayWWN}, "Serial number on the controller tray does not exist", null);
            }
            if (serialNum.length() <= 3) {
                throw new ConfigMgmtException("error.invalid.serial.number", new String[]{serialNum, arrayWWN}, "Serial number for the controller tray is not valid", null);
            }
            key.append(serialNum.substring(3).trim());
            break;
        }
        return key.toString();
    }

    private void addManagementPaths(ArrayReg ar, SYMbolAPIClientV1 sym, InetAddress inet, boolean isAgent) throws ConfigMgmtException {
        String methodName = "addManagementPaths";
        if (!isAgent) {
            Trace.verbose((Object)this, "addManagementPaths", "Not an agent, get all controller IPs");
            Controller[] controllers = null;
            try {
                controllers = sym.getObjectGraph().getController();
            }
            catch (RPCError e1) {
                Trace.error((Object)this, "addManagementPaths", (Throwable)e1);
            }
            catch (IOException e1) {
                Trace.error((Object)this, "addManagementPaths", (Throwable)e1);
            }
            int sz = controllers == null ? 0 : controllers.length;
            boolean foundAtLeastOneIP = false;
            for (int i = 0; i < sz; ++i) {
                String contrIP = this.getIPFromController(controllers[i]);
                Trace.verbose((Object)this, "addManagementPaths", "ar = " + ar + " contrIp = " + contrIP);
                if (contrIP == null) {
                    if (i == sz - 1 && !foundAtLeastOneIP) {
                        Trace.error((Object)this, "addManagementPaths", "Unable to obtain ip address from any controller - ABORT!");
                        throw new ConfigMgmtException(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY, "Unable to obtain ip address from any controller");
                    }
                    Trace.verbose((Object)this, "addManagementPaths", "Unable to obtain IP address from controller... Attempt another controller");
                    continue;
                }
                if (this.isNewIpForArrayReg(ar, contrIP)) {
                    Trace.verbose((Object)this, "addManagementPaths", "This is a new IP:" + contrIP);
                    foundAtLeastOneIP = true;
                    try {
                        if (!contrIP.equals(inet.getHostAddress())) {
                            SYMbolAPIClientV1 sym1 = this.validateConnectionToIP(InetAddress.getByName(contrIP));
                            if (sym1 == null) continue;
                            Trace.verbose((Object)this, "addManagementPaths", "Connection validated");
                            try {
                                sym1.close();
                            }
                            catch (Exception e) {
                                Trace.error((Object)this, "addManagementPaths", "Close connection exception:" + e.getMessage());
                            }
                            this.addIPToReg(ar, contrIP, isAgent);
                            Trace.verbose((Object)this, "addManagementPaths", "IP added");
                            continue;
                        }
                        this.addIPToReg(ar, contrIP, isAgent);
                        Trace.verbose((Object)this, "addManagementPaths", "IP added");
                    }
                    catch (UnknownHostException e) {
                        Trace.verbose((Object)this, "addManagementPaths", "This is not a valid ip:" + contrIP);
                    }
                    continue;
                }
                Trace.verbose((Object)this, "addManagementPaths", "IP already registered");
            }
        } else {
            Trace.verbose((Object)this, "addManagementPaths", "Agent detected for wwn:" + ar.wwn);
            if (this.isNewIpForArrayReg(ar, inet.getHostAddress())) {
                this.addIPToReg(ar, inet.getHostAddress(), isAgent);
                Trace.verbose((Object)this, "addManagementPaths", "IP added");
            } else {
                Trace.verbose((Object)this, "addManagementPaths", "Agent IP already registered");
            }
        }
    }

    private boolean isNewIpForArrayReg(ArrayReg ar, String newIp) {
        boolean isNew = true;
        int sz = ar.ips == null ? 0 : ar.ips.length;
        for (int z = 0; z < sz && isNew; ++z) {
            if (ar.ips[z] == null || !newIp.equals(ar.ips[z])) continue;
            Trace.verbose((Object)this, "isNewIpForArrayReg", "Found it!");
            isNew = false;
        }
        return isNew;
    }

    public SYMbolAPIClientV1 validateConnectionToIP(InetAddress newIp) {
        String methodName = "validateConnectionToIP";
        SYMbolAPIClientV1 sym = null;
        ThreadConnect tc = new ThreadConnect(newIp);
        try {
            tc.start();
            tc.join(ARRAY_RESPONSE_WAIT);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!tc.isDone()) {
            Trace.verbose((Object)this, "validateConnectionToIP", "thread not done, kill");
            tc.interrupt();
        }
        if (tc.isConnected()) {
            sym = tc.getSym();
            Trace.verbose((Object)this, "validateConnectionToIP", "Connected to ip:" + newIp);
        } else {
            Trace.verbose((Object)this, "validateConnectionToIP", "Could not connect within 5 seconds - not a valid IP");
        }
        tc = null;
        return sym;
    }

    private void addIPToReg(ArrayReg ar, String newIp, boolean isAgent) {
        ar.ips = this.addIpToArray(ar.ips, newIp);
        if (isAgent) {
            ar.proxyIps = this.addIpToArray(ar.proxyIps, newIp);
        } else {
            ar.directIps = this.addIpToArray(ar.directIps, newIp);
        }
    }

    private String[] addIpToArray(String[] ipArray, String newIp) {
        int sz = ipArray == null ? 1 : ipArray.length + 1;
        String[] newAgentIPs = new String[sz];
        newAgentIPs[sz - 1] = newIp;
        for (int i = 0; i < sz - 1; ++i) {
            newAgentIPs[i] = ipArray[i];
        }
        return newAgentIPs;
    }

    private boolean isValidReg(ArrayReg ar, MethodCallStatus mcs, Map map) {
        String methodName = "isValidReg";
        boolean valid = true;
        boolean errorProcessed = false;
        if (ar.ips == null || ar.ips[0] == null) {
            valid = false;
        } else {
            ErrorDescriptor ed;
            SYMbolAPIClientV1 sym = null;
            InetAddress inet = null;
            try {
                inet = InetAddress.getByName(ar.ips[0]);
                if (ArrayRegManager.getInstance().isRegistered(inet, "6130")) {
                    ErrorDescriptor ed2 = new ErrorDescriptor(new ErrorCode("error.storade.resource.exist", ErrorCode.DUPLICATE_OBJECT.getErrorCode(), ErrorCodeType.ERROR));
                    String[] x = new String[]{ar.ips[0]};
                    ed2.setI18nParams(x);
                    ed2.setMsg("Already registered:" + ar.ips[0]);
                    valid = false;
                    mcs.addErrorDescriptor(ed2);
                    return valid;
                }
            }
            catch (UnknownHostException e) {
                ed = new ErrorDescriptor(new ErrorCode(ErrorDescriptor.ERROR_INVALID_IP_KEY, ErrorDescriptor.ERROR_INVALID_IP, ErrorCodeType.ERROR));
                String[] x = new String[]{ar.ips[0]};
                ed.setI18nParams(x);
                ed.setMsg("Invalid IP Address:" + ar.ips[0]);
                valid = false;
                mcs.addErrorDescriptor(ed);
            }
            String wwn = DEFAULT_ARRAY_PASSWORD;
            sym = this.validateConnectionToIP(inet);
            if (sym != null) {
                try {
                    this.processDiscoveredIP(sym, inet, map, ar.password);
                    valid = true;
                    String strAName = DEFAULT_ARRAY_PASSWORD;
                    try {
                        byte[] aName = sym.getSAData().getStorageArrayLabel().getValue();
                        if (aName != null) {
                            strAName = UnicodeTranslator.getString((byte[])aName);
                        }
                    }
                    catch (RPCError e1) {
                        Trace.error((Object)this, "isValidReg", "Could not set the array name");
                    }
                    catch (IOException e1) {
                        Trace.error((Object)this, "isValidReg", "Could not set the array name");
                    }
                    ar.setResourceName(strAName);
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, "isValidReg", cme);
                    valid = false;
                    ErrorDescriptor ed3 = new ErrorDescriptor();
                    ed3.setErrorCode(2);
                    ed3.setI18nkey(cme.getExceptionKey());
                    ed3.setI18nParams(cme.getSubstitutions());
                    ed3.setMsg(cme.getExceptionMsg());
                    mcs.addErrorDescriptor(ed3);
                    mcs.setReturnCode(2);
                    errorProcessed = true;
                }
                try {
                    sym.close();
                }
                catch (Exception e) {
                    Trace.error((Object)this, "isValidReg", "Error closing connection:" + e.getMessage());
                }
            } else {
                Trace.verbose((Object)this, "isValidReg", "Could not connect to the array using specified IP.");
                valid = false;
            }
            if (!valid && !errorProcessed) {
                ed = new ErrorDescriptor(new ErrorCode(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY, ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY, ErrorCodeType.ERROR));
                ed.setMsg("Connect validation failed");
                mcs.addErrorDescriptor(ed);
            }
            errorProcessed = false;
        }
        return valid;
    }

    public synchronized ObjectBundle getObjectBundle(String arrayId) throws SEItemNotFoundException, ConfigMgmtException {
        String methodName = "getObjectBundle";
        Trace.methodBegin(this, "getObjectBundle");
        ObjectBundle bundle = null;
        MonitorThread mt = this.getMonitoringThread(arrayId);
        if (mt != null) {
            bundle = mt.getBundle();
        }
        if (bundle == null) {
            Trace.error((Object)this, "getObjectBundle", "Error retrieving object bundle - array not accessible");
            if (mt != null) {
                mt.stopMonitoring = true;
                mt.interrupt();
            }
            throw new ConfigMgmtException("error.array.not.accessible", "Failed to connect to the array - array not accessible.");
        }
        Trace.verbose((Object)this, "getObjectBundle", "PROFILE: Object Bundle retrieved from monitoring thread");
        return bundle;
    }

    public synchronized void stopMonitoringThread(String arrayID) throws SEItemNotFoundException {
        MonitorThread mt;
        if (this.allMTs != null && (mt = (MonitorThread)this.allMTs.get(arrayID)) != null) {
            mt.stopMonitoring = true;
            mt.interrupt();
            this.allMTs.remove(arrayID);
        }
    }

    public synchronized void forceBundleReload(String arrayID) throws SEItemNotFoundException, ConfigMgmtException {
        String methodName = "forceBundleReload";
        Trace.methodBegin(this, "forceBundleReload");
        this.stopMonitoringThread(arrayID);
        MonitorThread mt = this.startMonitoringThread(arrayID);
        if (mt != null) {
            this.updateArraySummaryData(mt);
        }
    }

    public synchronized Collection getObjectBundles() throws ConfigMgmtException {
        String METHOD = "getObjectBundles";
        Trace.methodBegin(this, "getObjectBundles");
        ArrayList bundles = new ArrayList();
        List regArrays = ArrayRegManager.getInstance().getRegisteredArrays("6130");
        int cnt = regArrays == null ? 0 : regArrays.size();
        ArrayList tblList = new ArrayList(cnt);
        int startIndex = 0;
        while (cnt > 0) {
            int numOfThreads = cnt > this.MAX_LOADER_THREADS ? this.MAX_LOADER_THREADS : cnt;
            tblList = new ArrayList(numOfThreads);
            this.startBundleLoaderThreads(regArrays, numOfThreads, startIndex, tblList);
            this.waitForLoaderThreads(bundles, tblList, true);
            cnt -= numOfThreads;
            startIndex += numOfThreads;
        }
        return bundles;
    }

    public synchronized List getAllArraysData() {
        Trace.verbose((Object)this, "getAllArraysData", "PROFILE: Begin");
        List regArrays = ArrayRegManager.getInstance().getRegisteredArrays("6130");
        List locAllASumData = new ArrayList();
        Trace.verbose((Object)this, "getAllArraysData", "Size:" + regArrays.size());
        if (!this.CACHE_ARRAY_SUMMARY_DATA) {
            locAllASumData = this.mapArrays(regArrays);
        } else if (!this.validateSummaryData(this.allArraysSummaryData, regArrays)) {
            Trace.verbose((Object)this, "getAllArraysData", "Data in the cache is not valid, some registrations do not match");
            if (this.loadAllArraysThread != null && this.loadAllArraysThread.isAlive()) {
                try {
                    this.loadAllArraysThread.join(ARRAY_LOAD_WAIT);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.loadAllArraysThread.isAlive()) {
                    this.allArraysSummaryData = this.mapArrays(regArrays);
                }
            } else {
                this.allArraysSummaryData = this.mapArrays(regArrays);
            }
            locAllASumData.addAll(this.allArraysSummaryData);
        } else {
            Trace.verbose((Object)this, "getAllArraysData", "Data in the cache is good, start the thread to refresh it for the next time");
            locAllASumData.addAll(this.allArraysSummaryData);
            this.refreshArraysSummaryData();
        }
        Trace.verbose((Object)this, "getAllArraysData", "PROFILE: Done");
        return locAllASumData;
    }

    private void refreshArraysSummaryData() {
        if ((this.loadAllArraysThread == null || !this.loadAllArraysThread.isAlive()) && this.CACHE_ARRAY_SUMMARY_DATA) {
            this.loadAllArraysThread = null;
            this.loadAllArraysThread = new ThreadLoadAllArrays();
            this.loadAllArraysThread.setDaemon(true);
            this.loadAllArraysThread.start();
            Trace.verbose((Object)this, "getAllArraysData", "PROFILE: Refresh arrays summary data");
        }
    }

    public void flushBundleCache() {
        if (this.allMTs != null) {
            Iterator it = this.allMTs.keySet().iterator();
            while (it.hasNext()) {
                String wwn = (String)it.next();
                Trace.verbose((Object)this, "flushBundleCache", wwn);
                MonitorThread mt = (MonitorThread)this.allMTs.get(wwn);
                mt.stopMonitoring = true;
                mt.interrupt();
            }
        }
    }

    public SYMbolAPIClientV1 getClient(String arrayID, boolean isAlternate) throws RPCError, IOException, SEItemNotFoundException {
        String wwn = this.getWWNForId(arrayID);
        String[] ips = this.getIPsForID(wwn);
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(wwn);
        boolean connected = false;
        SYMbolAPIClientV1 sym = null;
        for (int i = 0; i < ips.length && !connected; ++i) {
            InetAddress inet = InetAddress.getByName(ips[i]);
            sym = new SYMbolAPIClientV1(inet, 2463, true);
            DiscoveryResponse dr = sym.discoverControllers();
            if (!dr.getResponseFromAgent()) {
                if (!isAlternate) {
                    connected = true;
                    continue;
                }
                isAlternate = false;
                continue;
            }
            AccessibleController[] acs = dr.getControllers();
            int sz = acs == null ? 0 : acs.length;
            for (int x = 0; x < sz && !connected; ++x) {
                ControllerRef cr = acs[x].getThisController();
                SAIdentifier said = acs[x].getSaId();
                if (said.getWorldWideName() == null || !Convert.bytesToString(said.getWorldWideName()).equalsIgnoreCase(wwn)) continue;
                if (!isAlternate) {
                    Trace.verbose((Object)this, "getClient", "Binding to controller through agent");
                    ControllerDescriptor cd = new ControllerDescriptor();
                    cd.setControllerRef(cr);
                    cd.setSaId(said);
                    sym.bindToController(cd);
                    connected = true;
                    continue;
                }
                isAlternate = false;
            }
        }
        if (!connected) {
            throw new SEItemNotFoundException(arrayID);
        }
        return sym;
    }

    public SYMbolAPIClientV1 getClient(String arrayID, String controllerRef) throws RPCError, IOException, SEItemNotFoundException {
        String wwn = this.getWWNForId(arrayID);
        String[] ips = this.getIPsForID(wwn);
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(wwn);
        boolean connected = false;
        SYMbolAPIClientV1 sym = null;
        for (int i = 0; i < ips.length && !connected; ++i) {
            InetAddress inet = InetAddress.getByName(ips[i]);
            sym = new SYMbolAPIClientV1(inet, 2463, true);
            DiscoveryResponse dr = sym.discoverControllers();
            if (!dr.getResponseFromAgent()) {
                Controller[] cons = sym.getObjectGraph().getController();
                for (int x = 0; x < cons.length && !connected; ++x) {
                    String thisContrRef = Convert.bytesToString(cons[x].getControllerRef().getRefToken());
                    if (!thisContrRef.equals(controllerRef)) continue;
                    String contrIP = this.getIPFromController(cons[x]);
                    if (contrIP != null && contrIP.equals(inet.getHostAddress())) {
                        connected = true;
                    } else {
                        try {
                            sym.close();
                        }
                        catch (Exception e) {
                            Trace.error((Object)this, "getClient", "Error closing connection:" + e.getMessage());
                        }
                        sym = new SYMbolAPIClientV1(InetAddress.getByName(contrIP), 2463, true);
                        connected = true;
                    }
                    ControllerDescriptor cd = new ControllerDescriptor();
                    cd.setControllerRef(cons[x].getControllerRef());
                    SAIdentifier said = sym.getSAData().getSaId();
                    cd.setSaId(said);
                    sym.bindToController(cd);
                }
                continue;
            }
            AccessibleController[] acs = dr.getControllers();
            int sz = acs == null ? 0 : acs.length;
            for (int x = 0; x < sz && !connected; ++x) {
                SAIdentifier said;
                ControllerRef cr = acs[x].getThisController();
                if (!Convert.bytesToString(cr.getRefToken()).equals(controllerRef) || (said = acs[x].getSaId()).getWorldWideName() == null || !Convert.bytesToString(said.getWorldWideName()).equalsIgnoreCase(wwn)) continue;
                ControllerDescriptor cd = new ControllerDescriptor();
                cd.setControllerRef(cr);
                cd.setSaId(said);
                sym.bindToController(cd);
                connected = true;
            }
        }
        if (!connected) {
            throw new SEItemNotFoundException(arrayID);
        }
        return sym;
    }

    public SYMbolAPIClientV1 getAlternateAuthorizedClient(String arrayID) throws RPCError, IOException, SEItemNotFoundException {
        String wwn = this.getWWNForId(arrayID);
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(wwn);
        SYMbolAPIClientV1 sym = this.getClient(arrayID, true);
        this.setClientPassword(ar.password, sym);
        return sym;
    }

    public SYMbolAPIClientV1 getAuthorizedClient(String arrayID) throws RPCError, IOException, SEItemNotFoundException {
        String wwn = this.getWWNForId(arrayID);
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(wwn);
        SYMbolAPIClientV1 sym = this.getClient(arrayID, false);
        this.setClientPassword(ar.password, sym);
        return sym;
    }

    public SYMbolAPIClientV1 getAuthorizedClientForController(String arrayID, String controllerRef) throws RPCError, IOException, SEItemNotFoundException {
        String wwn = this.getWWNForId(arrayID);
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(wwn);
        SYMbolAPIClientV1 sym = this.getClient(arrayID, controllerRef);
        this.setClientPassword(ar.password, sym);
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getControlerReferences(String arrayId) {
        Controller[] c;
        String methodName = "getControlerReferences";
        String[] contRef = null;
        if (arrayId == null) {
            return null;
        }
        Object sym = null;
        String wwn = this.getWWNForId(arrayId);
        MonitorThread mt = this.getMonitoringThread(wwn);
        if (mt != null && (c = mt.getBundle().getController()) != null) {
            contRef = new String[c.length];
            for (int i = 0; i < c.length; ++i) {
                contRef[i] = Convert.bytesToString(c[i].getControllerRef().getRefToken());
            }
        }
        Object var10_10 = null;
        if (sym == null) return contRef;
        try {
            sym.close();
            return contRef;
        }
        catch (Exception e2) {
            Trace.error((Object)this, "getControlerReferences", e2.getMessage());
        }
        return contRef;
        {
            catch (ConfigMgmtException e) {
                Trace.error((Object)this, e);
                Object var10_11 = null;
                if (sym == null) return contRef;
                try {
                    sym.close();
                    return contRef;
                }
                catch (Exception e2) {
                    Trace.error((Object)this, "getControlerReferences", e2.getMessage());
                }
                return contRef;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (sym == null) throw throwable;
            try {
                sym.close();
                throw throwable;
            }
            catch (Exception e2) {
                Trace.error((Object)this, "getControlerReferences", e2.getMessage());
            }
            throw throwable;
        }
    }

    public SYMbolAPIClientV1 getAuthorizedClient(String password, String arrayID) throws RPCError, IOException, SEItemNotFoundException {
        String[] ips = null;
        SYMbolAPIClientV1 sym = null;
        if (this.arrayWWNIPsMap != null && this.arrayWWNIPsMap.get(arrayID) != null) {
            ips = (String[])this.arrayWWNIPsMap.get(arrayID);
        } else {
            ips = new String[2];
            ips[0] = arrayID;
        }
        InetAddress inet = InetAddress.getByName(ips[0]);
        sym = new SYMbolAPIClientV1(inet, 2463, true);
        this.setClientPassword(password, sym);
        return sym;
    }

    public SYMbolAPIClientV1 getAlternateAuthorizedClient(String password, String arrayID) throws RPCError, IOException, SEItemNotFoundException {
        SYMbolAPIClientV1 sym = null;
        String[] ips = null;
        if (this.arrayWWNIPsMap != null && this.arrayWWNIPsMap.get(arrayID) != null) {
            ips = (String[])this.arrayWWNIPsMap.get(arrayID);
        } else {
            ips = new String[2];
            ips[0] = arrayID;
        }
        if (ips != null && ips.length > 1 && ips[1] != null) {
            InetAddress inet = InetAddress.getByName(ips[1]);
            sym = new SYMbolAPIClientV1(inet, 2463, true);
            this.setClientPassword(password, sym);
        }
        return sym;
    }

    public void setClientPassword(String password, SYMbolAPIClientV1 client) throws RPCError, IOException {
        ChangeQueryDescriptor chgQuery = new ChangeQueryDescriptor();
        chgQuery.getLastKnown().setConfigGeneration(-1L);
        chgQuery.getLastKnown().setLastCriticalMelSeqNumber(-1L);
        chgQuery.setMaxWait(0);
        client.setTimeout(10);
        SYMbolAuthGenerator authGenerator = new SYMbolAuthGenerator(client.getLocalAddress(), client.getSAData().getSaId());
        client.setTimeout(10);
        authGenerator.setConfigGeneration(client.getChangeState(chgQuery).getConfigGeneration());
        authGenerator.setPassword(password);
        client.setAuthGenerator((RPCAuthGenerator)authGenerator);
    }

    public synchronized Object getPoolData(String arrayId) throws SEItemNotFoundException, ConfigMgmtException {
        String methodName = "getPoolData";
        Trace.methodBegin(this, "getPoolData");
        Object poolData = null;
        MonitorThread mt = this.getMonitoringThread(arrayId);
        if (mt != null) {
            poolData = mt.getPoolData();
        }
        Trace.verbose((Object)this, "getPoolData", "PROFILE: pool data retrieved from monitoing thread");
        return poolData;
    }

    public synchronized Object getProfileData(String arrayId) throws SEItemNotFoundException, ConfigMgmtException {
        String methodName = "getProfileData";
        Trace.methodBegin(this, "getProfileData");
        Object profileData = null;
        MonitorThread mt = this.getMonitoringThread(arrayId);
        if (mt != null) {
            profileData = mt.getProfileData();
        }
        if (profileData == null) {
            Trace.error((Object)this, "getProfileData", "Error retrieving profile data");
            if (mt != null && mt.getLastException() != null) {
                throw mt.getLastException();
            }
            if (mt != null) {
                mt.stopMonitoring = true;
                mt.interrupt();
            }
            throw new ConfigMgmtException("error.array.not.accessible", DEFAULT_ARRAY_PASSWORD);
        }
        Trace.verbose((Object)this, "getProfileData", "PROFILE: profileData retrieved from monitoing thread");
        return profileData;
    }

    public synchronized void setPoolData(String arrayId, Object poolData) throws RPCError, IOException, ConfigMgmtException {
        Object profileData = this.getProfileData(arrayId);
        Object mergedData = PoolProfileMergeManager.mergePoolsAndProfiles(poolData, profileData);
        DACStoreManager mgr = new DACStoreManager(arrayId);
        mgr.storeData(mergedData);
    }

    public synchronized void setProfileData(String arrayId, Object profileData) throws SEItemNotFoundException, ConfigMgmtException, RPCError, IOException {
        Object poolData = this.getPoolData(arrayId);
        Object mergedData = PoolProfileMergeManager.mergePoolsAndProfiles(poolData, profileData);
        DACStoreManager mgr = new DACStoreManager(arrayId);
        mgr.storeData(mergedData);
    }

    public synchronized Map getAllVolumeCandidatesByRaid(String arrayId) throws SEItemNotFoundException, ConfigMgmtException {
        MonitorThread mt = this.getMonitoringThread(arrayId);
        Map map = null;
        if (mt != null) {
            map = mt.getVolumeCandidatesByRaid();
        }
        return map;
    }

    public String getIPForName(String name) {
        String[] xips = (String[])this.nameIPMap.get(name);
        String ip = null;
        if (xips != null) {
            ip = xips[0];
        }
        return ip;
    }

    private boolean validateSummaryData(List aSumData, List arrayRegs) {
        int arSz;
        String methodName = "validateSummarydata";
        boolean valid = false;
        int asSz = aSumData == null ? -1 : aSumData.size();
        int n = arSz = arrayRegs == null ? 0 : arrayRegs.size();
        if (asSz == arSz) {
            com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray array = null;
            for (int i = 0; i < arSz; ++i) {
                ArrayReg ar = (ArrayReg)arrayRegs.get(i);
                array = null;
                com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray maybeSickArray = null;
                for (int j = 0; j < asSz && array == null; ++j) {
                    com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray tmp = (com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray)aSumData.get(j);
                    if (tmp.getHealth() == 13) {
                        maybeSickArray = tmp;
                    }
                    if (tmp.getWwn() == null || !tmp.getWwn().equals(ar.getWwn())) continue;
                    array = tmp;
                    this.setHealthFromStorade(ar, array);
                }
                if (array != null) continue;
                if (maybeSickArray == null) {
                    Trace.verbose((Object)this, "getAllArraysData", " ARRAY NOT FOUND! VALIDATE: ArrayRg WWN:" + ar.getWwn() + "< ");
                    break;
                }
                Trace.verbose((Object)this, "getAllArraysData", "Maybe a sick array, cannot validate wwn");
            }
            if (array != null) {
                valid = true;
            }
        }
        return valid;
    }

    private void updateArraySummaryData(MonitorThread mt) {
        String methodName = "updateArraySummaryData";
        Trace.methodBegin(this, "updateArraySummaryData");
        Trace.verbose((Object)this, "updateArraySummaryData", "PROFILE: start update");
        String wwn = mt.getArrayWWN();
        int sz = this.allArraysSummaryData == null ? 0 : this.allArraysSummaryData.size();
        com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray array = null;
        int x = -1;
        for (int i = 0; i < sz && array == null; ++i) {
            com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray tmp = (com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray)this.allArraysSummaryData.get(i);
            if (tmp.getWwn() == null || !tmp.getWwn().equals(wwn)) continue;
            array = tmp;
            x = i;
        }
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(wwn);
        if (array != null && ar != null && (array = this.loadSummaryData(ar, null, mt.getBundle(), array.getIsRegisteredPasswordValid())) != null) {
            this.allArraysSummaryData.remove(x);
            this.allArraysSummaryData.add(0, array);
        }
        Trace.verbose((Object)this, "updateArraySummaryData", "PROFILE: update complete");
    }

    private String getIPFromController(Controller controller) {
        String ip = null;
        NetInterfaceTypeData[] netData = controller.getNetInterfaces();
        for (int i = 0; i < netData.length && ip == null; ++i) {
            if (netData[i].getInterfaceType().getValue() != 1) continue;
            ip = Convert.getIpStrFromInt(netData[i].getEthernet().getIp());
        }
        return ip;
    }

    private String[] getIPsForID(String arrayID) {
        String[] ips = null;
        if (this.arrayWWNIPsMap.get(arrayID) != null) {
            ips = (String[])this.arrayWWNIPsMap.get(arrayID);
        } else {
            try {
                Trace.verbose((Object)this, "getIPsForID", "Attempt to get IP");
                InetAddress inet = InetAddress.getByName(arrayID);
                String ip = inet.getHostAddress();
                Collection col = this.arrayWWNIPsMap.values();
                Iterator it = col.iterator();
                while (it.hasNext() && ips == null) {
                    String[] aips = (String[])it.next();
                    for (int j = 0; j < aips.length && ips == null; ++j) {
                        if (!ip.equals(aips[j])) continue;
                        ips = aips;
                    }
                }
            }
            catch (UnknownHostException e) {
                Trace.error((Object)this, "getIPsForId", (Throwable)e);
            }
        }
        return ips;
    }

    private void createUnhealthyBundle(ObjectBundle bundle) {
        StorageArray sa = new StorageArray();
        sa.setSaData(null);
        bundle.setSa(sa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWWNForId(String arrayID) throws SEItemNotFoundException {
        HashMap hashMap;
        String wwn = null;
        if (this.arrayWWNIPsMap != null) {
            hashMap = this.arrayWWNIPsMap;
            synchronized (hashMap) {
                if (this.arrayWWNIPsMap.get(arrayID) != null) {
                    wwn = arrayID;
                }
            }
        }
        if (wwn == null) {
            if (this.ipWWNMap != null) {
                hashMap = this.ipWWNMap;
                synchronized (hashMap) {
                    if (this.ipWWNMap.get(arrayID) != null) {
                        wwn = (String)this.ipWWNMap.get(arrayID);
                    }
                }
            } else if (this.nameIPMap != null) {
                hashMap = this.nameIPMap;
                synchronized (hashMap) {
                    String[] ips;
                    if (this.nameIPMap.get(arrayID) != null && (ips = (String[])this.nameIPMap.get(arrayID)) != null && ips.length != 0 && ips[0] != null && this.ipWWNMap != null) {
                        wwn = (String)this.ipWWNMap.get(ips[0]);
                    }
                }
            } else if (wwn == null) {
                throw new SEItemNotFoundException(arrayID);
            }
        }
        return wwn;
    }

    private void waitForLoaderThreads(Collection results, List tblList, boolean loadBundles) {
        String methodName = "waitForLoaderThreads";
        while (!tblList.isEmpty()) {
            ThreadBundleLoader tbl = (ThreadBundleLoader)tblList.get(0);
            Trace.verbose((Object)this, "waitForLoaderThreads", "Wait for array:" + tbl.getArrayReg().getResourceName());
            try {
                tbl.join(ARRAY_RESPONSE_WAIT);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Trace.verbose((Object)this, "waitForLoaderThreads", "Wait done!");
            if (tbl.isLoaded) {
                if (loadBundles) {
                    results.add(tbl.getBundle());
                } else {
                    results.add(tbl);
                }
            } else if (!tbl.isConnected && tbl.isAlive()) {
                Trace.verbose((Object)this, "waitForLoaderThreads", "Not connected, but thread is alive - interupt");
                tbl.interrupt();
                tblList.add(tbl);
            } else {
                Trace.verbose((Object)this, "waitForLoaderThreads", "Connected, but not loaded, join a little");
                try {
                    tbl.join(ARRAY_LOAD_WAIT);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                Trace.verbose((Object)this, "waitForLoaderThreads", "Join done!");
                if (!tbl.isLoaded) {
                    Trace.verbose((Object)this, "waitForLoaderThreads", "Still not done! - KILL");
                    tbl.interrupt();
                    tbl.setUnhealthy();
                }
                if (loadBundles) {
                    results.add(tbl.getBundle());
                } else {
                    results.add(tbl);
                }
            }
            tblList.remove(0);
        }
        Trace.verbose((Object)this, "waitForThreadLoaders", "Done");
    }

    private void startBundleLoaderThreads(List regAr, int cnt, int startIndex, List tblList) {
        int endIndex = startIndex + cnt;
        ArrayList regArrays = new ArrayList(regAr);
        if (endIndex > regArrays.size()) {
            endIndex = regArrays.size();
        }
        for (int i = startIndex; i < endIndex; ++i) {
            ArrayReg ar = (ArrayReg)regArrays.get(i);
            ThreadBundleLoader tbl = new ThreadBundleLoader(ar);
            tbl.setDaemon(true);
            tbl.start();
            tblList.add(tbl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized MonitorThread startMonitoringThread(String arrayId) throws SEItemNotFoundException, ConfigMgmtException {
        String methodName = "startMonitoringThread";
        Object mt = null;
        String wwn = arrayId;
        String[] ips = this.getIPsForID(arrayId);
        if (ips == null) {
            Trace.verbose((Object)this, "startMonitoringThread", "Cannot find arrayId in internal maps - probably a sick array, or it was reported sick before; Array id:" + arrayId);
            ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(arrayId);
            if (ar == null) throw new SEItemNotFoundException(arrayId);
            ips = ar.ips;
            return this.startMonitoringThread(ips, wwn);
        } else {
            wwn = this.getWWNForId(arrayId);
        }
        return this.startMonitoringThread(ips, wwn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized MonitorThread startMonitoringThread(String[] ips, String wwn) throws ConfigMgmtException {
        Object object;
        String methodName = "startMonitoringThread";
        MonitorThread mt = null;
        byte[] mainLock = new byte[]{};
        if (ips == null) {
            Trace.verbose((Object)this, "startMonitoringThread", "ips is null??");
            throw new ConfigMgmtException("error.null.id", "Array id is null, cannot perform an action");
        }
        LoadMonitor lm = new LoadMonitor(ips, wwn, false, mainLock);
        lm.setDaemon(true);
        lm.start();
        try {
            Trace.verbose((Object)this, "startMonitoringThread", "Wait for notification");
            object = mainLock;
            synchronized (mainLock) {
                mainLock.wait();
                // ** MonitorExit[var7_7 /* !! */ ] (shouldn't be in output)
                Trace.verbose((Object)this, "startMonitoringThread", "Notification received!");
            }
        }
        catch (InterruptedException e) {
            Trace.error((Object)this, (Throwable)e);
        }
        {
            if (lm.isLoaded()) {
                Trace.verbose((Object)this, "startMonitoringThread", "Object bundle loaded");
                mt = lm.getMonitorThread();
                if (mt != null && mt.isMonitoring(ips[0])) {
                    this.allMTs.put(lm.getMonitorThread().getArrayWWN(), mt);
                    if (this.allMTs.size() <= this.REDUCE_CACHE_TIME_THRESHOLD_THREADS) return mt;
                    Trace.verbose((Object)this, "startMonitoringThread", "Reduce idle time for threads in half if not already reduced");
                    HashMap hashMap = this.allMTs;
                    object = hashMap;
                    synchronized (hashMap) {
                        mt.setMaxIdleTimeSec(mt.getMaxIdleTimeSec() / 2);
                        Collection list = this.allMTs.values();
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            MonitorThread aMonitor = (MonitorThread)it.next();
                            if (aMonitor.getMaxIdleTimeSec() != 1800) continue;
                            aMonitor.setMaxIdleTimeSec(aMonitor.getMaxIdleTimeSec() / 2);
                        }
                        // ** MonitorExit[var7_7 /* !! */ ] (shouldn't be in output)
                        Trace.verbose((Object)this, "startMonitoringThread", "Time reduced");
                        return mt;
                    }
                }
                Trace.verbose((Object)this, "startMonitoringThread", "Error loading object bundle");
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY, ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY);
            }
            Trace.error((Object)this, "startMonitorThread", "Not loaded?");
            return mt;
        }
    }

    public synchronized MonitorThread getMonitoringThread(String arrayID) throws SEItemNotFoundException, ConfigMgmtException {
        MonitorThread mt = null;
        String wwn = this.getWWNForId(arrayID);
        if (this.allMTs == null) {
            this.allMTs = new HashMap(10);
            String[] ips = this.getIPsForID(arrayID);
            if (ips == null) {
                Trace.verbose((Object)this, "getMonitoringThread", "No ips found for id:" + arrayID);
                Trace.verbose((Object)this, "getMonitoringThread", "Attempt to get registration and re-connect");
                this.mapArrays(ArrayRegManager.getInstance().getRegisteredArrays("6130"));
                ips = this.getIPsForID(arrayID);
                if (ips == null) {
                    Trace.verbose((Object)this, "getMonitoringThread", "this is one sick dude:" + arrayID);
                    throw new ConfigMgmtException("error.array.sick", "Could not connect to array to perform operation");
                }
            }
            mt = this.startMonitoringThread(ips, wwn);
        } else {
            mt = (MonitorThread)this.allMTs.get(wwn);
            if (mt == null || !mt.isAlive()) {
                mt = this.startMonitoringThread(wwn);
            }
        }
        return mt;
    }

    class ControllerDiscoveryThread
    extends Thread {
        ArrayReg ar = null;
        ObjectBundle bundle;

        public ControllerDiscoveryThread(ArrayReg arrayReg, ObjectBundle bndl) {
            this.ar = arrayReg;
            this.bundle = bndl;
        }

        public void run() {
            Controller[] ctrl;
            String methodName = "run";
            Trace.methodBegin(this, "run");
            if (this.bundle != null && (ctrl = this.bundle.getController()) != null) {
                for (int i = 0; i < ctrl.length; ++i) {
                    String ip;
                    Controller ctr = ctrl[i];
                    if (ctr == null || (ip = ObjectBundleManager.this.getControllerIp(ctr)) == null) continue;
                    Trace.verbose((Object)this, "run", "Check if we have ip:" + ip);
                    boolean found = false;
                    for (int j = 0; j < this.ar.ips.length && !found; ++j) {
                        if (!ip.equals(this.ar.ips[j])) continue;
                        found = true;
                    }
                    if (found) continue;
                    Trace.verbose((Object)this, "run", "IP not found in registrations - verify accessibility");
                    this.verifyIPAndUpdateReg(ip);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void verifyIPAndUpdateReg(String ip) {
            SYMbolAPIClientV1 sym;
            block10: {
                int x;
                String methodName = "verifyIPAndUpdateReg";
                sym = null;
                sym = new SYMbolAPIClientV1(InetAddress.getByName(ip), 2463, true);
                if (sym == null) break block10;
                Trace.verbose((Object)this, "verifyIPAndUpdateReg", "Connected!");
                String[] newIps = new String[this.ar.ips.length + 1];
                String[] newDirectIps = new String[this.ar.directIps.length + 1];
                for (x = 0; x < this.ar.ips.length; ++x) {
                    newIps[x] = this.ar.ips[x];
                }
                newIps[this.ar.ips.length] = ip;
                for (x = 0; x < this.ar.directIps.length; ++x) {
                    newDirectIps[x] = this.ar.directIps[x];
                }
                newDirectIps[this.ar.directIps.length] = ip;
                this.fillRegData(sym, newIps, newDirectIps);
                Trace.verbose((Object)this, "verifyIPAndUpdateReg", "Call storade to update registration");
                ArrayRegManager.getInstance().updateRegistration(this.ar);
                Trace.verbose((Object)this, "verifyIPAndUpdateReg", "DONE!");
            }
            Object var8_8 = null;
            if (sym == null) return;
            try {
                sym.close();
                return;
            }
            catch (Exception e1) {}
            return;
            {
                catch (Exception e) {
                    Trace.error((Object)this, "verifyIPAndUpdateReg", e.getMessage());
                    Object var8_9 = null;
                    if (sym == null) return;
                    try {
                        sym.close();
                        return;
                    }
                    catch (Exception e1) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (sym == null) throw throwable;
                try {
                    sym.close();
                    throw throwable;
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        private void fillRegData(SYMbolAPIClientV1 sym, String[] newIps, String[] newDirectIps) throws RPCError, IOException, ConfigMgmtException {
            this.ar.setDirectIps(newDirectIps);
            this.ar.setIps(newIps);
            byte[] bwwn = sym.getSAData().getSaId().getWorldWideName();
            if (bwwn != null) {
                String wwn = Convert.bytesToString(bwwn).toUpperCase();
                this.ar.wwn = wwn.toUpperCase();
                this.ar.registrationEntryKey = ObjectBundleManager.this.getRegKey(this.bundle.getTray(), this.ar.wwn);
                this.ar.nodeName = Convert.bytesToString(this.bundle.getSa().getRemoteAccessID());
                String strAName = null;
                byte[] aName = sym.getSAData().getStorageArrayLabel().getValue();
                if (aName != null) {
                    strAName = UnicodeTranslator.getString((byte[])aName);
                }
                this.ar.setResourceName(strAName);
            }
        }
    }

    class ThreadLoadAllArrays
    extends Thread {
        ThreadLoadAllArrays() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List regArrays = ArrayRegManager.getInstance().getRegisteredArrays("6130");
            List localAllArraysData = ObjectBundleManager.this.mapArrays(regArrays);
            if (ObjectBundleManager.this.allArraysSummaryData == null) {
                ObjectBundleManager.this.allArraysSummaryData = new ArrayList();
            }
            List list = ObjectBundleManager.this.allArraysSummaryData;
            synchronized (list) {
                try {
                    ObjectBundleManager.this.allArraysSummaryData.clear();
                    ObjectBundleManager.this.allArraysSummaryData.addAll(localAllArraysData);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    class ThreadConnect
    extends Thread {
        boolean isDone;
        boolean isConnected = false;
        InetAddress arrayIP;
        SYMbolAPIClientV1 sym = null;

        public ThreadConnect(InetAddress ip) {
            this.arrayIP = ip;
        }

        public void run() {
            try {
                Trace.verbose((Object)this, "run", "Attempt connection to ip:" + this.arrayIP.getHostAddress());
                this.sym = new SYMbolAPIClientV1(this.arrayIP, 2463, true);
                Trace.verbose((Object)this, "run", "Connected!");
                this.isConnected = true;
            }
            catch (Exception e) {
                Trace.error((Object)this, (Throwable)e);
            }
            this.isDone = true;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public SYMbolAPIClientV1 getSym() {
            return this.sym;
        }
    }

    class ThreadBundleLoader
    extends Thread {
        private boolean isLoaded = false;
        private boolean isConnected = false;
        private boolean isPasswordValid = true;
        private ObjectBundle bundle = null;
        private ControllerTime ct = null;
        ArrayReg arrayReg = null;
        SYMbolAPIClientV1 sym = null;

        public boolean isPasswordValid() {
            return this.isPasswordValid;
        }

        public ThreadBundleLoader(ArrayReg ar) {
            this.arrayReg = ar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            Object ip0;
            String methodName = "run";
            String[] ips = this.arrayReg.ips;
            String preferredIP = ips[0];
            String connectedToIP = null;
            ArrayList arrayList = ObjectBundleManager.this.goodIPs;
            synchronized (arrayList) {
                Trace.verbose((Object)this, "run", "Got the lock on IP list");
                for (int i = 0; i < ips.length && ObjectBundleManager.this.goodIPs != null && !ObjectBundleManager.this.goodIPs.isEmpty(); ++i) {
                    if (ObjectBundleManager.this.goodIPs == null || !ObjectBundleManager.this.goodIPs.contains(ips[i])) continue;
                    if (i == 0) break;
                    preferredIP = ips[i];
                    ip0 = ips[0];
                    ips[0] = preferredIP;
                    ips[i] = ip0;
                    break;
                }
            }
            Trace.verbose((Object)this, "run", "Lock on IP list released");
            for (int i = 0; i < this.arrayReg.ips.length && this.sym == null; ++i) {
                try {
                    if (this.arrayReg.ips[i] == null) continue;
                    Trace.verbose((Object)this, "run", "Attempt connection on IP:" + this.arrayReg.ips[i]);
                    InetAddress inet = InetAddress.getByName(this.arrayReg.ips[i]);
                    this.sym = new SYMbolAPIClientV1(inet, 2463, true);
                    connectedToIP = this.arrayReg.ips[i];
                    continue;
                }
                catch (Exception e) {
                    Trace.error((Object)this, (Throwable)e);
                    Trace.error((Object)this, "run", "Exception while attempting to connect:" + this.arrayReg.ips[i]);
                    this.sym = null;
                    if (this.arrayReg.ips[i] == null || !this.arrayReg.ips[i].equals(preferredIP)) continue;
                    ip0 = ObjectBundleManager.this.goodIPs;
                    synchronized (ip0) {
                        Trace.verbose((Object)this, "run", "Got the lock on IP list");
                        ObjectBundleManager.this.goodIPs.remove(preferredIP);
                    }
                    Trace.verbose((Object)this, "run", "Lock on IP list released");
                }
            }
            if (this.sym != null) {
                this.isConnected = true;
                ProcedureTimeout procTimeOut = new ProcedureTimeout();
                try {
                    Trace.verbose((Object)this, "run", "Timeout for controller discovery is:" + procTimeOut.getProcTimeout(1));
                    this.sym.setTimeout(procTimeOut.getProcTimeout(1));
                    DiscoveryResponse dr = this.sym.discoverControllers();
                    if (!dr.getResponseFromAgent()) {
                        this.loadBundleAndTime(preferredIP, connectedToIP, procTimeOut);
                        if (this.arrayReg.ips.length >= 2 && this.arrayReg.ips[0] != null && !this.arrayReg.ips[0].trim().equals(ObjectBundleManager.DEFAULT_ARRAY_PASSWORD) && this.arrayReg.ips[1] != null) {
                            if (!this.arrayReg.ips[1].trim().equals(ObjectBundleManager.DEFAULT_ARRAY_PASSWORD)) return;
                        }
                        Trace.verbose((Object)this, "run", "Only one IP registered for array:" + this.arrayReg.getWwn());
                        Trace.verbose((Object)this, "run", "Start a thread to attempt discovery of the second IP");
                        ControllerDiscoveryThread cdt = new ControllerDiscoveryThread(this.arrayReg, this.bundle);
                        cdt.setDaemon(true);
                        cdt.start();
                        return;
                    }
                    AccessibleController[] cons = dr.getControllers();
                    if (cons == null) {
                        return;
                    }
                    int n = cons.length;
                    int sz = n;
                    int x = 0;
                    while (x < sz) {
                        if (this.bundle != null) return;
                        ControllerRef cr = cons[x].getThisController();
                        SAIdentifier said = cons[x].getSaId();
                        ControllerDescriptor cd = new ControllerDescriptor();
                        cd.setControllerRef(cr);
                        cd.setSaId(said);
                        this.sym.setTimeout(procTimeOut.getProcTimeout(2));
                        Trace.verbose((Object)this, "run", "Timeout for bind to controller is:" + procTimeOut.getProcTimeout(2));
                        ReturnCode rc = this.sym.bindToController(cd);
                        if (rc.getValue() == 1) {
                            Trace.verbose((Object)this, "run", "bound to controller");
                            byte[] bwwn = said.getWorldWideName();
                            if (bwwn != null) {
                                String wwn = Convert.bytesToString(bwwn).toUpperCase();
                                if (this.arrayReg.wwn.equalsIgnoreCase(wwn)) {
                                    Trace.verbose((Object)this, "run", "Array:" + wwn + " FOUND ARRAY");
                                    this.loadBundleAndTime(preferredIP, connectedToIP, procTimeOut);
                                } else {
                                    Trace.verbose((Object)this, "run", "Array:" + wwn + " DOES NOT MATCH WITH REGISTRATION:" + this.arrayReg.wwn);
                                }
                            }
                        } else {
                            Trace.verbose((Object)this, "run", "failed binding with controller:" + cons[x].getSlot());
                        }
                        ++x;
                    }
                    return;
                }
                catch (RPCError e) {
                    Trace.error((Object)this, (Throwable)e);
                    this.setUnhealthy();
                    return;
                }
                catch (IOException e) {
                    Trace.error((Object)this, (Throwable)e);
                    this.setUnhealthy();
                    return;
                }
            } else {
                this.setUnhealthy();
            }
        }

        private void validatePassword() {
            String methodName = "validatePassword";
            Trace.methodBegin(this, "validatePassword");
            ReturnCodeWithRef rc = new ReturnCodeWithRef();
            XDRvoid v = new XDRvoid();
            Trace.verbose((Object)this, "validatePassword", "INITIATE VERIFY PASSWORD");
            try {
                if (this.sym != null) {
                    ObjectBundleManager.this.setClientPassword(this.arrayReg.password, this.sym);
                    this.sym.call(66, (XDRType)v, (XDRType)rc);
                    Trace.verbose((Object)this, "validatePassword", "VERIFY PASSWORD RETURNED:" + rc.getReturnCode().getValue());
                    if (rc.getReturnCode().getValue() == 30) {
                        this.isPasswordValid = false;
                        Trace.verbose((Object)this, "validatePassword", "Password is not valid for array:" + this.arrayReg.directIps[0]);
                    }
                }
            }
            catch (RPCError e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            Trace.verbose((Object)this, "validatePassword", "VERIFY PASSWORD COMPLETED");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadBundleAndTime(String preferredIP, String connectedToIP, ProcedureTimeout procTimeOut) throws IOException, RPCError {
            String methodName = "loadBundleAndTime";
            Trace.verbose((Object)this, "loadBundleAndTime", "Timeout for controller time is:" + procTimeOut.getProcTimeout(40));
            this.sym.setTimeout(procTimeOut.getProcTimeout(40));
            this.bundle = this.sym.getObjectGraph();
            byte[] arrWwnB = this.bundle.getSa().getSaData().getSaId().getWorldWideName();
            this.isLoaded = true;
            if (!preferredIP.equals(connectedToIP)) {
                ArrayList arrayList = ObjectBundleManager.this.goodIPs;
                synchronized (arrayList) {
                    Trace.verbose((Object)this, "loadBundleAndTime", "Update IP  - got lock on the list");
                    if (ObjectBundleManager.this.goodIPs.contains(preferredIP)) {
                        ObjectBundleManager.this.goodIPs.remove(preferredIP);
                    }
                    ObjectBundleManager.this.goodIPs.add(connectedToIP);
                }
                Trace.verbose((Object)this, "loadBundleAndTime", "Update IP  - Lock released");
            }
        }

        public boolean isLoaded() {
            return this.isLoaded;
        }

        public ObjectBundle getBundle() {
            return this.bundle;
        }

        public SYMbolAPIClientV1 getClient() {
            return this.sym;
        }

        public ControllerTime getControllerTime() {
            return this.ct;
        }

        public ArrayReg getArrayReg() {
            return this.arrayReg;
        }

        public void setUnhealthy() {
            ObjectBundle b = new ObjectBundle();
            ObjectBundleManager.this.createUnhealthyBundle(b);
            this.bundle = b;
            this.isLoaded = true;
        }
    }

    private class LoadMonitor
    extends Thread {
        MonitorThread mt = null;
        boolean loaded = false;
        String[] ips = null;
        byte[] lock;
        byte[] ml;
        byte[] noUseLock;
        boolean stopMT;
        String wwn = null;

        public LoadMonitor(String[] aip, String w, boolean smt, byte[] l) {
            this.ips = aip;
            this.stopMT = smt;
            this.ml = l;
            this.wwn = w;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Object object;
            Trace.verbose((Object)this, "run", "wait for load thread to notify us:" + this.ips[0]);
            try {
                this.lock = new byte[0];
                this.noUseLock = new byte[0];
                object = this.lock;
                // MONITORENTER : this.lock
                this.mt = new MonitorThread(this.ips, this.wwn, this.lock, this.noUseLock, this.stopMT);
                this.mt.setDaemon(true);
                this.mt.start();
                this.lock.wait();
                // MONITOREXIT : object
            }
            catch (InterruptedException e) {
                Trace.error((Object)this, (Throwable)e);
            }
            catch (Exception e) {
                Trace.error((Object)this, (Throwable)e);
            }
            finally {
                this.loaded = true;
            }
            Trace.verbose((Object)this, "run", "notification received for ip:" + this.ips[0]);
            object = this.ml;
            // MONITORENTER : this.ml
            this.ml.notify();
            // MONITOREXIT : object
            Trace.verbose((Object)this, "run", "Main thread notified, wait to kill monitor thread");
            if (this.mt == null) return;
            if (this.mt.isMonitoring(this.ips[0])) {
                object = this.noUseLock;
                // MONITORENTER : this.noUseLock
                try {
                    this.noUseLock.wait();
                }
                catch (InterruptedException e1) {
                    Trace.error((Object)this, (Throwable)e1);
                }
            }
            HashMap hashMap = ObjectBundleManager.this.allMTs;
            object = hashMap;
            // MONITORENTER : hashMap
            Trace.verbose((Object)this, "run", "destroy monitoring thread - no one is using it");
            ObjectBundleManager.this.allMTs.remove(this.mt.getArrayWWN());
            this.mt = null;
            // MONITOREXIT : object
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public MonitorThread getMonitorThread() {
            return this.mt;
        }
    }
}

