/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.Connection;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.DACStoreManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ObjectPool;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.symbol.ChangeQueryDescriptor;
import devmgr.versioned.symbol.ChangeState;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MonitorThread
extends Thread {
    private static final int POLL_DELAY_SEC = 120;
    private static final int SYSTEM_TIMEOUT_SEC = 160;
    public static final int DEFAULT_MAX_IDLE_TIME_SEC = 1800;
    private static final int SLEEP_RETRY = 300;
    private static final int MAX_RETRY = 5;
    private long lastRequest = -1L;
    private long latestConfigGen = -1L;
    private long latestCriticalMel = -1L;
    private String[] arrayIPs;
    private String arrayIP;
    private String arrayWWN;
    private ObjectBundle objectBundle = null;
    byte[] lock;
    byte[] noUseLock;
    boolean notified = false;
    boolean stopMonitoring = false;
    int controller = 0;
    boolean connected = false;
    int retryCount = 0;
    Object poolData = null;
    Object profileData = null;
    Map volumeCandidatesByRaid;
    DACStoreManager dacStoreMgr = null;
    int maxIdleTimeSec;
    private ConfigMgmtException lastException;
    Connection conn;
    boolean volumeCandidatesNeedReload = true;
    boolean poolsNeedReload = true;
    boolean profilesNeedReload = true;

    public MonitorThread(String[] argIP, String argWWN, byte[] alock, byte[] aNoUseLock, boolean smt) throws SEItemNotFoundException, RPCError, IOException {
        this.arrayIPs = argIP;
        this.arrayWWN = argWWN;
        this.lock = alock;
        this.noUseLock = aNoUseLock;
        this.stopMonitoring = smt;
        this.objectBundle = new ObjectBundle();
        this.lastRequest = System.currentTimeMillis();
        this.maxIdleTimeSec = 1800;
        this.dacStoreMgr = new DACStoreManager(this.arrayWWN);
        this.volumeCandidatesByRaid = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        byte[] byArray;
        Trace.methodBegin(this, "run");
        SYMbolAPIClientV1 sym = null;
        Object inet = null;
        this.connected = false;
        try {
            while (!this.stopMonitoring) {
                ChangeQueryDescriptor chgQuery = new ChangeQueryDescriptor();
                sym = this.establishConnection();
                while (this.connected && !this.stopMonitoring) {
                    try {
                        this.getDataFromController(sym, chgQuery);
                    }
                    catch (RPCError rpce) {
                        if (this.connected) {
                            this.closeConnection(sym);
                        }
                        while (!this.stopMonitoring && !this.connected) {
                            this.processRetry();
                            if (this.stopMonitoring) continue;
                            sym = this.establishConnection();
                        }
                    }
                    catch (NullPointerException npe) {
                        while (!this.stopMonitoring && !this.connected) {
                            this.processRetry();
                            if (this.stopMonitoring) continue;
                            sym = this.establishConnection();
                        }
                    }
                    catch (Exception ex) {
                        if (!this.stopMonitoring) {
                            Trace.error((Object)this, "run", (Throwable)ex);
                            this.stopMonitoring = true;
                        }
                        if (!this.connected) continue;
                        this.closeConnection(sym);
                    }
                }
                this.closeConnection(sym);
            }
        }
        catch (Throwable t) {
            this.connected = false;
            Trace.error((Object)this, "run", t);
        }
        if (this.lock != null) {
            byArray = this.lock;
            // MONITORENTER : this.lock
            this.lock.notifyAll();
            // MONITOREXIT : byArray
        }
        if (this.noUseLock != null) {
            byArray = this.noUseLock;
            // MONITORENTER : this.noUseLock
            this.noUseLock.notify();
            // MONITOREXIT : byArray
        }
        Trace.verbose((Object)this, "run", "Thread is DONE!");
    }

    private SYMbolAPIClientV1 establishConnection() {
        this.conn = (Connection)ObjectPool.getInstance().checkOut(this.arrayWWN, "6130");
        SYMbolAPIClientV1 sym = (SYMbolAPIClientV1)this.conn.getHandle();
        if (sym != null) {
            try {
                sym.setTimeout(160);
                this.connected = true;
            }
            catch (Exception e) {
                Trace.error((Object)this, "run", (Throwable)e);
                this.closeConnection(sym);
                this.processRetry();
            }
        } else {
            this.processRetry();
        }
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRetry() {
        String methodName = "processRetry";
        Trace.methodBegin(this, "processRetry");
        this.connected = false;
        try {
            MonitorThread.sleep(300L);
        }
        catch (InterruptedException e) {
            this.stopMonitoring = true;
            return;
        }
        ++this.retryCount;
        if (this.retryCount > 5) {
            Trace.verbose((Object)this, "processRetry", "Enough! Array is not accessible");
            this.objectBundle = null;
            this.stopMonitoring = true;
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                this.lock.notify();
                // ** MonitorExit[var2_3] (shouldn't be in output)
            }
        } else {
            Trace.verbose((Object)this, "processRetry", "Retry count:" + this.retryCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(SYMbolAPIClientV1 sym) {
        String methodName = "closeConnection";
        Trace.methodBegin(this, "closeConnection");
        try {
            try {
                if (sym != null) {
                    sym.close();
                }
                Trace.verbose((Object)this, "closeConnection", "Connection closed");
            }
            catch (Exception exception) {
                Object var5_4 = null;
                this.connected = false;
                this.objectBundle = new ObjectBundle();
                if (this.conn == null) return;
                ObjectPool.getInstance().remove(this.arrayWWN, this.conn);
                return;
            }
            Object var5_3 = null;
            this.connected = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.connected = false;
            this.objectBundle = new ObjectBundle();
            if (this.conn != null) {
                ObjectPool.getInstance().remove(this.arrayWWN, this.conn);
            }
            sym = null;
            throw throwable;
        }
        this.objectBundle = new ObjectBundle();
        if (this.conn == null) return;
        ObjectPool.getInstance().remove(this.arrayWWN, this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void getDataFromController(SYMbolAPIClientV1 sym, ChangeQueryDescriptor chgQuery) throws RPCError, IOException {
        long currentTimeMillis;
        String methodName = "getDataFromController";
        ChangeState chgState = null;
        if (this.notified) {
            Trace.verbose((Object)this, "getDataFromController", "Poll for change on array:" + this.arrayWWN);
            Trace.verbose((Object)this, "getDataFromController", "Last config generation number is:" + this.latestConfigGen);
            chgQuery.getLastKnown().setConfigGeneration(this.latestConfigGen);
            chgQuery.getLastKnown().setLastCriticalMelSeqNumber(this.latestCriticalMel);
            chgQuery.setMaxWait(120);
            chgState = sym.getChangeState(chgQuery);
            this.latestCriticalMel = chgState.getLastCriticalMelSeqNumber();
        }
        if (chgState == null || chgState.getConfigGeneration() != this.latestConfigGen) {
            Trace.verbose((Object)this, "getDataFromController", "PROFILE: GOT to request reload for array:" + this.arrayWWN);
            Object object = this.objectBundle;
            // MONITORENTER : object
            this.objectBundle = sym.getObjectGraph();
            this.volumeCandidatesNeedReload = true;
            this.poolsNeedReload = true;
            this.profilesNeedReload = true;
            // MONITOREXIT : object
            Trace.verbose((Object)this, "getDataFromController", "PROFILE: GOT bundle back");
            this.latestConfigGen = chgState == null ? -1L : chgState.getConfigGeneration();
            Trace.verbose((Object)this, "getDataFromController", "Last config generation number is:" + this.latestConfigGen);
            if (this.lock != null) {
                Trace.verbose((Object)this, "getDataFromController", "Notify if someone is waiting...");
                object = this.lock;
                // MONITORENTER : this.lock
                this.arrayWWN = Convert.bytesToString(sym.getSAData().getSaId().getWorldWideName());
                this.lock.notifyAll();
                this.notified = true;
                // MONITOREXIT : object
            }
        }
        if (((currentTimeMillis = System.currentTimeMillis()) - this.lastRequest) / 1000L <= (long)this.maxIdleTimeSec) return;
        Trace.verbose((Object)this, "getDataFromController", "Stop monitoring this array");
        this.stopMonitoring = true;
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "getDataFromController", "Free memory BEFORE object is invalidated:" + Runtime.getRuntime().freeMemory());
        }
        this.objectBundle = new ObjectBundle();
        byte[] byArray = this.noUseLock;
        // MONITORENTER : this.noUseLock
        this.noUseLock.notify();
        // MONITOREXIT : byArray
        if (Trace.isTraceEnabled(this)) {
            System.gc();
            Trace.verbose((Object)this, "getDataFromController", "Free memory AFTER object is invalidated:" + Runtime.getRuntime().freeMemory());
        }
        ObjectPool.getInstance().flush(this.arrayWWN);
    }

    public long getLatestConfigGen() {
        return this.latestConfigGen;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ObjectBundle getBundle() {
        this.lastRequest = System.currentTimeMillis();
        ObjectBundle objectBundle = this.objectBundle;
        // MONITORENTER : objectBundle
        // MONITOREXIT : objectBundle
        return this.objectBundle;
    }

    public boolean isMonitoring(String arg0) {
        boolean mon = false;
        Trace.verbose((Object)this, "isMonitoring", arg0);
        if (!this.connected) {
            return false;
        }
        if (this.arrayIPs != null && arg0 != null) {
            for (int i = 0; i < this.arrayIPs.length && !mon; ++i) {
                mon = arg0.equals(this.arrayIPs[i]);
            }
        }
        if (!mon && arg0 != null && arg0.equals(this.arrayWWN)) {
            mon = true;
        }
        return mon;
    }

    public String[] getArrayIPs() {
        return this.arrayIPs;
    }

    public String getArrayWWN() {
        return this.arrayWWN;
    }

    public byte[] getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPoolData() {
        this.lastRequest = System.currentTimeMillis();
        if (this.poolsNeedReload) {
            ObjectBundle objectBundle = this.objectBundle;
            synchronized (objectBundle) {
                block10: {
                    try {
                        this.poolData = this.dacStoreMgr.getPools();
                        this.poolsNeedReload = false;
                    }
                    catch (ConfigMgmtException e) {
                        if (!this.stopMonitoring) {
                            Trace.error((Object)this, e);
                            this.lastException = e;
                        }
                    }
                    catch (RPCError e) {
                        if (!this.stopMonitoring) {
                            Trace.error((Object)this, (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (this.stopMonitoring) break block10;
                        Trace.error((Object)this, (Throwable)e);
                    }
                }
            }
        }
        return this.poolData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProfileData() {
        this.lastRequest = System.currentTimeMillis();
        if (this.profilesNeedReload) {
            ObjectBundle objectBundle = this.objectBundle;
            synchronized (objectBundle) {
                block10: {
                    try {
                        this.profileData = this.dacStoreMgr.getProfiles();
                        this.profilesNeedReload = false;
                    }
                    catch (ConfigMgmtException e) {
                        if (!this.stopMonitoring) {
                            Trace.error((Object)this, e);
                            this.lastException = e;
                        }
                    }
                    catch (RPCError e) {
                        if (!this.stopMonitoring) {
                            Trace.error((Object)this, (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (this.stopMonitoring) break block10;
                        Trace.error((Object)this, (Throwable)e);
                    }
                }
            }
        }
        return this.profileData;
    }

    public int getMaxIdleTimeSec() {
        return this.maxIdleTimeSec;
    }

    public void setMaxIdleTimeSec(int maxIdleTimeSec) {
        this.maxIdleTimeSec = maxIdleTimeSec;
    }

    public ConfigMgmtException getLastException() {
        return this.lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getVolumeCandidatesByRaid() {
        String methodName = "getVolumeCandidatesByRaid";
        Map map = this.volumeCandidatesByRaid;
        synchronized (map) {
            if (this.volumeCandidatesNeedReload) {
                Trace.verbose((Object)this, "getVolumeCandidatesByRaid", "Get all volume candidates");
                try {
                    this.volumeCandidatesByRaid = VolumeCandidateFetcher.loadAllVolumeCandidates(this.arrayWWN);
                    this.volumeCandidatesNeedReload = false;
                }
                catch (ConfigMgmtException e) {
                    Trace.error((Object)this, "getVolumeCandidatesByRaid", "Cannot get volume candidates for this array...");
                }
            }
        }
        return this.volumeCandidatesByRaid;
    }
}

