/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import org.apache.commons.beanutils.PropertyUtils;

public class MapElement
implements Serializable {
    public static final boolean ALLOW_NULL = true;
    public static final boolean READ_ONLY = true;
    public static final int NOT_INDEXED = -1;
    private Class cimDataType;
    private String javaField;
    private String cimProperty;
    private boolean readOnly;
    private boolean nullAllowed;
    private int index;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$wbem$cim$UnsignedInt16;
    static /* synthetic */ Class class$java$lang$String;

    public MapElement(String javaField, String cimProperty, boolean readOnly, boolean nullAllowed, int index, Class cimDataType) {
        this.javaField = javaField;
        this.cimProperty = cimProperty;
        this.readOnly = readOnly;
        this.nullAllowed = nullAllowed;
        this.index = index;
        this.cimDataType = cimDataType;
    }

    public MapElement(String javaField, String cimProperty, boolean readOnly, boolean nullAllowed, int index) {
        this.javaField = javaField;
        this.cimProperty = cimProperty;
        this.readOnly = readOnly;
        this.nullAllowed = nullAllowed;
        this.index = index;
    }

    public String toString() {
        return "MapElement Object [ javaField = " + this.javaField + ", cimProperty = " + this.cimProperty + ", readOnly = " + this.readOnly + ", nullAllowed = " + this.nullAllowed + " ]";
    }

    public MapElement(String javaField, String cimProperty) {
        this(javaField, cimProperty, false, false, -1);
    }

    public MapElement(String javaField) {
        this(javaField, javaField, false, false, -1);
    }

    public MapElement(String javaField, String cimProperty, boolean readOnly, boolean nullAllowed) {
        this(javaField, cimProperty, readOnly, nullAllowed, -1);
    }

    public String getCimProperty() {
        return this.cimProperty;
    }

    public int getIndex() {
        return this.index;
    }

    public String getJavaField() {
        return this.javaField;
    }

    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isArray() {
        return this.index > -1;
    }

    public void populate(Object toPopulate, CIMInstance instance) throws ConfigMgmtException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Trace.methodBegin(this, "populate");
        Trace.verbose((Object)this, "populate", "CIMProperty=" + this.getCimProperty());
        Trace.verbose((Object)this, "populate", "Java Field =" + this.getJavaField());
        CIMValue value = null;
        CIMProperty prop = instance.getProperty(this.getCimProperty());
        if (prop != null) {
            value = prop.getValue();
        }
        if (value == null) {
            this.handleNullOnPopulate(toPopulate);
        } else if (value.getValue() == null) {
            this.handleNullOnPopulate(toPopulate);
        } else {
            this.doPopulate(toPopulate, value);
        }
    }

    protected void doPopulate(Object toPopulate, CIMValue value) throws ConfigMgmtException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (value.getType().getType() == 12) {
            this.populateDate(toPopulate, value);
        } else if (value.getType().isArrayType()) {
            this.populateFromArray(toPopulate, value);
        } else if (this.valueIsSmallNumber(value)) {
            this.populateFromNumber(toPopulate, value);
        } else if (this.valueIsBigNumber(value)) {
            this.populateBigNumber(toPopulate, value);
        } else {
            this.populateDefault(toPopulate, value);
        }
    }

    private void populateDate(Object toPopulate, CIMValue value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyUtils.setProperty((Object)toPopulate, (String)this.getJavaField(), (Object)((CIMDateTime)value.getValue()).getCalendar().getTime());
    }

    private void populateDefault(Object toPopulate, CIMValue value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyUtils.setProperty((Object)toPopulate, (String)this.getJavaField(), (Object)value.getValue());
    }

    private void populateBigNumber(Object toPopulate, CIMValue value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Number number = (Number)value.getValue();
        PropertyUtils.setProperty((Object)toPopulate, (String)this.getJavaField(), (Object)new BigInteger(number.toString()));
    }

    private boolean valueIsBigNumber(CIMValue value) {
        return value.getType().getType() == 6;
    }

    private void populateFromNumber(Object toPopulate, CIMValue value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Number number = (Number)value.getValue();
        String methodName = "get" + this.getJavaField().substring(0, 1).toUpperCase() + this.getJavaField().substring(1);
        Method method = toPopulate.getClass().getMethod(methodName, new Class[0]);
        if (method.getReturnType().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = MapElement.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            PropertyUtils.setProperty((Object)toPopulate, (String)this.getJavaField(), (Object)new Integer(number.intValue()));
        } else if (method.getReturnType().equals(Integer.TYPE)) {
            PropertyUtils.setProperty((Object)toPopulate, (String)this.getJavaField(), (Object)new Integer(number.intValue()));
        } else {
            PropertyUtils.setProperty((Object)toPopulate, (String)this.getJavaField(), (Object)new Long(number.longValue()));
        }
    }

    private boolean valueIsSmallNumber(CIMValue value) {
        return value.getType().getType() == 0 || value.getType().getType() == 2 || value.getType().getType() == 4;
    }

    private void populateFromArray(Object toPopulate, CIMValue value) throws ConfigMgmtException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Vector vector = (Vector)value.getValue();
        if (vector.size() < this.getIndex() + 1) {
            this.handleNullOnPopulate(toPopulate);
            return;
        }
        Object object = vector.get(this.getIndex());
        if (object == null) {
            this.handleNullOnPopulate(toPopulate);
        }
        if ((class$javax$wbem$cim$UnsignedInt16 == null ? (class$javax$wbem$cim$UnsignedInt16 = MapElement.class$("javax.wbem.cim.UnsignedInt16")) : class$javax$wbem$cim$UnsignedInt16).isInstance(object)) {
            object = new Integer(((UnsignedInt16)object).intValue());
        }
        PropertyUtils.setProperty((Object)toPopulate, (String)this.getJavaField(), object);
    }

    public void handleNullOnPopulate(Object toPopulate) throws ConfigMgmtException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Trace.methodBegin(this, "handleNullOnPopulate");
        Trace.verbose((Object)this, "handleNullOnPopulate", "good");
        if (!this.isNullAllowed()) {
            StringBuffer sb = new StringBuffer("Failed to populate java field: " + this.getJavaField() + " since null property not allowed");
            if (this.getIndex() > -1) {
                sb.append(" at index: " + this.getIndex());
            }
            sb.append(" in CIM property: " + this.getCimProperty());
            Trace.error((Object)this, "handleNullOnPopulate", sb.toString());
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", sb.toString());
        }
        PropertyUtils.setProperty((Object)toPopulate, (String)this.getJavaField(), null);
    }

    public void save(Object toSave, Vector vector) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.isReadOnly()) {
            return;
        }
        if (this.isArray()) {
            vector.add(this.arrayValue(toSave));
        } else {
            vector.add(this.simpleValue(toSave));
        }
    }

    public void save(Object toSave, Map map) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.isReadOnly()) {
            return;
        }
        CIMProperty property = this.isArray() ? this.arrayValue(toSave) : this.simpleValue(toSave);
        map.put(property.getName(), property);
    }

    protected CIMProperty simpleValue(Object toSave) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object o = PropertyUtils.getProperty((Object)toSave, (String)this.getJavaField());
        if (o instanceof Date) {
            o = new CIMDateTime((Date)o);
        }
        return new CIMProperty(this.getCimProperty(), new CIMValue(o));
    }

    private CIMProperty arrayValue(Object toSave) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Vector<String> valueVector = new Vector<String>();
        String value = PropertyUtils.getProperty((Object)toSave, (String)this.getJavaField()).toString();
        if (null != this.cimDataType) {
            Class[] constructorParamTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MapElement.class$("java.lang.String")) : class$java$lang$String};
            Constructor constructor = this.cimDataType.getConstructor(constructorParamTypes);
            Object[] initArgs = new Object[]{value};
            try {
                value = constructor.newInstance(initArgs);
            }
            catch (InstantiationException e) {
                Trace.verbose((Object)this, "InstantiationException", (Throwable)e);
            }
        }
        valueVector.add(value);
        return new CIMProperty(this.getCimProperty(), new CIMValue(valueVector));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

