/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.oz.baseline.Baseline;
import com.sun.oz.cli.StadeServer;
import com.sun.oz.devices.CSMArray;
import com.sun.oz.devices.CSMArrayException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class CSMProxy {
    private static final String base_line_master = "/var/sadm/swimages/env.sh";
    private static final String base_line_master_property = "CSM_PATCH_LIST";
    private static final String basedir_default = "/var/sadm/swimages";
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy;

    public static CSMArray getCSMArray(ArrayReg arrayReg, StadeServer saServer, Baseline baseline) throws ConfigMgmtException {
        CSMArray csmArray = null;
        try {
            DeviceProperties dp = StoradeProxy.getDeviceProperties(arrayReg, true);
            if (saServer == null) {
                saServer = CSMProxy.getSaServer();
            }
            if (baseline == null) {
                baseline = CSMProxy.getBaseline();
            }
            if ((csmArray = new CSMArray(dp, saServer, baseline)) == null) {
                throw new ConfigMgmtException("error.csmarray.is.null", "Error creating csmarray from array");
            }
        }
        catch (StoradeException se) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = CSMProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)se);
            throw new ConfigMgmtException((Exception)((Object)se));
        }
        catch (UnknownHostException uhe) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = CSMProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)uhe);
            throw new ConfigMgmtException(uhe);
        }
        catch (MalformedURLException mue) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = CSMProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, (Throwable)mue);
            throw new ConfigMgmtException(mue);
        }
        return csmArray;
    }

    public static String[] analyzeArray(CSMArray csmArray) throws ConfigMgmtException {
        String[] upgradeInfo = null;
        try {
            csmArray.analyze();
            upgradeInfo = CSMProxy.getUpgradeInfo(csmArray);
        }
        catch (CSMArrayException ex) {
            throw new ConfigMgmtException("error.array.analyze.component", "Error while analyzing the Array Components", (Exception)((Object)ex));
        }
        return upgradeInfo;
    }

    public static String[] getUpgradeInfo(CSMArray csmArray) {
        ArrayList<String> arrayInfoList = new ArrayList<String>();
        if (csmArray.is_CRM_F_UpdateRequired()) {
            arrayInfoList.add("CRM_F");
        }
        if (csmArray.is_CRM_F_NVSRAMUpdateRequired()) {
            arrayInfoList.add("CRM_F_NVSRAM");
        }
        if (csmArray.is_IOM_F_UpdateRequired()) {
            arrayInfoList.add("IOM_F");
        }
        if (csmArray.is_IOM_S_UpdateRequired()) {
            arrayInfoList.add("IOM_S");
        }
        if (csmArray.isDiskDriveUpdateRequired()) {
            arrayInfoList.add("DISK_DRIVE");
        }
        return arrayInfoList.toArray(new String[arrayInfoList.size()]);
    }

    private static Baseline getBaseline() throws ConfigMgmtException {
        String baselineStr = (String)Repository.getRepository().getProperty("CSM_BASELINE");
        if (baselineStr == null) {
            baselineStr = "117856-17";
        }
        if ("".equals(baselineStr)) {
            throw new ConfigMgmtException("error.patchid.not.found", "Cann't find PatchID to check firmware upgrades");
        }
        return new Baseline(baselineStr, basedir_default);
    }

    private static String getBaseLineStr() throws ConfigMgmtException {
        String property;
        String methodName = "getBaseLineStr";
        String basefile = (String)Repository.getRepository().getProperty("CSM_BASELINE_MASTER");
        if (basefile == null) {
            basefile = base_line_master;
        }
        if ((property = (String)Repository.getRepository().getProperty("CSM_BASELINE_MASTER_PROPERTY")) == null) {
            property = base_line_master_property;
        }
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy = CSMProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.CSMProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy, "getBaseLineStr", "basefile : " + basefile);
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy = CSMProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.CSMProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy, "getBaseLineStr", "property : " + property);
        String str = "";
        String patchIDStr = "";
        int patchIndex = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(basefile));
            boolean first = true;
            while ((str = in.readLine()) != null) {
                if (str.trim().startsWith("#") || str.indexOf(property) == -1) continue;
                int begin = str.indexOf("[");
                int end = str.indexOf("]");
                if (begin == -1 || end == -1 || end <= begin) continue;
                int tmpIndex = new BigInteger(str.substring(begin + 1, end)).intValue();
                if (str.indexOf("=") != -1) {
                    if ((str = str.substring(str.indexOf("=") + 1).trim()).startsWith("\"")) {
                        str = str.substring(str.indexOf("\"") + 1, str.lastIndexOf("\""));
                    }
                    if (str.indexOf(" ") != -1) {
                        str = str.substring(0, str.indexOf(" "));
                    }
                }
                if (first) {
                    patchIndex = tmpIndex;
                    patchIDStr = str;
                    continue;
                }
                if (tmpIndex <= patchIndex) continue;
                patchIndex = tmpIndex;
            }
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy = CSMProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.CSMProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$CSMProxy, "getBaseLineStr", " PatchID : " + patchIDStr);
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new ConfigMgmtException("error.patch.file.not.found", "Cann't find env.sh file to check firmware upgrades", fnfe);
        }
        catch (IOException ioe) {
            throw new ConfigMgmtException("error.patch.file.io", "Cann't read env.sh file to check firmware upgrades. File may corrupted", ioe);
        }
        return patchIDStr;
    }

    private static StadeServer getSaServer() throws MalformedURLException {
        StadeServer saServer = null;
        try {
            if (Repository.getRepository().getProperty("custom-storade-url") != null) {
                String url = (String)Repository.getRepository().getProperty("custom-storade-url");
                URI agent = null;
                agent = new URI(url);
                String userInfo = "root:solaris";
                agent = new URI(agent.getScheme(), userInfo, agent.getHost(), agent.getPort(), agent.getPath(), agent.getQuery(), agent.getFragment());
                saServer = new StadeServer(agent.toURL());
            } else {
                saServer = new StadeServer();
            }
        }
        catch (URISyntaxException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = CSMProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getSaServer", (Throwable)e);
        }
        catch (StoradeException se) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy = CSMProxy.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$StoradeProxy, "getSaServer", (Throwable)se);
        }
        return saServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

