/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.exception;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfigMgmtException
extends Exception {
    private Exception e;
    private String key;
    private String msg;
    private String[] substitutions = new String[0];
    private ArrayList context = new ArrayList();
    private ErrorDescriptor errorDescriptor;
    private int type = 100;
    private boolean isMulti = false;
    private ArrayList multiResult = null;

    public ConfigMgmtException() {
    }

    public ConfigMgmtException(String key, String msg) {
        super(msg);
        Trace.constructor(this);
        this.key = key;
        this.msg = msg;
    }

    public ConfigMgmtException(String key, String msg, Exception e) {
        super(msg);
        Trace.constructor(this);
        this.key = key;
        this.msg = msg;
        this.e = e;
    }

    public ConfigMgmtException(String key, String[] substitutions, String msg, Exception e) {
        this(key, msg, e);
        this.substitutions = substitutions;
    }

    public ConfigMgmtException(Exception e) {
        Trace.constructor(this);
        this.e = e;
    }

    public ConfigMgmtException(String key, String[] substitutions, String msg, Exception e, int type) {
        this(key, msg, e);
        this.substitutions = substitutions;
        this.type = type;
    }

    public ConfigMgmtException(ArrayList multi, String key, String msg, int type) {
        this(key, msg, null);
        this.type = type;
        this.multiResult = multi;
        this.isMulti = true;
    }

    public ConfigMgmtException(ErrorDescriptor descriptor, int type) {
        this(descriptor.getI18nkey(), descriptor.getMsg(), null);
        this.errorDescriptor = descriptor;
        this.substitutions = descriptor.getI18nParams();
        this.type = type;
    }

    public void addExceptionContext(Object o) {
        if (o != null) {
            this.context.add(o);
        }
    }

    public void addExceptionContext(List l) {
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                this.context.add(it.next());
            }
        }
    }

    public List getExceptionContext() {
        return this.context;
    }

    public Exception getEmbededException() {
        return this.e;
    }

    public String getExceptionKey() {
        Trace.verbose((Object)this, "getExceptionKey", this.key);
        return this.key;
    }

    public void setExceptionKey(String key) {
        Trace.verbose((Object)this, "setExceptionKey", key);
        this.key = key;
    }

    public String getExceptionMsg() {
        Trace.verbose((Object)this, "getExceptionMsg", this.msg);
        return this.msg;
    }

    public String[] getSubstitutions() {
        if (this.substitutions == null) {
            return new String[0];
        }
        return this.substitutions;
    }

    public int getType() {
        return this.type;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public ArrayList getMultiResults() {
        return this.multiResult;
    }

    public ErrorDescriptor getErrorDescriptor() {
        return this.errorDescriptor;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("");
        try {
            if (this.msg != null) {
                result.append(this.msg);
            } else {
                result.append("\nNO MESSAGE");
            }
            result.append("\n");
            result.append("Exception context:\n");
            if (this.context != null) {
                Iterator it = this.context.iterator();
                while (it.hasNext()) {
                    try {
                        result.append(it.next().toString());
                    }
                    catch (Exception e) {
                        result.append("Error appending parameter, cause:" + e.getMessage());
                    }
                    result.append("\n");
                }
            }
            result.append("Exception stack trace:\n");
            StackTraceElement[] ste = this.getStackTrace();
            if (ste != null) {
                for (int i = 0; i < ste.length; ++i) {
                    result.append("\t");
                    result.append(ste[i].toString());
                    result.append("\n");
                }
            }
            if (this.getEmbededException() != null) {
                result.append("\nRoot cause for the exception:\n");
                result.append(this.getEmbededException().toString());
                result.append("\n");
                ste = this.getEmbededException().getStackTrace();
                if (ste != null) {
                    for (int i = 0; i < ste.length; ++i) {
                        result.append("\t");
                        result.append(ste[i].toString());
                        result.append("\n");
                    }
                }
            }
        }
        catch (Throwable t) {
            result.append("***Exception in creating trace:" + t);
        }
        return result.toString();
    }

    public static interface Types {
        public static final int INTERNAL = 100;
        public static final int BE_CONNECTION = 200;
        public static final int OPERATIONAL = 300;
    }
}

