/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class ConfigContext
implements Serializable {
    private Map context;
    private Locale locale;
    private transient CIMOMHandleWrapper client;
    private transient PasswordCredential passwordCredential;
    private transient UserPrincipal userPrincipal;
    private String user;

    public ConfigContext(CIMOMHandleWrapper client) {
        Trace.constructor(this);
        this.context = new HashMap(5);
        this.client = client;
    }

    public ConfigContext() {
        this.context = new HashMap(5);
    }

    public void setAttribute(String key, Object value) {
        if (key != null) {
            if (value == null) {
                this.context.remove(key);
            } else {
                this.context.put(key, value);
            }
        }
    }

    public Map getAttributes() {
        return this.context;
    }

    public Object getAttribute(String key) {
        return this.context.get(key);
    }

    public ConfigContext(CIMOMHandleWrapper client, UserPrincipal principal, PasswordCredential credential) {
        Trace.constructor(this);
        this.client = client;
        this.passwordCredential = credential;
        this.userPrincipal = principal;
    }

    public ConfigContext(CIMOMHandleWrapper client, UserPrincipal principal, PasswordCredential credential, Locale loc) {
        Trace.constructor(this);
        this.client = client;
        this.passwordCredential = credential;
        this.userPrincipal = principal;
        Trace.verbose((Object)this, "constructor", "have locale: " + loc);
        this.locale = loc;
        this.context = new HashMap(5);
    }

    public ConfigContext(CIMOMHandleWrapper client, ConfigContext oldContext) {
        Trace.constructor(this);
        this.client = client;
        this.passwordCredential = oldContext.getPasswordCredential();
        this.userPrincipal = oldContext.getUserPrincipal();
        this.locale = oldContext.getLocale();
    }

    public CIMOMHandleWrapper getClient() {
        Trace.methodBegin(this, "getClient");
        return this.client;
    }

    public void setUser(String argUser) {
        this.user = argUser;
    }

    public String getUser() {
        return this.user;
    }

    public PasswordCredential getPasswordCredential() {
        return this.passwordCredential;
    }

    public UserPrincipal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

