/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business.impl.test;

import com.sun.netstorage.array.mgmt.cfg.admin.business.Role;
import com.sun.netstorage.array.mgmt.cfg.admin.business.UserRoleAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.test.UserTestImpl;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class UserRoleAdminTestImpl
implements UserRoleAdminInterface {
    private ConfigContext configContext;
    private Role role = null;
    private static UserTestImpl GUEST1 = new UserTestImpl("fg214314", Role.GUEST);
    private static UserTestImpl GUEST2 = new UserTestImpl("uy234124", Role.GUEST);
    private static UserTestImpl GUEST3 = new UserTestImpl("hh324214", Role.GUEST);
    private static UserTestImpl GUEST4 = new UserTestImpl("xx214314", Role.GUEST);
    private static UserTestImpl GUEST5 = new UserTestImpl("yy234124", Role.GUEST);
    private static UserTestImpl GUEST6 = new UserTestImpl("xx324214", Role.GUEST);
    private static UserTestImpl ADMIN1 = new UserTestImpl("aa1363521", Role.ADMIN);
    private static UserTestImpl ADMIN2 = new UserTestImpl("ab1363521", Role.ADMIN);
    private static UserTestImpl ADMIN3 = new UserTestImpl("ac1363521", Role.ADMIN);
    private static UserTestImpl ADMIN4 = new UserTestImpl("ad1363521", Role.ADMIN);
    private static UserTestImpl ADMIN5 = new UserTestImpl("ae1363521", Role.ADMIN);
    private static UserTestImpl ADMIN6 = new UserTestImpl("af1363521", Role.ADMIN);
    private static UserTestImpl STORAGE1 = new UserTestImpl("bv141166", Role.STORAGE);
    private static UserTestImpl STORAGE2 = new UserTestImpl("tg123456", Role.STORAGE);
    private static UserTestImpl STORAGE3 = new UserTestImpl("bb141166", Role.STORAGE);
    private static UserTestImpl STORAGE4 = new UserTestImpl("bc123456", Role.STORAGE);
    private UserTestImpl[] ALL_USER_ARRAY = new UserTestImpl[]{GUEST1, GUEST2, GUEST3, GUEST4, GUEST5, GUEST6, ADMIN1, ADMIN2, ADMIN3, ADMIN4, ADMIN5, ADMIN6, STORAGE1, STORAGE2, STORAGE3, STORAGE4};
    private UserTestImpl[] GUEST_USERS = new UserTestImpl[]{GUEST1, GUEST2, GUEST3, GUEST4, GUEST5, GUEST6};
    private UserTestImpl[] ADMIN_USERS = new UserTestImpl[]{ADMIN1, ADMIN2, ADMIN3, ADMIN4, ADMIN5, ADMIN6};
    private UserTestImpl[] STORAGE_USERS = new UserTestImpl[]{STORAGE1, STORAGE2, STORAGE3, STORAGE4};
    private List ALL_USERS = new ArrayList<UserTestImpl>(Arrays.asList(this.ALL_USER_ARRAY));
    private HashMap nameToUserMap;
    private HashMap roleToAccountMap;

    private HashMap getNameToUserMap() {
        if (null == this.nameToUserMap) {
            this.nameToUserMap = new HashMap();
            for (int i = 0; i < this.ALL_USER_ARRAY.length; ++i) {
                this.nameToUserMap.put(this.ALL_USER_ARRAY[i].getName(), this.ALL_USER_ARRAY[i]);
            }
        }
        return this.nameToUserMap;
    }

    private HashMap getRoleToAccountMap() {
        if (null == this.roleToAccountMap) {
            this.roleToAccountMap = new HashMap();
            this.roleToAccountMap.put(Role.ADMIN, new ArrayList<UserTestImpl>(Arrays.asList(this.ADMIN_USERS)));
            this.roleToAccountMap.put(Role.GUEST, new ArrayList<UserTestImpl>(Arrays.asList(this.GUEST_USERS)));
            this.roleToAccountMap.put(Role.STORAGE, new ArrayList<UserTestImpl>(Arrays.asList(this.STORAGE_USERS)));
        }
        return this.roleToAccountMap;
    }

    public void init(ConfigContext context) {
        this.configContext = context;
    }

    public void setRoleFilter(Role role) {
        this.role = role;
    }

    public List getUserList() throws ConfigMgmtException {
        if (null == this.role) {
            return this.ALL_USERS;
        }
        return (List)this.getRoleToAccountMap().get(this.role);
    }

    public void createUser(String name, Role role) {
        UserTestImpl newUser = new UserTestImpl(name, role);
        ((List)this.getRoleToAccountMap().get(role)).add(newUser);
        this.ALL_USERS.add(newUser);
        this.getNameToUserMap().put(name, newUser);
    }

    public void delete(String[] toDelete) throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        for (int i = 0; i < toDelete.length; ++i) {
            Trace.verbose((Object)this, "delete", "removing " + toDelete[i]);
            UserTestImpl deleteUser = (UserTestImpl)this.getNameToUserMap().get(toDelete[i]);
            this.ALL_USERS.remove(deleteUser);
            Iterator iterator = this.getRoleToAccountMap().values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                list.remove(deleteUser);
            }
            this.getNameToUserMap().remove(toDelete[i]);
        }
    }

    public void create(Properties props) throws ConfigMgmtException {
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        return null;
    }

    public int getMaxObjects() {
        return 0;
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
    }

    public List getItemList() throws ConfigMgmtException {
        return null;
    }

    public int getItemCount() throws ConfigMgmtException {
        return 0;
    }

    public boolean isOperationSupported(String operation) {
        return false;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
    }
}

