/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.OperatingSystem;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import java.util.Date;
import java.util.TimeZone;
import javax.wbem.cim.CIMInstance;

public class SystemTimeAdmin
implements SystemTimeAdminInterface {
    private OperatingSystem operatingSystem;
    private ConfigContext configContext;
    private CIMInstance t4Instance;

    public SystemTimeAdmin() {
        Trace.constructor(this);
    }

    public void setScope(InstanceWrapper scope) {
        if (Repository.getRepository().getConfigInteger() >= 3) {
            throw new RuntimeException("Attempted to call Set Scope in  Midrange 3 (or greater).  This is FOr MR1 and 2 Only");
        }
        this.t4Instance = scope.getInstance();
    }

    public void init(ConfigContext configContext) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.configContext = configContext;
        if (this.t4Instance != null) {
            this.operatingSystem = new OperatingSystem(configContext, this.t4Instance.getObjectPath());
        } else if (Repository.getRepository().getConfigInteger() >= 3) {
            this.operatingSystem = new OperatingSystem(configContext);
            Trace.verbose((Object)this, "init", "os is " + this.getOperatingSystem().getInstanceInternal());
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        Trace.verbose((Object)this, "save", "os is " + this.getOperatingSystem().getInstanceInternal());
        this.getOperatingSystem().save();
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public TimeZone getCurrentTimeZone() {
        return this.getOperatingSystem().getTimeZone();
    }

    public String getNtpServerIp() {
        return this.getOperatingSystem().getNtpServerIPAddress();
    }

    public Date getTime() {
        return this.getOperatingSystem().getDateTime();
    }

    public Boolean getUseNTPServer() {
        return new Boolean(this.getOperatingSystem().isNtpEnabled());
    }

    public void setCurrentTimeZone(TimeZone currentTimeZone) {
        this.getOperatingSystem().setTimeZone(currentTimeZone);
    }

    public void setNtpServerIp(String ntpServerIp) {
        this.getOperatingSystem().setNtpServerIPAddress(ntpServerIp);
    }

    public void setTime(Date time) {
        this.getOperatingSystem().setDateTime(time);
    }

    public void setUseNTPServer(Boolean useNTPServer) {
        this.getOperatingSystem().setNtpEnabled(useNTPServer);
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "releoad");
        this.init(this.configContext);
        Trace.verbose((Object)this, "reload", "os is " + this.getOperatingSystem().getInstanceInternal());
    }
}

