/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.admin.business.PasswordsAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.UserAccount;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;

public class PasswordsAdmin
implements PasswordsAdminInterface,
Constants.UserAccount {
    private ConfigContext configContext;
    private UserAccount guestUserAccount;
    private UserAccount adminUserAccount;
    private UserAccount systemAdminUserAccount;
    private CIMOMHandleWrapper handle;

    public PasswordsAdmin() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.configContext = context;
    }

    public void setGuestPassword(String guestPassword) throws ConfigMgmtException {
        Trace.methodBegin(this, "setGuestPassword");
        this.getGuestUserAccount().setPassword(guestPassword);
        this.getGuestUserAccount().save();
    }

    public void setStorageAdminPassword(String storageAdminPassword) throws ConfigMgmtException {
        Trace.methodBegin(this, "setStorageAdminPassword");
        this.getAdminUserAccount().setPassword(storageAdminPassword);
        this.getAdminUserAccount().save();
    }

    public void setStorageSystemAdminPassword(String storageSystemAdminPassword) throws ConfigMgmtException {
        Trace.methodBegin(this, "setStorageSystemAdminPassword");
        this.getSystemAdminUserAccount().setPassword(storageSystemAdminPassword);
        this.getSystemAdminUserAccount().save();
    }

    private ConfigContext getConfigContext() throws ConfigMgmtException {
        Trace.methodBegin(this, "getConfigContext");
        if (null == this.configContext) {
            throw new ConfigMgmtException();
        }
        return this.configContext;
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
    }

    private UserAccount getAdminUserAccount() throws ConfigMgmtException {
        if (null == this.adminUserAccount) {
            this.adminUserAccount = new UserAccount(this.getConfigContext(), this.getConfigContext().getClient(), "storage");
        }
        return this.adminUserAccount;
    }

    private UserAccount getGuestUserAccount() throws ConfigMgmtException {
        if (null == this.guestUserAccount) {
            this.guestUserAccount = new UserAccount(this.getConfigContext(), this.getConfigContext().getClient(), "guest");
        }
        return this.guestUserAccount;
    }

    private UserAccount getSystemAdminUserAccount() throws ConfigMgmtException {
        if (null == this.systemAdminUserAccount) {
            this.systemAdminUserAccount = new UserAccount(this.getConfigContext(), this.getConfigContext().getClient(), "admin");
        }
        return this.systemAdminUserAccount;
    }

    public void reload() throws ConfigMgmtException {
        this.init(this.configContext);
    }
}

