/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business.impl.m1m2;

import com.sun.netstorage.array.mgmt.cfg.admin.business.Role;
import com.sun.netstorage.array.mgmt.cfg.admin.business.UserRoleAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.m1m2.User;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.mgmt.dm.util.authorization.AuthorizationUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class UserRoleAdmin
implements UserRoleAdminInterface {
    private ConfigContext context;
    private SearchFilter filter;
    private Scope scope;

    public void init(ConfigContext context) {
        this.context = context;
    }

    public void createUser(String name, Role role) throws ConfigMgmtException {
        User user = new User(name, role);
        Trace.methodBegin(this, "createUser");
        Trace.verbose((Object)this, "createUser", "create user " + name + " with role " + role.toString());
        List uList = this.getUserList();
        if (uList.contains(name)) {
            Trace.verbose((Object)this, "createUser", "user already exists!");
            ConfigMgmtException cme = new ConfigMgmtException("admin.user.add.exists", "admin.user.add.exists");
            throw cme;
        }
        try {
            Properties properties = this.fetchProperties();
            properties.setProperty(name, role.toString());
            properties.store(new FileOutputStream(this.fetchUsersFile()), "");
        }
        catch (FileNotFoundException e) {
            Trace.verbose((Object)this, "createUser", (Throwable)e);
            throw new ConfigMgmtException(e);
        }
        catch (IOException e) {
            Trace.verbose((Object)this, "createUser", (Throwable)e);
            throw new ConfigMgmtException(e);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "createUser", (Throwable)e);
            throw new ConfigMgmtException(e);
        }
    }

    public void delete(String[] toDelete) throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        if (toDelete == null || toDelete.length == 0) {
            Trace.verbose((Object)this, "delete", "There is nothing to delete");
            return;
        }
        try {
            Properties properties = this.fetchProperties();
            for (int i = 0; i < toDelete.length; ++i) {
                Trace.verbose((Object)this, "delete", "delete user [" + toDelete[i] + "]");
                if (toDelete[i] == null) continue;
                properties.remove(toDelete[i]);
            }
            properties.store(new FileOutputStream(this.fetchUsersFile()), "");
        }
        catch (FileNotFoundException e) {
            Trace.verbose((Object)this, "delete", (Throwable)e);
            throw new ConfigMgmtException(e);
        }
        catch (IOException e) {
            Trace.verbose((Object)this, "delete", (Throwable)e);
            throw new ConfigMgmtException(e);
        }
    }

    public List getUserList() throws ConfigMgmtException {
        String methodName = "getUserList";
        Trace.methodBegin(this, methodName);
        ArrayList<User> allUsers = new ArrayList<User>();
        try {
            Properties properties = this.fetchProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                Role role = Role.forShortKey(properties.getProperty(name));
                User user = new User(name, role);
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("username", name);
                user.setKey(map);
                Trace.verbose((Object)this, "getUserList", user.getKeyAsString());
                if (this.filter != null && (this.filter.getSearchField() == null || !this.filter.getSearchString().equals(role.getKey()))) continue;
                allUsers.add(user);
                Trace.verbose((Object)this, methodName, "Loaded user " + name + " with role " + role.toString());
            }
        }
        catch (FileNotFoundException e) {
            Trace.verbose((Object)this, methodName, (Throwable)e);
            throw new ConfigMgmtException(e);
        }
        catch (IOException e) {
            Trace.verbose((Object)this, methodName, (Throwable)e);
            throw new ConfigMgmtException(e);
        }
        Trace.verbose((Object)this, "getUserList", "return:" + allUsers.size());
        return allUsers;
    }

    Properties fetchProperties() throws IOException, FileNotFoundException {
        File file = this.fetchUsersFile();
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return properties;
    }

    File fetchUsersFile() {
        Trace.verbose((Object)this, "fetchUsersFile", "Get file:" + Repository.getRepository().getUsersPath());
        File file = new File(Repository.getRepository().getUsersPath());
        return file;
    }

    public void create(Properties props) throws ConfigMgmtException {
        String user = props.getProperty("username");
        String userRole = props.getProperty("role");
        String pat = "[-\\w.]+";
        if (!Pattern.matches(pat, user)) {
            Trace.verbose((Object)this, "create", "Username contained invalid characters");
            throw new ConfigMgmtException("username.validChar", "username.validCharHelp");
        }
        Trace.verbose((Object)this, "create", "Username has all valid characters.");
        if (user == null || user.trim().equals("")) {
            throw new ConfigMgmtException("username.required", "Username is a required parameter");
        }
        if (userRole == null || userRole.trim().equals("")) {
            throw new ConfigMgmtException("user.role.required", "User role is a required parameter");
        }
        this.createUser(user, Role.forKey(userRole));
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        MethodCallStatus mcs = new MethodCallStatus();
        List mapList = this.validateDeleteList(list);
        try {
            Properties properties = this.fetchProperties();
            int size = list == null ? 0 : list.size();
            for (int i = 0; i < size; ++i) {
                Trace.verbose((Object)this, "delete", "delete user [" + list.get(i) + "]");
                Map m = (Map)mapList.get(i);
                properties.remove((String)m.get("username"));
                this.setErrorDescriptor(mcs, (String)list.get(i), ErrorDescriptor.ERROR_SUCCESS, ErrorDescriptor.ERROR_SUCCESS_KEY);
            }
            properties.store(new FileOutputStream(this.fetchUsersFile()), "");
            AuthorizationUtility.getInstance().getRole("");
            if (list != null && !list.isEmpty()) {
                String delUserRole = AuthorizationUtility.getInstance().getRole((String)list.get(0));
                Trace.verbose((Object)this, "delete", "Deleted User Role should be null, and it is:" + delUserRole);
            }
        }
        catch (FileNotFoundException e) {
            Trace.error((Object)this, (Throwable)e);
            this.setErrorDescriptor(mcs, Repository.getRepository().getUsersPath(), ErrorDescriptor.ERROR_FILE_NOT_FOUND, ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY);
        }
        catch (IOException e) {
            Trace.error((Object)this, (Throwable)e);
            this.setErrorDescriptor(mcs, Repository.getRepository().getUsersPath(), ErrorDescriptor.ERROR_IO, ErrorDescriptor.ERROR_IO_KEY);
        }
        return mcs;
    }

    private List validateDeleteList(List list) throws ConfigMgmtException {
        int i;
        if (list != null && list.size() == this.getUserList().size()) {
            throw new ConfigMgmtException("error.all.users.selected", "Request to delete all users denied");
        }
        List mapList = Convert.listOfStringKeysToMap(list);
        SearchFilter origFilter = this.filter;
        this.filter = new SearchFilter("role", Role.STORAGE.getKey());
        List allStorageUsers = this.getItemList();
        if (allStorageUsers == null || allStorageUsers.isEmpty()) {
            throw new ConfigMgmtException("error.no.storage.users", "Request to delete all users denied");
        }
        int sz = allStorageUsers.size();
        ArrayList<String> storageUserNames = new ArrayList<String>(sz);
        for (i = 0; i < sz; ++i) {
            storageUserNames.add(((User)allStorageUsers.get(i)).getName());
        }
        sz = list.size();
        for (i = 0; i < sz; ++i) {
            Map m = (Map)mapList.get(i);
            String name = (String)m.get("username");
            if (!storageUserNames.contains(name)) continue;
            storageUserNames.remove(name);
        }
        if (storageUserNames.isEmpty()) {
            throw new ConfigMgmtException("error.cannot.delete.all.storage.users", "Cannot delete all storage users");
        }
        return mapList;
    }

    private void setErrorDescriptor(MethodCallStatus mcs, String user, int ret, String ikey) {
        ErrorDescriptor ed = new ErrorDescriptor();
        ed.setErrorCode(ret);
        ed.setI18nkey(ikey);
        String[] params = new String[]{user};
        ed.setI18nParams(params);
        ed.setMsg("Operation on user:" + params[0] + " completed with code:" + ret);
        mcs.addErrorDescriptor(ed);
    }

    public int getMaxObjects() {
        return Integer.MAX_VALUE;
    }

    public void init(ConfigContext ctx, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.context = ctx;
        this.scope = s;
        this.filter = f;
    }

    public List getItemList() throws ConfigMgmtException {
        return this.getUserList();
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getUserList().size();
    }

    public boolean isOperationSupported(String operation) {
        return true;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        throw new ConfigMgmtException("not.supported", "Modify user is not supported. Use delete/create to modify");
    }

    private class UserComparator
    implements Comparator {
        Collator collator = null;

        UserComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof User && element2 instanceof User) {
                key1 = this.collator.getCollationKey(((User)element1).getName());
                key2 = this.collator.getCollationKey(((User)element2).getName());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }

    public static interface CreateProps {
        public static final String USERNAME = "username";
        public static final String USER_ROLE = "role";
    }

    public static interface KeyMap {
        public static final String NAME = "username";
    }
}

