/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageMappingsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.MappingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.Mapping;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.AbstractVolRefList;
import devmgr.versioned.symbol.Cluster;
import devmgr.versioned.symbol.GhostVolume;
import devmgr.versioned.symbol.Host;
import devmgr.versioned.symbol.HostPort;
import devmgr.versioned.symbol.HostRef;
import devmgr.versioned.symbol.LUNMapping;
import devmgr.versioned.symbol.LUNMappingCreationDescriptor;
import devmgr.versioned.symbol.LUNMappingRef;
import devmgr.versioned.symbol.LUNMappingUpdateDescriptor;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PersistentRegistrationList;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SYMbolRef;
import devmgr.versioned.symbol.SnapshotVolume;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManageMappings
implements ManageMappingsInterface,
MappingInterface.MappingType {
    private ConfigContext context;
    private SearchFilter filter;
    private Scope scope;
    public static final int MAX_NUMBER_OF_MAPPINGS = 256;
    public static final String NULL_SYMBOL_REF_STRING = "0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:";
    public static final String DEFAULT_GROUP_NAME = "mapping.object.All";
    private static final String MAPPING_OBJECT_TYPE = "MAPPING_OBJECT_TYPE";
    private static final String MAPPING_OBJECT_NAME = "MAPPING_OBJECT_NAME";
    private static final String MAPPING_VOLUME_NAME = "MAPPING_VOLUME_NAME";

    public void create(Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "create";
        Trace.methodBegin(this, "create");
        String arrayWwn = this.getArrayWwnFromScope();
        if (props == null || props.isEmpty()) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Properties passed empty.");
        }
        HashMap loggerHelperMap = new HashMap();
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = manager.getObjectBundle(arrayWwn);
        String mapKeyAsString = (String)props.get("hostOrHostGroupKey");
        SYMbolRef mapRef = this.populateMapReference(mapKeyAsString, bundle, loggerHelperMap);
        int lun = -1;
        String lunString = props.getProperty("lun");
        if (lunString != null) {
            try {
                lun = Integer.parseInt(lunString);
            }
            catch (NumberFormatException nfe) {
                LogAPI.staticLog((String)"MAPPING_CREATE_ERROR_INVALID_LUN", (String[])new String[]{arrayWwn, lunString, (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
                throw new ConfigMgmtException("error.no.lun.available", "Invalid value passed for lun number.");
            }
        } else {
            List availableLuns = this.getAvailableLuns(mapKeyAsString);
            if (availableLuns.size() > 0) {
                lun = (Integer)availableLuns.get(0);
            } else {
                LogAPI.staticLog((String)"MAPPING_CREATE_ERROR_NO_LUN_AVAILABLE", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
                throw new ConfigMgmtException("error.no.lun.available", "No available lun number for mapping creation.");
            }
        }
        AbstractVolRef volumeRef = this.populateVolumeReference(props.getProperty("volumeKey"), bundle, loggerHelperMap);
        LUNMappingCreationDescriptor descriptor = this.getLUNMappingCreationDescriptor(volumeRef, mapRef, lun);
        manager.stopMonitoringThread(arrayWwn);
        ReturnCodeWithRef returnCode = new ReturnCodeWithRef();
        int returnCodeInt = -1;
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            command.execute(77, (XDRType)descriptor, (XDRType)returnCode, true);
        }
        catch (RPCError rpce) {
            Trace.error((Object)this, "create", (Throwable)rpce);
            LogAPI.staticLog((String)"MAPPING_CREATE_ERROR", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
            throw new ConfigMgmtException("error.rpc", "RPCError exception trying to create mapping.", (Exception)((Object)rpce));
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "create", (Throwable)ioe);
            LogAPI.staticLog((String)"MAPPING_CREATE_ERROR", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
            throw new ConfigMgmtException("error.communication", "IOException trying to create maping.");
        }
        finally {
            manager.forceBundleReload(arrayWwn);
        }
        if (returnCode != null) {
            returnCodeInt = returnCode.getReturnCode().getValue();
            if (returnCodeInt != 1) {
                String message = "Mapping creation failed with the error code: " + returnCodeInt;
                Trace.verbose((Object)this, "create", message);
                LogAPI.staticLog((String)"MAPPING_CREATE_ERROR", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + returnCodeInt), message);
            }
            LogAPI.staticLog((String)"MAPPING_CREATE_SUCCESS", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
            Trace.verbose((Object)this, "create", "Mapping successfully created.");
        }
    }

    private SYMbolRef populateMapReference(String mapKeyAsString, ObjectBundle bundle, Map loggerHelperMap) throws ConfigMgmtException {
        SYMbolRef mapRef = null;
        int mapType = -1;
        String mapName = null;
        if (mapKeyAsString != null) {
            Map key = Convert.keyAsStringToMap(mapKeyAsString);
            mapType = Integer.parseInt((String)key.get("objectType"));
            if (mapType == 101) {
                mapName = (String)key.get("name");
                mapRef = this.getHostForName(bundle.getStoragePoolBundle().getHost(), mapName).getHostRef();
            } else if (mapType == 100) {
                mapName = (String)key.get("name");
                mapRef = this.getHostGroupForName(bundle.getStoragePoolBundle().getCluster(), mapName).getClusterRef();
            }
            loggerHelperMap.put(MAPPING_OBJECT_NAME, mapName);
            loggerHelperMap.put(MAPPING_OBJECT_TYPE, Integer.toString(mapType));
        } else {
            mapRef = new SYMbolRef();
            mapRef.setRefToken(Convert.stringToBytes(NULL_SYMBOL_REF_STRING));
            loggerHelperMap.put(MAPPING_OBJECT_NAME, DEFAULT_GROUP_NAME);
        }
        return mapRef;
    }

    private AbstractVolRef populateVolumeReference(Object volumeKey, ObjectBundle bundle, Map loggerHelperMap) throws ConfigMgmtException {
        if (volumeKey == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null passed for the volume key.");
        }
        String volumeWwn = null;
        if (volumeKey instanceof String) {
            volumeWwn = (String)Convert.keyAsStringToMap((String)volumeKey).get("volumeWwn");
        } else if (volumeKey instanceof Map) {
            volumeWwn = (String)((Map)volumeKey).get("volumeWwn");
        } else {
            throw new ConfigMgmtException("incorrect.method.parameter", "Incorrect type of object passed for the volume key.");
        }
        VolumeRef volumeRef = null;
        Volume volume = this.getVolumeForWwn(bundle.getVolume(), volumeWwn);
        if (volume != null) {
            volumeRef = volume.getVolumeRef();
            loggerHelperMap.put(MAPPING_VOLUME_NAME, volume.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])volume.getLabel().getValue()) : "");
        } else {
            SnapshotVolume snapshotVolume = this.getSnapshotVolumeForWwn(bundle.getHighLevelVolBundle().getSnapshotVol(), volumeWwn);
            if (snapshotVolume != null) {
                volumeRef = snapshotVolume.getSnapshotRef();
                loggerHelperMap.put(MAPPING_VOLUME_NAME, snapshotVolume.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])snapshotVolume.getLabel().getValue()) : "");
            } else {
                throw new ConfigMgmtException("volume.lookup.error", "Unable to lookup volume with wwn = " + volumeWwn);
            }
        }
        return volumeRef;
    }

    private LUNMappingCreationDescriptor getLUNMappingCreationDescriptor(AbstractVolRef volumeRef, SYMbolRef mapRef, int lun) {
        LUNMappingCreationDescriptor descriptor = new LUNMappingCreationDescriptor();
        descriptor.setVolumeRef(volumeRef);
        descriptor.setMapRef(mapRef);
        descriptor.setLun(lun);
        return descriptor;
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD_NAME = "delete";
        Trace.methodBegin(this, "delete");
        String arrayWwn = this.getArrayWwnFromScope();
        if (list == null || list.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null or empty list passed to ManageMappings.delete() method.");
        }
        List listOfMaps = Convert.listOfStringKeysToMap(list);
        MethodCallStatus mcs = new MethodCallStatus();
        Map key = null;
        String volumeWwn = null;
        Volume volume = null;
        SnapshotVolume snapshotVolume = null;
        String volumeRefString = null;
        String volumeName = null;
        Object returnCode = null;
        int returnCodeValue = -1;
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = manager.getObjectBundle(arrayWwn);
        Volume[] volumes = bundle.getVolume();
        LUNMapping[] lunMappings = bundle.getStoragePoolBundle().getLunMapping();
        Map volumeMap = this.populateVolumeWwnVolumeMap(bundle.getVolume());
        Map snapshotVolumeMap = this.populateSnapshotVolumeWwnSnapshotVolumeMap(bundle.getHighLevelVolBundle().getSnapshotVol());
        Map volumeRefLunMappingRefMap = this.populateVolumeRefLunMappingRefMap(lunMappings);
        manager.stopMonitoringThread(arrayWwn);
        CommandProcessor command = this.getCommandProcessor(arrayWwn);
        int listSize = listOfMaps.size();
        for (int i = 0; i < listSize; ++i) {
            int mappingType;
            key = (Map)listOfMaps.get(i);
            ErrorDescriptor errorDesc = null;
            String mappingTypeString = (String)key.get("mappingType");
            if (mappingTypeString != null && (mappingType = Integer.parseInt(mappingTypeString)) != 1002) {
                errorDesc = new ErrorDescriptor(ErrorCode.ERROR_DELETE_MAPPING_INVALID_MAPPING);
                errorDesc.setMsg("Trying to delete non-explicit mapping.");
                errorDesc.setI18nParams(new String[]{volumeName});
                mcs.addErrorDescriptor(errorDesc);
                continue;
            }
            volumeWwn = (String)key.get("volumeWwn");
            volume = (Volume)volumeMap.get(volumeWwn);
            if (volume != null) {
                volumeRefString = Convert.bytesToStringRaw(volume.getVolumeRef().getRefToken());
                volumeName = volume.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])volume.getLabel().getValue()) : "";
            } else {
                snapshotVolume = (SnapshotVolume)snapshotVolumeMap.get(volumeWwn);
                if (snapshotVolume != null) {
                    volumeRefString = Convert.bytesToStringRaw(snapshotVolume.getSnapshotRef().getRefToken());
                    volumeName = snapshotVolume.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])snapshotVolume.getLabel().getValue()) : "";
                } else {
                    errorDesc = new ErrorDescriptor(ErrorCode.ERROR_DELETE_MAPPING_INVALID_MAPPING);
                    errorDesc.setMsg("Unable to lookup volume for the wwn passed.");
                    errorDesc.setI18nParams(new String[]{volumeWwn});
                    mcs.addErrorDescriptor(errorDesc);
                    continue;
                }
            }
            LUNMappingRef lunMappingRef = (LUNMappingRef)volumeRefLunMappingRefMap.get(volumeRefString);
            if (lunMappingRef == null) continue;
            try {
                int rc = -1;
                if (volume != null) {
                    rc = this.clearPersistentRegistrations(mcs, volumeWwn, (AbstractVolRef)volume.getVolumeRef(), command);
                } else if (snapshotVolume != null) {
                    rc = this.clearPersistentRegistrations(mcs, volumeWwn, (AbstractVolRef)snapshotVolume.getSnapshotRef(), command);
                }
                if (rc != 1) continue;
                volumeRefLunMappingRefMap = this.removeMapping(volumeRefString, volumeName, bundle, volumeRefLunMappingRefMap, command, lunMappingRef);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "delete", cme);
                errorDesc = new ErrorDescriptor(ErrorCode.ERROR_DELETE_MAPPING_RPC_ERROR);
                errorDesc.setMsg("Exception when trying to unmap the volume: " + volumeName);
            }
            if (errorDesc == null) continue;
            if (errorDesc.getErrorCode() == ErrorDescriptor.ERROR_SUCCESS) {
                LogAPI.staticLog((String)"MAPPING_DELETE_SUCCESS", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
            } else {
                LogAPI.staticLog((String)"MAPPING_DELETE_ERROR", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
            }
            errorDesc.setI18nParams(new String[]{volumeName});
            mcs.addErrorDescriptor(errorDesc);
        }
        manager.forceBundleReload(arrayWwn);
        return mcs;
    }

    private Map removeMapping(String volumeRefString, String volumeName, ObjectBundle bundle, Map volumeRefLunMappingRefMap, CommandProcessor command, LUNMappingRef lunMappingRef) throws ConfigMgmtException {
        String METHOD_NAME = "removeMapping";
        ReturnCode returnCode = new ReturnCode();
        int returnCodeValue = 59;
        int maxRetries = 3;
        int retries = 0;
        String message = "";
        while (returnCodeValue == 59 && lunMappingRef != null && retries++ < maxRetries) {
            returnCode = new ReturnCode();
            command.execute(78, (XDRType)lunMappingRef, (XDRType)returnCode, true);
            returnCodeValue = returnCode != null ? returnCode.getValue() : -1;
            message = "Code " + returnCodeValue + " returned when deleting mapping to the volume " + volumeName;
            Trace.verbose((Object)this, "removeMapping", message);
            if (returnCodeValue != 59 || retries >= maxRetries) continue;
            command.execute(40, (XDRType)bundle, null, false);
            if (bundle == null) continue;
            LUNMapping[] lunMappings = bundle.getStoragePoolBundle().getLunMapping();
            volumeRefLunMappingRefMap = this.populateVolumeRefLunMappingRefMap(lunMappings);
            lunMappingRef = (LUNMappingRef)volumeRefLunMappingRefMap.get(volumeRefString);
        }
        ErrorDescriptor errorDesc = new ErrorDescriptor(OZErrorCode.getErrorCode("error.delete.mapping", returnCodeValue));
        errorDesc.setMsg(message);
        return volumeRefLunMappingRefMap;
    }

    private int clearPersistentRegistrations(MethodCallStatus mcs, String volumeWwn, AbstractVolRef volumeRef, CommandProcessor command) throws ConfigMgmtException {
        String METHOD_NAME = "clearPersistentRegistrations";
        PersistentRegistrationList prl = new PersistentRegistrationList();
        command.execute(129, (XDRType)volumeRef, (XDRType)prl, true);
        int rc = prl.getReturnCode().getValue();
        if (rc != 1) {
            Trace.error((Object)this, "clearPersistentRegistrations", "getPersistentRegistrationsForVolume() failure: " + rc);
            ErrorDescriptor errorDesc = new ErrorDescriptor(ErrorCode.ERROR_DELETE_MAPPING_INVALID_MAPPING);
            errorDesc.setMsg("Unable to lookup persistent registrations.");
            errorDesc.setI18nParams(new String[]{volumeWwn});
            mcs.addErrorDescriptor(errorDesc);
        } else if (prl != null && prl.getPersistentRegistration().length > 0) {
            AbstractVolRefList avrl = new AbstractVolRefList();
            AbstractVolRef[] avr = new AbstractVolRef[]{volumeRef};
            avrl.setAbstractVolRef(avr);
            ReturnCode returnCode = new ReturnCode();
            command.execute(130, (XDRType)avrl, (XDRType)returnCode, true);
            rc = returnCode.getValue();
            if (rc != 1) {
                Trace.error((Object)this, "clearPersistentRegistrations", "clearPersistentRegistration() failure: " + rc);
                ErrorDescriptor errorDesc = new ErrorDescriptor(ErrorCode.ERROR_DELETE_MAPPING_INVALID_MAPPING);
                errorDesc.setMsg("Unable to clear persistent registrations.");
                errorDesc.setI18nParams(new String[]{volumeWwn});
                mcs.addErrorDescriptor(errorDesc);
            } else {
                Trace.verbose((Object)this, "clearPersistentRegistrations", "Persistent registrations cleared for " + volumeWwn);
            }
        } else {
            Trace.verbose((Object)this, "clearPersistentRegistrations", "No persistent registrations found.");
        }
        return rc;
    }

    private Map populateVolumeRefLunMappingRefMap(LUNMapping[] lunMappings) {
        HashMap<String, LUNMappingRef> volumeRefLunMappingRefMap = new HashMap<String, LUNMappingRef>();
        int length = lunMappings == null ? 0 : lunMappings.length;
        for (int i = 0; i < length; ++i) {
            volumeRefLunMappingRefMap.put(Convert.bytesToStringRaw(lunMappings[i].getVolumeRef().getRefToken()), lunMappings[i].getLunMappingRef());
        }
        return volumeRefLunMappingRefMap;
    }

    private LUNMapping getLunMappingForVolume(String volumeRefString, LUNMapping[] lunMappings) {
        int length = lunMappings == null ? 0 : lunMappings.length;
        for (int i = 0; i < length; ++i) {
            if (!volumeRefString.equals(Convert.bytesToStringRaw(lunMappings[i].getVolumeRef().getRefToken()))) continue;
            return lunMappings[i];
        }
        return null;
    }

    private CommandProcessor getCommandProcessor(String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "getCommandProcessor";
        Trace.methodBegin(this, "getCommandProcessor");
        try {
            return new CommandProcessor(arrayWwn);
        }
        catch (RPCError e) {
            Trace.error((Object)this, "getCommandProcessor", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPCError trying to instantiate CommandProcessor.", (Exception)((Object)e));
        }
        catch (IOException e) {
            Trace.error((Object)this, "getCommandProcessor", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IOException trying to instantiate CommandProcessor.", e);
        }
    }

    public int getMaxObjects() {
        return 0;
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList().size();
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        String arrayWwn = this.getArrayWwnFromScope();
        String volumeScopeKey = (String)this.scope.getAttribute("volume");
        String hostScopeKey = (String)this.scope.getAttribute("host");
        String hostGroupScopeKey = (String)this.scope.getAttribute("hostGroup");
        if (volumeScopeKey != null && hostScopeKey != null && hostGroupScopeKey != null || volumeScopeKey != null && hostScopeKey != null || volumeScopeKey != null && hostGroupScopeKey != null || hostScopeKey != null && hostGroupScopeKey != null) {
            throw new ConfigMgmtException("invalid.scope.set", "Invalid scope set for listing of the mappings.");
        }
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = manager.getObjectBundle(arrayWwn);
        if (volumeScopeKey == null && hostScopeKey == null && hostGroupScopeKey == null) {
            return this.populateAllMappings(manager, bundle, arrayWwn);
        }
        List mappings = new ArrayList();
        if (volumeScopeKey != null) {
            mappings = this.populateVolumeMappings(manager, bundle, arrayWwn, volumeScopeKey);
        } else if (hostScopeKey != null) {
            mappings = this.populateHostMappings(manager, bundle, arrayWwn, hostScopeKey);
        } else if (hostGroupScopeKey != null) {
            mappings = this.populateHostGroupMappings(manager, bundle, arrayWwn, hostGroupScopeKey);
        }
        Trace.verbose((Object)this, "getItemList", "Number of items in the list = " + mappings.size());
        return mappings;
    }

    private List populateAllMappings(ObjectBundleManager manager, ObjectBundle bundle, String arrayWwn) throws ConfigMgmtException {
        int lunMappingCount;
        Trace.methodBegin(this, "populateAllMappings");
        ArrayList<Mapping> allMappings = new ArrayList<Mapping>();
        LUNMapping[] lunMappings = bundle.getStoragePoolBundle().getLunMapping();
        int n = lunMappingCount = lunMappings != null ? lunMappings.length : 0;
        if (lunMappingCount == 0) {
            return allMappings;
        }
        LUNMapping lunMapping = null;
        int lunMappingType = -1;
        Volume volume = null;
        SnapshotVolume snapshotVolume = null;
        Mapping mapping = null;
        String volumeName = null;
        String volumeWwn = null;
        boolean addMapping = false;
        int mappingType = -1;
        String mappedVia = null;
        String hostName = null;
        String hostGroupName = null;
        Host host = null;
        Cluster hostGroup = null;
        int volumeType = -1;
        HashMap volumeMap = new HashMap();
        this.populateVolumeRefVolumeMap(bundle.getVolume(), volumeMap);
        HashMap snapshotVolumeMap = new HashMap();
        this.populateSnapshotVolumeRefSnapshotVolumeMap(bundle.getHighLevelVolBundle().getSnapshotVol(), snapshotVolumeMap);
        Map hostMap = this.populateHostRefHostMap(bundle.getStoragePoolBundle().getHost());
        Map hostGroupMap = this.populateHostGroupRefHostGroupMap(bundle.getStoragePoolBundle().getCluster());
        Map missingVolumeMap = ManageVolumes.populateGhostVolumeRefVolumeMap(bundle.getGhostVolBundle().getGhostVol());
        for (int i = 0; i < lunMappingCount; ++i) {
            lunMapping = lunMappings[i];
            lunMappingType = lunMapping.getType().getValue();
            addMapping = false;
            hostName = null;
            hostGroupName = null;
            if (lunMappingType == 8) {
                addMapping = true;
                mappingType = 1000;
                mappedVia = "mapped.via.default.group";
            } else if (lunMappingType == 3) {
                mappingType = 1002;
                mappedVia = "mapped.via.host";
                host = (Host)hostMap.get(Convert.bytesToStringRaw(lunMapping.getMapRef().getRefToken()));
                if (host != null && host.getLabel().getValue() != null) {
                    addMapping = true;
                    hostName = UnicodeTranslator.getString((byte[])host.getLabel().getValue());
                } else {
                    addMapping = false;
                }
            } else if (lunMappingType == 4) {
                mappingType = 1002;
                mappedVia = "mapped.via.host.group";
                hostGroup = (Cluster)hostGroupMap.get(Convert.bytesToStringRaw(lunMapping.getMapRef().getRefToken()));
                if (hostGroup != null && hostGroup.getLabel().getValue() != null) {
                    addMapping = true;
                    hostGroupName = UnicodeTranslator.getString((byte[])hostGroup.getLabel().getValue());
                } else {
                    addMapping = false;
                }
            }
            if (!addMapping) continue;
            volume = (Volume)volumeMap.get(Convert.bytesToStringRaw(lunMapping.getVolumeRef().getRefToken()));
            if (volume != null) {
                volumeName = volume.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])volume.getLabel().getValue()) : "";
                volumeWwn = Convert.bytesToString(volume.getWorldWideName());
                volumeType = 100;
            } else {
                snapshotVolume = (SnapshotVolume)snapshotVolumeMap.get(Convert.bytesToStringRaw(lunMapping.getVolumeRef().getRefToken()));
                if (snapshotVolume != null) {
                    volumeName = snapshotVolume.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])snapshotVolume.getLabel().getValue()) : "";
                    volumeWwn = Convert.bytesToString(snapshotVolume.getWorldWideName());
                    volumeType = 101;
                } else {
                    Trace.verbose((Object)this, "populateAllMappings", "volume is missing.");
                    GhostVolume gv = (GhostVolume)missingVolumeMap.get(Convert.bytesToString(lunMapping.getVolumeRef().getRefToken()));
                    if (gv != null) {
                        volumeName = volumeWwn = Convert.bytesToString(gv.getWorldWideName());
                        volumeType = 100;
                    } else {
                        addMapping = false;
                    }
                }
            }
            if (!addMapping || this.filter != null && (this.filter.isEmpty() || !this.filter.getSearchField().equals("mappingType") || !this.filter.getSearchString().equals("" + mappingType))) continue;
            mapping = this.populateMapping(volumeName, hostGroupName, hostName, null, null, lunMapping.getLun(), mappedVia, mappingType, arrayWwn, volumeWwn, volumeType);
            allMappings.add(mapping);
        }
        return allMappings;
    }

    private List populateVolumeMappings(ObjectBundleManager manager, ObjectBundle bundle, String arrayWwn, String volumeScopeKey) throws ConfigMgmtException {
        Mapping noInitiatorsVolumeMapping;
        Trace.methodBegin(this, "populateVolumeMappings");
        String volumeRefString = null;
        String volumeName = "";
        int volumeType = -1;
        Map keyMap = Convert.keyAsStringToMap(volumeScopeKey);
        String volumeWwn = (String)keyMap.get("volumeWwn");
        Volume volume = this.getVolumeForWwn(bundle.getVolume(), volumeWwn);
        if (volume != null) {
            volumeRefString = Convert.bytesToStringRaw(volume.getVolumeRef().getRefToken());
            if (volume.getLabel().getValue() != null) {
                volumeName = UnicodeTranslator.getString((byte[])volume.getLabel().getValue());
            }
            volumeType = 100;
        } else {
            SnapshotVolume snapshotVolume = this.getSnapshotVolumeForWwn(bundle.getHighLevelVolBundle().getSnapshotVol(), volumeWwn);
            if (snapshotVolume != null) {
                volumeRefString = Convert.bytesToStringRaw(snapshotVolume.getSnapshotRef().getRefToken());
                if (snapshotVolume.getLabel().getValue() != null) {
                    volumeName = UnicodeTranslator.getString((byte[])snapshotVolume.getLabel().getValue());
                }
                volumeType = 101;
            } else {
                throw new ConfigMgmtException("volume.lookup.error", "Unable to lookup volume with wwn = " + volumeWwn);
            }
        }
        ArrayList<Mapping> volumeMappings = new ArrayList<Mapping>();
        LUNMapping lunMapping = null;
        LUNMapping[] lunMappings = bundle.getStoragePoolBundle().getLunMapping();
        int lunMappingCount = lunMappings != null ? lunMappings.length : 0;
        for (int i = 0; i < lunMappingCount; ++i) {
            if (!volumeRefString.equals(Convert.bytesToStringRaw(lunMappings[i].getVolumeRef().getRefToken()))) continue;
            lunMapping = lunMappings[i];
            break;
        }
        if (lunMapping == null) {
            return volumeMappings;
        }
        int lunMappingType = lunMapping.getType().getValue();
        int lun = lunMapping.getLun();
        String mapRefString = Convert.bytesToStringRaw(lunMapping.getMapRef().getRefToken());
        HostPort hostPort = null;
        Host host = null;
        Cluster hostGroup = null;
        String hostPortName = null;
        String hostPortWwn = null;
        String hostName = null;
        Mapping mapping = null;
        String hostRefString = null;
        String hostGroupRefString = null;
        HostPort[] hostPorts = bundle.getStoragePoolBundle().getHostPort();
        int hostPortCount = hostPorts != null ? hostPorts.length : 0;
        Host[] hosts = bundle.getStoragePoolBundle().getHost();
        Cluster[] hostGroups = bundle.getStoragePoolBundle().getCluster();
        Map hostMap = this.populateMapOfHosts(hosts);
        Map hostGroupMap = this.populateMapOfHostGroups(hostGroups);
        for (int i = 0; i < hostPortCount; ++i) {
            String hostGroupName;
            hostPort = hostPorts[i];
            hostPortName = hostPort.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])hostPort.getLabel().getValue()) : "";
            hostPortWwn = Convert.bytesToString(hostPort.getHostPortName().getValue());
            if (hostPort.getIsSAControlled()) {
                if (lunMappingType != 8 || (host = (Host)hostMap.get(Convert.bytesToStringRaw(hostPort.getHostRef().getRefToken()))) == null || !host.getIsSAControlled()) continue;
                hostName = host.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])host.getLabel().getValue()) : "";
                hostGroup = (Cluster)hostGroupMap.get(Convert.bytesToStringRaw(host.getClusterRef().getRefToken()));
                hostGroupName = null;
                if (hostGroup != null && hostGroup.getIsSAControlled()) {
                    hostGroupName = hostGroup.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])hostGroup.getLabel().getValue()) : "";
                }
                mapping = this.populateMapping(volumeName, hostGroupName, hostName, hostPortName, hostPortWwn, lun, "mapped.via.default.group", 1000, arrayWwn, volumeWwn, volumeType);
                volumeMappings.add(mapping);
                continue;
            }
            if (lunMappingType == 3) {
                hostRefString = Convert.bytesToStringRaw(hostPort.getHostRef().getRefToken());
                if (!hostRefString.equals(mapRefString) || (host = (Host)hostMap.get(hostRefString)) == null) continue;
                hostName = host.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])host.getLabel().getValue()) : "";
                mapping = this.populateMapping(volumeName, null, hostName, hostPortName, hostPortWwn, lun, "mapped.via.host", 1002, arrayWwn, volumeWwn, volumeType);
                volumeMappings.add(mapping);
                continue;
            }
            if (lunMappingType != 4 || (host = (Host)hostMap.get(Convert.bytesToStringRaw(hostPort.getHostRef().getRefToken()))) == null || !(hostGroupRefString = Convert.bytesToStringRaw(host.getClusterRef().getRefToken())).equals(mapRefString)) continue;
            hostName = host.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])host.getLabel().getValue()) : "";
            hostGroup = (Cluster)hostGroupMap.get(Convert.bytesToStringRaw(host.getClusterRef().getRefToken()));
            if (hostGroup == null) continue;
            hostGroupName = hostGroup.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])hostGroup.getLabel().getValue()) : "";
            mapping = this.populateMapping(volumeName, hostGroupName, hostName, hostPortName, hostPortWwn, lun, "mapped.via.host.group", 1002, arrayWwn, volumeWwn, volumeType);
            volumeMappings.add(mapping);
        }
        if (volumeMappings.size() == 0 && (noInitiatorsVolumeMapping = this.populateNoInitiatorsVolumeMapping(volumeName, volumeWwn, volumeType, arrayWwn, mapRefString, lun, lunMappingType, hostMap, hostGroupMap)) != null) {
            volumeMappings.add(noInitiatorsVolumeMapping);
        }
        return volumeMappings;
    }

    private Map populateMapOfHostGroups(Cluster[] clusters) {
        HashMap<String, Cluster> clusterMap = new HashMap<String, Cluster>();
        int length = clusters == null ? 0 : clusters.length;
        for (int i = 0; i < length; ++i) {
            clusterMap.put(Convert.bytesToStringRaw(clusters[i].getClusterRef().getRefToken()), clusters[i]);
        }
        return clusterMap;
    }

    private Map populateMapOfHosts(Host[] hosts) {
        HashMap<String, Host> hostMap = new HashMap<String, Host>();
        int length = hosts == null ? 0 : hosts.length;
        for (int i = 0; i < length; ++i) {
            hostMap.put(Convert.bytesToStringRaw(hosts[i].getHostRef().getRefToken()), hosts[i]);
        }
        return hostMap;
    }

    private Mapping populateMapping(String volumeName, String hostGroupName, String hostName, String hostPortName, String hostPortWwn, int lun, String mappedVia, int mappingType, String arrayWwn, String volumeWwn, int volumeType) {
        Mapping mapping = new Mapping();
        mapping.setVolumeName(volumeName);
        mapping.setHostGroupName(hostGroupName);
        mapping.setHostName(hostName);
        if (null == hostGroupName || "".equals(hostGroupName)) {
            mapping.setHostOrHostGroupName(hostName);
            mapping.setObjectItemType(String.valueOf(101));
        } else {
            mapping.setHostOrHostGroupName(hostGroupName);
            mapping.setObjectItemType(String.valueOf(100));
        }
        mapping.setHostPortName(hostPortName);
        mapping.setHostPortWwn(hostPortWwn);
        mapping.setLun(lun);
        mapping.setMappingType(mappingType);
        mapping.setMappedVia(mappedVia);
        mapping.setVolumeType(volumeType);
        HashMap<String, String> keys = new HashMap<String, String>(3);
        keys.put("array", arrayWwn);
        keys.put("volumeWwn", volumeWwn);
        keys.put("mappingType", mappingType + "");
        mapping.setKey(keys);
        return mapping;
    }

    private Mapping populateNoInitiatorsVolumeMapping(String volumeName, String volumeWwn, int volumeType, String arrayWwn, String mapRefString, int lun, int lunMappingType, Map hostMap, Map hostGroupMap) {
        Cluster hostGroup;
        Trace.methodBegin(this, "populateNoInitiatorsVolumeMapping");
        Mapping mapping = null;
        if (lunMappingType == 8) {
            mapping = this.populateMapping(volumeName, DEFAULT_GROUP_NAME, null, null, null, lun, "mapped.via.default.group", 1000, arrayWwn, volumeWwn, volumeType);
        } else if (lunMappingType == 3) {
            Host host = (Host)hostMap.get(mapRefString);
            if (host != null) {
                Cluster hostGroup2 = (Cluster)hostGroupMap.get(Convert.bytesToStringRaw(host.getClusterRef().getRefToken()));
                String hostGroupName = null;
                if (hostGroup2 != null) {
                    hostGroupName = hostGroup2.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])hostGroup2.getLabel().getValue()) : "";
                }
                mapping = this.populateMapping(volumeName, hostGroupName, host.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])host.getLabel().getValue()) : "", null, null, lun, "mapped.via.host", 1002, arrayWwn, volumeWwn, volumeType);
            }
        } else if (lunMappingType == 4 && (hostGroup = (Cluster)hostGroupMap.get(mapRefString)) != null) {
            mapping = this.populateMapping(volumeName, hostGroup.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])hostGroup.getLabel().getValue()) : "", null, null, null, lun, "mapped.via.host.group", 1002, arrayWwn, volumeWwn, volumeType);
        }
        return mapping;
    }

    private Volume getVolumeForWwn(Volume[] volumes, String volumeWwnString) throws ConfigMgmtException {
        Volume volume = null;
        if (volumeWwnString != null) {
            int size = volumes == null ? 0 : volumes.length;
            for (int i = 0; i < size; ++i) {
                if (!volumeWwnString.equals(Convert.bytesToString(volumes[i].getWorldWideName()))) continue;
                volume = volumes[i];
                break;
            }
        }
        return volume;
    }

    private SnapshotVolume getSnapshotVolumeForWwn(SnapshotVolume[] snapshotVolumes, String snapshotVolumeWwnString) throws ConfigMgmtException {
        SnapshotVolume snapshotVolume = null;
        if (snapshotVolumeWwnString != null) {
            int size = snapshotVolumes == null ? 0 : snapshotVolumes.length;
            for (int i = 0; i < size; ++i) {
                if (!snapshotVolumeWwnString.equals(Convert.bytesToString(snapshotVolumes[i].getWorldWideName()))) continue;
                snapshotVolume = snapshotVolumes[i];
                break;
            }
        }
        return snapshotVolume;
    }

    private Host getHostForName(Host[] hosts, String hostName) throws ConfigMgmtException {
        Host host = null;
        if (hostName != null) {
            int size = hosts == null ? 0 : hosts.length;
            for (int i = 0; i < size; ++i) {
                if (!hostName.equals(UnicodeTranslator.getString((byte[])hosts[i].getLabel().getValue()))) continue;
                host = hosts[i];
                break;
            }
        }
        if (host == null) {
            throw new ConfigMgmtException("host.lookup.error", "Unable to lookup host with name = " + hostName);
        }
        return host;
    }

    private Cluster getHostGroupForName(Cluster[] hostGroups, String hostGroupName) throws ConfigMgmtException {
        Cluster hostGroup = null;
        if (hostGroupName != null) {
            int size = hostGroups == null ? 0 : hostGroups.length;
            for (int i = 0; i < size; ++i) {
                if (!hostGroupName.equals(UnicodeTranslator.getString((byte[])hostGroups[i].getLabel().getValue()))) continue;
                hostGroup = hostGroups[i];
                break;
            }
        }
        if (hostGroup == null) {
            throw new ConfigMgmtException("hostgroup.lookup.error", "Unable to lookup host group with name = " + hostGroupName);
        }
        return hostGroup;
    }

    private List populateHostMappings(ObjectBundleManager manager, ObjectBundle bundle, String arrayWwn, String hostScopeKey) throws ConfigMgmtException {
        int lunMappingCount;
        Map keyMap = Convert.keyAsStringToMap(hostScopeKey);
        String hostName = (String)keyMap.get("name");
        Host host = this.getHostForName(bundle.getStoragePoolBundle().getHost(), hostName);
        String hostRefString = Convert.bytesToStringRaw(host.getHostRef().getRefToken());
        String hostGroupRefString = Convert.bytesToStringRaw(host.getClusterRef().getRefToken());
        ArrayList<Mapping> hostMappings = new ArrayList<Mapping>();
        LUNMapping[] lunMappings = bundle.getStoragePoolBundle().getLunMapping();
        int n = lunMappingCount = lunMappings != null ? lunMappings.length : 0;
        if (lunMappingCount == 0) {
            return hostMappings;
        }
        LUNMapping lunMapping = null;
        int lunMappingType = -1;
        Volume volume = null;
        SnapshotVolume snapshotVolume = null;
        Mapping mapping = null;
        String volumeName = null;
        String volumeWwn = null;
        boolean addMapping = false;
        int mappingType = -1;
        String mappedVia = null;
        int volumeType = -1;
        HashMap volumeMap = new HashMap();
        this.populateVolumeRefVolumeMap(bundle.getVolume(), volumeMap);
        HashMap snapshotVolumeMap = new HashMap();
        this.populateSnapshotVolumeRefSnapshotVolumeMap(bundle.getHighLevelVolBundle().getSnapshotVol(), snapshotVolumeMap);
        for (int i = 0; i < lunMappingCount; ++i) {
            lunMapping = lunMappings[i];
            lunMappingType = lunMapping.getType().getValue();
            addMapping = false;
            if (host.getIsSAControlled()) {
                if (lunMappingType == 8) {
                    addMapping = true;
                    mappingType = 1000;
                    mappedVia = "mapped.via.default.group";
                }
            } else if (lunMappingType == 3 && hostRefString.equals(Convert.bytesToStringRaw(lunMappings[i].getMapRef().getRefToken()))) {
                addMapping = true;
                mappingType = 1002;
                mappedVia = "mapped.via.host";
            } else if (lunMappingType == 4 && hostGroupRefString.equals(Convert.bytesToStringRaw(lunMappings[i].getMapRef().getRefToken()))) {
                addMapping = true;
                mappingType = 1001;
                mappedVia = "mapped.via.host.group";
            }
            if (!addMapping) continue;
            volume = (Volume)volumeMap.get(Convert.bytesToStringRaw(lunMapping.getVolumeRef().getRefToken()));
            if (volume != null) {
                volumeName = UnicodeTranslator.getString((byte[])volume.getLabel().getValue());
                volumeWwn = Convert.bytesToString(volume.getWorldWideName());
                volumeType = 100;
            } else {
                snapshotVolume = (SnapshotVolume)snapshotVolumeMap.get(Convert.bytesToStringRaw(lunMapping.getVolumeRef().getRefToken()));
                if (snapshotVolume != null) {
                    volumeName = UnicodeTranslator.getString((byte[])snapshotVolume.getLabel().getValue());
                    volumeWwn = Convert.bytesToString(snapshotVolume.getWorldWideName());
                    volumeType = 101;
                } else {
                    addMapping = false;
                }
            }
            if (!addMapping || this.filter != null && (this.filter.isEmpty() || !this.filter.getSearchField().equals("volumeName") || !this.filter.getSearchString().equals(volumeName)) && (!this.filter.getSearchField().equals("mappingType") || !this.filter.getSearchString().equals("" + mappingType))) continue;
            mapping = this.populateMapping(volumeName, null, hostName, null, null, lunMapping.getLun(), mappedVia, mappingType, arrayWwn, volumeWwn, volumeType);
            hostMappings.add(mapping);
        }
        return hostMappings;
    }

    private List populateHostGroupMappings(ObjectBundleManager manager, ObjectBundle bundle, String arrayWwn, String hostGroupScopeKey) throws ConfigMgmtException {
        int lunMappingCount;
        Map keyMap = Convert.keyAsStringToMap(hostGroupScopeKey);
        String hostGroupName = (String)keyMap.get("name");
        Cluster hostGroup = this.getHostGroupForName(bundle.getStoragePoolBundle().getCluster(), hostGroupName);
        String hostGroupRefString = Convert.bytesToStringRaw(hostGroup.getClusterRef().getRefToken());
        ArrayList<Mapping> hostGroupMappings = new ArrayList<Mapping>();
        LUNMapping[] lunMappings = bundle.getStoragePoolBundle().getLunMapping();
        int n = lunMappingCount = lunMappings != null ? lunMappings.length : 0;
        if (lunMappingCount == 0) {
            return hostGroupMappings;
        }
        LUNMapping lunMapping = null;
        int lunMappingType = -1;
        Volume volume = null;
        SnapshotVolume snapshotVolume = null;
        Mapping mapping = null;
        String volumeName = null;
        String volumeWwn = null;
        boolean addMapping = false;
        int mappingType = -1;
        String mappedVia = null;
        int volumeType = -1;
        HashMap volumeMap = new HashMap();
        this.populateVolumeRefVolumeMap(bundle.getVolume(), volumeMap);
        HashMap snapshotVolumeMap = new HashMap();
        this.populateSnapshotVolumeRefSnapshotVolumeMap(bundle.getHighLevelVolBundle().getSnapshotVol(), snapshotVolumeMap);
        for (int i = 0; i < lunMappingCount; ++i) {
            lunMapping = lunMappings[i];
            lunMappingType = lunMapping.getType().getValue();
            addMapping = false;
            if (hostGroup.getIsSAControlled()) {
                if (lunMappingType == 8) {
                    addMapping = true;
                    mappingType = 1000;
                    mappedVia = "mapped.via.default.group";
                }
            } else if (lunMappingType == 4 && hostGroupRefString.equals(Convert.bytesToStringRaw(lunMappings[i].getMapRef().getRefToken()))) {
                addMapping = true;
                mappingType = 1002;
                mappedVia = "mapped.via.host.group";
            }
            if (!addMapping) continue;
            volume = (Volume)volumeMap.get(Convert.bytesToStringRaw(lunMapping.getVolumeRef().getRefToken()));
            if (volume != null) {
                volumeName = UnicodeTranslator.getString((byte[])volume.getLabel().getValue());
                volumeWwn = Convert.bytesToString(volume.getWorldWideName());
                volumeType = 100;
            } else {
                snapshotVolume = (SnapshotVolume)snapshotVolumeMap.get(Convert.bytesToStringRaw(lunMapping.getVolumeRef().getRefToken()));
                if (snapshotVolume != null) {
                    volumeName = UnicodeTranslator.getString((byte[])snapshotVolume.getLabel().getValue());
                    volumeWwn = Convert.bytesToString(snapshotVolume.getWorldWideName());
                    volumeType = 101;
                } else {
                    addMapping = false;
                }
            }
            if (!addMapping || this.filter != null && (this.filter.isEmpty() || !this.filter.getSearchField().equals("volumeName") || !this.filter.getSearchString().equals(volumeName)) && (!this.filter.getSearchField().equals("mappingType") || !this.filter.getSearchString().equals("" + mappingType))) continue;
            mapping = this.populateMapping(volumeName, hostGroupName, null, null, null, lunMapping.getLun(), mappedVia, mappingType, arrayWwn, volumeWwn, volumeType);
            hostGroupMappings.add(mapping);
        }
        return hostGroupMappings;
    }

    private void populateVolumeRefVolumeMap(Volume[] volumes, Map volumeMap) {
        int length = volumes == null ? 0 : volumes.length;
        for (int i = 0; i < length; ++i) {
            volumeMap.put(Convert.bytesToStringRaw(volumes[i].getVolumeRef().getRefToken()), volumes[i]);
        }
    }

    private void populateSnapshotVolumeRefSnapshotVolumeMap(SnapshotVolume[] snapshotVolumes, Map snapshotVolumeMap) {
        int length = snapshotVolumes == null ? 0 : snapshotVolumes.length;
        for (int i = 0; i < length; ++i) {
            snapshotVolumeMap.put(Convert.bytesToStringRaw(snapshotVolumes[i].getSnapshotRef().getRefToken()), snapshotVolumes[i]);
        }
    }

    private Map populateVolumeWwnVolumeMap(Volume[] volumes) {
        HashMap<String, Volume> volumeMap = new HashMap<String, Volume>();
        int length = volumes == null ? 0 : volumes.length;
        for (int i = 0; i < length; ++i) {
            volumeMap.put(Convert.bytesToString(volumes[i].getWorldWideName()), volumes[i]);
        }
        return volumeMap;
    }

    private Map populateSnapshotVolumeWwnSnapshotVolumeMap(SnapshotVolume[] snapshotVolumes) {
        HashMap<String, SnapshotVolume> snapshotVolumeMap = new HashMap<String, SnapshotVolume>();
        int length = snapshotVolumes == null ? 0 : snapshotVolumes.length;
        for (int i = 0; i < length; ++i) {
            snapshotVolumeMap.put(Convert.bytesToString(snapshotVolumes[i].getWorldWideName()), snapshotVolumes[i]);
        }
        return snapshotVolumeMap;
    }

    private Map populateHostRefHostMap(Host[] hosts) {
        HashMap<String, Host> hostRefHostMap = new HashMap<String, Host>();
        int length = hosts == null ? 0 : hosts.length;
        for (int i = 0; i < length; ++i) {
            hostRefHostMap.put(Convert.bytesToStringRaw(hosts[i].getHostRef().getRefToken()), hosts[i]);
        }
        return hostRefHostMap;
    }

    private Map populateHostGroupRefHostGroupMap(Cluster[] hostGroups) {
        HashMap<String, Cluster> hostGroupRefHostMap = new HashMap<String, Cluster>();
        int length = hostGroups == null ? 0 : hostGroups.length;
        for (int i = 0; i < length; ++i) {
            hostGroupRefHostMap.put(Convert.bytesToStringRaw(hostGroups[i].getClusterRef().getRefToken()), hostGroups[i]);
        }
        return hostGroupRefHostMap;
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) {
        this.context = context;
        this.scope = scope;
        this.filter = filter;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        if (key == null || props == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null key and Properties object for modify.");
        }
        String arrayWwn = this.getArrayWwnFromScope();
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = manager.getObjectBundle(arrayWwn);
        String mapKeyAsString = (String)props.get("hostOrHostGroupKey");
        HashMap loggerHelperMap = new HashMap(5);
        SYMbolRef mapRef = this.populateMapReference(mapKeyAsString, bundle, loggerHelperMap);
        AbstractVolRef volumeRef = this.populateVolumeReference(key, bundle, loggerHelperMap);
        LUNMapping lunMapping = this.getLunMappingForVolume(Convert.bytesToStringRaw(volumeRef.getRefToken()), bundle.getStoragePoolBundle().getLunMapping());
        if (lunMapping == null) {
            LogAPI.staticLog((String)"MAPPING_MODIFY_ERROR", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
            throw new ConfigMgmtException("modify.nonexistent.mapping.error", "Can not modify nonexistent mapping.");
        }
        if (Convert.bytesToStringRaw(mapRef.getRefToken()).equals(Convert.bytesToStringRaw(lunMapping.getMapRef().getRefToken()))) {
            return;
        }
        int lun = -1;
        int oldLun = lunMapping.getLun();
        List availableLuns = this.getAvailableLuns(mapKeyAsString);
        if (availableLuns.size() == 0) {
            LogAPI.staticLog((String)"MAPPING_MODIFY_ERROR_NO_LUN", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
            throw new ConfigMgmtException("error.no.lun.available", "No available lun number for mapping creation.");
        }
        lun = availableLuns.contains(new Integer(oldLun)) ? oldLun : (Integer)availableLuns.get(0);
        LUNMappingUpdateDescriptor descriptor = this.getLUNMappingUpdateDescriptor(lunMapping.getLunMappingRef(), mapRef, lun);
        manager.stopMonitoringThread(arrayWwn);
        ReturnCode returnCode = new ReturnCode();
        int returnCodeInt = -1;
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            command.execute(81, (XDRType)descriptor, (XDRType)returnCode, true);
        }
        catch (RPCError rpce) {
            Trace.error((Object)this, "modify", (Throwable)rpce);
            LogAPI.staticLog((String)"MAPPING_MODIFY_ERROR", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
            throw new ConfigMgmtException("error.rpc", "RPCError exception trying to modify mapping.", (Exception)((Object)rpce));
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "modify", (Throwable)ioe);
            LogAPI.staticLog((String)"MAPPING_MODIFY_ERROR", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
            throw new ConfigMgmtException("error.communication", "IOException trying to modify maping.");
        }
        finally {
            manager.forceBundleReload(arrayWwn);
        }
        if (returnCode != null) {
            returnCodeInt = returnCode.getValue();
            if (returnCodeInt != 1) {
                String message = "Mapping modification failed with the error code: " + returnCodeInt;
                Trace.verbose((Object)this, "modify", message);
                LogAPI.staticLog((String)"MAPPING_MODIFY_ERROR", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + returnCodeInt), message);
            }
            LogAPI.staticLog((String)"MAPPING_MODIFY_SUCCESS", (String[])new String[]{arrayWwn, (String)loggerHelperMap.get(MAPPING_VOLUME_NAME), (String)loggerHelperMap.get(MAPPING_OBJECT_NAME)}, (String[])new String[0]);
            Trace.verbose((Object)this, "modify", "Mapping successfully created.");
        }
    }

    private LUNMappingUpdateDescriptor getLUNMappingUpdateDescriptor(LUNMappingRef lunMappingRef, SYMbolRef mapRef, int lun) {
        LUNMappingUpdateDescriptor descriptor = new LUNMappingUpdateDescriptor();
        descriptor.setLunMappingRef(lunMappingRef);
        descriptor.setMapRef(mapRef);
        descriptor.setLun(lun);
        return descriptor;
    }

    public List getAvailableLuns(String keyAsString) throws ConfigMgmtException {
        String METHOD_NAME = "getAvailableLuns";
        Trace.methodBegin(this, "getAvailableLuns");
        String arrayWwn = this.getArrayWwnFromScope();
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = manager.getObjectBundle(arrayWwn);
        HostRef mapRef = null;
        String mapRefString = null;
        ArrayList<String> hostsInHostGroup = new ArrayList<String>();
        String parentHostGroupRefString = null;
        if (keyAsString != null) {
            Map keyMap = Convert.keyAsStringToMap(keyAsString);
            int mapType = Integer.parseInt((String)keyMap.get("objectType"));
            String mapName = null;
            if (mapType == 101) {
                mapName = (String)keyMap.get("name");
                Host host = this.getHostForName(bundle.getStoragePoolBundle().getHost(), mapName);
                mapRef = host.getHostRef();
                mapRefString = Convert.bytesToStringRaw(mapRef.getRefToken());
                parentHostGroupRefString = Convert.bytesToStringRaw(host.getClusterRef().getRefToken());
            } else if (mapType == 100) {
                mapName = (String)keyMap.get("name");
                mapRef = this.getHostGroupForName(bundle.getStoragePoolBundle().getCluster(), mapName).getClusterRef();
                mapRefString = Convert.bytesToStringRaw(mapRef.getRefToken());
                Host[] hosts = bundle.getStoragePoolBundle().getHost();
                String hostGroupRefString = null;
                int hostCount = hosts != null ? hosts.length : 0;
                for (int i = 0; i < hostCount; ++i) {
                    hostGroupRefString = Convert.bytesToStringRaw(hosts[i].getClusterRef().getRefToken());
                    if (!mapRefString.equals(hostGroupRefString)) continue;
                    hostsInHostGroup.add(Convert.bytesToStringRaw(hosts[i].getHostRef().getRefToken()));
                }
            } else {
                throw new ConfigMgmtException("incorrect.method.parameter", "Invalid key passed.");
            }
        }
        ArrayList<Integer> availableLuns = new ArrayList<Integer>();
        for (int i = 0; i < 256; ++i) {
            availableLuns.add(new Integer(i));
        }
        LUNMapping[] lunMappings = bundle.getStoragePoolBundle().getLunMapping();
        int lunMappingCount = lunMappings != null ? lunMappings.length : 0;
        int lunMappingType = -1;
        String lunMappingMapRefString = null;
        for (int i = 0; i < lunMappingCount; ++i) {
            lunMappingType = lunMappings[i].getType().getValue();
            lunMappingMapRefString = Convert.bytesToStringRaw(lunMappings[i].getMapRef().getRefToken());
            if ((mapRefString != null || lunMappingType != 8) && (mapRefString == null || (lunMappingType != 4 || !mapRefString.equals(lunMappingMapRefString) && !lunMappingMapRefString.equals(parentHostGroupRefString)) && (lunMappingType != 3 || !mapRefString.equals(lunMappingMapRefString) && !hostsInHostGroup.contains(lunMappingMapRefString)))) continue;
            availableLuns.remove(new Integer(lunMappings[i].getLun()));
        }
        return availableLuns;
    }

    private String getArrayWwnFromScope() throws ConfigMgmtException {
        if (this.scope != null) {
            return Convert.scopeToArrayKey(this.scope);
        }
        throw new ConfigMgmtException("error.scope.required", "Scope not set before creating of a mapping.");
    }

    public static interface KeyMap {
        public static final String ARRAY = "array";
        public static final String VOLUME_WWN = "volumeWwn";
        public static final String MAPPING_TYPE = "mappingType";
    }

    public static interface ModifyProps {
        public static final String HOST_OR_HOST_GROUP_KEY = "hostOrHostGroupKey";
    }

    public static interface CreateProps {
        public static final String VOLUME_KEY = "volumeKey";
        public static final String HOST_OR_HOST_GROUP_KEY = "hostOrHostGroupKey";
        public static final String LUN = "lun";
    }
}

