/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.Initiator;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.symbol.ChangeQueryDescriptor;
import devmgr.versioned.symbol.Host;
import devmgr.versioned.symbol.HostPort;
import devmgr.versioned.symbol.HostPortCreationDescriptor;
import devmgr.versioned.symbol.HostPortName;
import devmgr.versioned.symbol.HostPortRef;
import devmgr.versioned.symbol.HostRef;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UserAssignedLabel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class ManageInitiators
implements ManageInitiatorsInterface {
    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        Collection bundles = ObjectBundleManager.getInstance().getObjectBundles();
        ArrayList iniList = new ArrayList();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            iniList.addAll(this.getInisFromBundle(bundle, null));
        }
        return iniList;
    }

    private List getInisFromBundle(ObjectBundle bundle, SearchFilter filter) throws ConfigMgmtException {
        String methodName = "getInisFromBundle";
        ArrayList<Initiator> inis = new ArrayList<Initiator>();
        HostPort[] ozHosts = bundle.getStoragePoolBundle().getHostPort();
        int ozHostsLength = ozHosts == null ? 0 : ozHosts.length;
        String arrayName = UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getStorageArrayLabel().getValue());
        for (int i = 0; i < ozHostsLength; ++i) {
            Initiator ini = new Initiator();
            ini.setStorageDomain(arrayName);
            ini.setWWN(Convert.bytesToString(ozHosts[i].getHostPortName().getValue()));
            ini.setName(UnicodeTranslator.getString((byte[])ozHosts[i].getLabel().getValue()));
            try {
                ini.setOSType(ozHosts[i].getHostPortTypeIndex());
            }
            catch (BadParameterException e) {
                Trace.verbose((Object)this, "getInisFromBundle", "Host port type was:" + ozHosts[i].getHostPortTypeIndex());
            }
            Trace.verbose((Object)this, "getInisFromBundle", "Name:" + ini.getName());
            Trace.verbose((Object)this, "getInisFromBundle", "WWN:" + ini.getWWN());
            ArrayList<String> key = new ArrayList<String>(2);
            byte[] rt = ozHosts[i].getHostPortRef().getRefToken();
            String lk = Convert.bytesToString(rt);
            key.add(lk);
            key.add(Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName()));
            ini.setKey(key);
            inis.add(ini);
        }
        return inis;
    }

    public ArrayList getItemsByStorageDomain(String name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByStorageDomain");
        Collection bundles = ObjectBundleManager.getInstance().getObjectBundles();
        ArrayList iniList = new ArrayList();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            String arrayName = UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getStorageArrayLabel().getValue());
            if (!arrayName.equals(name)) continue;
            iniList.addAll(this.getInisFromBundle(bundle, null));
        }
        return iniList;
    }

    public ArrayList getItemsByFCPort(String name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByInitiatorGroup(String name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public InitiatorInterface getItemByName(String name) throws ConfigMgmtException {
        return null;
    }

    public InitiatorInterface getItemByWwn(String wwn) throws ConfigMgmtException {
        return null;
    }

    public InitiatorInterface getByKey(Collection key) throws ConfigMgmtException {
        InitiatorInterface ini = null;
        Collection bundles = ObjectBundleManager.getInstance().getObjectBundles();
        ArrayList iniList = new ArrayList();
        String inKey = (String)key.toArray()[0];
        Trace.verbose((Object)this, "getByKey", "Find ini with WWN:" + inKey);
        Iterator iter = bundles.iterator();
        while (iter.hasNext() && ini == null) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            List inis = this.getInisFromBundle(bundle, null);
            for (int i = 0; i < inis.size() && ini == null; ++i) {
                InitiatorInterface temp = (InitiatorInterface)inis.get(i);
                if (!temp.getKey().contains(inKey)) continue;
                Trace.verbose((Object)this, "getByKey", "Found ini");
                ini = temp;
            }
        }
        return ini;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus create(String name, String wwn, String desc, int osType, String storageDomainName) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        HostPortCreationDescriptor hpcd = new HostPortCreationDescriptor();
        HostPortName hpn = new HostPortName();
        String[] wwnparts = wwn.split("\\.");
        byte[] n1 = new byte[wwnparts.length];
        Trace.verbose((Object)this, "create", "Number of parts:" + wwnparts.length);
        for (int i = 0; i < wwnparts.length; ++i) {
            n1[i] = (byte)Integer.decode("0x" + wwnparts[i]).intValue();
        }
        Trace.verbose((Object)this, "create", "wwn length:" + n1.length);
        hpn.setValue(n1);
        hpcd.setHostPortName(hpn);
        UserAssignedLabel label = new UserAssignedLabel();
        label.setValue(UnicodeTranslator.getBytes((String)name));
        hpcd.setLabel(label);
        hpcd.setHostPortTypeIndex(osType);
        HostRef hr = this.getFirstHostPortRefToken(storageDomainName);
        hpcd.setHostRef(hr);
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        String ip = manager.getIPForName(storageDomainName);
        try {
            SYMbolAPIClientV1 sym = manager.getAuthorizedClient("", ip);
            ReturnCodeWithRef rc = sym.createHostPort(hpcd);
            Trace.verbose((Object)this, "create", "Return Code is:" + rc.getReturnCode().getValue());
            Trace.verbose((Object)this, "create", "If it was OK return code would be: 1");
        }
        catch (RPCError e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HostRef getFirstHostPortRefToken(String storageDomainName) throws ItemNotFoundException {
        String ip = ObjectBundleManager.getInstance().getIPForName(storageDomainName);
        Trace.verbose((Object)this, "getFirstHostPortRefToken", "Get bundle for IP:" + ip);
        ObjectBundle bundle = null;
        try {
            bundle = ObjectBundleManager.getInstance().getObjectBundle(ip);
        }
        catch (SEItemNotFoundException e) {
            Trace.error((Object)this, (ConfigMgmtException)e);
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, e);
        }
        Host[] h = bundle.getStoragePoolBundle().getHost();
        HostRef res = null;
        if (h != null) {
            res = h[0].getHostRef();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        Object[] obj = key.toArray();
        String lk = (String)obj[0];
        String arrayWWN = (String)obj[1];
        String[] lkp = lk.split("\\.");
        byte[] n1 = new byte[lkp.length];
        Trace.verbose((Object)this, "create", "Number of parts:" + lkp.length);
        for (int i = 0; i < lkp.length; ++i) {
            n1[i] = (byte)Integer.decode("0x" + lkp[i]).intValue();
        }
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = manager.getObjectBundle(arrayWWN);
        SYMbolAPIClientV1 sym = null;
        sym = manager.getAuthorizedClient("", arrayWWN);
        HostPortRef hpr = this.getHostPortReference(n1);
        ReturnCode rc = sym.deleteHostPort(hpr);
        if (rc.getValue() != 1) {
            Trace.error((Object)this, "delete", "Return code is:" + rc.getValue());
            throw new ConfigMgmtException("error", "Delete failed with error code:" + rc.getValue());
        }
        Trace.verbose((Object)this, "delete", "GOT back from delete, wait for change");
        ChangeQueryDescriptor chgQuery = new ChangeQueryDescriptor();
        chgQuery.getLastKnown().setConfigGeneration(bundle.getConfigGeneration());
        chgQuery.getLastKnown().setLastCriticalMelSeqNumber(-1L);
        chgQuery.setMaxWait(2);
        sym.getChangeState(chgQuery);
        Trace.verbose((Object)this, "delete", "GOT CHANGE BACK ");
        Trace.verbose((Object)this, "create", "Return Code is:" + rc.getValue());
        Object var14_16 = null;
        if (sym == null) return null;
        try {
            sym.close();
            return null;
        }
        catch (IOException e1) {
            Trace.error((Object)this, "delete", (Throwable)e1);
        }
        return null;
        {
            catch (RPCError e) {
                e.printStackTrace();
                Object var14_17 = null;
                if (sym == null) return null;
                try {
                    sym.close();
                    return null;
                }
                catch (IOException e1) {
                    Trace.error((Object)this, "delete", (Throwable)e1);
                }
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var14_18 = null;
                if (sym == null) return null;
                try {
                    sym.close();
                    return null;
                }
                catch (IOException e1) {
                    Trace.error((Object)this, "delete", (Throwable)e1);
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (sym == null) throw throwable;
            try {
                sym.close();
                throw throwable;
            }
            catch (IOException e1) {
                Trace.error((Object)this, "delete", (Throwable)e1);
            }
            throw throwable;
        }
    }

    private HostPortRef getHostPortReference(byte[] tok) {
        String methodName = "getHostPortReference";
        HostPortRef ref = new HostPortRef();
        ref.setRefToken(tok);
        return ref;
    }

    public Comparator getInitiatorComparator(Locale loc) {
        return null;
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
    }

    public void validateDescription(String description) throws BadParameterException {
    }

    public List getItemList() throws ConfigMgmtException {
        return this.getItemsBySystem();
    }

    public void createInitiator(T4Interface t4, String wwn, String description, List initiatorGroups) throws ConfigMgmtException {
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
    }

    public void setScope(InstanceWrapper scope) {
    }

    public void setRestriction(int restriction) {
    }
}

