/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageHostsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.Host;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.Cluster;
import devmgr.versioned.symbol.ClusterRef;
import devmgr.versioned.symbol.HostCreationDescriptor;
import devmgr.versioned.symbol.HostPort;
import devmgr.versioned.symbol.HostRef;
import devmgr.versioned.symbol.LUNMapping;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SYMbolRef;
import devmgr.versioned.symbol.SYMbolRefPair;
import devmgr.versioned.symbol.SYMbolRefWithUAL;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UserAssignedLabel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ManageHosts
implements ManageHostsInterface {
    ConfigContext cfgctx = null;
    Scope scope = null;
    SearchFilter filter = null;

    public void create(Properties props) throws ConfigMgmtException {
        if (this.scope == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for creeeate operation");
        }
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        if (arrayKey == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for creeeate operation");
        }
        String newH = (String)props.get("name");
        if (newH == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_NAME_REQUIRED.getKey(), "Name is a required parameter");
        }
        try {
            UserAssignedLabel ual = new UserAssignedLabel();
            ual.setValue(UnicodeTranslator.getBytes((String)newH));
            HostCreationDescriptor hcd = new HostCreationDescriptor();
            hcd.setLabel(ual);
            Cluster cluster = null;
            if (props.get("hostGroupName") != null && !props.getProperty("hostGroupName").equals("")) {
                Trace.verbose((Object)this, "create", "host group name passed - find reference");
                Cluster[] clusters = ObjectBundleManager.getInstance().getObjectBundle(arrayKey).getStoragePoolBundle().getCluster();
                int size = clusters == null ? 0 : clusters.length;
                String sn = (String)props.get("hostGroupName");
                for (int i = 0; i < size && cluster == null; ++i) {
                    String cn = UnicodeTranslator.getString((byte[])clusters[i].getLabel().getValue());
                    if (!sn.equals(cn)) continue;
                    cluster = clusters[i];
                }
                if (cluster == null) {
                    throw new SEItemNotFoundException((String)props.get("hostGroupName"));
                }
                hcd.setClusterRef(cluster.getClusterRef());
            } else {
                ClusterRef cr = new ClusterRef();
                byte[] ref = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                cr.setRefToken(ref);
                hcd.setClusterRef(cr);
            }
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayKey);
            CommandProcessor command = new CommandProcessor(arrayKey);
            ReturnCodeWithRef rcr = new ReturnCodeWithRef();
            command.execute(66, (XDRType)hcd, (XDRType)rcr, true);
            Trace.verbose((Object)this, "create", "Return code:" + rcr.getReturnCode().getValue());
            if (rcr.getReturnCode().getValue() != 1) {
                LogAPI.staticLog((String)"HOST_CREATE_ERROR", (String[])new String[]{(String)props.get("name")}, (String[])new String[0]);
                throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rcr.getReturnCode().getValue()), "Create failed");
            }
            ObjectBundleManager.getInstance().forceBundleReload(arrayKey);
            Trace.verbose((Object)this, "create", "bundle reloaded");
            LogAPI.staticLog((String)"HOST_CREATE_SUCCESS", (String[])new String[]{(String)props.get("name")}, (String[])new String[0]);
        }
        catch (RPCError e) {
            LogAPI.staticLog((String)"HOST_CREATE_ERROR", (String[])new String[]{(String)props.get("name")}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage());
        }
        catch (IOException e) {
            LogAPI.staticLog((String)"HOST_CREATE_ERROR", (String[])new String[]{(String)props.get("name")}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String methodName = "delete";
        Trace.methodBegin(this, "delete");
        List keyMapList = Convert.listOfStringKeysToMap(list);
        int size = keyMapList == null ? 0 : keyMapList.size();
        MethodCallStatus mcs = new MethodCallStatus();
        String arrayID = Convert.scopeToArrayKey(this.scope);
        ObjectBundleManager.getInstance().stopMonitoringThread(arrayID);
        String name = "";
        try {
            CommandProcessor command = new CommandProcessor(arrayID);
            for (int i = 0; i < size; ++i) {
                Map m = (Map)keyMapList.get(i);
                name = (String)m.get("name");
                if (name == null) {
                    throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "Host name in the key is null");
                }
                ObjectBundle bundle = new ObjectBundle();
                command.execute(40, null, (XDRType)bundle, false);
                devmgr.versioned.symbol.Host host = this.getRef(name, bundle);
                if (host != null) {
                    Trace.verbose((Object)this, "delete", "delete");
                    ReturnCode ret = new ReturnCode();
                    command.execute(70, (XDRType)host.getHostRef(), (XDRType)ret, true);
                    if (ret.getValue() != 1) {
                        Trace.verbose((Object)this, "delete", "Delete failed with error:" + ret.getValue() + " for host :" + m.get("name"));
                        this.setErrorDescriptor(mcs, (String)m.get("name"), OZErrorCode.ERROR_CODE_MIN + ret.getValue(), "error.host.delete");
                        continue;
                    }
                    LogAPI.staticLog((String)"HOST_DELETE_SUCCESS", (String[])new String[]{name}, (String[])new String[0]);
                    Trace.verbose((Object)this, "delete", "delete successfull for host:" + m.get("name"));
                    this.setErrorDescriptor(mcs, (String)m.get("name"), ErrorDescriptor.ERROR_SUCCESS, "success");
                    continue;
                }
                this.setErrorDescriptor(mcs, (String)m.get("name"), ErrorDescriptor.ERROR_ITEM_NOT_FOUND, ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY);
            }
            ObjectBundleManager.getInstance().forceBundleReload(arrayID);
        }
        catch (IOException ioe) {
            LogAPI.staticLog((String)"HOST_DELETE_ERROR", (String[])new String[]{name}, (String[])new String[0]);
            Trace.error((Object)this, "delete", (Throwable)ioe);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        catch (RPCError ioe) {
            LogAPI.staticLog((String)"HOST_DELETE_ERROR", (String[])new String[]{name}, (String[])new String[0]);
            Trace.error((Object)this, "delete", (Throwable)ioe);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        return mcs;
    }

    private void setErrorDescriptor(MethodCallStatus mcs, String name, int ret, String ikey) {
        ErrorDescriptor ed = new ErrorDescriptor();
        ed.setErrorCode(ret);
        ed.setI18nkey(ikey);
        String[] params = new String[]{name};
        ed.setI18nParams(params);
        if (ret != 1) {
            ed.setMsg("Failed to delete host:" + params[0]);
        } else {
            ed.setMsg("Success deleting host:" + params[0]);
        }
        mcs.addErrorDescriptor(ed);
    }

    public int getMaxObjects() {
        return Integer.MAX_VALUE;
    }

    public void init(ConfigContext ctx, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = ctx;
        this.scope = s;
        this.filter = f;
    }

    public List getItemList() throws ConfigMgmtException {
        ArrayList<ObjectBundle> bundles = null;
        ArrayList<Host> itemList = new ArrayList<Host>();
        String filterClusterName = null;
        if (this.scope != null) {
            String arrayWWN = Convert.scopeToArrayKey(this.scope);
            ArrayList<ObjectBundle> bl = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWWN);
            bl.add(ob);
            bundles = bl;
            filterClusterName = this.getHostGroupNameFromScope();
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            devmgr.versioned.symbol.Host[] ozHosts = bundle.getStoragePoolBundle().getHost();
            Cluster[] ozHostGroup = bundle.getStoragePoolBundle().getCluster();
            Map clusterMap = this.mapClusters(ozHostGroup);
            String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            int size = ozHosts == null ? 0 : ozHosts.length;
            Set hostsWithPortsAndLunsRef = new HashSet();
            if (this.filter != null && this.filter.getSearchField().equals("hostsWithPortsAndLuns") && this.filter.passesFilter("hostsWithPortsAndLuns")) {
                hostsWithPortsAndLunsRef = this.getHostsWithPortsAndLunsRefs(bundle.getStoragePoolBundle().getHostPort(), bundle.getStoragePoolBundle().getHost(), bundle.getStoragePoolBundle().getLunMapping());
            }
            for (int i = 0; i < size; ++i) {
                devmgr.versioned.symbol.Host ozHost = ozHosts[i];
                Host host = new Host();
                String key = Convert.bytesToStringRaw(ozHost.getHostRef().getRefToken());
                host.setName(UnicodeTranslator.getString((byte[])ozHost.getLabel().getValue()));
                host.setObjectItemType("host");
                String fv = this.extractNameFromFilter(this.filter);
                Trace.verbose((Object)this, "getItemList", "Search filter value:" + fv);
                if (this.filter == null || this.filter.getSearchField().equals("keyAsString") && this.extractNameFromFilter(this.filter).equals(host.getName()) || this.filter.getSearchField().equals("name") && this.filter.passesFilter(host.getName()) || this.filter.getSearchField().equals("hostsWithPortsAndLuns") && this.filter.passesFilter("hostsWithPortsAndLuns") && hostsWithPortsAndLunsRef.contains(key)) {
                    Trace.verbose((Object)this, "getItemList", "Filter passed, host reference is:" + key);
                    if (ozHost.getIsSAControlled()) {
                        host.setAccessControl(0);
                    } else {
                        host.setAccessControl(1);
                    }
                    String clusterKey = null;
                    if (ozHost.getClusterRef() != null) {
                        clusterKey = Convert.bytesToStringRaw(ozHost.getClusterRef().getRefToken());
                        Trace.verbose((Object)this, "getItemList", "Cluster reference is:" + clusterKey);
                        Cluster cluster = (Cluster)clusterMap.get(clusterKey);
                        if (cluster != null) {
                            host.setGroupName(UnicodeTranslator.getString((byte[])cluster.getLabel().getValue()));
                        } else {
                            Trace.verbose((Object)this, "getItemList", "Cluster reference is not null, but not found in the map?");
                        }
                    }
                    if (filterClusterName != null && !filterClusterName.equals(host.getGroupName())) continue;
                    HashMap<String, String> keyMap = new HashMap<String, String>(2);
                    keyMap.put("array", arrayWWN);
                    keyMap.put("name", host.getName());
                    keyMap.put("objectType", host.getObjectType() + "");
                    host.setKey(keyMap);
                    itemList.add(host);
                    continue;
                }
                Trace.verbose((Object)this, "getItemList", "Does not match filter");
            }
        }
        return itemList;
    }

    private String extractNameFromFilter(SearchFilter filter) {
        String fv;
        String string = fv = filter == null ? "" : filter.getSearchString();
        if (fv == null || fv.equals("")) {
            return null;
        }
        Map map = Convert.keyAsStringToMap(fv);
        return (String)map.get("name");
    }

    private Map mapClusters(Cluster[] hostGroups) {
        HashMap<String, Cluster> map = new HashMap<String, Cluster>(10);
        int size = hostGroups == null ? 0 : hostGroups.length;
        for (int i = 0; i < size; ++i) {
            String key = Convert.bytesToStringRaw(hostGroups[i].getClusterRef().getRefToken());
            Trace.verbose((Object)this, "mapClusters", "Store reference:" + key);
            map.put(key, hostGroups[i]);
        }
        return map;
    }

    private String getHostGroupNameFromScope() {
        String methodName = "getHostGroupNameFromScope";
        String hgRef = null;
        Object key = this.scope.getAttribute("HostGroup");
        if (key != null) {
            Map map = null;
            map = !(key instanceof Map) ? Convert.keyAsStringToMap((String)key) : (Map)key;
            hgRef = (String)map.get("name");
            Trace.verbose((Object)this, "getHostGroupNameFromScope", "Host group name from scope is:" + hgRef);
        }
        return hgRef;
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList().size();
    }

    public boolean isOperationSupported(String operation) {
        return false;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String methodName = "modify";
        Trace.methodBegin(this, "modify");
        if (key == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "Key is null");
        }
        Map map = null;
        map = key instanceof Map ? (Map)key : Convert.keyAsStringToMap((String)key);
        if (map.get("name") == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "Host name in the key is null");
        }
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        String hostName = (String)props.get("name");
        String hostGroupName = (String)props.get("groupName");
        if (hostGroupName == null && hostName == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_NAME_REQUIRED.getKey(), "host and host group name is null ");
        }
        try {
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayKey);
            devmgr.versioned.symbol.Host h = null;
            Trace.verbose((Object)this, "modify", "New host name is:" + hostName);
            Trace.verbose((Object)this, "modify", "Old host name is:" + (String)map.get("name"));
            if (hostName != null && !hostName.equals((String)map.get("name"))) {
                this.renameHost(map, arrayKey, hostName);
            } else {
                hostName = (String)map.get("name");
            }
            ObjectBundle bundle = new ObjectBundle();
            CommandProcessor command = new CommandProcessor(arrayKey);
            command.execute(40, null, (XDRType)bundle, false);
            h = this.getRef(hostName, bundle);
            if (hostGroupName != null && !hostGroupName.equals("") && h != null) {
                this.moveHost(command, hostGroupName, bundle, h, null);
            }
            LogAPI.staticLog((String)"HOST_MODIFY_SUCCESS", (String[])new String[]{(String)props.get("name")}, (String[])new String[0]);
        }
        catch (RPCError e) {
            LogAPI.staticLog((String)"HOST_MODIFY_ERROR", (String[])new String[]{(String)props.get("name")}, (String[])new String[0]);
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage());
        }
        catch (IOException e) {
            LogAPI.staticLog((String)"HOST_MODIFY_ERROR", (String[])new String[]{(String)props.get("name")}, (String[])new String[0]);
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayKey);
        }
    }

    private void renameHost(Map map, String arrayKey, String hostName) throws RPCError, IOException, SEItemNotFoundException, ConfigMgmtException {
        String methodName = "renameHost";
        Trace.methodBegin(this, "renameHost");
        ObjectBundle bundle = new ObjectBundle();
        SYMbolRefWithUAL srual = new SYMbolRefWithUAL();
        UserAssignedLabel ual = new UserAssignedLabel();
        byte[] bName = UnicodeTranslator.getBytes((String)hostName);
        ual.setValue(bName);
        srual.setLabel(ual);
        CommandProcessor command = new CommandProcessor(arrayKey);
        command.execute(40, null, (XDRType)bundle, false);
        devmgr.versioned.symbol.Host h = this.getRef((String)map.get("name"), bundle);
        if (h != null) {
            HostRef ref = h.getHostRef();
            srual.setRef((SYMbolRef)ref);
            Trace.verbose((Object)this, "renameHost", "Rename host");
            ReturnCode rc = new ReturnCode();
            command.execute(71, (XDRType)srual, (XDRType)rc, true);
            if (rc.getValue() != 1) {
                throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "Failed to modify host name");
            }
        } else {
            Trace.error((Object)this, "renameHost", "Failed to find host with name:" + (String)map.get("name"));
            throw new SEItemNotFoundException((String)map.get("name"));
        }
        map.put("name", hostName);
        map.put("objectType", "100");
    }

    private void moveHost(CommandProcessor command, String hostGroupName, ObjectBundle bundle, devmgr.versioned.symbol.Host host, MethodCallStatus mcs) throws SEItemNotFoundException, RPCError, IOException, ConfigMgmtException {
        String methodName = "moveHost";
        Trace.methodBegin(this, "moveHost");
        HostRef hr = host.getHostRef();
        SYMbolRefPair srp = new SYMbolRefPair();
        SYMbolRef cr = new SYMbolRef();
        if (hostGroupName != null && !hostGroupName.equals("")) {
            Trace.verbose((Object)this, "moveHost", "Move host to group:" + hostGroupName);
            cr = this.getHostGroupRef(hostGroupName, bundle);
        } else {
            Trace.verbose((Object)this, "moveHost", "REMOVE HOST FROM GROUP WITH EMPTY REFERENCE");
            byte[] ref = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            cr.setRefToken(ref);
        }
        srp.setContainerRef(cr);
        srp.setItemRef((SYMbolRef)hr);
        if (hr == null || cr == null) {
            Trace.verbose((Object)this, "modify", "Host Ref:" + hr + " HostGroupRef:" + cr);
            if (mcs == null) {
                throw new SEItemNotFoundException(hostGroupName);
            }
            String hostName = this.getHostNameFromHost(host);
            this.setErrorDescriptor(mcs, hostName, ErrorDescriptor.ERROR_ITEM_NOT_FOUND, ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY);
        }
        ReturnCode rc = new ReturnCode();
        command.execute(72, (XDRType)srp, (XDRType)rc, true);
        Trace.verbose((Object)this, "moveHost", "Return code after move:" + rc.getValue());
        if (rc.getValue() != 1) {
            if (mcs == null) {
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "Failed to move the host");
            }
            String hostName = this.getHostNameFromHost(host);
            this.setErrorDescriptor(mcs, hostName, rc.getValue() + OZErrorCode.ERROR_CODE_MIN, ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()));
        }
    }

    private String getHostNameFromHost(devmgr.versioned.symbol.Host host) {
        byte[] bl = host.getLabel().getValue();
        String hostName = "";
        if (bl != null) {
            hostName = UnicodeTranslator.getString((byte[])bl);
        }
        return hostName;
    }

    private devmgr.versioned.symbol.Host getRef(String hostName, ObjectBundle bundle) {
        Trace.verbose((Object)this, "getRef", "Get reference for host:" + hostName);
        devmgr.versioned.symbol.Host[] ozHosts = bundle.getStoragePoolBundle().getHost();
        Object ref = null;
        devmgr.versioned.symbol.Host h = null;
        for (int i = 0; i < ozHosts.length && ref == null; ++i) {
            String tName;
            byte[] bName = ozHosts[i].getLabel().getValue();
            if (bName == null || !(tName = UnicodeTranslator.getString((byte[])bName)).equals(hostName)) continue;
            h = ozHosts[i];
            Trace.verbose((Object)this, "getRef", "Found host!");
        }
        return h;
    }

    private SYMbolRef getHostGroupRef(String hostGroupName, ObjectBundle bundle) {
        Trace.verbose((Object)this, "getHostGroupRef", "Find host group:" + hostGroupName);
        Cluster[] ozClusters = bundle.getStoragePoolBundle().getCluster();
        ClusterRef ref = null;
        for (int i = 0; i < ozClusters.length && ref == null; ++i) {
            String tName;
            byte[] bName = ozClusters[i].getLabel().getValue();
            if (bName == null || !(tName = UnicodeTranslator.getString((byte[])bName)).equals(hostGroupName)) continue;
            ref = ozClusters[i].getClusterRef();
            Trace.verbose((Object)this, "getHostGroupRef", "Found it!");
        }
        return ref;
    }

    private void validateProps(Properties props) throws ConfigMgmtException {
        if (this.scope == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for modify operation");
        }
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        String hostName = (String)props.get("name");
        if (arrayKey == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for modify operation");
        }
        if (hostName == null || hostName.trim().length() == 0) {
            throw new ConfigMgmtException(ErrorCode.ERROR_NAME_REQUIRED.getKey(), "Name is a required parameter");
        }
    }

    public MethodCallStatus removeFromGroup(List keyList) throws ConfigMgmtException {
        String methodName = "removeFromGroup";
        List keyMapList = Convert.listOfStringKeysToMap(keyList);
        int size = keyMapList == null ? 0 : keyMapList.size();
        MethodCallStatus mcs = new MethodCallStatus();
        String arrayID = Convert.scopeToArrayKey(this.scope);
        ObjectBundleManager bundleManager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = bundleManager.getObjectBundle(arrayID);
        bundleManager.stopMonitoringThread(arrayID);
        for (int i = 0; i < size; ++i) {
            Map m = (Map)keyMapList.get(i);
            String name = (String)m.get("name");
            if (name == null) {
                throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "Host name in the key is null");
            }
            devmgr.versioned.symbol.Host h = this.getRef(name, bundle);
            try {
                CommandProcessor command = new CommandProcessor(arrayID);
                this.moveHost(command, "", bundle, h, mcs);
                continue;
            }
            catch (RPCError e) {
                Trace.error((Object)this, "removeFromGroup", (Throwable)e);
                this.setErrorDescriptor(mcs, this.getHostNameFromHost(h), ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY, ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY);
                continue;
            }
            catch (IOException e) {
                Trace.error((Object)this, "removeFromGroup", (Throwable)e);
                this.setErrorDescriptor(mcs, this.getHostNameFromHost(h), ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY, ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY);
            }
        }
        return mcs;
    }

    private Set getHostsWithPortsAndLunsRefs(HostPort[] ozHostPorts, devmgr.versioned.symbol.Host[] ozHosts, LUNMapping[] ozLunMappings) {
        Trace.methodBegin(this, "getHostsWithPortsAndLunsRefs");
        String hostRef = null;
        String hostGroupRef = null;
        Integer numberOfHostMappings = null;
        Integer numberOfHostGroupMappings = null;
        int numberOfHostMappingsInt = 0;
        int numberOfHostGroupMappingsInt = 0;
        HashSet<String> hostsWithPortsAndLunsRefs = new HashSet<String>();
        int length = ozHostPorts != null ? ozHostPorts.length : 0;
        for (int i = 0; i < length; ++i) {
            hostsWithPortsAndLunsRefs.add(Convert.bytesToStringRaw(ozHostPorts[i].getHostRef().getRefToken()));
        }
        Map mappedHostAndHostGroups = this.getMappedHostAndHostGroups(ozLunMappings);
        length = ozHosts != null ? ozHosts.length : 0;
        for (int i = 0; i < length; ++i) {
            hostRef = Convert.bytesToStringRaw(ozHosts[i].getHostRef().getRefToken());
            if (!hostsWithPortsAndLunsRefs.contains(hostRef)) continue;
            numberOfHostMappings = (Integer)mappedHostAndHostGroups.get(hostRef);
            numberOfHostMappingsInt = numberOfHostMappings == null ? 0 : numberOfHostMappings;
            numberOfHostGroupMappingsInt = 0;
            hostGroupRef = Convert.bytesToStringRaw(ozHosts[i].getClusterRef().getRefToken());
            if (!hostGroupRef.equals("0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:")) {
                numberOfHostGroupMappings = (Integer)mappedHostAndHostGroups.get(hostGroupRef);
                int n = numberOfHostGroupMappingsInt = numberOfHostGroupMappings == null ? 0 : numberOfHostGroupMappings;
            }
            if (numberOfHostMappingsInt + numberOfHostGroupMappingsInt < 256) continue;
            hostsWithPortsAndLunsRefs.remove(hostRef);
        }
        return hostsWithPortsAndLunsRefs;
    }

    private Map getMappedHostAndHostGroups(LUNMapping[] ozLunMappings) {
        Trace.methodBegin(this, "getMappedHostAndHostGroups");
        int lunMappingType = -1;
        String lunMappingMapRefString = null;
        Integer numberOfMappings = null;
        HashMap<String, Integer> mappedHostAndHostGroups = new HashMap<String, Integer>();
        int lunMappingCount = ozLunMappings != null ? ozLunMappings.length : 0;
        for (int i = 0; i < lunMappingCount; ++i) {
            lunMappingType = ozLunMappings[i].getType().getValue();
            lunMappingMapRefString = Convert.bytesToStringRaw(ozLunMappings[i].getMapRef().getRefToken());
            if (lunMappingType != 4 && lunMappingType != 3) continue;
            numberOfMappings = (Integer)mappedHostAndHostGroups.get(lunMappingMapRefString);
            numberOfMappings = numberOfMappings == null ? new Integer(1) : new Integer(numberOfMappings + 1);
            mappedHostAndHostGroups.put(lunMappingMapRefString, numberOfMappings);
        }
        return mappedHostAndHostGroups;
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String HOSTS_WITH_PORTS_AND_LUNS = "hostsWithPortsAndLuns";
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String HOST_NAME = "name";
        public static final String KEY_NAME = "HostKey";
        public static final String OBJECT_TYPE = "objectType";
    }

    public static interface ModifyProps {
        public static final String NAME = "name";
        public static final String GROUP_NAME = "groupName";
    }

    public static interface CreateProps {
        public static final String NAME = "name";
        public static final String GROUP_NAME = "hostGroupName";
    }
}

