/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageHostGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.HostGroup;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.Cluster;
import devmgr.versioned.symbol.ClusterRef;
import devmgr.versioned.symbol.Host;
import devmgr.versioned.symbol.HostPort;
import devmgr.versioned.symbol.LUNMapping;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SYMbolRef;
import devmgr.versioned.symbol.SYMbolRefWithUAL;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UserAssignedLabel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ManageHostGroups
implements ManageHostGroupsInterface {
    ConfigContext cfgctx;
    Scope scope;
    SearchFilter filter;

    public void create(Properties props) throws ConfigMgmtException {
        if (this.scope == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for create operation");
        }
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        if (arrayKey == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for creeeate operation");
        }
        String newHG = (String)props.get("name");
        if (newHG == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_NAME_REQUIRED.getKey(), "Name is a required parameter");
        }
        try {
            try {
                CommandProcessor command = new CommandProcessor(arrayKey);
                Trace.verbose((Object)this, "create", "stop monitoring");
                ObjectBundleManager.getInstance().stopMonitoringThread(arrayKey);
                UserAssignedLabel ual = new UserAssignedLabel();
                ual.setValue(UnicodeTranslator.getBytes((String)newHG));
                Trace.verbose((Object)this, "create", "Create cluster");
                ReturnCodeWithRef rcr = new ReturnCodeWithRef();
                command.execute(67, (XDRType)ual, (XDRType)rcr, true);
                Trace.verbose((Object)this, "create", "Return code:" + rcr.getReturnCode().getValue());
                if (rcr.getReturnCode().getValue() != 1) {
                    LogAPI.staticLog((String)"HOSTGROUP_CREATE_ERROR", (String[])new String[]{newHG}, (String[])new String[0]);
                    throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rcr.getReturnCode().getValue()), "Create failed");
                }
                LogAPI.staticLog((String)"HOSTGROUP_CREATE_SUCCESS", (String[])new String[]{newHG}, (String[])new String[0]);
            }
            catch (RPCError e) {
                LogAPI.staticLog((String)"HOSTGROUP_CREATE_ERROR", (String[])new String[]{newHG}, (String[])new String[0]);
                Trace.error((Object)this, "create", (Throwable)e);
                throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                LogAPI.staticLog((String)"HOSTGROUP_CREATE_ERROR", (String[])new String[]{newHG}, (String[])new String[0]);
                Trace.error((Object)this, "create", (Throwable)e);
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage(), e);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Trace.verbose((Object)this, "create", "force bundle reload");
            ObjectBundleManager.getInstance().forceBundleReload(arrayKey);
            Trace.verbose((Object)this, "create", "Bundle reloaded");
            throw throwable;
        }
        Trace.verbose((Object)this, "create", "force bundle reload");
        ObjectBundleManager.getInstance().forceBundleReload(arrayKey);
        Trace.verbose((Object)this, "create", "Bundle reloaded");
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        List keyMapList = Convert.listOfStringKeysToMap(list);
        int size = keyMapList == null ? 0 : keyMapList.size();
        MethodCallStatus mcs = new MethodCallStatus();
        if (list == null || list.isEmpty()) {
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "Lists of keys for deletion is empty");
        }
        String arrayID = Convert.scopeToArrayKey(this.scope);
        String name = "";
        try {
            CommandProcessor command = new CommandProcessor(arrayID);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayID);
            for (int i = 0; i < size; ++i) {
                Map m = (Map)keyMapList.get(i);
                name = (String)m.get("name");
                ObjectBundle bundle = new ObjectBundle();
                command.execute(40, null, (XDRType)bundle, false);
                ClusterRef cr = (ClusterRef)this.getHostGroupRef(name, bundle);
                if (cr != null) {
                    Trace.verbose((Object)this, "delete", "delete");
                    ReturnCode ret = new ReturnCode();
                    command.execute(68, (XDRType)cr, (XDRType)ret, true);
                    if (ret.getValue() != 1) {
                        LogAPI.staticLog((String)"HOSTGROUP_DELETE_ERROR", (String[])new String[]{name}, (String[])new String[0]);
                        Trace.verbose((Object)this, "delete", "Delete failed with error:" + ret.getValue() + " for host group:" + m.get("name"));
                        this.setErrorDescriptor(mcs, m, OZErrorCode.ERROR_CODE_MIN + ret.getValue(), "error.hostGroup.delete");
                        continue;
                    }
                    LogAPI.staticLog((String)"HOSTGROUP_DELETE_SUCCESS", (String[])new String[]{name}, (String[])new String[0]);
                    Trace.verbose((Object)this, "delete", "delete successfull for hg:" + m.get("name"));
                    this.setErrorDescriptor(mcs, m, ErrorDescriptor.ERROR_SUCCESS, "success");
                    continue;
                }
                LogAPI.staticLog((String)"HOSTGROUP_DELETE_ERROR", (String[])new String[]{name}, (String[])new String[0]);
                this.setErrorDescriptor(mcs, m, ErrorDescriptor.ERROR_ITEM_NOT_FOUND, ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY);
            }
        }
        catch (RPCError e) {
            LogAPI.staticLog((String)"HOSTGROUP_DELETE_ERROR", (String[])new String[]{name}, (String[])new String[0]);
            Trace.error((Object)this, "delete", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (IOException e) {
            LogAPI.staticLog((String)"HOSTGROUP_DELETE_ERROR", (String[])new String[]{name}, (String[])new String[0]);
            Trace.error((Object)this, "delete", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayID);
        }
        return mcs;
    }

    private void setErrorDescriptor(MethodCallStatus mcs, Map m, int ret, String ikey) {
        ErrorDescriptor ed = new ErrorDescriptor();
        ed.setErrorCode(ret);
        ed.setI18nkey(ikey);
        String[] params = new String[]{(String)m.get("name")};
        ed.setI18nParams(params);
        if (ret != 1) {
            ed.setMsg("Operation failed on host group:" + params[0]);
        } else {
            ed.setMsg("Operation succeded on host group:" + params[0]);
        }
        mcs.addErrorDescriptor(ed);
    }

    public int getMaxObjects() {
        return Integer.MAX_VALUE;
    }

    public void init(ConfigContext context, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = context;
        this.scope = s;
        this.filter = f;
    }

    public List getItemList() throws ConfigMgmtException {
        String methodName = "getItemList";
        ArrayList<HostGroup> itemList = new ArrayList<HostGroup>();
        ArrayList<ObjectBundle> bundles = null;
        ArrayList trayList = new ArrayList();
        if (this.scope != null) {
            String arrayWWN = Convert.scopeToArrayKey(this.scope);
            ArrayList<ObjectBundle> bl = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWWN);
            bl.add(ob);
            bundles = bl;
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            Cluster[] clusters;
            ObjectBundle bundle = (ObjectBundle)iter.next();
            String arrayName = "";
            if (bundle.getSa().getSaData().getStorageArrayLabel().getValue() != null) {
                arrayName = UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getStorageArrayLabel().getValue());
            }
            String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            Set hostGroupsWithPortsAndLunsRef = new HashSet();
            if (this.filter != null && this.filter.getSearchField().equals("hostsWithPortsAndLuns") && this.filter.passesFilter("hostsWithPortsAndLuns")) {
                hostGroupsWithPortsAndLunsRef = this.getHostGroupsWithPortsAndLunsRefs(bundle.getStoragePoolBundle().getHostPort(), bundle.getStoragePoolBundle().getHost(), bundle.getStoragePoolBundle().getLunMapping());
            }
            int size = (clusters = bundle.getStoragePoolBundle().getCluster()) == null ? 0 : clusters.length;
            for (int i = 0; i < size; ++i) {
                Cluster cluster = clusters[i];
                HostGroup hg = new HostGroup();
                if (cluster.getLabel().getValue() != null) {
                    hg.setName(UnicodeTranslator.getString((byte[])cluster.getLabel().getValue()));
                }
                hg.setArrayName(arrayName);
                hg.setObjectItemType("hostgroup");
                if (cluster.getIsSAControlled()) {
                    hg.setAccessControl(0);
                } else {
                    hg.setAccessControl(1);
                }
                String clusterRef = Convert.bytesToStringRaw(cluster.getClusterRef().getRefToken());
                String fv = this.getGroupNameFromFilter(this.filter);
                if (!(this.filter == null || this.filter.getSearchField().equals("keyAsString") && fv.equals(hg.getName()) || this.filter.getSearchField().equals("name") && this.filter.passesFilter(hg.getName())) && (!this.filter.getSearchField().equals("hostsWithPortsAndLuns") || !this.filter.passesFilter("hostsWithPortsAndLuns") || !hostGroupsWithPortsAndLunsRef.contains(clusterRef))) continue;
                HashMap<String, String> keyMap = new HashMap<String, String>(2);
                keyMap.put("array", arrayWWN);
                keyMap.put("name", hg.getName());
                keyMap.put("objectType", hg.getObjectType() + "");
                hg.setKey(keyMap);
                itemList.add(hg);
            }
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "getItemList", "returning list with:" + itemList.size() + " elements");
        }
        return itemList;
    }

    private String getGroupNameFromFilter(SearchFilter filter) {
        String fv;
        String methodName = "getGroupNameFromFilter";
        String string = fv = filter == null ? "" : filter.getSearchString();
        if (fv == null || fv.equals("")) {
            return null;
        }
        Trace.verbose((Object)this, "getGroupNameFromFilter", fv);
        Map map = Convert.keyAsStringToMap(fv);
        return (String)map.get("name");
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList().size();
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        Map map = null;
        map = key instanceof Map ? (Map)key : Convert.keyAsStringToMap((String)key);
        if (key == null || map.get("name") == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "Key is null, or host name in the key is null");
        }
        this.validateProps(props);
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        String hostGroupName = (String)props.get("name");
        try {
            CommandProcessor command = new CommandProcessor(arrayKey);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayKey);
            ObjectBundle bundle = new ObjectBundle();
            Object cl = null;
            command.execute(40, null, (XDRType)bundle, false);
            SYMbolRefWithUAL srual = new SYMbolRefWithUAL();
            UserAssignedLabel ual = new UserAssignedLabel();
            byte[] bName = UnicodeTranslator.getBytes((String)hostGroupName);
            ual.setValue(bName);
            srual.setLabel(ual);
            SYMbolRef ref = this.getHostGroupRef((String)map.get("name"), bundle);
            if (ref != null) {
                srual.setRef(ref);
                Trace.verbose((Object)this, "modify", "Rename host group");
                ReturnCode rc = new ReturnCode();
                command.execute(69, (XDRType)srual, (XDRType)rc, true);
                if (rc.getValue() != 1) {
                    LogAPI.staticLog((String)"HOSTGROUP_MODIFY_ERROR", (String[])new String[]{hostGroupName}, (String[])new String[0]);
                    throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "Failed to modify host group name");
                }
            } else {
                LogAPI.staticLog((String)"HOSTGROUP_MODIFY_ERROR", (String[])new String[]{hostGroupName}, (String[])new String[0]);
                Trace.error((Object)this, "modify", "Failed to find host group with name:" + (String)map.get("name"));
                throw new SEItemNotFoundException((String)map.get("name"));
            }
            map.put("array", arrayKey);
            map.put("name", hostGroupName);
            map.put("objectType", "100");
            LogAPI.staticLog((String)"HOSTGROUP_MODIFY_SUCCESS", (String[])new String[]{hostGroupName}, (String[])new String[0]);
        }
        catch (RPCError e) {
            LogAPI.staticLog((String)"HOSTGROUP_MODIFY_ERROR", (String[])new String[]{hostGroupName}, (String[])new String[0]);
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage());
        }
        catch (IOException e) {
            LogAPI.staticLog((String)"HOSTGROUP_MODIFY_ERROR", (String[])new String[]{hostGroupName}, (String[])new String[0]);
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayKey);
        }
    }

    private SYMbolRef getHostGroupRef(String hostGroupName, ObjectBundle bundle) {
        Trace.verbose((Object)this, "getHostGroupRef", "Find host group:" + hostGroupName);
        Cluster[] ozClusters = bundle.getStoragePoolBundle().getCluster();
        ClusterRef ref = null;
        for (int i = 0; i < ozClusters.length && ref == null; ++i) {
            String tName;
            byte[] bName = ozClusters[i].getLabel().getValue();
            if (bName == null || !(tName = UnicodeTranslator.getString((byte[])bName)).equals(hostGroupName)) continue;
            ref = ozClusters[i].getClusterRef();
            Trace.verbose((Object)this, "getHostGroupRef", "Found it!");
        }
        return ref;
    }

    private void validateProps(Properties props) throws ConfigMgmtException {
        if (this.scope == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for modify operation");
        }
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        String hostGroupName = (String)props.get("name");
        if (arrayKey == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for modify operation");
        }
        if (hostGroupName == null || hostGroupName.trim().length() == 0) {
            throw new ConfigMgmtException(ErrorCode.ERROR_NAME_REQUIRED.getKey(), "Name is a required parameter");
        }
    }

    private Set getHostGroupsWithPortsAndLunsRefs(HostPort[] ozHostPorts, Host[] ozHosts, LUNMapping[] ozLunMappings) {
        int i;
        Trace.methodBegin(this, "getHostGroupsWithPortsAndLunsRefs");
        String hostRef = null;
        String hostGroupRef = null;
        Integer numberOfHostMappings = null;
        Integer numberOfHostGroupMappings = null;
        int numberOfHostMappingsInt = 0;
        int numberOfHostGroupMappingsInt = 0;
        HashSet<String> hostsWithPortsRefs = new HashSet<String>();
        HashSet<String> hostGroupsWithPortsAndLunsRefs = new HashSet<String>();
        HashMap<String, Integer> hostGroupHostMappings = new HashMap<String, Integer>();
        Map mappedHostAndHostGroups = this.getMappedHostAndHostGroups(ozLunMappings);
        int length = ozHostPorts != null ? ozHostPorts.length : 0;
        for (i = 0; i < length; ++i) {
            hostsWithPortsRefs.add(Convert.bytesToStringRaw(ozHostPorts[i].getHostRef().getRefToken()));
        }
        length = ozHosts != null ? ozHosts.length : 0;
        for (i = 0; i < length; ++i) {
            hostRef = Convert.bytesToStringRaw(ozHosts[i].getHostRef().getRefToken());
            if (!hostsWithPortsRefs.contains(hostRef) || (hostGroupRef = Convert.bytesToStringRaw(ozHosts[i].getClusterRef().getRefToken())).equals("0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:")) continue;
            hostGroupsWithPortsAndLunsRefs.add(hostGroupRef);
            numberOfHostMappings = (Integer)hostGroupHostMappings.get(hostGroupRef);
            if (numberOfHostMappings == null) {
                numberOfHostMappings = (Integer)mappedHostAndHostGroups.get(hostRef);
            } else if (mappedHostAndHostGroups.get(hostRef) != null) {
                numberOfHostMappings = new Integer(numberOfHostMappings + (Integer)mappedHostAndHostGroups.get(hostRef));
            }
            hostGroupHostMappings.put(hostGroupRef, numberOfHostMappings);
        }
        Set hostGroupKeys = hostGroupHostMappings.keySet();
        Iterator iter = hostGroupKeys.iterator();
        while (iter.hasNext()) {
            hostGroupRef = (String)iter.next();
            numberOfHostMappings = (Integer)hostGroupHostMappings.get(hostGroupRef);
            numberOfHostMappingsInt = numberOfHostMappings == null ? 0 : numberOfHostMappings;
            if (numberOfHostMappingsInt + (numberOfHostGroupMappingsInt = (numberOfHostGroupMappings = (Integer)mappedHostAndHostGroups.get(hostGroupRef)) == null ? 0 : numberOfHostGroupMappings) < 256) continue;
            hostGroupsWithPortsAndLunsRefs.remove(hostGroupRef);
        }
        return hostGroupsWithPortsAndLunsRefs;
    }

    private Map getMappedHostAndHostGroups(LUNMapping[] ozLunMappings) {
        Trace.methodBegin(this, "getMappedHostAndHostGroups");
        int lunMappingType = -1;
        String lunMappingMapRefString = null;
        Integer numberOfMappings = null;
        HashMap<String, Integer> mappedHostAndHostGroups = new HashMap<String, Integer>();
        int lunMappingCount = ozLunMappings != null ? ozLunMappings.length : 0;
        for (int i = 0; i < lunMappingCount; ++i) {
            lunMappingType = ozLunMappings[i].getType().getValue();
            lunMappingMapRefString = Convert.bytesToStringRaw(ozLunMappings[i].getMapRef().getRefToken());
            if (lunMappingType != 4 && lunMappingType != 3) continue;
            numberOfMappings = (Integer)mappedHostAndHostGroups.get(lunMappingMapRefString);
            numberOfMappings = numberOfMappings == null ? new Integer(1) : new Integer(numberOfMappings + 1);
            mappedHostAndHostGroups.put(lunMappingMapRefString, numberOfMappings);
        }
        return mappedHostAndHostGroups;
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String HOST_GROUPS_WITH_PORTS_AND_LUNS = "hostsWithPortsAndLuns";
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String OBJECT_NAME = "name";
        public static final String KEY_NAME = "HostGroupKey";
        public static final String OBJECT_TYPE = "objectType";
    }

    public static interface ModifyProps {
        public static final String NAME = "name";
    }

    public static interface CreateProps {
        public static final String NAME = "name";
    }
}

