/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;

public class ManageInitiators
implements ManageInitiatorsInterface {
    private ArrayList initiators;
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private SearchFilter filter;
    private InstanceWrapper scope;
    private int restriction = -1;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
        this.initiators = new ArrayList();
        Enumeration enumeration = null;
        if (this.scope == null) {
            Trace.verbose((Object)this, "init", "The scope is not set. ");
            enumeration = this.allInitiators();
        } else if (this.scope instanceof T4Interface) {
            Trace.verbose((Object)this, "init", "The scope is: " + this.scope);
            enumeration = this.allInitiatorsPerT4(((T4Interface)this.scope).getClusterName());
        } else {
            Trace.verbose((Object)this, "init", "Wrong scope set: " + this.scope);
            new ConfigMgmtException("error.scope.required", "Wrong scope set: " + this.scope);
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                if (filter != null && !filter.isEmpty() && !filter.passesFilter(ci)) continue;
                Initiator i = new Initiator();
                i.setInstance(ci);
                i.init(context);
                CIMObjectWrapper.populate(i, i.getFieldMap(), ci);
                if (i.getWWN() == null) continue;
                this.initiators.add(i);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "init", "The instance added to the list: " + i);
            }
            Trace.verbose((Object)this, "init", "Sort the initiator list");
            Collections.sort(this.initiators, new InitiatorComparator(context.getLocale()));
        } else {
            Trace.verbose((Object)this, "init", "No instance returned when trying to obtain the list of Initiators");
        }
    }

    private Enumeration allInitiatorsPerT4(String ipAddr) throws ConfigMgmtException {
        Trace.methodBegin(this, "allInitiatorsPerT4");
        try {
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.handle, "Select * from SunStorEdge_6120StorageHardwareID where InstanceID LIKE 'SunStorEdge_6120:" + ipAddr + ":%'");
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allInitiatorsPerT4", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private Enumeration allInitiators() throws ConfigMgmtException {
        Trace.methodBegin(this, "allInitiators");
        try {
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_6120StorageHardwareID"), false, false, true, false, Initiator.PROPERTY_NAMES);
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allInitiators", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return this.initiators;
    }

    public void createInitiator(T4Interface t4, String wwn, String description, List initiatorGroups) throws ConfigMgmtException {
        Trace.methodBegin(this, "createInitiator");
        try {
            InitiatorGroupInterface initiatorGroup = null;
            wwn = wwn.toUpperCase();
            CIMObjectPath managementServicePath = Initiator.getStorageHardwareIDManagementServiceObjectPath(this.handle, t4.getClusterName());
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)description)), new CIMArgument("StorageID", new CIMValue((Object)wwn)), new CIMArgument("IDType", new CIMValue((Object)new UnsignedInt16(2))), new CIMArgument("OtherIDType", null), new CIMArgument("Setting", null)};
            CIMArgument[] outArgs = new CIMArgument[1];
            Trace.verbose((Object)this, "createInitiator", "Input arguments initialized.");
            CIMValue returnValue = this.handle.invokeMethod(managementServicePath, "CreateStorageHardwareID", inArgs, outArgs);
            int result = ((UnsignedInt32)returnValue.getValue()).intValue();
            Trace.verbose((Object)this, "createInitiator", "Return code is: " + result);
            if (result != 0) {
                Trace.verbose((Object)this, "createInitiator", "Return code for CreateStorageHardwareID  is not success, it is " + result);
                throw new ConfigMgmtException("error.initiatorCreateError", "Return code is: " + result);
            }
            Trace.verbose((Object)this, "createInitiator", "Initiator created successfully.");
            CIMObjectPath initiatorPath = (CIMObjectPath)outArgs[0].getValue().getValue();
            Trace.verbose((Object)this, "createInitiator", "Object path of the created initiator is: " + initiatorPath);
            InitiatorInterface initiator = null;
            if (initiatorPath != null) {
                initiator = this.getByKey(initiatorPath.getKeys());
                Trace.verbose((Object)this, "createInitiator", "Got the new initiator.");
            }
            if (initiator == null) {
                Trace.verbose((Object)this, "createInitiator", "We couldn't obtain just created instance from CIMOM.");
                throw new ConfigMgmtException("error.initiatorCreateError", "We couldn't obtain just created instance from CIMOM.");
            }
            if (initiatorGroups != null) {
                for (int i = 0; i < initiatorGroups.size(); ++i) {
                    initiatorGroup = (InitiatorGroupInterface)initiatorGroups.get(i);
                    initiatorGroup.addInitiatorToGroup(initiator);
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, "createInitiator", "Initiator: " + wwn + " added to InitiatorGroup: " + initiatorGroup);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createInitiator", "Failed--" + cme.getMessage());
            cme.setExceptionKey("error.initiatorCreateError");
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "createInitiator", "NullPointerException - Null returned when trying to create Initiator instance.");
            throw new ConfigMgmtException("error.initiatorCreateError", "NullPointerException - Null returned when trying to create Initiator instance.", npe);
        }
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
        this.scope = scope;
    }

    public Comparator getInitiatorComparator(Locale loc) {
        return new InitiatorComparator(loc);
    }

    public void setRestriction(int restriction) {
        Trace.methodBegin(this, "setRestriction");
        this.restriction = restriction;
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        String methodName = "getItemsBySystem()";
        Trace.methodBegin(this, methodName);
        this.init(this.context, null);
        Trace.verbose((Object)this, methodName, "Returning list of size:" + this.getItemList().size());
        return (ArrayList)this.getItemList();
    }

    public ArrayList getItemsByStorageDomain(String name) throws ConfigMgmtException, ItemNotFoundException {
        String methodName = "getItemsByStorageDomain";
        Trace.methodBegin(this, methodName);
        ManageT4sInterface t4Manager = ManageT4sFactory.getManager();
        t4Manager.init(this.context, null);
        Trace.verbose((Object)this, methodName, "Looking for array :" + name);
        T4Interface t4 = t4Manager.getT4ByName(name);
        Trace.verbose((Object)this, methodName, "Setting scope to array name:" + t4.getName());
        this.setScope(t4);
        this.init(this.context, null);
        Trace.verbose((Object)this, methodName, "Returning list of size:" + this.getItemList().size());
        return (ArrayList)this.getItemList();
    }

    public ArrayList getItemsByFCPort(String name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByInitiatorGroup(String name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public InitiatorInterface getItemByName(String name) throws ConfigMgmtException {
        return null;
    }

    public InitiatorInterface getItemByWwn(String wwn) throws ConfigMgmtException {
        return null;
    }

    public InitiatorInterface getByKey(Collection props) throws ConfigMgmtException {
        CIMObjectPath path = new CIMObjectPath("SunStorEdge_6120StorageHardwareID", new Vector(props));
        Initiator ini = new Initiator();
        ini.setObjectPath(path);
        ini.init(this.context);
        ini.reload();
        return ini;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus create(String name, String wwn, String desc, int osType, String storageDomainName) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        String methodName = "create";
        Trace.methodBegin(this, "create");
        ManageT4sInterface t4Manager = ManageT4sFactory.getManager();
        t4Manager.init(this.context, null);
        T4Interface t4 = t4Manager.getT4ByName(storageDomainName);
        this.createInitiator(t4, wwn, desc, null);
        return null;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        InitiatorInterface ii = this.getByKey(key);
        Trace.verbose((Object)this, "delete", "Delete initiator:" + ii.getWWN());
        ii.delete();
        return null;
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
    }

    public void validateDescription(String description) throws BadParameterException {
    }

    public class InitiatorComparator
    implements Comparator {
        Collator collator = null;

        InitiatorComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof Initiator && element2 instanceof Initiator) {
                key1 = this.collator.getCollationKey(((Initiator)element1).getWWN());
                key2 = this.collator.getCollationKey(((Initiator)element2).getWWN());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

