/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.InitiatorGroup;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ManageInitiatorGroups
implements ManageInitiatorGroupsInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private SearchFilter filter;
    private InstanceWrapper scope;
    private ArrayList initiatorGroups;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
        this.initiatorGroups = new ArrayList();
        Enumeration enumeration = null;
        if (this.scope == null) {
            Trace.verbose((Object)this, "init", "The scope is not set. ");
            enumeration = this.allInitiatorGroups();
        } else if (this.scope instanceof T4Interface) {
            Trace.verbose((Object)this, "init", "The scope is: " + this.scope);
            enumeration = this.allInitiatorGroupsPerT4(((T4Interface)this.scope).getClusterName());
        } else {
            Trace.verbose((Object)this, "init", "Wrong scope set: " + this.scope);
            new ConfigMgmtException("error.scope.required", "Wrong scope set: " + this.scope);
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                if (filter != null && !filter.isEmpty() && !filter.passesFilter(ci)) continue;
                InitiatorGroup ig = new InitiatorGroup();
                ig.init(context);
                ig.setInstance(ci);
                CIMObjectWrapper.populate(ig, ig.getFieldMap(), ci);
                this.initiatorGroups.add(ig);
                Trace.verbose((Object)this, "init", "The InitiatorGroup added to the list: " + ig);
            }
            Trace.verbose((Object)this, "init", "Sort the initiator group list");
            Collections.sort(this.initiatorGroups, new IGComparator(context.getLocale()));
        } else {
            Trace.verbose((Object)this, "init", "No instance returned when trying to obtain the list of InitiatorGroups");
        }
    }

    private Enumeration allInitiatorGroupsPerT4(String ipAddr) throws ConfigMgmtException {
        Trace.methodBegin(this, "allInitiatorGroupsPerT4");
        try {
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.handle, "Select * from SunStorEdge_6120SystemSpecificCollection where SystemName = '" + ipAddr + "'");
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allInitiatorGroupsPerT4", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private Enumeration allInitiatorGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "allInitiatorGroups");
        try {
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_6120SystemSpecificCollection"), false, false, true, false, InitiatorGroup.PROPERTY_NAMES);
            Trace.verbose((Object)this, "allInitiatorGroupsPerT4", "Came back from enumerating InitiatorGroups.");
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allInitiatorGroups", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return this.initiatorGroups;
    }

    public void createInitiatorGroup(String name, T4Interface t4, List initiators) throws ConfigMgmtException {
        Trace.methodBegin(this, "createInitiatorGroup");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("InstanceID", InitiatorGroup.createInitiatorGroupInstanceID(t4.getName(), name));
        map.put("ElementName", name);
        Vector keys = CIMObjectWrapper.instanceKeyBuilder(map);
        CIMObjectPath igPath = CIMObjectWrapper.createInstance(this.handle, keys, "SunStorEdge_6120SystemSpecificCollection");
        Trace.verbose((Object)this, "createInitiatorGroup", "The CIMObjectPath of created InitiatorGroup: " + igPath);
        map = new HashMap();
        map.put("Antecedent", (String)t4.getInstance().getObjectPath());
        map.put("Dependent", (String)igPath);
        keys = CIMObjectWrapper.instanceKeyBuilder(map);
        CIMObjectPath hcPath = CIMObjectWrapper.createInstance(this.handle, keys, "SunStorEdge_6120HostedCollection");
        Trace.verbose((Object)this, "createInitiatorGroup", "The CIMObjectPath of created HostedCollection: " + hcPath);
        try {
            CIMInstance igInstance = this.handle.getInstance(igPath, false, true, false, InitiatorGroup.PROPERTY_NAMES);
            Trace.verbose((Object)this, "createInitiatorGroup", "Got back from CIMOM with instance: " + igInstance.getObjectPath());
            InitiatorGroup ig = new InitiatorGroup();
            ig.init(this.context);
            ig.setInstance(igInstance);
            CIMObjectWrapper.populate(ig, ig.getFieldMap(), igInstance);
            Trace.verbose((Object)this, "createInitiatorGroup", "InitiatorGroup created: " + ig);
            if (initiators != null) {
                for (int i = 0; i < initiators.size(); ++i) {
                    InitiatorInterface initiator = (InitiatorInterface)initiators.get(i);
                    ig.addInitiatorToGroup(initiator);
                    Trace.verbose((Object)this, "createInitiatorGroup", "Initiator added: " + initiator);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createInitiatorGroup", "Failed: " + cme.getMessage());
            cme.setExceptionKey("INITIATOR_GRP_CREATE_ERROR");
            throw cme;
        }
    }

    public void importInitiatorGroups(List importToT4s, T4Interface importFromT4, List initatorGroups) throws ConfigMgmtException {
        Trace.methodBegin(this, "importInitiatorGroups");
        T4Interface t4 = null;
        ArrayList initiators = null;
        ArrayList<InitiatorGroupInterface> newGroups = null;
        InitiatorGroupInterface group = null;
        InitiatorGroupInterface newGroup = null;
        InitiatorInterface initiator = null;
        InitiatorInterface newInitiator = null;
        SearchFilter sf = null;
        String[] logArgs = new String[2];
        ManageInitiatorsInterface mi = ManageInitiatorsFactory.getManager();
        ManageInitiatorGroupsInterface migs = ManageInitiatorGroupsFactory.getManager();
        try {
            for (int i = 0; i < importToT4s.size(); ++i) {
                t4 = (T4Interface)importToT4s.get(i);
                Trace.verbose((Object)this, "importInitiatorGroups", "The T4 we are in: " + t4.getName());
                for (int j = 0; j < initatorGroups.size(); ++j) {
                    group = (InitiatorGroupInterface)initatorGroups.get(j);
                    Trace.verbose((Object)this, "importInitiatorGroups", "The InitiatorGroup we are importing: " + group.getName());
                    this.createInitiatorGroup(group.getName(), t4, null);
                    Trace.verbose((Object)this, "importInitiatorGroups", "InitiatorGroup " + group.getName() + " successfully created.");
                    sf = new SearchFilter("ElementName", group.getName());
                    migs.setScope(t4);
                    migs.init(this.context, sf);
                    if (migs.getItemList().size() == 1) {
                        newGroup = (InitiatorGroupInterface)migs.getItemList().get(0);
                        newGroups = new ArrayList<InitiatorGroupInterface>();
                        newGroups.add(newGroup);
                        initiators = group.getInitiators();
                        for (int k = 0; k < initiators.size(); ++k) {
                            initiator = (InitiatorInterface)initiators.get(k);
                            Trace.verbose((Object)this, "importInitiatorGroups", "The Initiator we are about to add: " + initiator.getWWN());
                            sf = new SearchFilter("StorageID", initiator.getWWN());
                            mi.setScope(t4);
                            mi.init(this.context, sf);
                            if (mi.getItemList().size() == 1) {
                                newInitiator = (InitiatorInterface)mi.getItemList().get(0);
                                newGroup.addInitiatorToGroup(newInitiator);
                                continue;
                            }
                            mi.createInitiator(t4, initiator.getWWN(), initiator.getDescription(), newGroups);
                            Trace.verbose((Object)this, "importInitiatorGroups", "Initiator created: " + initiator.getWWN());
                        }
                        continue;
                    }
                    logArgs[0] = group.getName();
                    logArgs[1] = t4.getName();
                    Trace.verbose((Object)this, "importInitiatorGroups", "Created InitiatorGroup could not be obtained from CIMOM.");
                    throw new ConfigMgmtException("INITIATOR_GRP_IMPORT_ERROR", logArgs, "Created InitiatorGroup could not be obtained from CIMOM.", null);
                }
            }
            Trace.verbose((Object)this, "importInitiatorGroups", "InitiatorGroups successfully imported!");
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, "importInitiatorGroups", (Throwable)cme);
            if ("INITIATOR_GRP_IMPORT_ERROR".equals(cme.getExceptionKey())) {
                throw cme;
            }
            logArgs[0] = group.getName();
            logArgs[1] = t4.getName();
            throw new ConfigMgmtException("INITIATOR_GRP_IMPORT_ERROR", logArgs, "Rethrown ConfigMgmtException in importInitiatorGroups.", cme);
        }
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
        this.scope = scope;
    }

    public void delete(Collection key) throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        InitiatorGroupInterface igi = this.getByKey(key);
        Trace.verbose((Object)this, "delete", "About to delete ig: " + igi.getName());
        igi.delete();
    }

    public InitiatorGroupInterface getByKey(Collection key) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        CIMObjectPath path = new CIMObjectPath("SunStorEdge_6120SystemSpecificCollection", new Vector(key));
        InitiatorGroup ig = new InitiatorGroup();
        ig.setInitiatorGroupPath(path);
        ig.init(this.context);
        ig.reload();
        return ig;
    }

    private class IGComparator
    implements Comparator {
        Collator collator = null;

        IGComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof InitiatorGroup && element2 instanceof InitiatorGroup) {
                key1 = this.collator.getCollationKey(((InitiatorGroup)element1).getName());
                key2 = this.collator.getCollationKey(((InitiatorGroup)element2).getName());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

