/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Binding;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.InitiatorGroup;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageVolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.VolumeGroup;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public class ManageBindings
implements ManageBindingsInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private SearchFilter filter;
    private InstanceWrapper scope;
    private ArrayList bindings;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings;

    /*
     * Enabled aggressive block sorting
     */
    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
        this.bindings = new ArrayList();
        if (this.scope == null) {
            Trace.verbose((Object)this, "init", "The scope is not set. ");
            throw new ConfigMgmtException("error.scope.required", "Scope is null in ManageBindings.");
        }
        if (this.scope instanceof VolumeGroupInterface) {
            Trace.verbose((Object)this, "init", "The scope is VolumeGroup: " + this.scope);
            this.setAllBindingsPerVolumeGroup();
            return;
        }
        if (this.scope instanceof InitiatorGroupInterface) {
            Trace.verbose((Object)this, "init", "The scope is InitiatorGroup: " + this.scope);
            this.setAllBindingsPerInitiatorGroup();
            return;
        }
        Trace.verbose((Object)this, "init", "The scope set is not instance of VolumeGroup or InitiatorGroup.");
        throw new ConfigMgmtException("error.scope.required", "The scope set is not instance of VolumeGroup or InitiatorGroup.");
    }

    private void setAllBindingsPerVolumeGroup() throws ConfigMgmtException {
        Trace.methodBegin(this, "setAllBindingsPerVolumeGroup");
        try {
            Enumeration enumACI = this.handle.associators(this.scope.getInstance().getObjectPath(), "SunStorEdge_6120AuthorizationTarget", "SunStorEdge_6120AccessControlInformation", "Dependent", "Antecedent", true, false, Binding.PROPERTY_NAMES);
            Trace.verbose((Object)this, "setAllBindingsPerVolumeGroup", "Came back from ACI instance enumeration.");
            if (enumACI != null) {
                while (enumACI.hasMoreElements()) {
                    CIMInstance aciInstance = (CIMInstance)enumACI.nextElement();
                    Binding binding = new Binding();
                    binding.init(this.context);
                    binding.setVolumeGroup((VolumeGroupInterface)this.scope);
                    binding.setAciInstance(aciInstance);
                    CIMObjectWrapper.populate(binding, binding.getFieldMap(), aciInstance);
                    Trace.verbose((Object)this, "setAllBindingsPerVolumeGroup", "Access value looked up is: " + binding.getAccess());
                    Enumeration enumeration = this.handle.associators(aciInstance.getObjectPath(), "SunStorEdge_6120AuthorizationSubject", "SunStorEdge_6120SystemSpecificCollection", "Antecedent", "Dependent", true, false, InitiatorGroup.PROPERTY_NAMES);
                    Trace.verbose((Object)this, "setAllBindingsPerVolumeGroup", "We are back from enumerating SystemSpecificCollections.");
                    if (enumeration == null) continue;
                    while (enumeration.hasMoreElements()) {
                        CIMInstance igInstance = (CIMInstance)enumeration.nextElement();
                        InitiatorGroup initiatorGroup = new InitiatorGroup();
                        initiatorGroup.init(this.context);
                        initiatorGroup.setInstance(igInstance);
                        CIMObjectWrapper.populate(initiatorGroup, initiatorGroup.getFieldMap(), igInstance);
                        binding.setInitiatorGroup(initiatorGroup);
                        this.bindings.add(binding);
                    }
                    Trace.verbose((Object)this, "setAllBindingsPerVolumeGroup", "Sort the bindings list");
                    Collections.sort(this.bindings, new BindingComparator(this.scope, this.context.getLocale()));
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "setAllBindingsPerVolumeGroup", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void setAllBindingsPerInitiatorGroup() throws ConfigMgmtException {
        Trace.methodBegin(this, "setAllBindingsPerInitiatorGroup");
        try {
            Enumeration enumACI = this.handle.associators(this.scope.getInstance().getObjectPath(), "SunStorEdge_6120AuthorizationSubject", "SunStorEdge_6120AccessControlInformation", "Dependent", "Antecedent", true, false, Binding.PROPERTY_NAMES);
            Trace.verbose((Object)this, "setAllBindingsPerInitiatorGroup", "Came back from ACI instance enumeration.");
            if (enumACI != null) {
                while (enumACI.hasMoreElements()) {
                    CIMInstance aciInstance = (CIMInstance)enumACI.nextElement();
                    Enumeration enumeration = this.handle.associators(aciInstance.getObjectPath(), "SunStorEdge_6120AuthorizationTarget", "SunStorEdge_6120AuthorizationViewSCSIController", "Antecedent", "Dependent", true, false, VolumeGroup.PROPERTY_NAMES);
                    Trace.verbose((Object)this, "setAllBindingsPerInitiatorGroup", "We are back from enumerating AuthorizationViewSCSIController(s).");
                    if (enumeration == null) continue;
                    while (enumeration.hasMoreElements()) {
                        CIMInstance vgInstance = (CIMInstance)enumeration.nextElement();
                        if (!ManageVolumeGroups.isVolumeGroup(vgInstance)) continue;
                        Binding binding = new Binding();
                        binding.init(this.context);
                        binding.setInitiatorGroup((InitiatorGroupInterface)this.scope);
                        binding.setAciInstance(aciInstance);
                        CIMObjectWrapper.populate(binding, binding.getFieldMap(), aciInstance);
                        Trace.verbose((Object)this, "setAllBindingsPerInitiatorGroup", "Access value looked up is: " + binding.getAccess());
                        VolumeGroup volumeGroup = new VolumeGroup();
                        volumeGroup.init(this.context);
                        volumeGroup.setInstance(vgInstance);
                        CIMObjectWrapper.populate(volumeGroup, volumeGroup.getFieldMap(), vgInstance);
                        binding.setVolumeGroup(volumeGroup);
                        this.bindings.add(binding);
                    }
                    Trace.verbose((Object)this, "setAllBindingsPerInitiatorGroup", "Sort the bindings list");
                    Collections.sort(this.bindings, new BindingComparator(this.scope, this.context.getLocale()));
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "setAllBindingsPerInitiatorGroup", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return this.bindings;
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
        this.scope = scope;
    }

    public void addBinding(T4Interface t4, VolumeGroupInterface volumeGroup, InitiatorGroupInterface initiatorGroup, String access) throws ConfigMgmtException {
        Trace.methodBegin(this, "addBinding");
        try {
            Vector<String> aciAccess = new Vector<String>();
            aciAccess.add(access);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Name", new Date().getTime() + "");
            map.put("AccessType", aciAccess);
            map.put("SystemName", IPUtil.lookUpIP(t4.getName()));
            CIMObjectPath aciPath = CIMObjectWrapper.createInstance(this.handle, CIMObjectWrapper.instanceKeyBuilder(map), "SunStorEdge_6120AccessControlInformation");
            Vector<String> targets = new Vector<String>();
            targets.add(volumeGroup.getInstance().getObjectPath().toString());
            Trace.verbose((Object)this, "addBinding", "Adding binding with: volume group = " + targets.get(0) + "initiator group = " + initiatorGroup.getInstance().getObjectPath() + "ACI = " + aciPath);
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Subject", new CIMValue((Object)initiatorGroup.getInstance().getObjectPath())), new CIMArgument("AccessRights", new CIMValue((Object)aciPath)), new CIMArgument("Target", new CIMValue(targets))};
            CIMObjectPath authorizationServicePath = ManageBindings.getAuthorizationServiceObjectPath(this.handle, t4.getInstance().getObjectPath());
            CIMValue returnValue = this.handle.invokeMethod(authorizationServicePath, "AssignAccess", inArgs, null);
            int result = ((UnsignedInt32)returnValue.getValue()).intValue();
            Trace.verbose((Object)this, "addBinding", "Result is: " + result);
            if (result != 0) {
                String message = "Return code for AssignAccess from InitiatorGroup: " + initiatorGroup + "to VolumeGroup: " + volumeGroup + " is not success, it is " + result;
                Trace.verbose((Object)this, "addBinding", message);
                if (result == 32768) {
                    throw new ConfigMgmtException("ACCESS_ALREADY_ASSIGNED", message);
                }
                throw new ConfigMgmtException("EXTRINSIC_CIM_METHOD_EXCEPTION", message);
            }
            Trace.verbose((Object)this, "addBinding", "Binding added successfully.");
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "addBinding", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    protected static CIMObjectPath getAuthorizationServiceObjectPath(CIMOMHandleWrapper handle, CIMObjectPath t4Path) throws ConfigMgmtException {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings = ManageBindings.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageBindings")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings, "getAuthorizationServiceObjectPath");
        try {
            Enumeration enumeration = handle.associatorNames(t4Path, "SunStorEdge_6120HostedAuthorizationService", "SunStorEdge_6120AuthorizationService", "Antecedent", "Dependent");
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMObjectPath asPath = (CIMObjectPath)enumeration.nextElement();
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings = ManageBindings.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageBindings")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings, "getAuthorizationServiceObjectPath", "The AuthorizationService object path is: " + asPath);
                return asPath;
            }
            String message = "No instances returned when trying to obtain AuthorizationService object path for t4: " + t4Path;
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings = ManageBindings.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageBindings")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings, "getAuthorizationServiceObjectPath", message);
            throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", message);
        }
        catch (ConfigMgmtException cme) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings = ManageBindings.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageBindings")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageBindings, "getAuthorizationServiceObjectPath", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    protected void removeAllBindings(ConfigContext context, InstanceWrapper scope) throws ConfigMgmtException {
        Trace.methodBegin(this, "removeAllBindings");
        this.setScope(scope);
        this.init(context, null);
        ArrayList allBindings = (ArrayList)this.getItemList();
        for (int i = 0; i < allBindings.size(); ++i) {
            Binding binding = (Binding)allBindings.get(i);
            Trace.verbose((Object)this, "removeAllBindings", "The Binding to be deleted is: " + binding);
            binding.delete();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BindingComparator
    implements Comparator {
        Collator collator = null;
        InstanceWrapper scope;

        BindingComparator(InstanceWrapper iw, Locale loc) {
            this.scope = iw;
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof Binding && element2 instanceof Binding) {
                if (this.scope instanceof VolumeGroupInterface) {
                    key1 = this.collator.getCollationKey(((Binding)element1).getInitiatorGroup().getName());
                    key2 = this.collator.getCollationKey(((Binding)element2).getInitiatorGroup().getName());
                } else {
                    key1 = this.collator.getCollationKey(((Binding)element1).getVolumeGroup().getName());
                    key2 = this.collator.getCollationKey(((Binding)element2).getVolumeGroup().getName());
                }
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

