/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.InitiatorGroup;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageVolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.VolumeGroup;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public class Initiator
implements InitiatorInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private String WWN;
    private String description;
    private String instanceId;
    private ArrayList initiatorGroups;
    private ArrayList volumeGroups;
    private CIMInstance instance;
    private CIMObjectPath initiatorPath;
    private ArrayList fieldMap;
    private String t4Name;
    private String t4IpAddress;
    public static final String[] PROPERTY_NAMES = new String[]{"StorageID", "ElementName", "InstanceID"};
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator;

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.handle = context.getClient();
        this.initiatorGroups = new ArrayList();
        this.volumeGroups = new ArrayList();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper value is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper value is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
    }

    public void delete() throws ConfigMgmtException {
        block5: {
            Trace.methodBegin(this, "delete");
            if (this.instance != null) {
                try {
                    this.removeFromAllGroups();
                    CIMObjectPath amsPath = Initiator.getStorageHardwareIDManagementServiceObjectPath(this.handle, this.t4IpAddress);
                    CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("HardwareID", new CIMValue((Object)this.instance.getObjectPath()))};
                    CIMValue returnValue = this.handle.invokeMethod(amsPath, "deleteStorageHardwareID", inArgs, null);
                    int result = ((UnsignedInt32)returnValue.getValue()).intValue();
                    if (result != 0) {
                        Trace.verbose((Object)this, "delete", "Deleting of the Initiator: " + this.toString() + " failed with return code = " + result);
                        throw new ConfigMgmtException("EXTRINSIC_CIM_METHOD_EXCEPTION", "Deleting of the Initiator: " + this.toString() + " failed with return code = " + result);
                    }
                    break block5;
                }
                catch (NullPointerException npe) {
                    Trace.verbose((Object)this, "delete", (Throwable)npe);
                    throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - When trying to delete the Initiator: " + this.toString(), npe);
                }
                catch (ConfigMgmtException cme) {
                    cme.addExceptionContext(this);
                    Trace.error((Object)this, "delete", "Failed--current state: " + this.toString());
                    throw cme;
                }
            }
            Trace.verbose((Object)this, "delete", "CIMInstance instance member variable not initialized.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.initiatorPath, false, true, false, PROPERTY_NAMES);
        Trace.verbose((Object)this, "reload", "Object path of the fresh CIMInstance: " + ci.getObjectPath());
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.initiatorGroups = new ArrayList();
        this.volumeGroups = new ArrayList();
        this.t4Name = null;
        Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
    }

    public String getWWN() {
        return this.WWN;
    }

    public String getDescription() {
        return this.description;
    }

    public List getInitiatorGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "getInitiatorGroups");
        if (this.instance != null) {
            this.initiatorGroups = new ArrayList();
            try {
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_6120MemberOfCollection", "SunStorEdge_6120SystemSpecificCollection", "Member", "Collection", false, false, InitiatorGroup.PROPERTY_NAMES);
                Trace.verbose((Object)this, "getInitiatorGroups", "Returned from enumerating SystemSpecificCollections.");
                if (enumeration != null && enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        CIMInstance ci = (CIMInstance)enumeration.nextElement();
                        InitiatorGroup ig = new InitiatorGroup();
                        ig.init(this.context);
                        ig.setInstance(ci);
                        CIMObjectWrapper.populate(ig, ig.getFieldMap(), ci);
                        this.initiatorGroups.add(ig);
                        Trace.verbose((Object)this, "getInitiatorGroups", "InitiatorGroup added: " + ig.toString());
                    }
                }
                return this.initiatorGroups;
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "getInitiatorGroups", "Failed--current state: " + this.toString());
                throw cme;
            }
        }
        Trace.verbose((Object)this, "getInitiatorGroups", "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    public List getVolumeGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumeGroups");
        if (this.instance != null) {
            this.volumeGroups = new ArrayList();
            HashSet<String> allACISet = new HashSet<String>();
            CIMInstance controllerInstance = null;
            Enumeration allACIs = null;
            try {
                Enumeration allSSCs = this.handle.associatorNames(this.instance.getObjectPath(), "SunStorEdge_6120MemberOfCollection", "SunStorEdge_6120SystemSpecificCollection", "Member", "Collection");
                if (allSSCs != null) {
                    Trace.verbose((Object)this, "getVolumeGroups", "We are looping through SystemSpecificCollection instances.");
                    HashSet<String> vgNames = new HashSet<String>();
                    while (allSSCs.hasMoreElements()) {
                        CIMObjectPath cop = (CIMObjectPath)allSSCs.nextElement();
                        allACIs = this.handle.associatorNames(cop, "SunStorEdge_6120AuthorizationSubject", "SunStorEdge_6120AccessControlInformation", "Dependent", "Antecedent");
                        if (allACIs == null) continue;
                        Trace.verbose((Object)this, "getVolumeGroups", "We are looping through AccessControlInfo instances.");
                        while (allACIs.hasMoreElements()) {
                            CIMObjectPath aciPath = (CIMObjectPath)allACIs.nextElement();
                            if (allACISet.contains(aciPath.toString())) continue;
                            allACISet.add(aciPath.toString());
                            controllerInstance = this.lookupControllerFromACI(aciPath);
                            if (!ManageVolumeGroups.isVolumeGroup(controllerInstance)) continue;
                            VolumeGroup vg = new VolumeGroup();
                            vg.init(this.context);
                            vg.setInstance(controllerInstance);
                            CIMObjectWrapper.populate(vg, vg.getFieldMap(), controllerInstance);
                            if (vgNames.contains(vg.getName())) continue;
                            this.volumeGroups.add(vg);
                            vgNames.add(vg.getName());
                        }
                    }
                }
                return this.volumeGroups;
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "getVolumeGroups", "Failed--current state: " + this.toString());
                throw cme;
            }
        }
        Trace.verbose((Object)this, "getVolumeGroups", "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    private CIMInstance lookupControllerFromACI(CIMObjectPath aciPath) throws ConfigMgmtException {
        Trace.methodBegin(this, "lookupControllerFromACI");
        try {
            Enumeration enumeration = this.handle.associators(aciPath, "SunStorEdge_6120AuthorizationTarget", "SunStorEdge_6120AuthorizationViewSCSIController", "Antecedent", "Dependent", true, false, VolumeGroup.PROPERTY_NAMES);
            Trace.verbose((Object)this, "lookupControllerFromACI", "Came back from enumerating controllers.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                return (CIMInstance)enumeration.nextElement();
            }
            Trace.verbose((Object)this, "lookupControllerFromACI", "Association missing for ACI: " + aciPath);
            throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "Association missing for ACI: " + aciPath);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "lookupControllerFromACI", "Failed delete--current state: " + this.toString());
            throw cme;
        }
    }

    public CIMInstance getInstance() {
        return this.instance;
    }

    public String getT4Name() {
        Trace.methodBegin(this, "getT4Name");
        if (this.t4Name == null) {
            this.t4Name = IPUtil.lookUpHostName(this.t4IpAddress);
        }
        return this.t4Name;
    }

    public void setWWN(String WWN) {
        this.WWN = WWN;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        StringTokenizer st = new StringTokenizer(instanceId, ":");
        if (st.hasMoreElements()) {
            st.nextElement();
            if (st.hasMoreElements()) {
                this.t4IpAddress = (String)st.nextElement();
            }
        }
    }

    public void setInstance(CIMInstance instance) {
        this.instance = instance;
        if (this.initiatorPath == null) {
            this.initiatorPath = instance.getObjectPath();
        }
    }

    private CIMObjectPath getT4ObjectPath() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4ObjectPath");
        try {
            Enumeration enumeration = this.handle.associatorNames(this.instance.getObjectPath(), "SunStorEdge_6120IDConcreteComponent", "SunStorEdge_6120Cluster", "PartComponent", "GroupComponent");
            Trace.verbose((Object)this, "getT4ObjectPath", "Came back from enumerating Cluster.");
            if (enumeration == null) {
                Trace.verbose((Object)this, "getT4ObjectPath", "Null returned when trying to get Cluster CIMObjectPath.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null returned when trying to get Cluster CIMObjectPath.");
            }
            if (!enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getT4ObjectPath", "No instance returned when trying to get Cluster CIMObjectPath.");
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "No instance returned when trying to get Cluster CIMObjectPath.");
            }
            CIMObjectPath t4Path = (CIMObjectPath)enumeration.nextElement();
            if (t4Path != null) {
                Trace.verbose((Object)this, "getT4ObjectPath", "The CIMObjectPath we got is: " + t4Path);
                return t4Path;
            }
            Trace.verbose((Object)this, "getT4ObjectPath", "The T4 instance returned is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "The T4 instance returned is null.");
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "getT4ObjectPath", "Failed--current state: " + this.toString());
            throw cme;
        }
    }

    public static CIMObjectPath getStorageHardwareIDManagementServiceObjectPath(CIMOMHandleWrapper handle, String t4IpAddr) throws ConfigMgmtException {
        try {
            Enumeration enumeration = CIMObjectWrapper.execQuery(handle, "Select * from SunStorEdge_6120StorageHardwareIDManagementService where SystemName = '" + t4IpAddr + "'");
            if (enumeration == null || !enumeration.hasMoreElements()) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator = Initiator.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator, "getStorageHardwareIDManagementServiceObjectPath", "No instance returned when trying to get StorageHardwareIDManagementService CIMObjectPath.");
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "No instance returned when trying to get StorageHardwareIDManagementService CIMObjectPath.");
            }
            return ((CIMInstance)enumeration.nextElement()).getObjectPath();
        }
        catch (ConfigMgmtException cme) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator = Initiator.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator, "getStorageHardwareIDManagementServiceObjectPath", "Failed--: " + cme.getMessage());
            throw cme;
        }
    }

    public static CIMObjectPath getStorageHardwareIDManagementServiceObjectPath(CIMOMHandleWrapper handle, CIMObjectPath t4ObjectPath) throws ConfigMgmtException {
        try {
            Enumeration enumeration = handle.associatorNames(t4ObjectPath, "SunStorEdge_6120HostedIDService", "SunStorEdge_6120StorageHardwareIDManagementService", "Antecedent", "Dependent");
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator = Initiator.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator, "getStorageHardwareIDManagementServiceObjectPath", "Came back from enumerating StorageHardwareIDManagementService.");
            if (enumeration == null) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator = Initiator.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator, "getStorageHardwareIDManagementServiceObjectPath", "Null returned when trying to get StorageHardwareIDManagementService CIMObjectPath.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null returned when trying to get StorageHardwareIDManagementService CIMObjectPath.");
            }
            if (!enumeration.hasMoreElements()) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator = Initiator.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator, "getStorageHardwareIDManagementServiceObjectPath", "No instance returned when trying to get StorageHardwareIDManagementService CIMObjectPath.");
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "No instance returned when trying to get StorageHardwareIDManagementService CIMObjectPath.");
            }
            CIMObjectPath amsPath = (CIMObjectPath)enumeration.nextElement();
            if (amsPath != null) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator = Initiator.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator, "getStorageHardwareIDManagementServiceObjectPath", "The CIMObjectPath we got is: " + amsPath);
                return amsPath;
            }
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator = Initiator.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator, "getStorageHardwareIDManagementServiceObjectPath", "The AccountManagementService CIMObjectPath returned is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "The StorageHardwareIDManagementService CIMObjectPath returned is null.");
        }
        catch (ConfigMgmtException cme) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator = Initiator.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$Initiator, "getStorageHardwareIDManagementServiceObjectPath", "Failed--current state: " + cme.getMessage());
            throw cme;
        }
    }

    private void removeFromAllGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "removeFromAllGroups");
        try {
            Enumeration enumeration = this.handle.referenceNames(this.instance.getObjectPath(), "SunStorEdge_6120MemberOfCollection", "Member");
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    CIMObjectPath associationPath = (CIMObjectPath)enumeration.nextElement();
                    this.handle.deleteInstance(associationPath);
                    Trace.verbose((Object)this, "removeFromAllGroups", "Association removed: " + associationPath);
                }
                Trace.verbose((Object)this, "removeFromAllGroups", "Initiator succesfully removed from all InitiatorGroups.");
            } else {
                Trace.verbose((Object)this, "removeFromAllGroups", "Initiator didn't belong to any InitiatorGroup.");
            }
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "removeFromAllGroups", "Failed delete--current state: " + this.toString());
            throw cme;
        }
    }

    public boolean isAlreadyMember() throws ConfigMgmtException {
        String methodName = "isAlreadyMember";
        boolean result = false;
        Trace.methodBegin(this, methodName);
        if (this.instance != null) {
            try {
                Enumeration mocEnum = this.handle.references(this.instance.getObjectPath(), "SunStorEdge_6120MemberOfCollection", "Member", false, false, null);
                if (mocEnum != null && mocEnum.hasMoreElements()) {
                    result = true;
                }
                return result;
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, methodName, "Failed--current state: " + this.toString());
                throw cme;
            }
        }
        Trace.verbose((Object)this, methodName, "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    protected Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("WWN", "StorageID", true, true));
            this.fieldMap.add(new MapElement("description", "ElementName", false, true));
            this.fieldMap.add(new MapElement("instanceId", "InstanceID", true, false));
        }
        return this.fieldMap;
    }

    public String toString() {
        StringBuffer thisObject = new StringBuffer("Initiator with:");
        thisObject.append("\n CIMObjectPath: " + this.instance.getObjectPath());
        thisObject.append("\n wwn: " + this.WWN);
        thisObject.append("\n description: " + this.description);
        thisObject.append("\n number of initiatorGroups: " + this.initiatorGroups.size());
        thisObject.append("\n number of volumeGroups: " + this.volumeGroups.size());
        return thisObject.toString();
    }

    public String getName() {
        return this.getWWN();
    }

    public String getStorageDomain() {
        return this.getT4Name();
    }

    public int getState() {
        return -1;
    }

    public int getStatus() {
        return -1;
    }

    public String getGroupName() {
        return null;
    }

    public int getOSType() {
        return 2;
    }

    public ArrayList getVolumeMappings() throws ConfigMgmtException {
        return new ArrayList();
    }

    public InitiatorVolumeMappingInterface getVolumeMapping(String volName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public Collection getKey() {
        return this.initiatorPath.getKeys();
    }

    public void setName(String name) throws ConfigMgmtException, BadParameterException {
    }

    public void setGroupName(String groupName) {
    }

    public void setOSType(int osType) throws BadParameterException {
    }

    public MethodCallStatus createMapping(InitiatorVolumeMappingInterface mapping) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus createMapping(int lun, Set permissions, StorageVolumeInterface volume) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus createMapping(Set permissions, StorageVolumeInterface volume) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus removeMapping(StorageVolumeInterface volume) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public int getNextAvailableLUN() throws ConfigMgmtException {
        return -1;
    }

    public ArrayList getAllLUNs() throws ConfigMgmtException {
        return null;
    }

    public void setObjectPath(CIMObjectPath path) {
        this.initiatorPath = path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

