/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.logger;

import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPTransport;
import com.sun.netstorage.array.mgmt.logger.LocalizedFile;
import com.sun.netstorage.array.mgmt.logger.LogConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

public class LoggerTemplate
implements LogConfiguration {
    public static final String ALL_SUBSCRIBERS = "all";
    private Properties configuration;
    private File templateFile;
    private File subscriptionsFile;
    private String templatePrefix;
    private String templateSuffix;
    private String ipAddress;
    private File templateDirectory;
    private File logFile;
    private File logDirectory;
    private String logPrefix;
    private String logSuffix;
    private long maxLogSize;
    private int maxLogFiles;
    private boolean sendEmail = false;
    private String mailFrom;
    private String replyTo;
    private URLName mailServer;
    private static Logger logger = Logger.getLogger((String)(class$com$sun$netstorage$array$mgmt$logger$LoggerTemplate == null ? (class$com$sun$netstorage$array$mgmt$logger$LoggerTemplate = LoggerTemplate.class$("com.sun.netstorage.array.mgmt.logger.LoggerTemplate")) : class$com$sun$netstorage$array$mgmt$logger$LoggerTemplate).getName());
    private Hashtable messages;
    private Hashtable subscriptions;
    private LocalizedFile localizedFile;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$logger$LoggerTemplate;

    public LoggerTemplate(File templateDirectory, String templatePrefix, String templateSuffix, Locale locale, Properties configuration) {
        try {
            this.configuration = configuration;
            this.init(templateDirectory, templatePrefix, templateSuffix, locale);
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
        }
    }

    public synchronized ArrayList getSubscribers(String key) {
        ArrayList result = new ArrayList();
        LoggerTemplate.logEntry("getSubscribers");
        logger.debug((Object)("Trying to get subscribers for key = " + key));
        ArrayList subs = (ArrayList)this.subscriptions.get(key);
        if (subs != null) {
            result = (ArrayList)subs.clone();
        }
        return result;
    }

    public synchronized void setSubscribers(String key, ArrayList subscribers) {
        LoggerTemplate.logEntry("setSubscribers");
        logger.debug((Object)("Trying to set subscribers for key = " + key));
        this.subscriptions.put(key, subscribers);
        this.updateFile();
    }

    public LoggerMessage getMessageByFriendlyName(String friendlyName) {
        return (LoggerMessage)this.messages.get(friendlyName);
    }

    public LoggerMessage getMessageById(String id) {
        Iterator i = this.messages.values().iterator();
        while (i.hasNext()) {
            LoggerMessage message = (LoggerMessage)i.next();
            if (!message.id.equals(id)) continue;
            return message;
        }
        return null;
    }

    public String getMessageText(String friendlyName) {
        LoggerMessage message = (LoggerMessage)this.messages.get(friendlyName);
        if (null == message) {
            return null;
        }
        return message.getText();
    }

    public String getLogFilePrefix() {
        return this.logPrefix;
    }

    public String getLogFileSuffix() {
        return this.logSuffix;
    }

    public int getMaxLogFiles() {
        return this.maxLogFiles;
    }

    public boolean getSendEmail() {
        return this.sendEmail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void log(LoggerMessage message, Object[] args, Address[] addresses) {
        try {
            String s;
            block24: {
                LoggerTemplate.logEntry("log");
                Object[] delimited = new String[args.length];
                if (null == this.localizedFile) {
                    throw new Exception("localizedFile is null");
                }
                Locale locale = this.localizedFile.getLocale();
                if (null == locale) {
                    throw new Exception("locale is null");
                }
                MessageFormat argFormat = new MessageFormat("{0}", locale);
                for (int i = 0; i < args.length; ++i) {
                    delimited[i] = "{" + String.valueOf(i) + ":" + argFormat.format(new Object[]{args[i]}) + "}";
                }
                s = message.format(delimited);
                boolean truncate = this.rotateLogs();
                FileOutputStream stream = new FileOutputStream(this.logFile, !truncate);
                try {
                    logger.debug((Object)("Writing message to log: " + s));
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)stream, "UTF8");
                    try {
                        PrintWriter writer = new PrintWriter(osw);
                        try {
                            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, this.localizedFile.getLocale());
                            writer.print(dateFormat.format(new Date()));
                            writer.print("|");
                            writer.print(message.getFriendlyName());
                            writer.print("|");
                            writer.println(s);
                        }
                        finally {
                            writer.close();
                        }
                    }
                    finally {
                        osw.close();
                    }
                }
                finally {
                    stream.close();
                }
                if (this.sendEmail) break block24;
                return;
            }
            try {
                if (null == addresses) {
                    addresses = new Address[]{};
                }
                String eventKey = message.getFriendlyName();
                logger.debug((Object)("Get subscribers to SEND for EVENT = " + eventKey));
                ArrayList eventAddrList = this.getSubscribers(eventKey);
                String categoryKey = this.getCategoryForEvent(eventKey);
                logger.debug((Object)("Get subscribers to SEND for CATEGORY = " + categoryKey));
                ArrayList categoryAddrList = this.getSubscribers(categoryKey);
                ArrayList allSubscribersList = this.getSubscribers(ALL_SUBSCRIBERS);
                Properties properties = new Properties();
                Session mailSession = Session.getInstance((Properties)properties);
                SMTPMessage mailMessage = new SMTPMessage(mailSession);
                mailMessage.setEnvelopeFrom(this.mailFrom);
                mailMessage.setFrom((Address)new InternetAddress(this.mailFrom));
                InternetAddress[] addr = new InternetAddress[]{new InternetAddress(this.replyTo)};
                mailMessage.setReplyTo((Address[])addr);
                mailMessage.setSubject(s);
                mailMessage.setText(s + this.getFooterText());
                SMTPTransport mailTransport = new SMTPTransport(mailSession, this.mailServer);
                Address[] temp = new Address[1];
                this.sendMessages(mailTransport, mailMessage, eventAddrList);
                this.sendMessages(mailTransport, mailMessage, categoryAddrList);
                this.sendMessages(mailTransport, mailMessage, allSubscribersList);
                for (int i = 0; i < addresses.length; ++i) {
                    temp[0] = addresses[i];
                    try {
                        SMTPTransport.send((Message)mailMessage, (Address[])temp);
                        continue;
                    }
                    catch (Throwable x) {
                        logger.error((Object)x.getMessage(), x);
                    }
                }
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
            }
        }
        finally {
            LoggerTemplate.logExit("log");
        }
    }

    private void sendMessages(SMTPTransport mailTransport, SMTPMessage mailMessage, ArrayList addresses) throws Exception {
        if (addresses == null) {
            return;
        }
        Address[] temp = new Address[1];
        for (int i = 0; i < addresses.size(); ++i) {
            temp[0] = (Address)addresses.get(i);
            logger.debug((Object)("Trying to send email to address = " + temp[0].toString()));
            try {
                SMTPTransport.send((Message)mailMessage, (Address[])temp);
                continue;
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
            }
        }
    }

    private String getFooterText() {
        StringBuffer result = new StringBuffer("\n\n https://" + this.ipAddress);
        result.append(":6789/se6920ui\n http://" + this.ipAddress);
        return result.toString();
    }

    private synchronized String getCategoryForEvent(String eventFriendlyName) {
        String category = null;
        try {
            LoggerMessage message = (LoggerMessage)this.messages.get(eventFriendlyName);
            int index = message.id.indexOf(".");
            category = message.id.substring(0, index);
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
        }
        return category;
    }

    public synchronized LoggerMessage[] getMessagesByCategory(String category) {
        Vector<LoggerMessage> vector = new Vector<LoggerMessage>();
        try {
            Iterator<Object> i = this.messages.values().iterator();
            while (i.hasNext()) {
                LoggerMessage message = (LoggerMessage)i.next();
                StringTokenizer tokenizer = new StringTokenizer(message.id, ".");
                String messageCategory = tokenizer.nextToken();
                if (!messageCategory.equals(category)) continue;
                vector.addElement(message);
            }
            LoggerMessage[] result = new LoggerMessage[vector.size()];
            int n = 0;
            i = vector.iterator();
            while (i.hasNext()) {
                result[n++] = (LoggerMessage)i.next();
            }
            return result;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            return new LoggerMessage[0];
        }
    }

    public synchronized LoggerMessage[] getMessages() {
        Collection msgs = this.messages.values();
        int size = msgs.size();
        LoggerMessage[] result = new LoggerMessage[size];
        int count = 0;
        Iterator i = msgs.iterator();
        while (i.hasNext()) {
            result[count++] = (LoggerMessage)i.next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCategories() {
        try {
            LoggerTemplate.logEntry("getCategories");
            try {
                Vector<String> vector = new Vector<String>();
                Iterator<Object> i = this.messages.values().iterator();
                while (i.hasNext()) {
                    LoggerMessage message = (LoggerMessage)i.next();
                    StringTokenizer tokenizer = new StringTokenizer(message.id, ".");
                    String category = tokenizer.nextToken();
                    if (vector.contains(category)) continue;
                    vector.addElement(category);
                }
                String[] result = new String[vector.size()];
                int n = 0;
                i = vector.iterator();
                while (i.hasNext()) {
                    result[n++] = (String)i.next();
                }
                String[] stringArray = result;
                return stringArray;
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
                String[] stringArray = new String[]{};
                LoggerTemplate.logExit("getCategories");
                return stringArray;
            }
        }
        finally {
            LoggerTemplate.logExit("getCategories");
        }
    }

    public LoggerMessage getInvalidLoggerMessage(String friendlyName, int argCount) {
        StringBuffer buffer = new StringBuffer("INVALID MESSAGE ID ");
        buffer.append(friendlyName);
        for (int i = 0; i < argCount; ++i) {
            buffer.append(" {");
            buffer.append(i);
            buffer.append("}");
        }
        LoggerMessage message = new LoggerMessage();
        message.friendlyName = friendlyName;
        message.text = buffer.toString();
        message.id = "0.0";
        message.variableCount = argCount;
        LoggerMessage.access$602(message, new Address[0]);
        return message;
    }

    /*
     * Exception decompiling
     */
    public String[] translate(int fileNumber, String locale) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getLog(int fileNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String translate(String message, LoggerTemplate localizedLogger, Locale loc) {
        try {
            LoggerTemplate.logEntry("translate");
            StringTokenizer tokenizer = new StringTokenizer(message, "|");
            String timeStamp = tokenizer.nextToken();
            String name = tokenizer.nextToken();
            String text = tokenizer.nextToken();
            Object[] args = this.parseMessageText(text);
            logger.info((Object)("Parsed " + args.length + " message args"));
            for (int i = 0; i < args.length; ++i) {
                logger.info((Object)("Message arg " + i + " is " + args[i]));
            }
            LoggerMessage loggerMessage = localizedLogger.getMessageByFriendlyName(name);
            if (null == loggerMessage) {
                loggerMessage = localizedLogger.getInvalidLoggerMessage(name, args.length);
            }
            Locale locale = localizedLogger.localizedFile.getLocale();
            logger.info((Object)("Translating " + message + " using " + locale.toString()));
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, this.localizedFile.getLocale());
            Date date = dateFormat.parse(timeStamp);
            dateFormat = DateFormat.getDateTimeInstance(1, 1, locale);
            timeStamp = dateFormat.format(date);
            if (name != null && args != null && args.length != 0 && (name.equals("SP_TIME_ZONE_SET") || name.equals("SP_TIME_ZONE_SET_FAILED") || name.equals("ARRAY_TIME_ZONE_SET") || name.equals("ARRAY_TIME_ZONE_SET_FAILED") || name.equals("ARRAY_TIME_SET_FAILED") || name.equals("ARRAY_TIME_TIME_SET"))) {
                int tzIndex = 0;
                if (name.equals("ARRAY_TIME_SET_FAILED") || name.equals("ARRAY_TIME_TIME_SET")) {
                    tzIndex = 4;
                }
                Object tz = args[tzIndex];
                ResourceBundle rb = null;
                try {
                    rb = ResourceBundle.getBundle("TimeZoneDisplayStrings", loc);
                }
                catch (Exception e) {
                    try {
                        rb = ResourceBundle.getBundle("TimeZoneDisplayStrings_m1m2", loc);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                if (rb != null) {
                    args[tzIndex] = rb.getString((String)tz);
                }
            }
            text = loggerMessage.format(args);
            String string = timeStamp + "|" + name + "|" + text;
            return string;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            String string = message;
            return string;
        }
        finally {
            LoggerTemplate.logExit("translate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init(File templateDirectory, String templatePrefix, String templateSuffix, Locale locale) throws Exception {
        try {
            LoggerTemplate.logEntry("init");
            this.templatePrefix = templatePrefix;
            this.templateSuffix = templateSuffix;
            this.templateDirectory = templateDirectory;
            String logDirectoryName = this.getParameter("com.sun.netstorage.array.mgmt.logger.directory", "/opt/se6x20/resources");
            this.logDirectory = new File(logDirectoryName);
            this.logPrefix = this.getParameter("com.sun.netstorage.array.mgmt.logger.prefix", "logger");
            this.logSuffix = this.getParameter("com.sun.netstorage.array.mgmt.logger.suffix", ".log");
            this.logFile = new File(this.logDirectory, this.logPrefix + "1" + this.logSuffix);
            String maxLogFilesString = this.getParameter("com.sun.netstorage.array.mgmt.logger.maxlogs", String.valueOf(9));
            this.maxLogFiles = Integer.parseInt(maxLogFilesString);
            String sendEmailString = this.getParameter("send.email.notification", "false");
            this.sendEmail = new Boolean(sendEmailString);
            this.maxLogFiles = Integer.parseInt(maxLogFilesString);
            String maxLogSizeString = this.getParameter("com.sun.netstorage.array.mgmt.logger.maxsize", String.valueOf(10000L));
            this.maxLogSize = Long.parseLong(maxLogSizeString);
            this.mailFrom = this.getParameter("com.sun.netstorage.array.mgmt.logger.mailfrom", "logger@sun.com");
            this.replyTo = this.getParameter("com.sun.netstorage.array.mgmt.logger.replyto", "logger@sun.com");
            String mailServerName = this.getParameter("com.sun.netstorage.array.mgmt.logger.mailserver", "localhost");
            this.mailServer = new URLName("smtp://" + mailServerName);
            templatePrefix = this.getParameter("com.sun.netstorage.array.mgmt.logger.template.prefix", "log_template");
            templateSuffix = this.getParameter("com.sun.netstorage.array.mgmt.logger.template.suffix", "");
            templateDirectory = new File(this.getParameter("com.sun.netstorage.array.mgmt.logger.template.directory", "/opt/se6x20/resources"));
            this.ipAddress = this.extractIPAddress();
            logger.info((Object)"Finished setting configuration parameters. Attempting to parse template file.");
            this.localizedFile = new LocalizedFile(locale);
            this.messages = new Hashtable();
            this.subscriptions = new Hashtable();
            this.subscriptionsFile = new File(templateDirectory, this.getParameter("com.sun.netstorage.array.mgmt.logger.template.subscriptions", "log_subscriptions.properties"));
            if (this.subscriptionsFile != null && this.subscriptionsFile.exists()) {
                FileInputStream subscriptionsIs = new FileInputStream(this.subscriptionsFile);
                Properties propSubs = new Properties();
                propSubs.load(subscriptionsIs);
                Enumeration<?> e = propSubs.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String[] values = propSubs.getProperty(key).split(",");
                    this.subscriptions.put(key, LoggerTemplate.stringEmailArrayToAddressList(values));
                }
            }
            this.templateFile = this.localizedFile.getFile(templateDirectory, templatePrefix, templateSuffix);
            if (null == this.templateFile) {
                throw new Exception("No template file found.");
            }
            logger.debug((Object)("Processing " + this.templateFile.toString()));
            FileInputStream stream = new FileInputStream(this.templateFile);
            try {
                String line;
                InputStreamReader isr = new InputStreamReader((InputStream)stream, "UTF8");
                BufferedReader reader = new BufferedReader(isr);
                while (null != (line = reader.readLine())) {
                    if (0 == line.length() || '#' == line.charAt(0)) continue;
                    try {
                        StringTokenizer tokenizer = new StringTokenizer(line, ":");
                        LoggerMessage message = new LoggerMessage();
                        message.id = tokenizer.nextToken();
                        message.friendlyName = tokenizer.nextToken();
                        message.variableCount = Integer.parseInt(tokenizer.nextToken());
                        message.text = tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            String addresses = tokenizer.nextToken();
                            StringTokenizer addressTokenizer = new StringTokenizer(addresses, ",;");
                            int addressCount = addressTokenizer.countTokens();
                            LoggerMessage.access$602(message, new Address[addressCount]);
                            for (int i = 0; i < addressCount; ++i) {
                                String xaddr = addressTokenizer.nextToken();
                                if (xaddr == null || xaddr.trim().equals("")) continue;
                                ((LoggerMessage)message).subscribers[i] = new InternetAddress(addressTokenizer.nextToken());
                            }
                        } else {
                            LoggerMessage.access$602(message, new Address[0]);
                        }
                        this.messages.put(message.friendlyName, message);
                    }
                    catch (Throwable x) {
                        logger.error((Object)x.getMessage(), x);
                    }
                }
            }
            finally {
                ((InputStream)stream).close();
            }
            logger.info((Object)"Initialization complete.");
        }
        finally {
            LoggerTemplate.logExit("init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String extractIPAddress() {
        String ipAddressString;
        block17: {
            LoggerTemplate.logEntry("extractIPAddress");
            String WAN_IP_ADDRESS = "WanIPAddr:";
            String ipAddressFileName = this.configuration.getProperty("com.sun.netstorage.array.mgmt.logger.ipfile", "/opt/SUNWsespfw/repository");
            ipAddressString = null;
            if (ipAddressFileName != null && ipAddressFileName.trim().length() > 0) {
                BufferedReader in = null;
                File ipAddressFile = new File(ipAddressFileName);
                if (ipAddressFile.exists()) {
                    in = new BufferedReader(new FileReader(ipAddressFile));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        int location = line.indexOf("WanIPAddr:");
                        if (location < 0 || line.length() <= location + "WanIPAddr:".length()) continue;
                        ipAddressString = line.substring(location + "WanIPAddr:".length());
                        break;
                    }
                }
                Object var9_10 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block17;
                }
                catch (Exception e) {}
                break block17;
                {
                    catch (IOException ioe) {
                        ipAddressString = null;
                        Object var9_11 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block17;
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (ipAddressString == null || ipAddressString.trim().length() == 0) {
            logger.info((Object)"IP address not read from the file -  getting the address of the localhost ");
            try {
                ipAddressString = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                ipAddressString = "localhost";
            }
        }
        logger.info((Object)("IP address is " + ipAddressString));
        LoggerTemplate.logExit("extractIPAddress");
        return ipAddressString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean rotateLogs() throws Exception {
        try {
            LoggerTemplate.logEntry("rotateLogs");
            if (this.logFile.length() > this.maxLogSize) {
                logger.info((Object)"Rotating log files.");
                File temp1 = new File(this.logDirectory, this.logPrefix + this.maxLogFiles + this.logSuffix);
                File temp2 = new File(this.logDirectory, this.logPrefix + "0" + this.logSuffix);
                logger.debug((Object)("Renaming " + temp1.toString() + " to " + temp2.toString()));
                temp1.renameTo(temp2);
                for (int i = this.maxLogFiles - 1; i >= 1; --i) {
                    File f1 = new File(this.logDirectory, this.logPrefix + i + this.logSuffix);
                    File f2 = new File(this.logDirectory, this.logPrefix + (i + 1) + this.logSuffix);
                    logger.debug((Object)("Renaming " + f1.toString() + " to " + f2.toString()));
                    f1.renameTo(f2);
                }
                logger.debug((Object)("Renaming " + temp2.toString() + " to " + this.logFile.toString()));
                temp2.renameTo(this.logFile);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LoggerTemplate.logExit("rotateLogs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateFile() {
        try {
            LoggerTemplate.logEntry("updateFile");
            File newFile = new File(this.templateDirectory, "temp_subscriptions.properties");
            if (newFile != null && !newFile.exists() && !newFile.createNewFile()) {
                logger.debug((Object)"Unable to create new file; return right away; no file update");
                return;
            }
            FileOutputStream stream = new FileOutputStream(newFile);
            try {
                Properties tmpProps = new Properties();
                Enumeration e = this.subscriptions.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    tmpProps.put(key, LoggerTemplate.addressListToString((ArrayList)this.subscriptions.get(key)));
                }
                tmpProps.store(stream, null);
            }
            finally {
                stream.close();
            }
            if (!this.subscriptionsFile.exists() || this.subscriptionsFile.delete()) {
                if (newFile.renameTo(this.subscriptionsFile)) {
                    logger.info((Object)("updated subscriptions file " + this.subscriptionsFile.toString()));
                } else {
                    logger.error((Object)("Error renaming updated subscriptions file! Current data can be found in " + this.subscriptionsFile.toString()));
                }
            }
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
        }
        finally {
            LoggerTemplate.logExit("updateFile");
        }
    }

    private String getParameter(String name) {
        return this.getParameter(name, null);
    }

    private String getParameter(String name, String defaultValue) {
        String value = this.configuration.getProperty(name);
        if (null == (value = System.getProperty(name, value)) && null != defaultValue) {
            value = defaultValue;
            logger.warn((Object)("No configuration property specified for " + name + ". Using default value " + value));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] parseMessageText(String text) {
        try {
            LoggerTemplate.logEntry("parseMessageText");
            logger.info((Object)("Parsing " + text));
            try {
                String expression = "\\{([0-9]+):(.*?)\\}";
                Pattern pattern = Pattern.compile(expression);
                Matcher matcher = pattern.matcher(text);
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                while (matcher.find()) {
                    String pos = text.substring(matcher.start(1), matcher.end(1));
                    String value = text.substring(matcher.start(2), matcher.end(2));
                    logger.info((Object)("Value at pos " + pos + " is " + value));
                    hashtable.put(pos, value);
                }
                String[] result = new String[hashtable.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (String)hashtable.get(String.valueOf(i));
                }
                String[] stringArray = result;
                return stringArray;
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
                String[] stringArray = new String[]{};
                LoggerTemplate.logExit("parseMessageText");
                return stringArray;
            }
        }
        finally {
            LoggerTemplate.logExit("parseMessageText");
        }
    }

    private static void logEntry(String methodName) {
        logger.debug((Object)("Entering " + methodName));
    }

    private static void logExit(String methodName) {
        logger.debug((Object)("Exiting " + methodName));
    }

    private static ArrayList stringEmailArrayToAddressList(String[] strings) {
        LoggerTemplate.logEntry("stringEmailArrayToAddressList");
        ArrayList<InternetAddress> addressList = new ArrayList<InternetAddress>();
        try {
            if (null == strings) {
                return addressList;
            }
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i] != null && "".equals(strings[i])) continue;
                InternetAddress addr = new InternetAddress(strings[i]);
                addressList.add(addr);
            }
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
        }
        return addressList;
    }

    private static String addressListToString(ArrayList addrList) {
        LoggerTemplate.logEntry("addressListToString");
        StringBuffer str = new StringBuffer("");
        if (addrList != null) {
            for (int i = 0; i < addrList.size(); ++i) {
                if (i == 0) {
                    str.append(addrList.get(i).toString());
                    continue;
                }
                str.append(",").append(addrList.get(i).toString());
            }
        }
        return str.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class LoggerMessage {
        private String id;
        private String friendlyName;
        private int variableCount;
        private String text;
        private Address[] subscribers;

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public String getText() {
            return this.text;
        }

        public String getId() {
            return this.id;
        }

        public int getVariableCount() {
            return this.variableCount;
        }

        public synchronized Address[] getSubscribers() {
            return (Address[])this.subscribers.clone();
        }

        public synchronized void setSubscribers(Address[] subscribers) {
            this.subscribers = (Address[])subscribers.clone();
            LoggerTemplate.this.updateFile();
        }

        public String format(Object[] variables) throws Exception {
            MessageFormat messageFormat = new MessageFormat(this.text, LoggerTemplate.this.localizedFile.getLocale());
            return messageFormat.format(variables);
        }

        static /* synthetic */ Address[] access$602(LoggerMessage x0, Address[] x1) {
            x0.subscribers = x1;
            return x1;
        }
    }
}

