/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.logger;

import com.sun.netstorage.array.mgmt.logger.EventCategoryInfo;
import com.sun.netstorage.array.mgmt.logger.EventInfo;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.logger.LoggerTemplate;
import java.io.File;
import java.io.InputStream;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

public class LogServer
extends LogAPI {
    private String serverName;
    private LoggerTemplate loggerTemplate;
    private static Logger logger = Logger.getLogger((String)(class$com$sun$netstorage$array$mgmt$logger$LogServer == null ? (class$com$sun$netstorage$array$mgmt$logger$LogServer = LogServer.class$("com.sun.netstorage.array.mgmt.logger.LogServer")) : class$com$sun$netstorage$array$mgmt$logger$LogServer).getName());
    private Locale locale;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$logger$LogServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogServer() {
        try {
            LogServer.logEntry("Constructor");
            try {
                InputStream stream;
                Properties configuration = new Properties();
                this.loggerTemplate = null;
                this.locale = null;
                String configurationName = System.getProperty("com.sun.netstorage.array.mgmt.logger.configuration");
                if (null == configurationName) {
                    configurationName = "/logger.properties";
                    logger.warn((Object)("No configuration file name specified. Defaulting to " + configurationName));
                }
                if (null == (stream = (class$com$sun$netstorage$array$mgmt$logger$LogServer == null ? (class$com$sun$netstorage$array$mgmt$logger$LogServer = LogServer.class$("com.sun.netstorage.array.mgmt.logger.LogServer")) : class$com$sun$netstorage$array$mgmt$logger$LogServer).getResourceAsStream(configurationName))) {
                    logger.warn((Object)("No resource found named " + configurationName));
                } else {
                    try {
                        configuration.load(stream);
                    }
                    finally {
                        stream.close();
                    }
                }
                this.setConfiguration(configuration);
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
            }
        }
        finally {
            LogServer.logExit("Constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVariableCount(String friendlyName) {
        try {
            LoggerTemplate.LoggerMessage message;
            LogServer.logEntry("getVariableCount");
            if (null == this.loggerTemplate) {
                this.init();
            }
            if (null == (message = this.loggerTemplate.getMessageByFriendlyName(friendlyName))) {
                logger.error((Object)("No message found named " + friendlyName));
                int n = 0;
                return n;
            }
            int n = message.getVariableCount();
            return n;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            int n = 0;
            return n;
        }
        finally {
            LogServer.logExit("getVariableCount");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String friendlyName, String[] args, String[] addresses) {
        block9: {
            LogServer.logEntry("log");
            if (null == this.loggerTemplate) {
                this.init();
            }
            if (null != this.loggerTemplate) break block9;
            logger.error((Object)"Error processing log template file.");
            LogServer.logExit("log");
            return;
        }
        try {
            try {
                LoggerTemplate.LoggerMessage message = this.loggerTemplate.getMessageByFriendlyName(friendlyName);
                if (null == message) {
                    logger.error((Object)("No message found named " + friendlyName));
                    message = this.loggerTemplate.getInvalidLoggerMessage(friendlyName, args.length);
                }
                Address[] addr = new Address[addresses != null ? addresses.length : 0];
                for (int i = 0; i < addr.length; ++i) {
                    addr[i] = new InternetAddress(addresses[i]);
                }
                this.loggerTemplate.log(message, args, addr);
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            LogServer.logExit("log");
        }
    }

    public String getLocale() {
        return this.locale.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageId(String friendlyName) {
        try {
            LoggerTemplate.LoggerMessage message;
            LogServer.logEntry("getMessageId");
            if (null == this.loggerTemplate) {
                this.init();
            }
            if (null == (message = this.loggerTemplate.getMessageByFriendlyName(friendlyName))) {
                throw new Exception("No message found with name " + friendlyName);
            }
            String string = message.getId();
            return string;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            String string = null;
            return string;
        }
        finally {
            LogServer.logExit("getMessageId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubscribers(String friendlyName) {
        try {
            LogServer.logEntry("getSubscribers");
            if (null == this.loggerTemplate) {
                this.init();
            }
            ArrayList subscriptions = this.loggerTemplate.getSubscribers(friendlyName);
            String[] result = new String[]{};
            if (null != subscriptions) {
                result = new String[subscriptions.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = subscriptions.get(i).toString();
                    logger.debug((Object)("Got email address = " + result[i]));
                }
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            LogServer.logExit("getSubscribers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscribers(String friendlyName, String[] subscribers) {
        try {
            try {
                LogServer.logEntry("setSubscribers");
                if (null == this.loggerTemplate) {
                    this.init();
                }
                ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
                for (int i = 0; i < subscribers.length; ++i) {
                    addresses.add(new InternetAddress(subscribers[i]));
                    logger.debug((Object)("SETTING subscriber = " + subscribers[i]));
                }
                this.loggerTemplate.setSubscribers(friendlyName, addresses);
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
            }
        }
        finally {
            LogServer.logExit("setSubscribers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMessages() {
        try {
            LogServer.logEntry("getMessages");
            if (null == this.loggerTemplate) {
                this.init();
            }
            LoggerTemplate.LoggerMessage[] messages = this.loggerTemplate.getMessages();
            String[] result = new String[messages.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = messages[i].getFriendlyName();
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            LogServer.logExit("getMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMessagesByCategory(String category) {
        try {
            LogServer.logEntry("getMessagesByCategory");
            if (null == this.loggerTemplate) {
                this.init();
            }
            LoggerTemplate.LoggerMessage[] messages = this.loggerTemplate.getMessagesByCategory(category);
            String[] result = new String[messages.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = messages[i].getFriendlyName();
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            LogServer.logExit("getMessagesByCategory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageById(String id) {
        try {
            LoggerTemplate.LoggerMessage message;
            LogServer.logEntry("getMessageById");
            if (null == this.loggerTemplate) {
                this.init();
            }
            if (null == (message = this.loggerTemplate.getMessageById(id))) {
                String string = null;
                return string;
            }
            String string = message.getFriendlyName();
            return string;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            String string = null;
            return string;
        }
        finally {
            LogServer.logExit("getMessageById");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageText(String friendlyName) {
        try {
            LogServer.logEntry("getMessageText");
            if (null == this.loggerTemplate) {
                this.init();
            }
            String string = this.loggerTemplate.getMessageText(friendlyName);
            return string;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            String string = null;
            return string;
        }
        finally {
            LogServer.logExit("getMessageText");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCategories() {
        try {
            LogServer.logEntry("getCategories");
            try {
                if (null == this.loggerTemplate) {
                    this.init();
                }
                String[] stringArray = this.loggerTemplate.getCategories();
                return stringArray;
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
                String[] stringArray = new String[]{};
                LogServer.logExit("getCategories");
                return stringArray;
            }
        }
        finally {
            LogServer.logExit("getCategories");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] translate(int fileNumber, String locale) {
        try {
            LogServer.logEntry("translate");
            try {
                if (null == this.loggerTemplate) {
                    this.init();
                }
                String[] stringArray = this.loggerTemplate.translate(fileNumber, locale);
                return stringArray;
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
                String[] stringArray = new String[]{};
                LogServer.logExit("translate");
                return stringArray;
            }
        }
        finally {
            LogServer.logExit("translate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLog(int fileNumber) {
        try {
            LogServer.logEntry("getLog");
            try {
                if (null == this.loggerTemplate) {
                    this.init();
                }
                String[] stringArray = this.loggerTemplate.getLog(fileNumber);
                return stringArray;
            }
            catch (Throwable x) {
                logger.error((Object)x.getMessage(), x);
                String[] stringArray = new String[]{};
                LogServer.logExit("getLog");
                return stringArray;
            }
        }
        finally {
            LogServer.logExit("getLog");
        }
    }

    public EventInfo getEvent(String event) {
        EventInfo info = new EventInfo();
        info.setEvent(event);
        info.setId(this.getMessageId(event));
        info.setSubscribers(this.getSubscribers(event));
        info.setText(this.getMessageText(event));
        return info;
    }

    public void addSubscribers(String key, String[] subscribers) {
        int i;
        String[] oldSubs = this.getSubscribers(key);
        Vector<String> subs = new Vector<String>();
        for (i = 0; i < oldSubs.length; ++i) {
            subs.add(oldSubs[i]);
        }
        for (i = 0; i < subscribers.length; ++i) {
            boolean found = false;
            for (int j = 0; j < oldSubs.length; ++j) {
                if (!subscribers[i].equalsIgnoreCase(oldSubs[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            subs.add(subscribers[i]);
        }
        String[] newSubs = new String[subs.size()];
        for (i = 0; i < newSubs.length; ++i) {
            newSubs[i] = (String)subs.get(i);
        }
        this.setSubscribers(key, newSubs);
    }

    public void removeSubscribers(String key, String[] subscribers) {
        int i;
        Vector<String> subs = new Vector<String>();
        String[] oldSubs = this.getSubscribers(key);
        for (i = 0; i < oldSubs.length; ++i) {
            boolean found = false;
            for (int j = 0; j < subscribers.length; ++j) {
                if (!subscribers[j].equalsIgnoreCase(oldSubs[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            subs.add(oldSubs[i]);
        }
        String[] newSubs = new String[subs.size()];
        for (i = 0; i < newSubs.length; ++i) {
            newSubs[i] = (String)subs.get(i);
        }
        this.setSubscribers(key, newSubs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventCategoryInfo getEventCategory(String category) {
        try {
            LogServer.logEntry("getEventCategory");
            String[] eventNames = this.getMessagesByCategory(category);
            ArrayList<EventInfo> eventList = new ArrayList<EventInfo>();
            for (int i = 0; i < eventNames.length; ++i) {
                eventList.add(this.getEvent(eventNames[i]));
            }
            Collections.sort(eventList, new EventComparator());
            EventInfo[] events = new EventInfo[eventList.size()];
            eventList.toArray(events);
            String[] subscribers = this.getSubscribers(category);
            EventCategoryInfo info = new EventCategoryInfo();
            info.setCategory(category);
            info.setSubscribers(subscribers);
            info.setEvents(events);
            EventCategoryInfo eventCategoryInfo = info;
            return eventCategoryInfo;
        }
        catch (Exception e) {
            logger.debug((Object)("got exception " + e));
            EventCategoryInfo eventCategoryInfo = null;
            return eventCategoryInfo;
        }
        finally {
            LogServer.logExit("getEventCategory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventCategoryInfo[] getEventCategories() {
        try {
            LogServer.logEntry("getEventCategories");
            String[] categories = this.getCategories();
            EventCategoryInfo[] result = new EventCategoryInfo[categories.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.getEventCategory(categories[i]);
            }
            EventCategoryInfo[] eventCategoryInfoArray = result;
            return eventCategoryInfoArray;
        }
        finally {
            LogServer.logExit("getEventCategories");
        }
    }

    private static void logEntry(String methodName) {
        logger.debug((Object)("Entering " + methodName));
    }

    private static void logExit(String methodName) {
        logger.debug((Object)("Exiting " + methodName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() throws Exception {
        try {
            LogServer.logEntry("init");
            ClassLoader classLoader = this.getClass().getClassLoader();
            String localeString = this.getParameter("com.sun.netstorage.array.mgmt.logger.locale", Locale.getDefault().toString());
            this.serverName = this.getParameter("com.sun.netstorage.array.mgmt.logger.servername", "LogServer");
            StringTokenizer tokenizer = new StringTokenizer(localeString, "_-");
            int count = tokenizer.countTokens();
            String[] localeParts = new String[count];
            for (int i = 0; i < count; ++i) {
                localeParts[i] = tokenizer.nextToken();
            }
            switch (localeParts.length) {
                case 1: {
                    logger.debug((Object)"only language specified");
                    this.locale = new Locale(localeParts[0]);
                    break;
                }
                case 2: {
                    logger.debug((Object)"language and country specified");
                    this.locale = new Locale(localeParts[0], localeParts[1]);
                    break;
                }
                case 3: {
                    logger.debug((Object)"language, country, and variant specified");
                    this.locale = new Locale(localeParts[0], localeParts[1], localeParts[2]);
                    break;
                }
                default: {
                    logger.error((Object)"Invalid locale syntax. Using default locale.");
                    this.locale = Locale.getDefault();
                }
            }
            Properties configuration = this.getConfiguration();
            File templateDirectory = new File(this.getParameter("com.sun.netstorage.array.mgmt.logger.template.directory", "/opt/se6x20/resources"));
            String templatePrefix = this.getParameter("com.sun.netstorage.array.mgmt.logger.template.prefix", "log_template");
            String templateSuffix = this.getParameter("com.sun.netstorage.array.mgmt.logger.template.suffix", "");
            this.loggerTemplate = new LoggerTemplate(templateDirectory, templatePrefix, templateSuffix, this.locale, configuration);
        }
        finally {
            LogServer.logExit("init");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EventComparator
    implements Comparator {
        Collator collator = Collator.getInstance();

        EventComparator() {
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof EventInfo && element2 instanceof EventInfo) {
                key1 = this.collator.getCollationKey(((EventInfo)element1).getSortKey());
                key2 = this.collator.getCollationKey(((EventInfo)element2).getSortKey());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

