/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.logger;

import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LocalizedFile {
    private static Logger logger = Logger.getLogger((String)(class$com$sun$netstorage$array$mgmt$logger$LocalizedFile == null ? (class$com$sun$netstorage$array$mgmt$logger$LocalizedFile = LocalizedFile.class$("com.sun.netstorage.array.mgmt.logger.LocalizedFile")) : class$com$sun$netstorage$array$mgmt$logger$LocalizedFile).getName());
    private Locale locale;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$logger$LocalizedFile;

    public LocalizedFile() {
        this.locale = Locale.getDefault();
        logger.warn((Object)("Setting locale to default " + this.locale.toString()));
    }

    public LocalizedFile(Locale locale) {
        this.locale = locale;
        logger.info((Object)("Setting locale to " + locale.toString()));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public File getFile(File directory, String prefix, String suffix) {
        try {
            return this.findFile(directory, prefix, suffix);
        }
        catch (Throwable x) {
            logger.error((Object)x);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findFile(File directory, String prefix, String suffix) {
        try {
            LocalizedFile.logEntry("findFile");
            Vector<Locale> locales = new Vector<Locale>();
            locales.add(this.locale);
            Locale defaultLocale = Locale.getDefault();
            if (!this.locale.equals(defaultLocale)) {
                locales.add(defaultLocale);
            }
            Vector<File> files = new Vector<File>();
            Enumeration e = locales.elements();
            while (e.hasMoreElements()) {
                Locale l = (Locale)e.nextElement();
                String language = l.getLanguage();
                String country = l.getCountry();
                String variant = l.getVariant();
                if (null == language || "".equals(language)) continue;
                File languageFile = new File(directory, prefix + "_" + language + suffix);
                if (null != country && !"".equals(country)) {
                    File countryFile = new File(directory, prefix + "_" + language + "_" + country + suffix);
                    if (null != variant && !"".equals(variant)) {
                        File variantFile = new File(directory, prefix + "_" + language + "_" + country + "_" + variant + suffix);
                        files.add(variantFile);
                    }
                    files.add(countryFile);
                }
                files.add(languageFile);
            }
            files.add(new File(directory, prefix + suffix));
            e = files.elements();
            while (e.hasMoreElements()) {
                File file = (File)e.nextElement();
                logger.info((Object)("Checking " + file.toString()));
                if (!file.exists()) continue;
                logger.info((Object)("Using " + file.toString()));
                File file2 = file;
                return file2;
            }
            logger.info((Object)"No template file found.");
            File file = null;
            return file;
        }
        finally {
            LocalizedFile.logExit("findFile");
        }
    }

    private static void logEntry(String methodName) {
        logger.debug((Object)("Entering " + methodName));
    }

    private static void logExit(String methodName) {
        logger.debug((Object)("Exiting " + methodName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

