/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp.licensing;

import com.sun.netstorage.array.mgmt.sp.licensing.Key;
import com.sun.netstorage.array.mgmt.sp.licensing.KeyGenerator;
import com.sun.netstorage.array.mgmt.util.StorEdge_PersistentStorage;
import java.util.Vector;

public class KeyStore {
    private static Vector keys = new Vector();
    private static final String LICENSES_KEY = "licenses";

    private static void save() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.size(); ++i) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(keys.elementAt(i).toString());
        }
        StorEdge_PersistentStorage store = StorEdge_PersistentStorage.getInstance();
        store.setPersistentString(LICENSES_KEY, sb.toString(), true);
    }

    public static boolean add(String license) {
        Key k = KeyGenerator.makeKeyFromLicense(license);
        if (k == null) {
            return false;
        }
        for (int i = 0; i < keys.size(); ++i) {
            Key e = (Key)keys.elementAt(i);
            if (!e.getLicenseKey().equals(license) || e.getLicenseId() == 0L) continue;
            return false;
        }
        keys.add(k);
        KeyStore.save();
        return true;
    }

    public static boolean remove(String license) {
        Key k = KeyGenerator.makeKeyFromLicense(license);
        if (k == null) {
            return false;
        }
        for (int i = 0; i < keys.size(); ++i) {
            Key e = (Key)keys.elementAt(i);
            if (!e.getLicenseKey().equals(license)) continue;
            keys.remove(i);
            KeyStore.save();
            return true;
        }
        return false;
    }

    public static Key[] getKeys() {
        Object[] ks = new Key[keys.size()];
        keys.copyInto(ks);
        return ks;
    }

    public static long getAmountLicensed(String featureName) {
        long total = 0L;
        Key[] k = KeyStore.getKeys();
        boolean unlimited = false;
        for (int i = 0; i < k.length; ++i) {
            if (!k[i].getFeatureName().equals(featureName)) continue;
            if (k[i].getAmount() == Long.MAX_VALUE) {
                total = Long.MAX_VALUE;
                unlimited = true;
                continue;
            }
            if (unlimited) continue;
            total += k[i].getAmount();
        }
        return total;
    }

    static {
        StorEdge_PersistentStorage store = StorEdge_PersistentStorage.getInstance();
        String licenses = store.getPersistentString(LICENSES_KEY);
        if (licenses != null) {
            String[] lic = licenses.split(",");
            for (int i = 0; i < lic.length; ++i) {
                Key k = KeyGenerator.makeKeyFromLicense(lic[i]);
                if (k == null) continue;
                keys.add(k);
            }
        }
    }
}

