/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp.licensing;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.sp.licensing.KeyA;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Key {
    private long amount;
    private long licenseId;
    private String featureName;
    private String systemId;
    private String licenseKey;
    private Date expiration;
    private char version;
    public static final long MEGABYTE = 0x100000L;
    public static final long GIGABYTE = 0x40000000L;
    public static final long TERABYTE = 0x10000000000L;

    public long getAmount() {
        return this.amount;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public long getLicenseId() {
        return this.licenseId;
    }

    public char getVersion() {
        return this.version;
    }

    public String toString() {
        return this.licenseKey;
    }

    static Key makeKey(char version) {
        KeyA thisKey = null;
        switch (Character.toUpperCase(version)) {
            case 'A': {
                thisKey = new KeyA();
                break;
            }
            default: {
                return thisKey;
            }
        }
        return thisKey;
    }

    static Key makeKey(String licensePayload, char ver) {
        int rc;
        Key key = Key.makeKey(ver);
        if (key != null && (rc = key.update(licensePayload)) != 0) {
            return null;
        }
        return key;
    }

    static Key makeKey(String featureName, long amount, long licenseId, String systemId, char version, Date expiration) {
        return Key.makeKey(featureName, amount, licenseId, systemId, version, expiration, null);
    }

    static Key makeKey(String featureName, long amount, long licenseId, String systemId, char version, Date expiration, String licenseKey) {
        Key thisKey = Key.makeKey(version);
        if (thisKey != null) {
            thisKey.update(featureName, amount, licenseId, systemId, version, expiration, licenseKey);
        }
        return thisKey;
    }

    protected String getPayload() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.featureName);
        sb.append("-");
        if (this.amount < 0x40000000L) {
            sb.append(this.amount / 0x100000L);
            sb.append("M");
        } else if (this.amount < 0x10000000000L) {
            sb.append(this.amount / 0x40000000L);
            sb.append("G");
        } else if (this.amount == Long.MAX_VALUE) {
            sb.append("UNL");
        } else {
            sb.append(this.amount / 0x10000000000L);
            sb.append("T");
        }
        sb.append("-");
        sb.append(this.systemId);
        sb.append("-");
        sb.append(Long.toHexString(this.licenseId));
        if (this.expiration != null) {
            sb.append("-");
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy", Locale.US);
            sb.append(sdf.format(this.expiration));
        }
        return sb.toString().toUpperCase();
    }

    protected void update(String featureName, long amount, long licenseId, String systemId, char version, Date expiration, String licenseKey) {
        this.featureName = featureName;
        this.amount = amount;
        this.systemId = systemId;
        this.licenseId = licenseId;
        this.version = version;
        this.expiration = expiration;
        this.setLicenseKey(licenseKey);
    }

    protected int update(String licensePayload) {
        long number;
        String METHOD = "update";
        String[] payload = licensePayload.split("-");
        if (payload.length != 4 && payload.length != 5) {
            return 1;
        }
        Date expiration = null;
        if (payload.length == 5) {
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy", Locale.US);
            try {
                expiration = sdf.parse(payload[4]);
            }
            catch (ParseException e) {
                Trace.error((Object)this, (String)"update", (Throwable)e);
                return 2;
            }
        }
        String lastPart = payload[payload.length - 1];
        char version = lastPart.charAt(lastPart.length() - 1);
        try {
            number = Long.parseLong(payload[3], 16);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"update", (Throwable)e);
            return 3;
        }
        long amt = Long.MAX_VALUE;
        if (!"UNL".equals(payload[1])) {
            String digits = payload[1].substring(0, payload[1].length() - 1);
            try {
                amt = Long.parseLong(digits);
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)"update", (Throwable)e);
                return 4;
            }
            char c = payload[1].charAt(payload[1].length() - 1);
            if (c == 'T') {
                amt *= 0x10000000000L;
            } else if (c == 'M') {
                amt *= 0x100000L;
            } else if (c == 'G') {
                amt *= 0x40000000L;
            }
        }
        this.update(payload[0], amt, number, payload[2], version, expiration, licensePayload);
        return 0;
    }
}

