/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.sp.FirewallManager;
import com.sun.netstorage.array.mgmt.sp.SunStorEdge_6x20ApplicationServer;
import com.sun.netstorage.array.mgmt.util.StorEdge_InstanceProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;

public class SunStorEdge_6x20RemoteServiceAccessPoint
extends StorEdge_InstanceProvider {
    private static final String PROP_SYSTEM_NAME = "SystemName";
    private static final String PROP_SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static final String PROP_CREATION_CLASS_NAME = "CreationClassName";
    private static final String PROP_NAME = "Name";
    private static final String PROP_ACCESS_INFO = "AccessInfo";
    private static final String PROP_INFO_FORMAT = "InfoFormat";
    private static final String PROP_DHCP_ACCESS = "DHCPAccess";
    private static final String PROP_GATEWAY_ADDRESS = "GatewayAddress";
    private static final String PROP_DNS_ADDRESS = "DNSAddress";
    private static final String PROP_DHCP_SERVER_ENABLED = "DHCPServerEnabled";
    private static final String PROP_NETMASK = "NetMask";
    private static final String PROP_DOMAIN_NAME = "DomainName";
    private static final String LAN_IP_ADDRESS = "LanIPAddr";
    private static final String WAN_ADDRESS_TYPE = "WanAddrType";
    private static final String LAN_DHCP_SERVER = "LanDHCPSrv";
    private static final String WAN_SUBNET_MASK = "WanSubnetMask";
    private static final String WAN_GATEWAY = "WanGateway";
    private static final String LAN_DNS_SERVER = "LanDNSSrv";
    private static final String WAN_IP_ADDRESS = "WanIPAddr";
    private static final String DELIMITER = ":";
    private static final String ENABLED = "enabled";
    private static final String STATIC = "static";
    private static final String DOMAIN = "domain";
    private static final String NAMESERVER = "nameserver";
    private String wanIPAddress;
    private String lanIPAddress;
    private String gatewayAddress;
    private boolean dhcpServerEnabled;
    private boolean dhcpAccess;
    private String netMask;
    private String tempDNS;
    private String tempDomain;
    public static final String CLASSNAME = "SunStorEdge_6x20RemoteServiceAccessPoint";

    public String getClassName() {
        return CLASSNAME;
    }

    public void initialize(CIMOMHandle cimom) throws CIMException {
        super.initialize(cimom);
        FirewallManager fm = FirewallManager.getInstance();
    }

    protected CIMInstance getFirewallInstance(CIMOMHandle cimomhandle, String nameSpace) throws CIMException {
        String METHOD = "getFirewallInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getFirewallInstance" + " entered"));
        try {
            this.readConfigValues(FirewallManager.DEFAULT_FW_CONFIG_FILE);
        }
        catch (FileNotFoundException ex) {
            WBEMDebug.trace2((String)(this.getClassName() + "." + "getFirewallInstance" + " Firewall repository file doesn't exist: " + FirewallManager.DEFAULT_FW_CONFIG_FILE));
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getFirewallInstance" + " Error processing firewall repository file: " + FirewallManager.DEFAULT_FW_CONFIG_FILE));
            throw new CIMException(ex.getMessage());
        }
        CIMInstance ci = null;
        try {
            CIMObjectPath cop = new CIMObjectPath(this.getClassName());
            cop.setNameSpace(nameSpace);
            ci = cimomhandle.getClass(cop, false, true, true, null).newInstance();
            ci.setProperty(PROP_CREATION_CLASS_NAME, new CIMValue((Object)this.getClassName()));
            ci.setProperty(PROP_SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)new SunStorEdge_6x20ApplicationServer().getClassName()));
            ci.setProperty(PROP_SYSTEM_NAME, new CIMValue((Object)SunStorEdge_6x20ApplicationServer.getHostID().toString()));
            ci.setProperty(PROP_NAME, new CIMValue((Object)this.getLANFirewallIPAddress()));
            ci.setProperty(PROP_ACCESS_INFO, new CIMValue((Object)this.getWANFirewallIPAddress()));
            ci.setProperty(PROP_INFO_FORMAT, new CIMValue((Object)new UnsignedInt16(3)));
            ci.setProperty(PROP_NETMASK, new CIMValue((Object)this.getNetMask()));
            ci.setProperty(PROP_DHCP_ACCESS, new CIMValue((Object)new Boolean(this.getDHCPAccess())));
            ci.setProperty(PROP_GATEWAY_ADDRESS, new CIMValue((Object)this.getGatewayAddress()));
            HashMap resolvContent = null;
            resolvContent = this.readResolvFile();
            if (resolvContent.containsKey(NAMESERVER)) {
                ci.setProperty(PROP_DNS_ADDRESS, new CIMValue((Object)((String)resolvContent.get(NAMESERVER))));
            }
            if (resolvContent.containsKey(DOMAIN)) {
                ci.setProperty(PROP_DOMAIN_NAME, new CIMValue((Object)((String)resolvContent.get(DOMAIN))));
            }
            ci.setProperty(PROP_DHCP_SERVER_ENABLED, new CIMValue((Object)new Boolean(this.getDHCPServerEnabled())));
        }
        catch (CIMException e) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getFirewallInstance" + " failed to build " + "instance"), (Throwable)e);
            throw e;
        }
        return ci;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "getInstance");
        try {
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " Wrong class requested: " + op.getObjectName()));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            Vector keys = op.getKeys();
            String parentClass = null;
            for (int i = 0; i < keys.size(); ++i) {
                CIMProperty prop = (CIMProperty)keys.elementAt(i);
                if (!prop.getName().equalsIgnoreCase(PROP_SYSTEM_CREATION_CLASS_NAME)) continue;
                parentClass = (String)prop.getValue().getValue();
                break;
            }
            if (parentClass.equalsIgnoreCase(new SunStorEdge_6x20ApplicationServer().getClassName())) {
                CIMInstance ci = this.getFirewallInstance((CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
                ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                if (localOnly) {
                    ci.localElements();
                }
                return ci;
            }
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + "(Internal Error) Client attempted to retrieve" + "access point with bad SystemCreationClassName: " + parentClass));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (CIMException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " unknown failure."), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMException(ex.getMessage());
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        String METHOD = "setInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "setInstance");
        boolean newAddrType = false;
        boolean newDHCPServerState = false;
        Vector<PropertyInfo> propVector = new Vector<PropertyInfo>();
        try {
            PropertyInfo prop;
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "setInstance" + " Wrong class requested: " + op.getObjectName()));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            if (ci.getProperty(PROP_DHCP_ACCESS) != null && ci.getProperty(PROP_DHCP_ACCESS).getValue() != null) {
                Boolean val = (Boolean)ci.getProperty(PROP_DHCP_ACCESS).getValue().getValue();
                this.dhcpAccess = val;
                PropertyInfo prop2 = new PropertyInfo(PROP_DHCP_ACCESS, ci.getProperty(PROP_DHCP_ACCESS).getValue());
                propVector.addElement(prop2);
                WBEMDebug.trace2((String)("Setting dhcpAccess = " + this.dhcpAccess));
            }
            if (ci.getProperty(PROP_GATEWAY_ADDRESS) != null && ci.getProperty(PROP_GATEWAY_ADDRESS).getValue() != null) {
                this.gatewayAddress = (String)ci.getProperty(PROP_GATEWAY_ADDRESS).getValue().getValue();
                PropertyInfo prop3 = new PropertyInfo(PROP_GATEWAY_ADDRESS, ci.getProperty(PROP_GATEWAY_ADDRESS).getValue());
                propVector.addElement(prop3);
                WBEMDebug.trace2((String)("Setting gatewayAddress = " + this.gatewayAddress));
            }
            String newDNSAddress = null;
            String newDomainName = null;
            if (ci.getProperty(PROP_DNS_ADDRESS) != null && ci.getProperty(PROP_DNS_ADDRESS).getValue() != null) {
                newDNSAddress = (String)ci.getProperty(PROP_DNS_ADDRESS).getValue().getValue();
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setInstance" + " dnsAddress = " + newDNSAddress));
            }
            if (ci.getProperty(PROP_DOMAIN_NAME) != null && ci.getProperty(PROP_DOMAIN_NAME).getValue() != null) {
                newDomainName = (String)ci.getProperty(PROP_DOMAIN_NAME).getValue().getValue();
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setInstance" + " domainName  = " + newDomainName));
            }
            if (newDNSAddress != null || newDomainName != null) {
                HashMap currentValues = this.updateResolvFile(newDNSAddress, newDomainName);
                SunStorEdge_6x20RemoteServiceAccessPoint.invokeCommandString("/etc/init.d/sendmail restart");
                SunStorEdge_6x20RemoteServiceAccessPoint.invokeCommandString("/etc/init.d/nscd stop");
                SunStorEdge_6x20RemoteServiceAccessPoint.invokeCommandString("/etc/init.d/nscd start");
                if (currentValues.containsKey(NAMESERVER)) {
                    PropertyInfo prop4 = new PropertyInfo(PROP_DNS_ADDRESS, new CIMValue(currentValues.get(NAMESERVER)));
                    propVector.addElement(prop4);
                }
            }
            if (ci.getProperty(PROP_NETMASK) != null && ci.getProperty(PROP_NETMASK).getValue() != null) {
                this.netMask = (String)ci.getProperty(PROP_NETMASK).getValue().getValue();
                prop = new PropertyInfo(PROP_NETMASK, ci.getProperty(PROP_NETMASK).getValue());
                propVector.addElement(prop);
                WBEMDebug.trace2((String)("Setting netMask = " + this.netMask));
            }
            if (ci.getProperty(PROP_ACCESS_INFO) != null && ci.getProperty(PROP_ACCESS_INFO).getValue() != null) {
                this.wanIPAddress = (String)ci.getProperty(PROP_ACCESS_INFO).getValue().getValue();
                prop = new PropertyInfo(PROP_ACCESS_INFO, ci.getProperty(PROP_ACCESS_INFO).getValue());
                propVector.addElement(prop);
                WBEMDebug.trace2((String)("Setting accessInfo = " + this.wanIPAddress));
            }
            if (!(this.dhcpAccess || this.wanIPAddress != null && this.netMask != null && this.gatewayAddress != null)) {
                throw new CIMException("CIM_ERR_FAILED: Must provide all params");
            }
            this.setFirewallConfig(propVector);
        }
        catch (Exception ex) {
            WBEMDebug.trace2((String)(this.getClassName() + "." + "setInstance" + " setInstance failed"));
            ex.printStackTrace();
            throw new CIMException(ex.getMessage());
        }
    }

    protected String getWANFirewallIPAddress() {
        return this.wanIPAddress;
    }

    protected String getLANFirewallIPAddress() {
        return this.lanIPAddress;
    }

    protected boolean getDHCPAccess() {
        return this.dhcpAccess;
    }

    protected String getGatewayAddress() {
        return this.gatewayAddress;
    }

    private synchronized void setLanIPAddress(String newValue) throws IOException {
        block4: {
            String METHOD = "setLanIPAddress";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "setLanIPAddress" + " entered"));
            if (newValue != null && !newValue.equals(this.lanIPAddress)) {
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setLanIPAddress" + " Changing from " + this.lanIPAddress + " to " + newValue));
                String defaultRouterValue = this.readDefaultRouter();
                String oldValue = null;
                oldValue = this.lanIPAddress == null || !this.lanIPAddress.equals(defaultRouterValue) ? defaultRouterValue : this.lanIPAddress;
                this.lanIPAddress = newValue;
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setLanIPAddress" + " Updating /etc/defaultrouter file "));
                this.updateDefaultRouter();
                Process p = null;
                try {
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "setLanIPAddress" + " \n running  " + "/usr/sbin/route -n add default -gateway " + newValue));
                    p = Runtime.getRuntime().exec("/usr/sbin/route -n add default -gateway " + newValue);
                    p.waitFor();
                    if (oldValue != null && !oldValue.equalsIgnoreCase(newValue)) {
                        WBEMDebug.trace2((String)(this.getClassName() + "." + "setLanIPAddress" + " \n running  " + "/usr/sbin/route -n delete default -gateway " + oldValue));
                        p = Runtime.getRuntime().exec("/usr/sbin/route -n delete default -gateway " + oldValue);
                        p.waitFor();
                    }
                }
                catch (Exception e) {
                    if (p == null) break block4;
                    p.destroy();
                }
            }
        }
    }

    protected String getNetMask() {
        return this.netMask;
    }

    protected boolean getDHCPServerEnabled() {
        return this.dhcpServerEnabled;
    }

    protected void readConfigValues(String configFileName) throws FileNotFoundException, Exception {
        String METHOD = "readConfigValues";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "readConfigValues" + " entered"));
        try {
            BufferedReader reader = new BufferedReader(new FileReader(configFileName));
            String currLine = reader.readLine();
            while (currLine != null) {
                String tmpAccess;
                WBEMDebug.trace3((String)(this.getClassName() + "." + "readConfigValues" + " curr line is " + currLine));
                if (currLine.startsWith(LAN_IP_ADDRESS)) {
                    String tmpLanIPAddress = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                    this.setLanIPAddress(tmpLanIPAddress);
                } else if (currLine.startsWith(LAN_DHCP_SERVER)) {
                    tmpAccess = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                    this.dhcpServerEnabled = false;
                    if (tmpAccess.equalsIgnoreCase(ENABLED)) {
                        this.dhcpServerEnabled = true;
                    }
                } else if (currLine.startsWith(WAN_ADDRESS_TYPE)) {
                    tmpAccess = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                    this.dhcpAccess = true;
                    if (tmpAccess.equalsIgnoreCase(STATIC)) {
                        this.dhcpAccess = false;
                    }
                } else if (currLine.startsWith(WAN_GATEWAY)) {
                    this.gatewayAddress = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                } else if (currLine.startsWith(WAN_SUBNET_MASK)) {
                    this.netMask = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                } else if (currLine.startsWith(WAN_IP_ADDRESS)) {
                    this.wanIPAddress = currLine.substring(currLine.indexOf(DELIMITER) + 1);
                }
                currLine = reader.readLine();
            }
        }
        catch (IOException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "readConfigValues" + " Firewall repository file not found " + configFileName));
            String[] arg = new String[]{configFileName};
            LogAPI.staticLog((String)"FIREWALL_IO_ERROR", (String[])arg, (String[])new String[0]);
            throw ex;
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "readConfigValues" + " ex is " + ex.getMessage()));
            throw ex;
        }
        WBEMDebug.trace3((String)(this.getClassName() + "." + "readConfigValues" + " exited."));
    }

    private void setFirewallConfig(Vector properties) throws CIMException {
        String METHOD = "setFirewallConfig";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setFirewallConfig" + " entered"));
        StringBuffer configStr = new StringBuffer("/usr/local/bin/FW_config ");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_ACCESS_INFO, "--wan_ip_addr");
        map.put(PROP_DHCP_ACCESS, "--wan_addr_type");
        map.put(PROP_NETMASK, "--wan_subnet_mask");
        map.put(PROP_GATEWAY_ADDRESS, "--wan_gateway");
        map.put(PROP_DNS_ADDRESS, "--dhcp_dns_server");
        map.put(PROP_DHCP_SERVER_ENABLED, "--dhcp_server");
        try {
            for (int i = 0; i < properties.size(); ++i) {
                PropertyInfo prop = (PropertyInfo)properties.elementAt(i);
                String name = prop.getName();
                CIMValue cv = prop.getValue();
                String cmd = (String)map.get(name);
                if (cmd == null) {
                    throw new CIMException("CIM_NO_SUCH_PROPERTY");
                }
                String val = new String(cv.getValue().toString());
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setFirewallConfig" + " initially  " + name + "=" + val));
                if (name.equalsIgnoreCase(PROP_DHCP_ACCESS)) {
                    val = STATIC;
                    if (cv.toString().equals("true")) {
                        val = "dynamic";
                        configStr = new StringBuffer("/usr/local/bin/FW_config " + cmd + " " + val);
                        break;
                    }
                } else if (name.equalsIgnoreCase(PROP_DHCP_SERVER_ENABLED)) {
                    val = "dis";
                    if (cv.toString().equals("true")) {
                        val = "en";
                    }
                } else if (name.equalsIgnoreCase(PROP_DNS_ADDRESS)) {
                    int maseratiId = -1;
                    try {
                        String maseratiStr = SunStorEdge_6x20ApplicationServer.getOtherIdentifyingInfo();
                        maseratiId = new Integer(maseratiStr);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (maseratiId == 0) {
                        configStr.append((String)map.get(PROP_DHCP_SERVER_ENABLED) + " en ");
                    } else {
                        configStr.append((String)map.get(PROP_DHCP_SERVER_ENABLED) + " dis ");
                        continue;
                    }
                }
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setFirewallConfig" + " " + name + "=" + val));
                configStr.append(cmd + " " + val + " ");
            }
            SunStorEdge_6x20RemoteServiceAccessPoint.setConfigValue(configStr.toString());
        }
        catch (Exception ex) {
            throw new CIMException(ex.getMessage());
        }
    }

    static void setConfigValue(String cmdStr) throws InterruptedException, Exception {
        String METHOD = "setConfigValue";
        WBEMDebug.trace3((String)"SunStorEdge_6x20RemoteServiceAccessPoint.setConfigValue entered");
        WBEMDebug.trace2((String)("Calling FW config script: " + cmdStr));
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdStr);
            p.waitFor();
            if (p.exitValue() < 0 || p.exitValue() > 0 && p.exitValue() < 100) {
                WBEMDebug.trace1((String)("SunStorEdge_6x20RemoteServiceAccessPoint.setConfigValue Error running FW_config script: " + cmdStr));
                WBEMDebug.trace1((String)("SunStorEdge_6x20RemoteServiceAccessPoint.setConfigValue The value of error code is " + p.exitValue()));
                throw new Exception("Error running FW command");
            }
            if (p.exitValue() >= 100) {
                WBEMDebug.trace2((String)("SunStorEdge_6x20RemoteServiceAccessPoint.setConfigValue Error code from FW_config script: " + p.exitValue()));
            }
        }
        catch (InterruptedException ex) {
            p.destroy();
            WBEMDebug.trace1((String)"SunStorEdge_6x20RemoteServiceAccessPoint.setConfigValue Destroying process after InterruptedException");
            throw ex;
        }
    }

    static void invokeCommandString(String cmdStr) throws InterruptedException, Exception {
        String METHOD = "invokeCommandString";
        WBEMDebug.trace3((String)"SunStorEdge_6x20RemoteServiceAccessPoint.invokeCommandString entered");
        WBEMDebug.trace2((String)("Invoking Command : " + cmdStr));
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdStr);
            p.waitFor();
            if (p.exitValue() != 0) {
                WBEMDebug.trace1((String)("SunStorEdge_6x20RemoteServiceAccessPoint.invokeCommandString Error running command: " + cmdStr));
                WBEMDebug.trace1((String)("SunStorEdge_6x20RemoteServiceAccessPoint.invokeCommandString The value of error code is " + p.exitValue()));
                throw new Exception("Error Running Command");
            }
        }
        catch (InterruptedException ex) {
            p.destroy();
            WBEMDebug.trace1((String)"SunStorEdge_6x20RemoteServiceAccessPoint.invokeCommandString Destroying process after InterruptedException");
            throw ex;
        }
    }

    protected Vector enumerate(String nameSpace) throws CIMException {
        String METHOD = "enumerate";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerate" + " entered"));
        Vector<CIMInstance> v = new Vector<CIMInstance>(1);
        v.addElement(this.getFirewallInstance((CIMOMHandle)this.getCimomHandle(), nameSpace));
        return v;
    }

    /*
     * Loose catch block
     */
    protected void saveProperties(String filename) throws IOException {
        block7: {
            String METHOD = "saveProperties";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "saveProperties" + " entered"));
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            String output = "// This is a temporary file.  This will hold the \n// firewall data until the firewall configuration\n// script is complete. Once complete the firewall\n// data will be stored in /opt/SUNWsespfw/repository.\n";
            String wanAddressTypeString = this.dhcpAccess ? "dynamic" : STATIC;
            output = output + "LanIPAddr:" + this.lanIPAddress + "\n";
            output = output + "WanIPAddr:" + this.wanIPAddress + "\n";
            output = output + "WanAddrType:" + wanAddressTypeString + "\n";
            output = output + "WanGateway:" + this.gatewayAddress + "\n";
            output = output + "LanDHCPSrv:" + this.dhcpServerEnabled + "\n";
            output = output + "WanSubnetMask:" + this.netMask + "\n";
            output = output + "DomainName:" + this.tempDomain + "\n";
            output = output + "LanDNSSrv:" + this.tempDNS + "\n";
            WBEMDebug.trace2((String)(this.getClassName() + "." + "saveProperties" + " writing to the file:\n" + output));
            writer.write(output, 0, output.length());
            writer.flush();
            writer.close();
            Object var7_7 = null;
            try {
                writer.close();
            }
            catch (IOException ex) {
                WBEMDebug.trace2((String)(this.getClassName() + "." + "saveProperties" + " error closing file: " + filename));
            }
            break block7;
            {
                catch (IOException ex) {
                    System.out.println("Error opening file: " + ex.toString());
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "saveProperties" + " error closing file: " + filename));
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized HashMap updateResolvFile(String newDNSAddress, String newDomainName) throws IOException {
        OutputStreamWriter out;
        HashMap<String, String> result;
        block8: {
            String METHOD = "updateResolvFile";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "updateResolvFile" + " entered"));
            result = new HashMap<String, String>();
            WBEMDebug.trace3((String)(this.getClassName() + "." + "updateResolvFile" + " newDNS is " + newDNSAddress + " newDomain is " + newDomainName));
            out = null;
            File tmpFile = null;
            try {
                HashMap currentValues = this.readResolvFile();
                String currDNSAddress = (String)currentValues.get(NAMESERVER);
                String currDomainName = (String)currentValues.get(DOMAIN);
                WBEMDebug.trace3((String)(this.getClassName() + "." + "updateResolvFile" + " currDNS is " + currDNSAddress + " currDomain is " + currDomainName));
                if (newDNSAddress != null && !newDNSAddress.equals(currDNSAddress) || newDomainName != null && !newDomainName.equals(currDomainName)) {
                    File resolvFile = new File("/etc/resolv.conf");
                    StringBuffer content = new StringBuffer("");
                    if (newDNSAddress != null || currDNSAddress != null) {
                        String whichDNS = newDNSAddress != null ? newDNSAddress : currDNSAddress;
                        content.append("nameserver " + whichDNS + "\n");
                        result.put(NAMESERVER, whichDNS);
                    }
                    if (newDomainName != null || currDomainName != null) {
                        String whichDomain = newDomainName != null ? newDomainName : currDomainName;
                        content.append("domain " + whichDomain + "\n");
                        result.put(DOMAIN, whichDomain);
                    }
                    tmpFile = new File("/etc/.resolv.conf");
                    out = new FileWriter(tmpFile);
                    out.write(content.toString());
                    out.flush();
                    out.close();
                    tmpFile.renameTo(resolvFile);
                }
                Object var14_13 = null;
                if (tmpFile == null || !tmpFile.exists()) break block8;
                tmpFile.delete();
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
        }
        if (out != null) {
            out.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readDefaultRouter() throws IOException {
        String METHOD = "readDefaultRouter";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "readDefaultRouter" + " entered"));
        BufferedReader reader = null;
        String result = null;
        try {
            File file = new File("/etc/defaultrouter");
            if (file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                result = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized HashMap readResolvFile() {
        HashMap<String, String> result;
        block13: {
            String METHOD = "readResolvFile";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "readResolvFile" + " entered"));
            BufferedReader reader = null;
            result = new HashMap<String, String>();
            File file = new File("/etc/resolv.conf");
            if (file.exists()) {
                reader = new BufferedReader(new FileReader(file));
                int found = 0;
                String line = null;
                while ((line = reader.readLine()) != null && found < 2) {
                    if (!line.startsWith(DOMAIN) && !line.startsWith(NAMESERVER)) continue;
                    ++found;
                    StringTokenizer tokenizer = new StringTokenizer(line, " \t");
                    if (tokenizer.countTokens() < 2) continue;
                    String firstToken = tokenizer.nextToken();
                    String secondToken = tokenizer.nextToken();
                    result.put(firstToken, secondToken);
                    WBEMDebug.trace3((String)(this.getClassName() + "." + "readResolvFile" + " \n putting " + firstToken + "=" + secondToken));
                }
            }
            Object var11_11 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block13;
            }
            catch (IOException ioe) {}
            break block13;
            {
                catch (IOException ie) {
                    Object var11_12 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block13;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateDefaultRouter() throws IOException {
        File tmpFile;
        block5: {
            String METHOD = "updateDefaultRouter";
            WBEMDebug.trace3((String)(this.getClassName() + "." + "updateDefaultRouter" + " entered"));
            OutputStreamWriter fr = null;
            tmpFile = null;
            try {
                File dRFile = new File("/etc/defaultrouter");
                tmpFile = new File("/etc/.defaultrouter");
                String content = this.lanIPAddress + "\n";
                fr = new FileWriter(tmpFile);
                fr.write(content);
                fr.flush();
                fr.close();
                tmpFile.renameTo(dRFile);
                Object var7_6 = null;
                if (fr == null) break block5;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (fr != null) {
                    fr.close();
                }
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                throw throwable;
            }
            fr.close();
        }
        if (tmpFile != null && tmpFile.exists()) {
            tmpFile.delete();
        }
    }

    class PropertyInfo {
        private String name;
        private CIMValue value;

        public PropertyInfo(String name, CIMValue value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public CIMValue getValue() {
            return this.value;
        }
    }
}

