/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp;

import com.sun.netstorage.array.mgmt.sp.PowerSupplyJNI;
import com.sun.netstorage.array.mgmt.util.StorEdge_InstanceProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.File;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class SunStorEdge_6x20PowerSupply
extends StorEdge_InstanceProvider {
    private static final String ENABLED_STATE = "EnabledState";
    private static final String OPERATIONAL_STATUS = "OperationalStatus";
    private static final String SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static final String CREATION_CLASS_NAME = "CreationClassName";
    private static final String APPLICATION_SERVER_CLASS = "SunStorEdge_6x20ApplicationServer";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String DEVICE_ID = "DeviceID";
    private static final String POWER_SUPPLY_INSTALLED_FILE = "/opt/se6x20/PSDATA/PS";
    private static final String CLASSNAME = "SunStorEdge_6x20PowerSupply";

    public String getClassName() {
        return CLASSNAME;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "getInstance");
        try {
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " Wrong class requested: " + op.getObjectName()));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            CIMInstance ci = this.getPowerSupplyInstance(op.getNameSpace());
            if (null != ci) {
                ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                if (localOnly) {
                    ci.localElements();
                }
            }
            return ci;
        }
        catch (CIMException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " unknown failure."), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " Failure: "), (Throwable)ex);
            throw new CIMException(ex.getMessage());
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        String METHOD = "setInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "setInstance");
        int opStatus = 0;
        CIMProperty tmpProp = ci.getProperty(OPERATIONAL_STATUS);
        WBEMDebug.trace2((String)"PowerSupply Provider : ");
        if (null == tmpProp.getValue() || null == tmpProp.getValue().getValue()) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        CIMValue cv = tmpProp.getValue();
        WBEMDebug.trace3((String)("PowerSupply cv : " + cv));
        Vector vect = (Vector)cv.getValue();
        WBEMDebug.trace3((String)("PowerSupply vect : " + vect));
        UnsignedInt16 u16opStatus = (UnsignedInt16)vect.firstElement();
        WBEMDebug.trace3((String)("PowerSupply u16opStatus : " + u16opStatus));
        opStatus = u16opStatus.intValue();
        WBEMDebug.trace3((String)("PowerSupply opStatus : " + opStatus));
        WBEMDebug.trace2((String)("PowerSupply Provider setting opstatus: " + opStatus));
        int retVal = new PowerSupplyJNI().setOperationalStatus(opStatus);
        WBEMDebug.trace2((String)("PowerSupply Provider returned : " + retVal));
    }

    protected Vector enumerate(String nameSpace) throws CIMException {
        String METHOD = "enumerate";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerate" + " entered"));
        CIMInstance ci = this.getPowerSupplyInstance(nameSpace);
        Vector<CIMInstance> retVec = new Vector<CIMInstance>();
        if (null != ci) {
            retVec.add(ci);
        }
        return retVec;
    }

    private CIMInstance getPowerSupplyInstance(String nameSpace) throws CIMException {
        CIMObjectPath cop = new CIMObjectPath(CLASSNAME);
        cop.setNameSpace(nameSpace);
        CIMClass cimClass = this.getCimomHandle().getClass(cop, false, true, true, null);
        PowerSupplyJNI psjni = new PowerSupplyJNI();
        int enabledState = 3;
        int opStatus = 0;
        String hostID = null;
        if (!this.lightsOutMgmtEnabled()) {
            return null;
        }
        try {
            hostID = psjni.getHostID();
            enabledState = psjni.getEnabledState();
            opStatus = psjni.getOperationalStatus();
        }
        catch (Exception ex) {
            WBEMDebug.trace2((String)"could not get host name", (Throwable)ex);
            hostID = "localhost";
        }
        CIMInstance ci = cimClass.newInstance();
        Vector<UnsignedInt16> enabledStateVector = new Vector<UnsignedInt16>();
        enabledStateVector.add(new UnsignedInt16(enabledState));
        ci.setProperty(ENABLED_STATE, new CIMValue(enabledStateVector, new CIMDataType(16)));
        Vector<UnsignedInt16> opStatusVector = new Vector<UnsignedInt16>();
        opStatusVector.add(new UnsignedInt16(opStatus));
        ci.setProperty(OPERATIONAL_STATUS, new CIMValue(opStatusVector, new CIMDataType(16)));
        ci.setProperty(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)APPLICATION_SERVER_CLASS));
        ci.setProperty(SYSTEM_NAME, new CIMValue((Object)hostID));
        ci.setProperty(CREATION_CLASS_NAME, new CIMValue((Object)CLASSNAME));
        ci.setProperty(DEVICE_ID, new CIMValue((Object)""));
        return ci;
    }

    boolean lightsOutMgmtEnabled() {
        String METHOD = "lightsOutMgmtEnabled";
        File f = new File(POWER_SUPPLY_INSTALLED_FILE);
        return f.exists();
    }
}

